package jp.mosp.payroll.common.action;

import java.sql.SQLException;
import java.util.List;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.common.vo.AdjustmentReferVo;
import jp.mosp.payroll.dto.PhPaymentDto;

public class AdjustmentReferAction extends AdjustmentAction {
	
	// R}h
	private static final String	CMD_ADJUSTMENT_REFER_SHOW	= "P3060";
	

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VȌ
		AdjustmentReferVo vo = new AdjustmentReferVo();
		// ̎擾pz擾
		setNameArray(vo);
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		storeVo(PayrollConst.VO_ADJUSTMENT_LIST, vo);
		
		// R}h̏
		if (cmd.equals(CMD_ADJUSTMENT_REFER_SHOW)) {
			vo.setParams(request);
			kCode = "";
			if (vo.getLblChangeKCode() != null && !vo.getLblChangeKCode().equals("")) {
				// ͉ʂJ
				kCode = vo.getLblChangeKCode();
				adjustYear = getAdjustYear();
			} else if (key1 != null && !key1.equals("")) {
				// ꗗJ
				kCode = key1;
				vo.setHidAdjustYear(Integer.parseInt(key2));
				adjustYear = Integer.parseInt(key2);
			} else {
				kCode = vo.getHidKCode();
				adjustYear = getAdjustYear();
			}
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate = getLastDateOfYear(adjustYear);
			
			// NmF
			//confirmAdjustYear(vo.getHidAdjustYear());
			show(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	private void show(AdjustmentReferVo vo) throws Exception {
		// DAO
		prepareDao();
		// Ώ۔NAΏۃf[^ݒ
		setTargetData();
		// Nf[^擾
		setAdjustmentInfo(vo);
		// lݒ
		setHumanInfo(vo);
		// ^Aܗ^擾
		setPaymentBonusInfo(vo);
		
	}
	
	/**
	 * ̎擾pz擾
	 * @param vo ݒΏVO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 */
	private void setNameArray(AdjustmentReferVo vo) throws SQLException, NoSuchFieldException, IllegalAccessException,
			ClassNotFoundException {
		// DBRlNV擾
		getConnection();
		// 擾ϊmF
		if (vo.aryStation != null) {
			return;
		}
		// z擾
		vo.aryStation = getStationArrayAll();
		vo.aryPosition = getPositionArrayAll();
		vo.aryEra = getCodeArray(PayrollConst.TID_JAPANESE);
		vo.aryRelation = getCodeArray(PayrollConst.TID_RELATION);
		// aݒ擾
		vo.listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		// Ǖw(v) Up
		vo.aryGender = getCodeArray(PayrollConst.TID_GENDER);
	}
	
	/**
	 * lݒ
	 * @param vo ݒΏVO
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws MospException 
	 */
	private void setHumanInfo(AdjustmentReferVo vo) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		
		// l{擾
		mKihonDto = mKihonPayrollDao.findForKey(kCode);
		
		if (mKihonDto == null) {
			// l{񂪖ꍇ
			vo.setLblChangeKCode(kCode);
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_HUMAN_DATA, "");
			addErrMessage(errMessage);
		}
		// lǗ擾
		mKojinDto = mKojinDao.findForKey(kCode);
		// l^擾
		cmIncomeTaxDto = cmIncomeTaxDao.findForEmployeeDate(kCode, lastDate);
		cmMidwayEnterDto = cmMidwayEnterDao.findForKey(kCode);
		// Ƒ擾
		// listFamily = cmFamilyDao.findForAdjustment(kCode);
		// VOݒ
		vo.setFields(mKihonDto, cmIncomeTaxDto, cmMidwayEnterDto, mKojinDto);
	}
	
	/**
	 * ^Aܗ^擾
	 * @param vo
	 * @throws Exception 
	 */
	private void setPaymentBonusInfo(AdjustmentReferVo vo) throws Exception {
		// vZΏۋ^f[^擾
		List<PhPaymentDto> listPaymentData = phPaymentDao.findForConditionDate(kCode, targetBefDate, targetAffDate);
		// vZΏۏܗ^f[^擾
		List<PhBounsDto> listBonusData = phBonusDao.findForConditionDate(kCode, startAdjDate, lastDate);
		// ^f[^mF
		setTargetPaymentData();
		// Ώۃf[^ŌvZ(o^Ȃ)
		calcTargetIncomeTax(false);
		// VOݒ
		vo.setFields(listPaymentData, listBonusData, pdPayDeductionDao, phPaymentDto, phBonusDto, cdAdjustmentDto);
	}
	
	/**
	 * Nf[^擾
	 * @param vo
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	private void setAdjustmentInfo(AdjustmentReferVo vo) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		cdAdjustmentDto = cdAdjustmentDao.findForKey(kCode, adjustYear);
		// tB[h̐ݒ(Nf[^)
		vo.setFields(cdAdjustmentDto);
	}
}
