package jp.mosp.payroll.common;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.legal.LegalReportUtility;
import jp.mosp.payroll.base.Bonus;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.bonus.dao.PdBonAllowanceDao;
import jp.mosp.payroll.bonus.dao.PdBonDeductionDao;
import jp.mosp.payroll.bonus.dao.PdBonSumDao;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.bonus.dao.PmDetailBaDao;
import jp.mosp.payroll.bonus.dao.PmDetailBdDao;
import jp.mosp.payroll.bonus.dao.PmDetailBsDao;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.common.vo.FirmBankingOutputVo;
import jp.mosp.payroll.dao.BankTransferDao;
import jp.mosp.payroll.dao.CmBankDao;
import jp.mosp.payroll.dao.CmBranchDao;
import jp.mosp.payroll.dao.CmCoBankDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.BankTransferFBDataDto;
import jp.mosp.payroll.dto.CmBankDto;
import jp.mosp.payroll.dto.CmBranchDto;
import jp.mosp.payroll.dto.CmCoBankDto;
import jp.mosp.payroll.dto.CmCompanyDto;

public class BonusFBDataOutputAction extends MosPAction {
	
	// R}h
	private static final String	CMD_BONUS_FB_DATA_OUTPUT	= "P9011";
	

	/**
	 * RXgN^
	 */
	public BonusFBDataOutputAction() {
		super();
		setNeedProcSeq(false);
	}
	

	int	total		= 0;
	int	amount		= 0;
	// ǉR[h
	int	lenRecord	= 0;
	

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		FirmBankingOutputVo vo = (FirmBankingOutputVo)session.getAttribute(MospConst.ATT_FORMER_VO);
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		if (cmd.equals(CMD_BONUS_FB_DATA_OUTPUT)) {
			// p[^擾
			vo.setParams(request);
			// Џo^
			updateCompanyInfo(vo);
			// ǉR[h擾
			getAddRecordLength(Integer.parseInt(vo.getTxtRecordLength()));
			// Ώ۔N擾
			Date payday = vo.getDate(vo.getPltSpecifyYear(), vo.getPltSpecifyMonth(), vo.getPltSpecifyDay());
			Date targetMonth = vo.getDate(vo.getPltSpecifyYear(), vo.getPltSpecifyMonth(), vo.getPltSpecifyDay());
			// FBf[^擾
			BankTransferDao bankTransferDao = new BankTransferDao();
			bankTransferDao.initDao(cfg, cmd, aspUser, user, conn);
			// Xe[^Xm̏ܗ^f[^̂ݎ擾
			List<BankTransferFBDataDto> list = bankTransferDao.findForCondition(vo.getPltCoBankCode(), targetMonth,
					payday, false);
			// [쐬
			StringBuffer sb = new StringBuffer();
			String fileName = vo.getPltSpecifyYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltSpecifyMonth()
					+ PayrollConst.FILE_NAME_SEPARATOR + vo.getPltSpecifyDay() + PayrollConst.FILE_NAME_SEPARATOR
					+ PayrollConst.FILE_FB_BONUS_DATA;
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			request.setAttribute(MospConst.ATT_FILE_OBJECT, sb);
			// ܗ^f[^mF
			if (list.size() == 0) {
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_BONUS, "");
				sb.append(errMessage);
				return;
			}
			//Uz̎擾
			getFrimAmo(list);
			// FBf[^쐬
			getFBDataRecord(sb, list, vo);
		}
	}
	
	/**
	 * FBf[^쐬
	 * @param sb
	 * @param list
	 * @throws Exception
	 */
	protected void getFBDataRecord(StringBuffer sb, List<BankTransferFBDataDto> list, FirmBankingOutputVo vo)
			throws Exception {
		// Ћs擾
		CmCoBankDao cmCoBankDao = new CmCoBankDao();
		cmCoBankDao.initDao(cfg, cmd, aspUser, user, conn);
		// ЋsR[hЈ̃Xg擾
		// Ћs擾
		CmCoBankDto cmCoBankDto = cmCoBankDao.findForKey(vo.getPltCoBankCode());
		// ΏێЈł܂킷
		for (int j = 0; j < list.size(); j++) {
			BankTransferFBDataDto bankTransferFBDataDto = list.get(j);
			if (j == 0) {
				// wb_[R[hݒ
				setHeaderRecordData(sb, bankTransferFBDataDto, cmCoBankDto, vo);
			}
			// f[^R[hݒ
			setDataRecordData(sb, bankTransferFBDataDto, vo);
			// Xe[^XXV
			updateBonusStatus(bankTransferFBDataDto);
		}
		// ׂĊmFIg[[R[hݒ
		LegalReportUtility.getTrailerRecord(sb, String.valueOf(total), String.valueOf(amount), checkLineFeed(vo
			.getPltRecordType()), lenRecord);
		// st^mF
		checkLineFeed(vo.getPltEndRecord());
		
		// GhR[h쐬
		// GhR[ho͊mF
		if (checkLineFeed(vo.getPltEndRecord())) {
			LegalReportUtility.getEndRecord(sb, checkLineFeed(vo.getPltRecordType()), lenRecord);
		}
		// 
		total = 0;
		amount = 0;
	}
	
	/**
	 * wb_[f[^ݒ
	 * @param sb
	 * @param aryBankCode
	 * @param aryBranchCode
	 * @param cmCompanyDto
	 * @param udPaymentDto
	 * @param cmCoBankDto
	 * @throws Exception 
	 */
	protected void setHeaderRecordData(StringBuffer sb, BankTransferFBDataDto bankTransferFBDataDto,
			CmCoBankDto cmCoBankDto, FirmBankingOutputVo vo) throws Exception {
		
		String[] aryBankName = getBankName(cmCoBankDto.getBankCode());
		String[] aryBranchName = getBranchNameArray(cmCoBankDto.getBankCode(), cmCoBankDto.getBranchCode());
		
		// sݒ
		String coBankName = aryBankName[2];
		String coBranchName = aryBranchName[3];
		LegalReportUtility.getHeaderRecode(sb, PayrollConst.FB_BONUS_TYPE_CODE, vo.getPltCodeType(), vo
			.getTxtCompanyCode(), getLowerUpKana(vo.getTxtCompanyName()), String.valueOf(MospUtility
			.getMonth(bankTransferFBDataDto.getPayday())), String.valueOf(MospUtility.getDay(bankTransferFBDataDto
			.getPayday())), cmCoBankDto.getBankCode(), getLowerUpKana(coBankName), cmCoBankDto.getBranchCode(),
				getLowerUpKana(coBranchName), cmCoBankDto.getAccountType(), cmCoBankDto.getAccountNo(),
				checkLineFeed(vo.getPltRecordType()), lenRecord);
	}
	
	/**
	 * f[^R[hf[^ݒ
	 * @param sb
	 * @param bankTransferFBDataDto
	 * @throws Exception
	 */
	private void setDataRecordData(StringBuffer sb, BankTransferFBDataDto bankTransferFBDataDto, FirmBankingOutputVo vo)
			throws Exception {
		if (0 != bankTransferFBDataDto.getBankPayAmount()) {
			String[] aryBankName = getBankName(bankTransferFBDataDto.getPaidBankCode());
			String[] aryBranchName = getBranchNameArray(bankTransferFBDataDto.getPaidBankCode(), bankTransferFBDataDto
				.getPaidBranchCode());
			
			// sݒ
			String bankName = aryBankName[2];
			String branchName = aryBranchName[3];
			String bankPayAmount = String.valueOf(bankTransferFBDataDto.getBankPayAmount());
			
			LegalReportUtility.getFBDataRecord(sb, bankTransferFBDataDto.getPaidBankCode(), getLowerUpKana(bankName),
					bankTransferFBDataDto.getPaidBranchCode(), getLowerUpKana(branchName), bankTransferFBDataDto
						.getAccountType(), bankTransferFBDataDto.getAccountNo(), getLowerUpKana(bankTransferFBDataDto
						.getHolderKana()), bankPayAmount, bankTransferFBDataDto.getKCode(), bankTransferFBDataDto
						.getStationCode(), checkLineFeed(vo.getPltRecordType()), lenRecord);
			// ݒ
			total++;
			// vzݒ
			amount += bankTransferFBDataDto.getBankPayAmount();
		}
	}
	
	/**
	 * ܗ^Xe[^XXV
	 * @param bankTransferFBDataDto
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	private void updateBonusStatus(BankTransferFBDataDto bankTransferFBDataDto) throws SQLException,
			IllegalAccessException, NoSuchFieldException, MospException {
		// ^XV
		//	PhBounsDao phBonusDao = new PhBounsDao();
		//	phBonusDao.initDao(cfg, cmd, aspUser, user, conn);
		//	PhBounsDto udBonusDto = phBonusDao.findForKey(bankTransferFBDataDto.getKCode(), bankTransferFBDataDto.getCalcDate(), bankTransferFBDataDto.getPayday());
		//	if (udBonusDto != null) {
		// Xe[^XFBf[^o͍ς݂ɐݒ
		//		udBonusDto.setCalcStatus(UnicConst.CALC_STATUS_FB);
		// UD_PAYMENTXV
		//		udBonusDao.update(udBonusDto, true);
		// R~bg
		//		commit();
		//	}
		
	}
	
	/**
	 * ЏXV
	 * @param vo
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	private void updateCompanyInfo(FirmBankingOutputVo vo) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		// DAO
		CmCompanyDao cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		// ݊mF
		CmCompanyDto cmCompanyDto = cmCompanyDao.findAll();
		
		if (cmCompanyDto != null) {
			cmCompanyDto.setCompanyFbAddress(vo.getTxtCoAddress());
			cmCompanyDto.setCompanyFbKana(vo.getTxtCompanyName());
			// XV
			cmCompanyDao.update(cmCompanyDto);
		} else {
			cmCompanyDto = new CmCompanyDto();
			cmCompanyDto.setCompanyFbAddress(vo.getTxtCoAddress());
			cmCompanyDto.setCompanyFbKana(vo.getTxtCompanyName());
			// o^
			cmCompanyDao.insert(cmCompanyDto);
			
		}
		// R~bg
		commit();
	}
	
	/**
	 * s擾(p\̂)(CM_BANK)
	 * @return sXg
	 * @throws Exception
	 */
	protected String[] getBankName(String bankCode) throws Exception {
		// 
		String[] aryBankName = new String[3];
		// DAȌ
		CmBankDao dao = new CmBankDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		CmBankDto cmBankDto = dao.findForKey(bankCode);
		// z̍쐬
		if (cmBankDto != null) {
			aryBankName[0] = cmBankDto.getBankCode();
			aryBankName[1] = cmBankDto.getBankName();
			aryBankName[2] = cmBankDto.getBankKana();
		} else {
			aryBankName[0] = bankCode;
			aryBankName[1] = bankCode;
			aryBankName[2] = bankCode;
			
		}
		
		return aryBankName;
	}
	
	/**
	 * xXR[h擾(p\̂)(CM_BANK)
	 * @return sR[hXg
	 * @throws Exception
	 */
	protected String[] getBranchNameArray(String bankCode, String branchCode) throws Exception {
		// 
		String[] aryBranchName = new String[4];
		// DAȌ
		CmBranchDao dao = new CmBranchDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		CmBranchDto cmBranchDto = dao.findForKey(bankCode, branchCode);
		// z̍쐬
		if (cmBranchDto != null) {
			aryBranchName[0] = cmBranchDto.getBankCode();
			aryBranchName[1] = cmBranchDto.getBranchCode();
			aryBranchName[2] = cmBranchDto.getBranchName();
			aryBranchName[3] = cmBranchDto.getBranchKana();
		} else {
			aryBranchName[0] = bankCode;
			aryBranchName[1] = branchCode;
			aryBranchName[2] = branchCode;
			aryBranchName[3] = branchCode;
			
		}
		return aryBranchName;
	}
	
	/**
	 * pJiϊ(啶)
	 * @param strTarget
	 * @return@pJi
	 */
	protected String getLowerUpKana(String strTarget) {
		// pJi()
		String[] aryLowerKana = { "", "", "", "", "", "", "", "", "" };
		// pJi(啶)
		String[] aryLowerUpKana = { "", "", "", "", "", "", "", "", "" };
		// 
		String retString = "";
		String repString = "";
		// ̌ŉ
		for (int i = 0; i < strTarget.length(); i++) {
			// Ԃɕ擾Ă
			repString = strTarget.substring(i, i + 1);
			// ԂɊmF
			for (int j = 0; j < aryLowerKana.length; j++) {
				// p()݂啶֕ϊ
				if (aryLowerKana[j].equals(repString)) {
					repString = aryLowerUpKana[j];
					break;
				}
			}
			// 
			retString += repString;
		}
		return retString;
	}
	
	/**
	 * st^mF
	 * @param strLineFeed
	 * @return
	 */
	private boolean checkLineFeed(String strLineFeed) {
		// R[h敪ɉsȂ
		if (strLineFeed.equals(PayrollConst.FB_RECORD_TYPE_NONE)) {
			return false;
		}
		// R[h敪ɉs
		return true;
	}
	
	/**
	 * ǉR[h擾
	 * @param addLenRecord
	 */
	private void getAddRecordLength(int addLenRecord) {
		// ǉR[h-120(ŏR[h)
		lenRecord = addLenRecord - PayrollConst.FB_LOWER_LEN_RECORD;
		if (lenRecord < 0) {
			lenRecord = 0;
		}
	}
	
	/**
	 * U݋z̎擾
	 * @param list
	 */
	private void getFrimAmo(List<BankTransferFBDataDto> lineList) throws Exception {
		String oldkCode = "";
		String newkCode = "";
		
		for (int i = 0; i < lineList.size(); i++) {
			BankTransferFBDataDto list = lineList.get(i);
			
			newkCode = list.getKCode();
			if (!oldkCode.equals(newkCode)) {
				Bonus sumAmo = getPayment(list.getKCode(), list.getCalcDate());
				int amount = sumAmo.getSumAmount(BonusConst.DTL_SUM_BANK1);
				list.setBankPayAmount(amount);
			} else {
				Bonus sumAmo = getPayment(list.getKCode(), list.getCalcDate());
				int amount = sumAmo.getSumAmount(BonusConst.DTL_SUM_BANK2);
				list.setBankPayAmount(amount);
			}
			oldkCode = newkCode;
			
		}
		
	}
	
	/**
	 * ܗ^`[CX^X擾Aݒ肷B<br><br>
	 * kCodeAcalcDateL[Ƃďܗ^擾A{@link #payment}Ɋi[B
	 * @param kCode     ЈR[h
	 * @param payMonth vZN
	 * @return ܗ^`[
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected Bonus getPayment(String kCode, Date payMonth) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		PhBounsDto header = new PhBounsDao(cfg, cmd, aspUser, user, conn).findForKey(kCode, payMonth);
		if (header == null) {
			return null;
		}
		return new Bonus(header, new PmDetailBaDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
				new PmDetailBdDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()), new PmDetailBsDao(
						cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()), new PdBonAllowanceDao(cfg,
						cmd, aspUser, user, conn).find(kCode, payMonth), new PdBonDeductionDao(cfg, cmd, aspUser, user,
						conn).find(kCode, payMonth), new PdBonSumDao(cfg, cmd, aspUser, user, conn).find(kCode,
						payMonth));
	}
	
}
