package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.CashKindListDto;
import jp.mosp.payroll.dao.DetailMoneyDao;
import jp.mosp.payroll.dao.MKihonPayrollDao;

public class CashKindListDao extends PayrollDao {
	
	//	
	public static final String	COL_K_CODE				= PhBounsDao.COL_KCODE;			// ЈR[h
	public static final String	COL_CALC_DATE			= PhBounsDao.COL_CALC_MONTH;		// vZN
	public static final String	COL_PAYDAY				= PhBounsDao.COL_PAY_DATE;			// ^x
	public static final String	COL_K_NAME				= MKihonPayrollDao.COL_SIMEI;		// Ј
	public static final String	COL_DETAIL_CODE			= DetailMoneyDao.COL_DETAIL_CODE;	// ׃R[h
	public static final String	COL_AMOUNT				= DetailMoneyDao.COL_AMOUNT;		// ׋z
	public static final String	COL_DETAIL_CODE_PS013	= "BS013";							//׃R[h@
																							
	
	/**
	 * RXgN^
	 */
	public CashKindListDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CashKindListDto> mappingAll() throws SQLException {
		List<CashKindListDto> all = new ArrayList<CashKindListDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return  CashKindListDto zR[h
	 * @throws SQLException
	 */
	private CashKindListDto mapping() throws SQLException {
		CashKindListDto dto = new CashKindListDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setCalcDate(rs.getDate(COL_CALC_DATE)); // vZN
		dto.setPayday(rs.getDate(COL_PAYDAY)); // ^x
		dto.setKName(rs.getString(COL_K_NAME)); // Ј
		dto.setCashAmount(rs.getInt(COL_AMOUNT)); // xz
		return dto;
	}
	
	/**
	 * ɂ錻zf[^擾
	 * @param adjustYear Ώ۔N
	 * @param lastDate   Ώی
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public List<CashKindListDto> findForCondition(Date payday) throws SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		setCashKindBonus(sb);
		prepareStatement(sb.toString());
		setDateParam(index++, payday);
		sb.append(" ");
		sb.append(getOrderBy());
		sb.append(COL_K_CODE);
		try {
			//s
			executeQuery();
			List<CashKindListDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂ錻zf[^擾(ܗ^)
	 * @param sb SQLobt@
	 */
	private void setCashKindBonus(StringBuffer sb) {
		sb.append("SELECT ");
		sb.append(" PHBON.");
		sb.append(COL_K_CODE);
		sb.append(", ");
		sb.append(" PHBON.");
		sb.append(COL_CALC_DATE);
		sb.append(", ");
		sb.append(" PHBON.");
		sb.append(COL_PAYDAY);
		sb.append(", ");
		sb.append(" MKIHON.");
		sb.append(COL_K_NAME);
		sb.append(", ");
		sb.append(" PDSUM.");
		sb.append(COL_AMOUNT);
		
		sb.append(" FROM ");
		sb.append(PhBounsDao.TABLE + " PHBON ");
		sb.append(", ");
		sb.append(MKihonPayrollDao.TABLE + " MKIHON ");
		sb.append(", ");
		sb.append("PD_BON_SUM" + " PDSUM ");
		
		sb.append(" WHERE ");
		sb.append(" PHBON.");
		sb.append(COL_K_CODE);
		sb.append(" = ");
		sb.append(" MKIHON.");
		sb.append(COL_K_CODE);
		sb.append(" AND ");
		sb.append(" PHBON.");
		sb.append(COL_K_CODE);
		sb.append(" = ");
		sb.append(" PDSUM.");
		sb.append(COL_K_CODE);
		sb.append(" AND ");
		sb.append(" PHBON.");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(" PHBON.");
		sb.append(COL_CALC_DATE);
		sb.append(" = ");
		sb.append(" PDSUM.");
		sb.append("CALC_DATE");
		sb.append(" AND ");
		sb.append(" PDSUM.");
		sb.append(COL_DETAIL_CODE);
		sb.append(" = ");
		sb.append("'" + COL_DETAIL_CODE_PS013 + "'");
		sb.append(" AND ");
		sb.append(" PDSUM.");
		sb.append(COL_AMOUNT);
		sb.append(" <> ");
		sb.append(PayrollConst.AMOUNT_ZERO);
	}
	
}
