package jp.mosp.payroll.base;

import java.util.Date;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.ListVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.MosPConfDto;

/**
 * ^VXeVOŗp鋤ʋ@\񋟂B<br><br>
 * ^VXe̊eVÓANXgĎB
 */
public abstract class PayrollVo extends ListVo {
	
	private static final long	serialVersionUID	= -2887585326696702206L;
	

	/**
	 * ^vZVXeVOʏsB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link BaseVo#BaseVo()}
	 * </li><li>
	 * {@link #setViewPath(String)}
	 * </li><li>
	 * javascripto͗vݒ
	 * </li></ul>
	 */
	protected PayrollVo() {
		super();
		setViewPath(getClassName());
		needDirectJs = true;
	}
	
	/**
	 * ^VXẽTu^Cgݒ肷B<br>
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = "@";
		aryMenu = new String[1][2];
		aryMenu[0][0] = "P1910";
		aryMenu[0][1] = getName("C_MENU") + getName("C_TO");
	}
	
	/**
	 * javascript擾B<br>
	 */
	@Override
	public String getDirectJs(Class<?> cls) throws IllegalAccessException {
		return super.getDirectJs(cls);
	}
	
	/**
	 * {^zvfǉB<br>
	 * @param cmd   R}h
	 * @param title {^^Cg
	 */
	protected void addAryMenu(String cmd, String title) {
		String[][] aryNew = new String[aryMenu.length + 1][2];
		for (int i = 0; i < aryMenu.length; i++) {
			aryNew[i][0] = aryMenu[i][0];
			aryNew[i][1] = aryMenu[i][1];
		}
		aryNew[aryMenu.length][0] = cmd;
		aryNew[aryMenu.length][1] = title;
		aryMenu = aryNew;
	}
	
	/**
	 * ̎擾
	 * @param code 擾ΏۃR[h
	 * @param array Ώۃe[u
	 * @return R[h
	 */
	protected String getCodeName(String code, String[][] array) {
		String codeName = code;
		if (array == null) {
			return codeName;
		}
		for (String[] element : array) {
			if (code.equals(element[0])) {
				codeName = element[1];
				break;
			}
		}
		return codeName;
	}
	
	/**
	 * 폜tÔ擾B
	 * @param deleteFlag 폜tO
	 * @return 폜tO
	 */
	protected String getDeleteName(byte deleteFlag) {
		if (deleteFlag == MospConst.DELETE_FLAG_OFF) {
			return MospConst.DELETE_FLAG_OFF_NAME;
		} else if (deleteFlag == MospConst.DELETE_FLAG_ON) {
			return MospConst.DELETE_FLAG_ON_NAME;
		}
		return "";
	}
	
	/**
	 * 3؃J}}B
	 * @param strTarget Ώە
	 * @return 3؃J}t
	 */
	public String insertComma(String strTarget) {
		if (strTarget == null || strTarget.equals("")) {
			return "";
		}
		return strTarget.replaceAll("(?m)(?<=\\d)(?=(?:\\d{3})+$)", ",");
	}
	
	/**
	 * ׋敪z擾B
	 * @return ׋敪z
	 */
	protected String[][] getDetailTypeArray() {
		String[][] aryType = new String[8][2];
		aryType[0][0] = PayrollConst.DETAIL_TYPE_PT;
		aryType[1][0] = PayrollConst.DETAIL_TYPE_PA;
		aryType[2][0] = PayrollConst.DETAIL_TYPE_PD;
		aryType[3][0] = PayrollConst.DETAIL_TYPE_PB;
		aryType[4][0] = PayrollConst.DETAIL_TYPE_PS;
		aryType[5][0] = PayrollConst.DETAIL_TYPE_BA;
		aryType[6][0] = PayrollConst.DETAIL_TYPE_BD;
		aryType[7][0] = PayrollConst.DETAIL_TYPE_BS;
		aryType[0][1] = getName("P_PAYMENT") + getName("P_TIME");
		aryType[1][1] = getName("P_PAYMENT") + getName("P_ALLOWANCE");
		aryType[2][1] = getName("P_PAYMENT") + getName("P_DEDUCTION");
		aryType[3][1] = getName("P_PAYMENT") + getName("P_BREAKDOWN");
		aryType[4][1] = getName("P_PAYMENT") + getName("P_SUM");
		aryType[5][1] = getName("P_BONUS") + getName("P_ALLOWANCE");
		aryType[6][1] = getName("P_BONUS") + getName("P_DEDUCTION");
		aryType[7][1] = getName("P_BONUS") + getName("P_SUM");
		return aryType;
	}
	
	/**
	 * a擾
	 * @param list a񃊃Xg
	 * @param date t
	 * @return tz
	 * @throws MospException MosPOꍇ
	 */
	public String[] getJpImperialCal(List<MosPConfDto> list, Date date) throws MospException {
		String[] aryJpDate = new String[4];
		if (date == null) {
			return aryJpDate;
		}
		for (MosPConfDto dto : list) {
			Date startDate = getDate(dto.getConfCode());
			Date endDate = getDate(dto.getConfValue());
			if (startDate.compareTo(date) <= 0 && endDate.compareTo(date) >= 0) {
				int year = MospUtility.getYear(date) - MospUtility.getYear(startDate) + 1;
				aryJpDate[0] = dto.getConfId();
				aryJpDate[1] = String.valueOf(year);
				aryJpDate[2] = String.valueOf(MospUtility.getMonth(date));
				aryJpDate[3] = String.valueOf(MospUtility.getDay(date));
				return aryJpDate;
			}
		}
		throw new MospException(MospConst.EX_DATE_INVALID);
	}
	
	/**
	 * t擾(/p)
	 * @param strDate t
	 * @return t
	 * @throws MospException MosPOꍇ
	 */
	public Date getDate(String strDate) throws MospException {
		if (strDate == null || strDate.length() != 8) {
			throw new MospException(MospConst.EX_DATE_INVALID);
		}
		return MospUtility.getDate(strDate.substring(0, 4) + PayrollConst.SEPARATOR_DATE + strDate.substring(4, 6)
				+ PayrollConst.SEPARATOR_DATE + strDate.substring(6, 8));
	}
	
}
