/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.mospcommon.system.dto.CmLimitStandardDto;

/**
 * @author nakamura
 *
 */
public class LimitStandardMasterCardVo extends MosPVo {
	
	private static final long	serialVersionUID				= -2692577633142378846L;
	
	// 萔
	/**
	 * VKo^[h
	 */
	public static final int		MODE_INSERT						= 0;
	
	/**
	 * XV[h
	 */
	public static final int		MODE_UPDATE						= 1;
	
	// p[^
	/**
	 * xR[h
	 */
	public static final String	PRM_TXT_LCODE					= "txtLCode";
	
	/**
	 * x
	 */
	public static final String	PRM_TXT_LNAME					= "txtLName";
	
	/**
	 * Ԃ̎
	 */
	public static final String	PRM_PLT_TERM_TYPE				= "pltTermType";
	
	/**
	 * J()
	 */
	public static final String	PRM_TXT_PRESCRIBED_TIME_HOUR	= "txtPrescribedTimeHour";
	
	/**
	 * J()
	 */
	public static final String	PRM_TXT_PRESCRIBED_TIME_MIN		= "txtPrescribedTimeMin";
	
	/**
	 * 1̌x()
	 */
	public static final String	PRM_TXT_CAUTION_DAY_HOUR		= "txtCautionDayHour";
	
	/**
	 * 1̌x()
	 */
	public static final String	PRM_TXT_CAUTION_DAY_MIN			= "txtCautionDayMin";
	
	/**
	 * wԂ̌x()
	 */
	public static final String	PRM_TXT_CAUTION_TERM_HOUR		= "txtCautionTermHour";
	
	/**
	 * wԂ̌x()
	 */
	public static final String	PRM_TXT_CAUTION_TERM_MIN		= "txtCautionTermMin";
	
	/**
	 * 1Ňx()
	 */
	public static final String	PRM_TXT_CAUTION_YEAR_HOUR		= "txtCautionYearHour";
	
	/**
	 * 1Ňx()
	 */
	public static final String	PRM_TXT_CAUTION_YEAR_MIN		= "txtCautionYearMin";
	
	/**
	 * 1̌x()
	 */
	public static final String	PRM_TXT_LIMIT_DAY_HOUR			= "txtLimitDayHour";
	
	/**
	 * 1̌x()
	 */
	public static final String	PRM_TXT_LIMIT_DAY_MIN			= "txtLimitDayMin";
	
	/**
	 * wԂ̌x()
	 */
	public static final String	PRM_TXT_LIMIT_TERM_HOUR			= "txtLimitTermHour";
	
	/**
	 * wԂ̌x()
	 */
	public static final String	PRM_TXT_LIMIT_TERM_MIN			= "txtLimitTermMin";
	
	/**
	 * 1Ňx()
	 */
	public static final String	PRM_TXT_LIMIT_YEAR_HOUR			= "txtLimitYearHour";
	
	/**
	 * 1Ňx()
	 */
	public static final String	PRM_TXT_LIMIT_YEAR_MIN			= "txtLimitYearMin";
	
	/**
	 * wԂ̊
	 */
	public static final String	PRM_TXT_RATE_TERM				= "txtRateTerm";
	
	/**
	 * 1N̊
	 */
	public static final String	PRM_TXT_RATE_YEAR				= "txtRateYear";
	
	/**
	 * 폜tO
	 */
	public static final String	PRM_PLT_DELETE_FLAG				= "txtDeleteFlag";
	
	// tB[h
	private String				txtLCode;
	private String				txtLName;
	private String				pltTermType;
	private String				txtPrescribedTimeHour;
	private String				txtPrescribedTimeMin;
	private String				txtCautionDayHour;
	private String				txtCautionDayMin;
	private String				txtCautionTermHour;
	private String				txtCautionTermMin;
	private String				txtCautionYearHour;
	private String				txtCautionYearMin;
	private String				txtLimitDayHour;
	private String				txtLimitDayMin;
	private String				txtLimitTermHour;
	private String				txtLimitTermMin;
	private String				txtLimitYearHour;
	private String				txtLimitYearMin;
	private String				txtRateTerm;
	private String				txtRateYear;
	private String				pltDeleteFlag;
	
	// v_EXg
	/**
	 * Ԃ̎
	 */
	public String[][]			aryPltTermType;
	
	// [h(0FVKo^A1FXV)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * xR[h
	 */
	public String				NAM_LCODE;
	
	/**
	 * x
	 */
	public String				NAM_LNAME;
	
	/**
	 * Ԃ̎
	 */
	public String				NAM_TERM_TYPE;
	
	/**
	 * J
	 */
	public String				NAM_PRESCRIBED_TIME;
	
	/**
	 * J()
	 */
	public String				NAM_PRESCRIBED_TIME_HOUR;
	
	/**
	 * J()
	 */
	public String				NAM_PRESCRIBED_TIME_MIN;
	
	/**
	 * 1̌x
	 */
	public String				NAM_CAUTION_DAY;
	
	/**
	 * 1̌x()
	 */
	public String				NAM_CAUTION_DAY_HOUR;
	
	/**
	 * 1̌x()
	 */
	public String				NAM_CAUTION_DAY_MIN;
	
	/**
	 * wԂ̌x
	 */
	public String				NAM_CAUTION_TERM;
	
	/**
	 * wԂ̌x()
	 */
	public String				NAM_CAUTION_TERM_HOUR;
	
	/**
	 * wԂ̌x()
	 */
	public String				NAM_CAUTION_TERM_MIN;
	
	/**
	 * 1Ňx
	 */
	public String				NAM_CAUTION_YEAR;
	
	/**
	 * 1Ňx()
	 */
	public String				NAM_CAUTION_YEAR_HOUR;
	
	/**
	 * 1Ňx()
	 */
	public String				NAM_CAUTION_YEAR_MIN;
	
	/**
	 * 1̌x
	 */
	public String				NAM_LIMIT_DAY;
	
	/**
	 * 1̌x()
	 */
	public String				NAM_LIMIT_DAY_HOUR;
	
	/**
	 * 1̌x()
	 */
	public String				NAM_LIMIT_DAY_MIN;
	
	/**
	 * wԂ̌x
	 */
	public String				NAM_LIMIT_TERM;
	
	/**
	 * wԂ̌x()
	 */
	public String				NAM_LIMIT_TERM_HOUR;
	
	/**
	 * wԂ̌x()
	 */
	public String				NAM_LIMIT_TERM_MIN;
	
	/**
	 * 1Ňx
	 */
	public String				NAM_LIMIT_YEAR;
	
	/**
	 * 1Ňx()
	 */
	public String				NAM_LIMIT_YEAR_HOUR;
	
	/**
	 * 1Ňx()
	 */
	public String				NAM_LIMIT_YEAR_MIN;
	
	/**
	 * wԂ̊
	 */
	public String				NAM_RATE_TERM;
	
	/**
	 * 1N̊
	 */
	public String				NAM_RATE_YEAR;
	
	/**
	 * 폜tO
	 */
	public String				NAM_DELETE_FLAG;
	
	/**
	 * 
	 */
	public String				LBL_ONE_DAY;
	
	/**
	 * w
	 */
	public String				LBL_SPECIFIED_PERIOD;
	
	/**
	 * N
	 */
	public String				LBL_ONE_YEAR;
	
	/**
	 * x
	 */
	public String				LBL_CAUTION_TIME;
	
	/**
	 * x
	 */
	public String				LBL_LIMIT_TIME;
	
	/**
	 * 
	 */
	public String				LBL_RATE;
	
	/**
	 * xR[h
	 */
	public int					LEN_LCODE;
	
	/**
	 * x
	 */
	public int					LEN_LNAME;
	
	/**
	 * J()
	 */
	public int					LEN_PRESCRIBED_TIME_HOUR;
	
	/**
	 * J()
	 */
	public int					LEN_PRESCRIBED_TIME_MIN;
	
	/**
	 * 1̌x()
	 */
	public int					LEN_CAUTION_DAY_HOUR;
	
	/**
	 * 1̌x()
	 */
	public int					LEN_CAUTION_DAY_MIN;
	
	/**
	 * wԂ̌x()
	 */
	public int					LEN_CAUTION_TERM_HOUR;
	
	/**
	 * wԂ̌x()
	 */
	public int					LEN_CAUTION_TERM_MIN;
	
	/**
	 * 1Ňx()
	 */
	public int					LEN_CAUTION_YEAR_HOUR;
	
	/**
	 * 1Ňx()
	 */
	public int					LEN_CAUTION_YEAR_MIN;
	
	/**
	 * 1̌x()
	 */
	public int					LEN_LIMIT_DAY_HOUR;
	
	/**
	 * 1̌x()
	 */
	public int					LEN_LIMIT_DAY_MIN;
	
	/**
	 * wԂ̌x()
	 */
	public int					LEN_LIMIT_TERM_HOUR;
	
	/**
	 * wԂ̌x()
	 */
	public int					LEN_LIMIT_TERM_MIN;
	
	/**
	 * 1Ňx()
	 */
	public int					LEN_LIMIT_YEAR_HOUR;
	
	/**
	 * 1Ňx()
	 */
	public int					LEN_LIMIT_YEAR_MIN;
	
	/**
	 * wԂ̊
	 */
	public int					LEN_RATE_TERM;
	
	/**
	 * 1N̊
	 */
	public int					LEN_RATE_YEAR;
	

	/**
	 * RXgN^[
	 */
	public LimitStandardMasterCardVo() {
		super();
		mode = 0;
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_LIMIT_STANDARD;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuLaborAgreement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_LCODE = CommonConst.NAM_LIMIT_STANDARD + CommonConst.NAM_COMMON_CODE;
		NAM_LNAME = CommonConst.NAM_LIMIT_STANDARD + CommonConst.NAM_COMMON_MEISYO;
		NAM_TERM_TYPE = CommonConst.NAM_ACCOUNTING_PERIOD + CommonConst.MSG_OF + CommonConst.NAM_TYPE;
		NAM_PRESCRIBED_TIME = CommonConst.NAM_STATUTORY_HOUR;
		NAM_PRESCRIBED_TIME_HOUR = CommonConst.NAM_STATUTORY_HOUR + CommonConst.MSG_HOUR;
		NAM_PRESCRIBED_TIME_MIN = CommonConst.NAM_STATUTORY_HOUR + CommonConst.MSG_MINUTES;
		NAM_CAUTION_DAY = NumberUtil.NAM_ONE + CommonConst.NAM_DAY + CommonConst.MSG_OF + CommonConst.NAM_CAUTION_TIME;
		NAM_CAUTION_DAY_HOUR = NAM_CAUTION_DAY + CommonConst.MSG_HOUR;
		NAM_CAUTION_DAY_MIN = NAM_CAUTION_DAY + CommonConst.MSG_MINUTES;
		NAM_CAUTION_TERM = CommonConst.NAM_SPECIFIED_PERIOD + CommonConst.MSG_OF + CommonConst.NAM_CAUTION_TIME;
		NAM_CAUTION_TERM_HOUR = NAM_CAUTION_TERM + CommonConst.MSG_HOUR;
		NAM_CAUTION_TERM_MIN = NAM_CAUTION_TERM + CommonConst.MSG_MINUTES;
		NAM_CAUTION_YEAR = NumberUtil.NAM_ONE + CommonConst.NAM_YEAR + CommonConst.MSG_OF
				+ CommonConst.NAM_CAUTION_TIME;
		NAM_CAUTION_YEAR_HOUR = NAM_CAUTION_YEAR + CommonConst.MSG_HOUR;
		NAM_CAUTION_YEAR_MIN = NAM_CAUTION_YEAR + CommonConst.MSG_MINUTES;
		NAM_LIMIT_DAY = NumberUtil.NAM_ONE + CommonConst.NAM_DAY + CommonConst.MSG_OF + CommonConst.NAM_LIMIT_TIME;
		NAM_LIMIT_DAY_HOUR = NAM_LIMIT_DAY + CommonConst.MSG_HOUR;
		NAM_LIMIT_DAY_MIN = NAM_LIMIT_DAY + CommonConst.MSG_MINUTES;
		NAM_LIMIT_TERM = CommonConst.NAM_SPECIFIED_PERIOD + CommonConst.MSG_OF + CommonConst.NAM_LIMIT_TIME;
		NAM_LIMIT_TERM_HOUR = NAM_LIMIT_TERM + CommonConst.MSG_HOUR;
		NAM_LIMIT_TERM_MIN = NAM_LIMIT_TERM + CommonConst.MSG_MINUTES;
		NAM_LIMIT_YEAR = NumberUtil.NAM_ONE + CommonConst.NAM_YEAR + CommonConst.MSG_OF + CommonConst.NAM_LIMIT_TIME;
		NAM_LIMIT_YEAR_HOUR = NAM_LIMIT_YEAR + CommonConst.MSG_HOUR;
		NAM_LIMIT_YEAR_MIN = NAM_LIMIT_YEAR + CommonConst.MSG_MINUTES;
		NAM_RATE_TERM = CommonConst.NAM_SPECIFIED_PERIOD + CommonConst.MSG_OF + CommonConst.NAM_PREMIUM_RATE;
		NAM_RATE_YEAR = NumberUtil.NAM_ONE + CommonConst.NAM_YEAR + CommonConst.MSG_OF + CommonConst.NAM_PREMIUM_RATE;
		NAM_DELETE_FLAG = CommonConst.NAM_DELETE_FLAG;
		LBL_ONE_DAY = NumberUtil.NAM_ONE + CommonConst.NAM_DAY;
		LBL_SPECIFIED_PERIOD = CommonConst.NAM_SPECIFIED_PERIOD;
		LBL_ONE_YEAR = NumberUtil.NAM_ONE + CommonConst.NAM_YEAR;
		LBL_CAUTION_TIME = CommonConst.NAM_CAUTION + CommonConst.NAM_COMMON_TIME;
		LBL_LIMIT_TIME = CommonConst.NAM_LIMIT_TIME;
		LBL_RATE = CommonConst.NAM_PREMIUM_RATE;
		LEN_LCODE = 10;
		LEN_LNAME = 50;
		LEN_PRESCRIBED_TIME_HOUR = 2;
		LEN_PRESCRIBED_TIME_MIN = 2;
		LEN_CAUTION_DAY_HOUR = 2;
		LEN_CAUTION_DAY_MIN = 2;
		LEN_CAUTION_TERM_HOUR = 3;
		LEN_CAUTION_TERM_MIN = 2;
		LEN_CAUTION_YEAR_HOUR = 3;
		LEN_CAUTION_YEAR_MIN = 2;
		LEN_LIMIT_DAY_HOUR = 2;
		LEN_LIMIT_DAY_MIN = 2;
		LEN_LIMIT_TERM_HOUR = 3;
		LEN_LIMIT_TERM_MIN = 2;
		LEN_LIMIT_YEAR_HOUR = 3;
		LEN_LIMIT_YEAR_MIN = 2;
		LEN_RATE_TERM = 3;
		LEN_RATE_YEAR = 3;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtLCode("");
		setTxtLName("");
		setTxtPrescribedTimeHour("8");
		setTxtPrescribedTimeMin("0");
		setTxtCautionDayHour("0");
		setTxtCautionDayMin("0");
		setTxtCautionTermHour("0");
		setTxtCautionTermMin("0");
		setTxtCautionYearHour("0");
		setTxtCautionYearMin("0");
		setTxtLimitDayHour("15");
		setTxtLimitDayMin("0");
		setTxtLimitTermHour("15");
		setTxtLimitTermMin("0");
		setTxtLimitYearHour("360");
		setTxtLimitYearMin("0");
		setTxtRateTerm("125");
		setTxtRateYear("125");
		setPltDeleteFlag("0");
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtLCode = request.getParameter(PRM_TXT_LCODE);
		txtLName = request.getParameter(PRM_TXT_LNAME);
		txtPrescribedTimeHour = request.getParameter(PRM_TXT_PRESCRIBED_TIME_HOUR);
		txtPrescribedTimeMin = request.getParameter(PRM_TXT_PRESCRIBED_TIME_MIN);
		/*
				pltTermType = request.getParameter(PRM_PLT_TERM_TYPE);
				txtCautionDayHour = request.getParameter(PRM_TXT_CAUTION_DAY_HOUR);
				txtCautionDayMin = request.getParameter(PRM_TXT_CAUTION_DAY_MIN);
				txtCautionTermHour = request.getParameter(PRM_TXT_CAUTION_TERM_HOUR);
				txtCautionTermMin = request.getParameter(PRM_TXT_CAUTION_TERM_MIN);
				txtCautionYearHour = request.getParameter(PRM_TXT_CAUTION_YEAR_HOUR);
				txtCautionYearMin = request.getParameter(PRM_TXT_CAUTION_YEAR_MIN);
				txtLimitDayHour = request.getParameter(PRM_TXT_LIMIT_DAY_HOUR);
				txtLimitDayMin = request.getParameter(PRM_TXT_LIMIT_DAY_MIN);
				txtLimitTermHour = request.getParameter(PRM_TXT_LIMIT_TERM_HOUR);
				txtLimitTermMin = request.getParameter(PRM_TXT_LIMIT_TERM_MIN);
				txtLimitYearHour = request.getParameter(PRM_TXT_LIMIT_YEAR_HOUR);
				txtLimitYearMin = request.getParameter(PRM_TXT_LIMIT_YEAR_MIN);
				txtRateTerm = request.getParameter(PRM_TXT_RATE_TERM);
				txtRateYear = request.getParameter(PRM_TXT_RATE_YEAR);
		*/
		pltDeleteFlag = request.getParameter(PRM_PLT_DELETE_FLAG);
	}
	
	/**
	 * tB[hݒ
	 * @param dto x}X^DTO
	 */
	public void setFields(CmLimitStandardDto dto) {
		txtLCode = dto.getLimitCode();
		txtLName = dto.getLimitName();
		txtPrescribedTimeHour = TimeUtil.convIntegerTimeToStringHour(dto.getPrescribedTime());
		txtPrescribedTimeMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getPrescribedTime());
		/*
				pltTermType = dto.getTermType();
				txtCautionDayHour = TimeUtil.convIntegerTimeToStringHour(dto.getCautionDay());
				txtCautionDayMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getCautionDay());
				txtCautionTermHour = TimeUtil.convIntegerTimeToStringHour(dto.getCautionTerm());
				txtCautionTermMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getCautionTerm());
				txtCautionYearHour = TimeUtil.convIntegerTimeToStringHour(dto.getCautionYear());
				txtCautionYearMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getCautionYear());
				txtLimitDayHour = TimeUtil.convIntegerTimeToStringHour(dto.getLimitDay());
				txtLimitDayMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getLimitDay());
				txtLimitTermHour = TimeUtil.convIntegerTimeToStringHour(dto.getLimitTerm());
				txtLimitTermMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getLimitTerm());
				txtLimitYearHour = TimeUtil.convIntegerTimeToStringHour(dto.getLimitYear());
				txtLimitYearMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getLimitYear());
				txtRateTerm = String.valueOf(dto.getRateTerm());
				txtRateYear = String.valueOf(dto.getRateYear());
		*/
		pltDeleteFlag = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmLimitStandardDto dto) {
		dto.setLimitCode(txtLCode);
		dto.setLimitName(txtLName);
		dto.setPrescribedTime(TimeUtil.convStringTimeToIntegerTime(txtPrescribedTimeHour, txtPrescribedTimeMin));
		/*
				dto.setTermType(pltTermType);
				dto.setCautionDay(TimeUtil.convStringTimeToIntegerTime(txtCautionDayHour, txtCautionDayMin));
				dto.setCautionTerm(TimeUtil.convStringTimeToIntegerTime(txtCautionTermHour, txtCautionTermMin));
				dto.setCautionYear(TimeUtil.convStringTimeToIntegerTime(txtCautionYearHour, txtCautionYearMin));
				dto.setLimitDay(TimeUtil.convStringTimeToIntegerTime(txtLimitDayHour, txtLimitDayMin));
				dto.setLimitTerm(TimeUtil.convStringTimeToIntegerTime(txtLimitTermHour, txtLimitTermMin));
				dto.setLimitYear(TimeUtil.convStringTimeToIntegerTime(txtLimitYearHour, txtLimitYearMin));
				dto.setRateTerm(Integer.parseInt(txtRateTerm));
				dto.setRateYear(Integer.parseInt(txtRateYear));
		*/
		dto.setDeleteFlag(Integer.parseInt(pltDeleteFlag));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtLCode, NAM_LCODE, PRM_TXT_LCODE);
		checkRequired(txtLName, NAM_LNAME, PRM_TXT_LNAME);
		checkRequired(txtPrescribedTimeHour, NAM_PRESCRIBED_TIME_HOUR, PRM_TXT_PRESCRIBED_TIME_HOUR);
		checkRequired(txtPrescribedTimeMin, NAM_PRESCRIBED_TIME_MIN, PRM_TXT_PRESCRIBED_TIME_MIN);
		/*
				checkRequired(txtCautionDayHour, NAM_CAUTION_DAY_HOUR, PRM_TXT_CAUTION_DAY_HOUR);
				checkRequired(txtCautionDayMin, NAM_CAUTION_DAY_MIN, PRM_TXT_CAUTION_DAY_MIN);
				checkRequired(txtCautionTermHour, NAM_CAUTION_TERM_HOUR, PRM_TXT_CAUTION_TERM_HOUR);
				checkRequired(txtCautionTermMin, NAM_CAUTION_TERM_MIN, PRM_TXT_CAUTION_TERM_MIN);
				checkRequired(txtCautionYearHour, NAM_CAUTION_YEAR_HOUR, PRM_TXT_CAUTION_YEAR_HOUR);
				checkRequired(txtCautionYearMin, NAM_CAUTION_YEAR_MIN, PRM_TXT_CAUTION_YEAR_MIN);
				checkRequired(txtLimitDayHour, NAM_LIMIT_DAY_HOUR, PRM_TXT_LIMIT_DAY_HOUR);
				checkRequired(txtLimitDayMin, NAM_LIMIT_DAY_MIN, PRM_TXT_LIMIT_DAY_MIN);
				checkRequired(txtLimitTermHour, NAM_LIMIT_TERM_HOUR, PRM_TXT_LIMIT_TERM_HOUR);
				checkRequired(txtLimitTermMin, NAM_LIMIT_TERM_MIN, PRM_TXT_LIMIT_TERM_MIN);
				checkRequired(txtLimitYearHour, NAM_LIMIT_YEAR_HOUR, PRM_TXT_LIMIT_YEAR_HOUR);
				checkRequired(txtLimitYearMin, NAM_LIMIT_YEAR_MIN, PRM_TXT_LIMIT_YEAR_MIN);
				checkRequired(txtRateTerm, NAM_RATE_TERM, PRM_TXT_RATE_TERM);
				checkRequired(txtRateYear, NAM_RATE_YEAR, PRM_TXT_RATE_YEAR);
		*/
		// ^CvmF
		checkCode(txtLCode, NAM_LCODE, PRM_TXT_LCODE);
		checkNumber(txtPrescribedTimeHour, NAM_PRESCRIBED_TIME_HOUR, PRM_TXT_PRESCRIBED_TIME_HOUR);
		checkNumber(txtPrescribedTimeMin, NAM_PRESCRIBED_TIME_MIN, PRM_TXT_PRESCRIBED_TIME_MIN);
		/*
				checkNumber(txtCautionDayHour, NAM_CAUTION_DAY_HOUR, PRM_TXT_CAUTION_DAY_HOUR);
				checkNumber(txtCautionDayMin, NAM_CAUTION_DAY_MIN, PRM_TXT_CAUTION_DAY_MIN);
				checkNumber(txtCautionTermHour, NAM_CAUTION_TERM_HOUR, PRM_TXT_CAUTION_TERM_HOUR);
				checkNumber(txtCautionTermMin, NAM_CAUTION_TERM_MIN, PRM_TXT_CAUTION_TERM_MIN);
				checkNumber(txtCautionYearHour, NAM_CAUTION_YEAR_HOUR, PRM_TXT_CAUTION_YEAR_HOUR);
				checkNumber(txtCautionYearMin, NAM_CAUTION_YEAR_MIN, PRM_TXT_CAUTION_YEAR_MIN);
				checkNumber(txtLimitDayHour, NAM_LIMIT_DAY_HOUR, PRM_TXT_LIMIT_DAY_HOUR);
				checkNumber(txtLimitDayMin, NAM_LIMIT_DAY_MIN, PRM_TXT_LIMIT_DAY_MIN);
				checkNumber(txtLimitTermHour, NAM_LIMIT_TERM_HOUR, PRM_TXT_LIMIT_TERM_HOUR);
				checkNumber(txtLimitTermMin, NAM_LIMIT_TERM_MIN, PRM_TXT_LIMIT_TERM_MIN);
				checkNumber(txtLimitYearHour, NAM_LIMIT_YEAR_HOUR, PRM_TXT_LIMIT_YEAR_HOUR);
				checkNumber(txtLimitYearMin, NAM_LIMIT_YEAR_MIN, PRM_TXT_LIMIT_YEAR_MIN);
				checkNumber(txtRateTerm, NAM_RATE_TERM, PRM_TXT_RATE_TERM);
				checkNumber(txtRateYear, NAM_RATE_YEAR, PRM_TXT_RATE_YEAR);
		*/
		// 񒷊mF
		checkLength(txtLCode, LEN_LCODE, NAM_LCODE, PRM_TXT_LCODE);
		checkLength(txtLName, LEN_LNAME, NAM_LNAME, PRM_TXT_LNAME);
		checkLength(txtPrescribedTimeHour, LEN_PRESCRIBED_TIME_HOUR, NAM_PRESCRIBED_TIME_HOUR,
				PRM_TXT_PRESCRIBED_TIME_HOUR);
		checkLength(txtPrescribedTimeMin, LEN_PRESCRIBED_TIME_MIN, NAM_PRESCRIBED_TIME_MIN, PRM_TXT_PRESCRIBED_TIME_MIN);
		/*
				checkLength(txtCautionDayHour, LEN_CAUTION_DAY_HOUR, NAM_CAUTION_DAY_HOUR, PRM_TXT_CAUTION_DAY_HOUR);
				checkLength(txtCautionDayMin, LEN_CAUTION_DAY_MIN, NAM_CAUTION_DAY_MIN, PRM_TXT_CAUTION_DAY_MIN);
				checkLength(txtCautionTermHour, LEN_CAUTION_TERM_HOUR, NAM_CAUTION_TERM_HOUR, PRM_TXT_CAUTION_TERM_HOUR);
				checkLength(txtCautionTermMin, LEN_CAUTION_TERM_MIN, NAM_CAUTION_TERM_MIN, PRM_TXT_CAUTION_TERM_MIN);
				checkLength(txtCautionYearHour, LEN_CAUTION_YEAR_HOUR, NAM_CAUTION_YEAR_HOUR, PRM_TXT_CAUTION_YEAR_HOUR);
				checkLength(txtCautionYearMin, LEN_CAUTION_YEAR_MIN, NAM_CAUTION_YEAR_MIN, PRM_TXT_CAUTION_YEAR_MIN);
				checkLength(txtLimitDayHour, LEN_LIMIT_DAY_HOUR, NAM_LIMIT_DAY_HOUR, PRM_TXT_LIMIT_DAY_HOUR);
				checkLength(txtLimitDayMin, LEN_LIMIT_DAY_MIN, NAM_LIMIT_DAY_MIN, PRM_TXT_LIMIT_DAY_MIN);
				checkLength(txtLimitTermHour, LEN_LIMIT_TERM_HOUR, NAM_LIMIT_TERM_HOUR, PRM_TXT_LIMIT_TERM_HOUR);
				checkLength(txtLimitTermMin, LEN_LIMIT_TERM_MIN, NAM_LIMIT_TERM_MIN, PRM_TXT_LIMIT_TERM_MIN);
				checkLength(txtLimitYearHour, LEN_LIMIT_YEAR_HOUR, NAM_LIMIT_YEAR_HOUR, PRM_TXT_LIMIT_YEAR_HOUR);
				checkLength(txtLimitYearMin, LEN_LIMIT_YEAR_MIN, NAM_LIMIT_YEAR_MIN, PRM_TXT_LIMIT_YEAR_MIN);
				checkLength(txtRateTerm, LEN_RATE_TERM, NAM_RATE_TERM, PRM_TXT_RATE_TERM);
				checkLength(txtRateYear, LEN_RATE_YEAR, NAM_RATE_YEAR, PRM_TXT_RATE_YEAR);
		*/
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	/**
	 * @return txtLCode
	 */
	public String getTxtLCode() {
		return txtLCode;
	}
	
	/**
	 * @return txtLName
	 */
	public String getTxtLName() {
		return txtLName;
	}
	
	/**
	 * @return pltTermType
	 */
	public String getPltTermType() {
		return pltTermType;
	}
	
	/**
	 * @return txtPrescribedTimeHour
	 */
	public String getTxtPrescribedTimeHour() {
		return txtPrescribedTimeHour;
	}
	
	/**
	 * @return txtPrescribedTimeMin
	 */
	public String getTxtPrescribedTimeMin() {
		return txtPrescribedTimeMin;
	}
	
	/**
	 * @return txtCautionDayHour
	 */
	public String getTxtCautionDayHour() {
		return txtCautionDayHour;
	}
	
	/**
	 * @return txtCautionDayMin
	 */
	public String getTxtCautionDayMin() {
		return txtCautionDayMin;
	}
	
	/**
	 * @return txtCautionTermHour
	 */
	public String getTxtCautionTermHour() {
		return txtCautionTermHour;
	}
	
	/**
	 * @return txtCautionTermMin
	 */
	public String getTxtCautionTermMin() {
		return txtCautionTermMin;
	}
	
	/**
	 * @return txtCautionYearHour
	 */
	public String getTxtCautionYearHour() {
		return txtCautionYearHour;
	}
	
	/**
	 * @return txtCautionYearMin
	 */
	public String getTxtCautionYearMin() {
		return txtCautionYearMin;
	}
	
	/**
	 * @return txtLimitDayHour
	 */
	public String getTxtLimitDayHour() {
		return txtLimitDayHour;
	}
	
	/**
	 * @return txtLimitDayMin
	 */
	public String getTxtLimitDayMin() {
		return txtLimitDayMin;
	}
	
	/**
	 * @return txtLimitTermHour
	 */
	public String getTxtLimitTermHour() {
		return txtLimitTermHour;
	}
	
	/**
	 * @return txtLimitTermMin
	 */
	public String getTxtLimitTermMin() {
		return txtLimitTermMin;
	}
	
	/**
	 * @return txtLimitYearHour
	 */
	public String getTxtLimitYearHour() {
		return txtLimitYearHour;
	}
	
	/**
	 * @return txtLimitYearMin
	 */
	public String getTxtLimitYearMin() {
		return txtLimitYearMin;
	}
	
	/**
	 * @return txtRateTerm
	 */
	public String getTxtRateTerm() {
		return txtRateTerm;
	}
	
	/**
	 * @return txtRateYear
	 */
	public String getTxtRateYear() {
		return txtRateYear;
	}
	
	/**
	 * @return txtDeleteFlag
	 */
	public String getPltDeleteFlag() {
		return pltDeleteFlag;
	}
	
	/**
	 * @return txtLCode
	 */
	public String getEscTxtLCode() {
		return escapeHTML(txtLCode);
	}
	
	/**
	 * @return txtLName
	 */
	public String getEscTxtLName() {
		return escapeHTML(txtLName);
	}
	
	/**
	 * @return txtPrescribedTimeHour
	 */
	public String getEscTxtPrescribedTimeHour() {
		return escapeHTML(txtPrescribedTimeHour);
	}
	
	/**
	 * @return txtPrescribedTimeMin
	 */
	public String getEscTxtPrescribedTimeMin() {
		return escapeHTML(txtPrescribedTimeMin);
	}
	
	/**
	 * @return txtCautionDayHour
	 */
	public String getEscTxtCautionDayHour() {
		return escapeHTML(txtCautionDayHour);
	}
	
	/**
	 * @return txtCautionDayMin
	 */
	public String getEscTxtCautionDayMin() {
		return escapeHTML(txtCautionDayMin);
	}
	
	/**
	 * @return txtCautionTermHour
	 */
	public String getEscTxtCautionTermHour() {
		return escapeHTML(txtCautionTermHour);
	}
	
	/**
	 * @return txtCautionTermMin
	 */
	public String getEscTxtCautionTermMin() {
		return escapeHTML(txtCautionTermMin);
	}
	
	/**
	 * @return txtCautionYearHour
	 */
	public String getEscTxtCautionYearHour() {
		return escapeHTML(txtCautionYearHour);
	}
	
	/**
	 * @return txtCautionYearMin
	 */
	public String getEscTxtCautionYearMin() {
		return escapeHTML(txtCautionYearMin);
	}
	
	/**
	 * @return txtLimitDayHour
	 */
	public String getEscTxtLimitDayHour() {
		return escapeHTML(txtLimitDayHour);
	}
	
	/**
	 * @return txtLimitDayMin
	 */
	public String getEscTxtLimitDayMin() {
		return escapeHTML(txtLimitDayMin);
	}
	
	/**
	 * @return txtLimitTermHour
	 */
	public String getEscTxtLimitTermHour() {
		return escapeHTML(txtLimitTermHour);
	}
	
	/**
	 * @return txtLimitTermMin
	 */
	public String getEscTxtLimitTermMin() {
		return escapeHTML(txtLimitTermMin);
	}
	
	/**
	 * @return txtLimitYearHour
	 */
	public String getEscTxtLimitYearHour() {
		return escapeHTML(txtLimitYearHour);
	}
	
	/**
	 * @return txtLimitYearMin
	 */
	public String getEscTxtLimitYearMin() {
		return escapeHTML(txtLimitYearMin);
	}
	
	/**
	 * @return txtRateTerm
	 */
	public String getEscTxtRateTerm() {
		return escapeHTML(txtRateTerm);
	}
	
	/**
	 * @return txtRateYear
	 */
	public String getEscTxtRateYear() {
		return escapeHTML(txtRateYear);
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param txtLCode Zbg txtLCode
	 */
	public void setTxtLCode(String txtLCode) {
		this.txtLCode = txtLCode;
	}
	
	/**
	 * @param txtLName Zbg txtLName
	 */
	public void setTxtLName(String txtLName) {
		this.txtLName = txtLName;
	}
	
	/**
	 * @param pltTermType Zbg pltTermType
	 */
	public void setPltTermType(String pltTermType) {
		this.pltTermType = pltTermType;
	}
	
	/**
	 * @param txtPrescribedTimeHour Zbg txtPrescribedTimeHour
	 */
	public void setTxtPrescribedTimeHour(String txtPrescribedTimeHour) {
		this.txtPrescribedTimeHour = txtPrescribedTimeHour;
	}
	
	/**
	 * @param txtPrescribedTimeMin Zbg txtPrescribedTimeMin
	 */
	public void setTxtPrescribedTimeMin(String txtPrescribedTimeMin) {
		this.txtPrescribedTimeMin = txtPrescribedTimeMin;
	}
	
	/**
	 * @param txtCautionDayHour Zbg txtCautionDayHour
	 */
	public void setTxtCautionDayHour(String txtCautionDayHour) {
		this.txtCautionDayHour = txtCautionDayHour;
	}
	
	/**
	 * @param txtCautionDayMin Zbg txtCautionDayMin
	 */
	public void setTxtCautionDayMin(String txtCautionDayMin) {
		this.txtCautionDayMin = txtCautionDayMin;
	}
	
	/**
	 * @param txtCautionTermHour Zbg txtCautionTermHour
	 */
	public void setTxtCautionTermHour(String txtCautionTermHour) {
		this.txtCautionTermHour = txtCautionTermHour;
	}
	
	/**
	 * @param txtCautionTermMin Zbg txtCautionTermMin
	 */
	public void setTxtCautionTermMin(String txtCautionTermMin) {
		this.txtCautionTermMin = txtCautionTermMin;
	}
	
	/**
	 * @param txtCautionYearHour Zbg txtCautionYearHour
	 */
	public void setTxtCautionYearHour(String txtCautionYearHour) {
		this.txtCautionYearHour = txtCautionYearHour;
	}
	
	/**
	 * @param txtCautionYearMin Zbg txtCautionYearMin
	 */
	public void setTxtCautionYearMin(String txtCautionYearMin) {
		this.txtCautionYearMin = txtCautionYearMin;
	}
	
	/**
	 * @param txtLimitDayHour Zbg txtLimitDayHour
	 */
	public void setTxtLimitDayHour(String txtLimitDayHour) {
		this.txtLimitDayHour = txtLimitDayHour;
	}
	
	/**
	 * @param txtLimitDayMin Zbg txtLimitDayMin
	 */
	public void setTxtLimitDayMin(String txtLimitDayMin) {
		this.txtLimitDayMin = txtLimitDayMin;
	}
	
	/**
	 * @param txtLimitTermHour Zbg txtLimitTermHour
	 */
	public void setTxtLimitTermHour(String txtLimitTermHour) {
		this.txtLimitTermHour = txtLimitTermHour;
	}
	
	/**
	 * @param txtLimitTermMin Zbg txtLimitTermMin
	 */
	public void setTxtLimitTermMin(String txtLimitTermMin) {
		this.txtLimitTermMin = txtLimitTermMin;
	}
	
	/**
	 * @param txtLimitYearHour Zbg txtLimitYearHour
	 */
	public void setTxtLimitYearHour(String txtLimitYearHour) {
		this.txtLimitYearHour = txtLimitYearHour;
	}
	
	/**
	 * @param txtLimitYearMin Zbg txtLimitYearMin
	 */
	public void setTxtLimitYearMin(String txtLimitYearMin) {
		this.txtLimitYearMin = txtLimitYearMin;
	}
	
	/**
	 * @param txtRateTerm Zbg txtRateTerm
	 */
	public void setTxtRateTerm(String txtRateTerm) {
		this.txtRateTerm = txtRateTerm;
	}
	
	/**
	 * @param txtRateYear Zbg txtRateYear
	 */
	public void setTxtRateYear(String txtRateYear) {
		this.txtRateYear = txtRateYear;
	}
	
	/**
	 * @param pltDeleteFlag Zbg pltDeleteFlag
	 */
	public void setPltDeleteFlag(String pltDeleteFlag) {
		this.pltDeleteFlag = pltDeleteFlag;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
