/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.dto.CmAuthorityDto;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.vo.MosPMenuGuideVo;

/**
 * @author yoshida
 *
 */
public class MosPMenuGuideAction extends MosPAction {
	
	/**
	 * RXgN^
	 */
	public MosPMenuGuideAction() {
		super();
	}
	
	public void action() throws Exception {
		// VȌ
		prepareVo(false);
		// 
		init();
		// \
		show();
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new MosPMenuGuideVo();
	}
	
	@Override
	protected void init() throws Exception {
		// ZbVێ̏
		initStoredData();
		// RlNV擾
		getConnection();
	}
	
	@Override
	protected void show() throws Exception {
		// ̎擾
		CmAuthorityDto dto = part().menu().getUserAuthInfo();
		List<String[]> listMenu = new ArrayList<String[]>();
		MosPMenuGuideVo vo = (MosPMenuGuideVo)getVo();
		if (chkExistDto(dto)) {
			if (StringUtil.isNotNull(dto.getEmployee())) {
				listMenu.add(StringUtil.createArray(CommonConst.TTL_MENU_INPUT, CommonConst.CMD_MENU_INPUT));
			}
			if (StringUtil.isNotNull(dto.getManager())) {
				listMenu.add(StringUtil.createArray(CommonConst.TTL_MENU_MANAGE, CommonConst.CMD_MENU_MAMAGE));
			}
			if (StringUtil.isNotNull(dto.getPayroll())) {
				listMenu.add(StringUtil.createArray(CommonConst.TTL_MENU_PAYROLL, CommonConst.CMD_MENU_PAYROLL));
			}
			if (StringUtil.isNotNull(dto.getHuman())) {
				listMenu.add(StringUtil.createArray(CommonConst.TTL_MENU_HUMAN, CommonConst.CMD_MENU_HUMAN));
			}
		}
		String[][] aryMenuGuide = listMenu.toArray(new String[listMenu.size()][2]);
		vo.setAryMenuGuide(aryMenuGuide);
	}
	
}
