/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.common.HtmlUtility;
import jp.mosp.common.common.ListVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.ValidateUtility;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;

/**
 * @author yoshida
 *
 */
public class MosPVo extends ListVo {
	
	private static final long	serialVersionUID	= 2955340745357599845L;
	
	// j[R}h
	/**
	 * K1910
	 */
	public final String			CMD_MENU_INPUT		= CommonConst.CMD_MENU_INPUT;
	/**
	 * K2910
	 */
	public final String			CMD_MENU_MAMAGE		= CommonConst.CMD_MENU_MAMAGE;
	/**
	 * P1910
	 */
	public final String			CMD_MENU_PAYROLL	= CommonConst.CMD_MENU_PAYROLL;
	/**
	 * H1910
	 */
	public final String			CMD_MENU_HUMAN		= CommonConst.CMD_MENU_HUMAN;
	/**
	 * gp
	 */
	public final String			CMD_MENU_SYSTEM		= CommonConst.CMD_MENU_SYSTEM;
	/**
	 * S2910
	 */
	public final String			CMD_MENU_SYSTEM2	= CommonConst.CMD_MENU_SYSTEM2;
	/**
	 * namL[(R}hNo.)
	 */
	public static final String	C_MENU_BTN_CMD		= "C_MENU_BTN_CMD";
	/**
	 * namL[({^)
	 */
	public static final String	C_MENU_BTN_NAM		= "C_MENU_BTN_NAM";
	/**
	 * namL[(Tu^Cg)
	 */
	public static final String	C_MENU_SUB_TITLE	= "C_MENU_SUB_TITLE";
	
	private String				lblKCode;
	private String				lblKName;
	private String				lblSectionName;
	

	/**
	 * RXgN^
	 */
	public MosPVo() {
		super();
		needDirectJs = true;
	}
	
	@Override
	public void initVo(Properties cfg, Properties msg, String cmd, CmAspUserDto aspUser, CmUserDto user) {
		super.initVo(cfg, msg, cmd, aspUser, user);
		// gJS̐ݒ
		setExtraJs();
	}
	
	/**
	 * Tu^Cg擾
	 * @param subTitle Tu^Cg
	 * @param cmdMenu  j[R}h
	 * @return Tu^CgHTML
	 */
	@Deprecated
	public String getSubTitle(String subTitle, String cmdMenu) {
		return getSubTitle(subTitle, cmdMenu, cmdMenu, subTitle);
	}
	
	/**
	 * Tu^Cg擾iTuj[j
	 * @param subTitle 		Tu^Cg
	 * @param cmdMenu  		j[R}h
	 * @param cmdUp			ʃR}h
	 * @param cmdUpName		ʃR}h
	 * @return Tu^CgHTML
	 */
	@Deprecated
	public String getSubTitle(String subTitle, String cmdMenu, String cmdUp, String cmdUpName) {
		String tag = null;
		if (useLogo()) {
			tag = getTagSubTitleLogo(subTitle, cmdMenu, cmdUp, cmdUpName);
		} else {
			tag = getTagSubTitleNoLogo(subTitle, cmdMenu, cmdUp, cmdUpName);
		}
		return tag;
	}
	
	/**
	 * Tu^Cg擾iTuj[j
	 * @param subTitle		Tu^Cg
	 * @param cmdMenu		j[R}h
	 * @param cmdUp			ʃR}h
	 * @param cmdUpName		ʃR}h
	 * @return Tu^CgHTML
	 */
	@Deprecated
	private String getTagSubTitleLogo(String subTitle, String cmdMenu, String cmdUp, String cmdUpName) {
		StringBuffer sb = new StringBuffer();
		sb.append("<div class=\"Header\">");
		sb.append("<table><tr>");
		sb.append("<td id=\"logoTd\" >");
		sb.append("<div class=\"logoBar\">");
		sb.append(getTagLogoImage());
		sb.append("</div>");
		sb.append("</td><td>");
		sb.append("<div class=\"SubTitleBar\">");
		sb.append(subTitle);
		sb.append("</div>");
		sb.append("</td><td>");
		sb.append("<div class=\"MenuButtonBar\">");
		if (!cmdUp.equals(cmdMenu)) {
			sb.append(getButtonTag("", cmdUp, cmdUpName));
		}
		sb.append(getButtonTag("btnMenu", cmdMenu, CommonConst.NAM_TO_MENU));
		sb.append(getButtonTag("btnLogout", MospConst.CMD_LOGOUT, CommonConst.NAM_LOGOUT));
		sb.append("</div>");
		sb.append("</td></tr></table>");
		sb.append("</div>");
		return sb.toString();
	}
	
	/**
	 * Tu^Cg擾iTuj[j
	 * @param subTitle		Tu^Cg
	 * @param cmdMenu		j[R}h
	 * @param cmdUp			ʃR}h
	 * @param cmdUpName		ʃR}h
	 * @return Tu^CgHTML
	 */
	@Deprecated
	private String getTagSubTitleNoLogo(String subTitle, String cmdMenu, String cmdUp, String cmdUpName) {
		StringBuffer sb = new StringBuffer();
		sb.append("<div class=\"Header\">");
		sb.append("<div class=\"MenuButtonBar\">");
		if (!cmdUp.equals(cmdMenu)) {
			sb.append(getButtonTag("", cmdUp, cmdUpName));
		}
		sb.append(getButtonTag("btnMenu", cmdMenu, CommonConst.NAM_TO_MENU));
		sb.append(getButtonTag("btnLogout", MospConst.CMD_LOGOUT, CommonConst.NAM_LOGOUT));
		sb.append("</div>");
		sb.append("<div class=\"SubTitleBar\">");
		sb.append(subTitle);
		sb.append("</div>");
		sb.append("</div>");
		return sb.toString();
	}
	
	/**
	 * {^^O擾
	 * @param id		id
	 * @param cmd		R}hNo.
	 * @param name		{^
	 * @return {^^OHTML
	 */
	public static String getButtonTag(String id, String cmd, String name) {
		StringBuffer sb = new StringBuffer();
		sb.append("<button type=\"button\" ");
		if (id.length() != 0) {
			sb.append("id=\"");
			sb.append(id);
			sb.append("\"");
		}
		sb.append(" onclick=\"doSubmit(document.form, '");
		sb.append(cmd);
		sb.append("')\">");
		sb.append(name);
		sb.append("</button>");
		return sb.toString();
	}
	
	/**
	 * {^^O擾
	 * @param id		id
	 * @param cssClass css̃NX
	 * @param cmd		R}hNo.
	 * @param name		{^
	 * @return {^^OHTML
	 */
	public static String getButtonTag(String id, String cssClass, String cmd, String name) {
		StringBuffer sb = new StringBuffer();
		sb.append("<button type=\"button\" ");
		if (id.length() != 0) {
			sb.append("id=\"");
			sb.append(id);
			sb.append("\"");
		}
		sb.append(" class=\"");
		sb.append(cssClass);
		sb.append("\"");
		sb.append(" onclick=\"doSubmit(document.form, '");
		sb.append(cmd);
		sb.append("')\">");
		sb.append(name);
		sb.append("</button>");
		return sb.toString();
	}
	
	/**
	 * SC[W^O擾
	 * @return SC[W^OHTML
	 */
	@Deprecated
	public String getTagLogoImage() {
		if (useLogo()) {
			return HtmlUtility.getTagLogoImage(CommonConst.FILE_LOGO, CommonConst.NAME_LOGO);
		}
		return "";
	}
	
	/**
	 * Sp۔f
	 * @return
	 * <p>
	 * S𗘗pꍇtrueAłȂꍇfalse
	 * </p>
	 */
	@Deprecated
	public boolean useLogo() {
		return Boolean.parseBoolean(cfg.getProperty(CommonConst.PPT_USE_LOGO));
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		
	}
	
	/**
	 * JavaScript(ݒz)擾
	 * @param name       ϐ
	 * @param arySetting ݒz(String[i][2])
	 * @return JavaScript(ݒz)
	 */
	public static String getDefaultJs(String name, String[][] arySetting) {
		StringBuffer sb = new StringBuffer();
		sb.append("var ");
		sb.append(escapeHTML(name));
		sb.append(" = new Object();");
		for (String[] element : arySetting) {
			sb.append(name);
			sb.append("[\"");
			sb.append(escapeHTML(element[0]));
			sb.append("\"] = \"");
			sb.append(escapeHTML(element[1]));
			sb.append("\";");
		}
		return sb.toString();
	}
	
	/**
	 * JavaScript(ݒz)擾
	 * @param name       ϐ
	 * @param arySetting ݒz
	 * @return JavaScript(ݒz)
	 */
	public static String getSettingJs(String name, String[][] arySetting) {
		StringBuffer sb = new StringBuffer();
		sb.append("var ");
		sb.append(escapeHTML(name));
		sb.append(" = new Object();");
		for (String[] element : arySetting) {
			sb.append(name);
			sb.append("[\"");
			sb.append(escapeHTML(element[0]));
			sb.append("\"] = new Array(");
			sb.append(element.length - 1);
			sb.append(");");
			for (int j = 1; j < element.length; j++) {
				sb.append(name);
				sb.append("[\"");
				sb.append(escapeHTML(element[0]));
				sb.append("\"][");
				sb.append(j - 1);
				sb.append("] = \"");
				sb.append(escapeHTML(element[j]));
				sb.append("\";");
			}
		}
		return sb.toString();
	}
	
	/**
	 * JavaScript(ݒz)擾
	 * @param name       ϐ
	 * @param arySetting ݒz
	 * @return JavaScript(ݒz)
	 */
	public static String getArrayJs(String name, String[][] arySetting) {
		StringBuffer sb = new StringBuffer();
		sb.append("var ");
		sb.append(escapeHTML(name));
		sb.append(" = new Array(");
		sb.append(arySetting.length);
		sb.append(");");
		for (String[] element : arySetting) {
			sb.append(name);
			sb.append("[");
			sb.append(escapeHTML(element[0]));
			sb.append("] = new Array(");
			sb.append(2);
			sb.append(");");
			
			sb.append(name);
			sb.append("[");
			sb.append(escapeHTML(element[0]));
			sb.append("][");
			sb.append(0);
			sb.append("] = \"");
			sb.append(escapeHTML(element[0]));
			sb.append("\";");
			
			sb.append(name);
			sb.append("[");
			sb.append(escapeHTML(element[0]));
			sb.append("][");
			sb.append(1);
			sb.append("] = \"");
			sb.append(escapeHTML(element[1]));
			sb.append("\";");
		}
		return sb.toString();
	}
	
	/**
	 * JavaScript(ݒz)擾
	 * @param name       ϐ
	 * @param arySetting ݒz
	 * @return JavaScript(ݒz)
	 */
	public static String getArrayCodeJs(String name, String[][] arySetting) {
		StringBuffer sb = new StringBuffer();
		sb.append("var ");
		sb.append(escapeHTML(name));
		sb.append(" = new Array(");
		sb.append(arySetting.length);
		sb.append(");");
		for (int i = 0; i < arySetting.length; i++) {
			sb.append(name);
			sb.append("[");
			sb.append(i);
			sb.append("] = new Array(");
			sb.append(2);
			sb.append(");");
			
			sb.append(name);
			sb.append("[");
			sb.append(i);
			sb.append("][");
			sb.append(0);
			sb.append("] = \"");
			sb.append(escapeHTML(arySetting[i][0]));
			sb.append("\";");
			
			sb.append(name);
			sb.append("[");
			sb.append(i);
			sb.append("][");
			sb.append(1);
			sb.append("] = \"");
			sb.append(escapeHTML(arySetting[i][1]));
			sb.append("\";");
		}
		return sb.toString();
	}
	
	/**
	 * JavaScript(ݒz)擾
	 * @param name		ϐ
	 * @param aryCodes	ݒz
	 * @return JavaScript(ݒz)
	 */
	public static String getCodesJs(String name, ArrayList<String[][]> aryCodes) {
		StringBuffer sb = new StringBuffer();
		sb.append("var ");
		sb.append(escapeHTML(name));
		sb.append(" = new Object();");
		for (int i = 0; i < aryCodes.size(); i++) {
			String[][] aryCode = aryCodes.get(i);
			if (aryCode.length == 0 || aryCode[0].length == 0) {
				break;
			}
			sb.append(name);
			sb.append("[\"");
			sb.append(escapeHTML(aryCode[0][0]));
			sb.append("\"] = new Array(");
			sb.append(aryCode.length);
			sb.append(");");
			for (int j = 0; j < aryCode.length; j++) {
				sb.append(name);
				sb.append("[\"");
				sb.append(escapeHTML(aryCode[j][0]));
				sb.append("\"][" + j + "] = new Array(");
				sb.append(aryCode[j].length - 1);
				sb.append(");");
				for (int k = 1; k < aryCode[j].length; k++) {
					sb.append(name);
					sb.append("[\"");
					sb.append(escapeHTML(aryCode[j][0]));
					sb.append("\"][" + j + "][");
					sb.append(k - 1);
					sb.append("] = \"");
					sb.append(escapeHTML(aryCode[j][k]));
					sb.append("\";");
				}
			}
		}
		return sb.toString();
	}
	
	/**
	 * `FbN{bNXNGXgp[^擾
	 * @param value `FbN{bNXNGXgp[^l
	 * @return ϊ`FbN{bNXNGXgp[^l
	 */
	public String getCheckBoxParam(String value) {
		if (value == null) {
			return String.valueOf(CommonConst.CHECKBOX_OFF);
		} else if (value.equals(CommonConst.CHECKBOX_CHARACTER_ON)) {
			return String.valueOf(CommonConst.CHECKBOX_ON);
		} else {
			return value;
		}
	}
	
	/**
	 * `FbN{bNXNGXgp[^擾(zp)
	 * @param aryValue `FbN{bNXNGXgp[^l(z)
	 * @return ϊ`FbN{bNXNGXgp[^l(z)
	 */
	public String[] getAryCheckBoxParam(String[] aryValue) {
		String[] aryString;
		aryString = new String[aryValue.length];
		for (int i = 0; i < aryValue.length; i++) {
			if (aryValue[i] == null) {
				aryString[i] = String.valueOf(CommonConst.CHECKBOX_OFF);
			} else if (aryValue[i].equals(CommonConst.CHECKBOX_CHARACTER_ON)) {
				aryString[i] = String.valueOf(CommonConst.CHECKBOX_ON);
			} else {
				aryString[i] = aryValue[i];
			}
		}
		return aryString;
	}
	
	/**
	 * `FbN{bNXNGXgp[^擾
	 * @param value `FbN{bNXNGXgp[^l
	 * @return ϊ`FbN{bNXNGXgp[^l
	 */
	public String getCheckBoxChecked(String value) {
		if (value == null) {
			return "";
		} else if (value.equals("0")) {
			return "";
		}
		return "checked=\"checked\"";
	}
	
	/**
	 * `FbN{bNXNGXgp[^擾(zp)
	 * @param aryValue `FbN{bNXNGXgp[^l(z)
	 * @return ϊ`FbN{bNXNGXgp[^l(z)
	 */
	public String[] getAryCheckBoxChecked(String[] aryValue) {
		String[] aryString;
		aryString = new String[aryValue.length];
		for (int i = 0; i < aryValue.length; i++) {
			if (aryValue[i] == null) {
				aryString[i] = "";
			} else if (aryValue[i].equals("0")) {
				aryString[i] = "";
			} else {
				aryString[i] = "checked=\"checked\"";
			}
		}
		return aryString;
	}
	
	/**
	 * zGXP[v
	 * @param array Ώ۔z
	 * @return GXP[vς݂̔z
	 */
	public static String[] escapeArray(String[] array) {
		for (int i = 0; i < array.length; i++) {
			array[i] = escapeHTML(array[i]);
		}
		return array;
	}
	
	/**
	 * zGXP[v
	 * @param array Ώ۔z
	 * @return GXP[vς݂̔z
	 */
	public static String[][] escapeArray(String[][] array) {
		for (int i = 0; i < array.length; i++) {
			for (int j = 0; j < array[i].length; j++) {
				array[i][j] = escapeHTML(array[i][j]);
			}
		}
		return array;
	}
	
	/**
	 * ZNgIvVo
	 * @param array ZNgIvVe
	 * @param value Il
	 * @return HTMLZNgIvV
	 */
	public static String getSelectOption(String[][] array, String[] value) {
		StringBuffer sb = new StringBuffer();
		for (String[] element : array) {
			String selected = "";
			if (value != null) {
				for (String element2 : value) {
					if (element[0].equals(element2)) {
						selected = "selected=\"selected\"";
					}
				}
			}
			sb.append("<option value=\"");
			sb.append(element[0]);
			sb.append("\"");
			sb.append(selected);
			sb.append(">");
			sb.append(element[1]);
			sb.append("</option>");
		}
		return sb.toString();
	}
	
	/**
	 * ̎擾
	 * @param code  擾ΏۃR[h
	 * @param array R[hƃR[ĥ܂񂾔z
	 * @return R[h
	 */
	protected String getCodeName(String code, String[][] array) {
		return StringUtil.getCodeName(code, array);
	}
	
	/**
	 * tÓmF(a)
	 * @param list      a񃊃Xg
	 * @param era       N
	 * @param year      N
	 * @param month     (1`12)
	 * @param day       
	 * @param name      mFΏۖ
	 * @param idYear    mFΏۃtB[hID
	 * @param idDay     mFΏۃtB[hID
	 * @param isDetails ׃tO
	 * @param rowNo     sԍ
	 * @throws MospException	MosPOꍇ
	 */
	protected void checkDate(List<MosPConfDto> list, String era, int year, int month, int day, String name,
			String idYear, String idDay, boolean isDetails, int rowNo) throws MospException {
		for (MosPConfDto dto : list) {
			if (!dto.getConfId().equals(era)) {
				continue;
			}
			Date startDate = getDate(dto.getConfCode());
			Date endDate = getDate(dto.getConfValue());
			int gregorianYear = MospUtility.getYear(startDate) + year - 1;
			Date date = getDate(list, era, String.valueOf(year), String.valueOf(month), String.valueOf(day));
			if (isDetails) {
				checkDate(gregorianYear, month, day, name, rowNo, idDay);
				if (ValidateUtility.chkDate(year, month - 1, day)) {
					checkTerm(date, startDate, endDate, name, rowNo, idYear);
				}
			} else {
				checkDate(gregorianYear, month, day, name, idDay);
				if (ValidateUtility.chkDate(year, month - 1, day)) {
					checkTerm(date, startDate, endDate, name, idYear);
				}
			}
			return;
		}
		throw new MospException(MospConst.EX_DATE_INVALID);
	}
	
	/**
	 * tmF(K{łȂatp)
	 * @param list      a񃊃Xg
	 * @param strEra    N
	 * @param strYear   N
	 * @param strMonth  (1`12)
	 * @param strDay    
	 * @param name      mFΏۖ
	 * @param idEra    mFΏۃtB[hID
	 * @param idYear    mFΏۃtB[hID
	 * @param idMonth   mFΏۃtB[hID
	 * @param idDay     mFΏۃtB[hID
	 * @param isDetails ׃tO
	 * @param rowNo     sԍ
	 * @return t
	 * @throws MospException 	MosPOꍇ
	 */
	protected Date checkDateParam(List<MosPConfDto> list, String strEra, String strYear, String strMonth,
			String strDay, String name, String idEra, String idYear, String idMonth, String idDay, boolean isDetails,
			int rowNo) throws MospException {
		if ((strEra == null || strEra.equals("")) && (strYear == null || strYear.equals(""))
				&& (strMonth == null || strMonth.equals("")) && (strDay == null || strDay.equals(""))) {
			return null;
		}
		if (isDetails) {
			checkRequired(strEra, name, rowNo, idEra);
		} else {
			checkRequired(strEra, name, idEra);
		}
		if (!ValidateUtility.chkRequired(strEra)) {
			return null;
		}
		if (isDetails) {
			checkRequired(strYear, name, rowNo, idYear);
		} else {
			checkRequired(strYear, name, idYear);
		}
		if (!ValidateUtility.chkRequired(strYear)) {
			return null;
		}
		if (isDetails) {
			checkRequired(strMonth, name, rowNo, idMonth);
		} else {
			checkRequired(strMonth, name, idMonth);
		}
		if (!ValidateUtility.chkRequired(strMonth)) {
			return null;
		}
		if (isDetails) {
			checkRequired(strDay, name, rowNo, idDay);
		} else {
			checkRequired(strDay, name, idDay);
		}
		if (!ValidateUtility.chkRequired(strDay)) {
			return null;
		}
		Date startDate = null;
		Date endDate = null;
		for (MosPConfDto dto : list) {
			if (!dto.getConfId().equals(strEra)) {
				continue;
			}
			startDate = getDate(dto.getConfCode());
			endDate = getDate(dto.getConfValue());
			break;
		}
		checkDate(list, strEra, getIntParam(strYear), getIntParam(strMonth), getIntParam(strDay), name, idYear, idDay,
				isDetails, rowNo);
		int gregorianYear = MospUtility.getYear(startDate) + getIntParam(strYear) - 1;
		if (!ValidateUtility.chkDate(gregorianYear, getIntParam(strMonth) - 1, getIntParam(strDay))) {
			return null;
		}
		Date date = getDate(list, strEra, strYear, strMonth, strDay);
		if (!ValidateUtility.chkDate(MospUtility.getYear(date), MospUtility.getMonth(date) - 1, MospUtility
			.getDay(date))) {
			return null;
		}
		if (!ValidateUtility.chkTerm(date, startDate, endDate)) {
			return null;
		}
		return date;
	}
	
	/**
	 * a擾
	 * @param list a񃊃Xg
	 * @param date t
	 * @return tz
	 * @throws MospException 	MosPOꍇ
	 */
	public String[] getJpImperialCal(List<MosPConfDto> list, Date date) throws MospException {
		String[] aryJpDate = new String[4];
		if (date == null) {
			return aryJpDate;
		}
		for (MosPConfDto dto : list) {
			Date startDate = getDate(dto.getConfCode());
			Date endDate = getDate(dto.getConfValue());
			if (startDate.compareTo(date) <= 0 && endDate.compareTo(date) >= 0) {
				int year = MospUtility.getYear(date) - MospUtility.getYear(startDate) + 1;
				aryJpDate[0] = dto.getConfId();
				aryJpDate[1] = String.valueOf(year);
				aryJpDate[2] = String.valueOf(MospUtility.getMonth(date));
				aryJpDate[3] = String.valueOf(MospUtility.getDay(date));
				return aryJpDate;
			}
		}
		throw new MospException(MospConst.EX_DATE_INVALID);
	}
	
	/**
	 * t擾(/p)
	 * @param strDate t
	 * @return t
	 * @throws MospException 	MosPOꍇ
	 */
	public Date getDate(String strDate) throws MospException {
		if (strDate == null || strDate.length() != 8) {
			throw new MospException(MospConst.EX_DATE_INVALID);
		}
		return MospUtility.getDate(strDate.substring(0, 4) + CommonConst.SEPARATOR_DATE + strDate.substring(4, 6)
				+ CommonConst.SEPARATOR_DATE + strDate.substring(6, 8));
	}
	
	/**
	 * t擾(a)
	 * @param list     a񃊃Xg
	 * @param strEra   N
	 * @param strYear  N
	 * @param strMonth (1`12)
	 * @param strDay   
	 * @return t
	 * @throws MospException	MosPOꍇ
	 */
	protected Date getDate(List<MosPConfDto> list, String strEra, String strYear, String strMonth, String strDay)
			throws MospException {
		for (MosPConfDto dto : list) {
			if (!dto.getConfId().equals(strEra)) {
				continue;
			}
			Date startDate = getDate(dto.getConfCode());
			int gregorianYear = MospUtility.getYear(startDate) + getIntParam(strYear) - 1;
			return getDate(String.valueOf(gregorianYear), strMonth, strDay);
		}
		throw new MospException(MospConst.EX_DATE_INVALID);
	}
	
	/**
	 * t擾(a)
	 * @param list a񃊃Xg
	 * @param aryEra az
	 * @param date 
	 * @return t
	 * @throws MospException	MosPOꍇ
	 */
	protected String getDateString(List<MosPConfDto> list, String[][] aryEra, Date date) throws MospException {
		if (date == null || list == null) {
			return "";
		}
		String[] strDate = getJpImperialCal(list, date);
		strDate[0] = getCodeName(strDate[0], aryEra);
		for (int i = 1; i < strDate.length; i++) {
			strDate[i] = strDate[i].length() < 2 ? CommonConst.SUPPRESS_DATE + strDate[i] : strDate[i];
		}
		return strDate[0] + strDate[1] + CommonConst.NAM_YEAR + strDate[2] + CommonConst.NAM_MONTH + strDate[3]
				+ CommonConst.NAM_DAY;
	}
	
	/**
	 * t擾()
	 * @param strMonth (1`12)
	 * @return t
	 * @throws MospException 	MosPOꍇ
	 */
	protected Date getDateForMonth(String strMonth) throws MospException {
		return getDate(String.valueOf(CommonConst.TIME_DEFAULT_YEAR), strMonth, String
			.valueOf(CommonConst.TIME_DEFAULT_DAY));
	}
	
	/**
	 * TextBox擾
	 * @param strClass  NX
	 * @param strId     id
	 * @param strValue  l
	 * @param isTextBox TextBoxtO(trueFTextBoxAfalseFLabel)
	 * @return R[h
	 */
	public static String getTextBox(String strClass, String strId, String strValue, boolean isTextBox) {
		StringBuffer sb = new StringBuffer();
		if (isTextBox) {
			sb.append("<input type=\"text\" class=\"");
			sb.append(strClass);
			sb.append("\" id=\"");
			sb.append(strId);
			sb.append("\" name=\"");
			sb.append(strId);
			sb.append("\" value=\"");
			sb.append(strValue);
			sb.append("\" />");
		} else {
			sb.append("<span class=\"");
			sb.append(strClass);
			sb.append("\" id=\"");
			sb.append(strId);
			sb.append("\">");
			sb.append(strValue);
			sb.append("</span>");
		}
		return sb.toString();
	}
	
	/**
	 * tÓmF(t)
	 * @param strDate	t(yyyy/MM/dd)
	 * @return tÓłtrueAłȂꍇfalse
	 */
	public static boolean checkStrDate(String strDate) {
		String[] aryStrDate = StringUtil.divideByComma(strDate);
		if (aryStrDate.length < 3) {
			return false;
		}
		if (ValidateUtility.chkDate(Integer.parseInt(aryStrDate[0]), Integer.parseInt(aryStrDate[1]) - 1, Integer
			.parseInt(aryStrDate[2]))) {
			return true;
		}
		return false;
	}
	
	/**
	 * CheckBox擾
	 * @param strid id
	 * @param strname name
	 * @param value checked
	 * @return sb
	 */
	public static String getCheckBox(String strid, String strname, String value) {
		StringBuffer sb = new StringBuffer();
		sb.append("<input type=\"checkbox\" class=\"CheckBox\" id=\"");
		sb.append(strid);
		sb.append("\" name=\"");
		sb.append(strname);
		sb.append("\" ");
		sb.append(value);
		sb.append(">");
		return sb.toString();
	}
	
	/**
	 * CheckBoxϕ\i\fޗ󗓂̏ꍇA\Ȃj
	 * @param strid id
	 * @param strname name
	 * @param value value
	 * @param factor \fޗ
	 * @return factor \fޗ󗓂̏ꍇA\Ȃ
	 */
	public static String getVariableCheckBox(String strid, String strname, String value, String factor) {
		StringBuffer sb = new StringBuffer();
		sb.append("<input type=\"checkbox\" class=\"CheckBox\" id=\"");
		sb.append(strid);
		sb.append("\" name=\"");
		sb.append(strname);
		sb.append("\" value=\"");
		sb.append(value);
		sb.append("\">");
		if (StringUtil.isNull(factor)) {
			return "&nbsp;";
		}
		return sb.toString();
	}
	
	/**
	 * CheckBox擾iJavascriptΉj
	 * <p>	2008/11/14	m.yoshida	\o^@\ǉΉ	</p>
	 * @param strid 	id
	 * @param strname 	name
	 * @param value 	checked
	 * @param type		Cxg^Cv
	 * @param function	function
	 * @return	sb
	 */
	public static String getCheckBoxWithJs(String strid, String strname, String value, String type, String function) {
		StringBuffer sb = new StringBuffer();
		sb.append("<input type=\"checkbox\" class=\"CheckBox\" id=\"");
		sb.append(strid);
		sb.append("\" name=\"");
		sb.append(strname);
		sb.append("\" ");
		sb.append(type);
		sb.append("=\"");
		sb.append(function);
		sb.append("\" ");
		sb.append(value);
		sb.append(">");
		return sb.toString();
	}
	
	/**
	 * tOɂ镶F̕ύX
	 * @param aryFlag tOz
	 * @param name tO
	 * @return sb
	 */
	public String changeColorText(String[][] aryFlag, String name) {
		StringBuffer sb = new StringBuffer();
		String color = "black";
		String value = StringUtil.getCodeValue(name, aryFlag);
		if (StringUtil.isFlagOff(value)) {
			color = "blue";
		} else if (StringUtil.isFlagOn(value)) {
			color = "red";
		}
		sb.append("<span style=\"color: ");
		sb.append(color);
		sb.append(";\">");
		sb.append(name);
		sb.append("</span>");
		return sb.toString();
	}
	
	/**
	 * R[h݊mF
	 * @param value 	mFΏۃR[h
	 * @param aryTarget	mFΏ۔z
	 * @param name 		mFΏۖ
	 * @param id 		mFΏۃtB[hID
	 * @throws MospException	MosPOꍇ
	 */
	protected void checkCodeExist(String value, String[][] aryTarget, String name, String id) throws MospException {
		if (value.equals(getCodeName(value, aryTarget))) {
			String errMsg = MospUtility.getMessage(msg, CommonConst.MSG_TARGET_NOT_EXIST, name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
		}
	}
	
	/**
	 * XgóB<br>
	 * \ĂŐASŐyёOŁAŃ{^o͂B<br>
	 * <p>	2009/02/25	m.yoshida	ǉ		</p>
	 * @param command R}h
	 * @param selectPage ݕ
	 * @param fullPage S
	 * @return HTMLXg񕶎
	 */
	public static String getListInfo(String command, String selectPage, String fullPage) {
		StringBuffer sb = new StringBuffer();
		int select = Integer.parseInt(selectPage);
		int full = Integer.parseInt(fullPage);
		sb.append("<div class=\"ListPageInfo\">");
		sb.append("<table>");
		sb.append("<tr>");
		sb.append("<td>");
		if (select - 1 > 0) {
			sb.append("<button type=\"button\" onclick=\"doSubmitKey(document.form, '");
			sb.append(command);
			sb.append("', '");
			sb.append(select - 1);
			sb.append("', '')\">");
		} else {
			sb.append("<button type=\"button\" disabled=\"disabled\">");
		}
		sb.append("O</button>");
		sb.append("</td>");
		if (!fullPage.equals("0")) {
			int pageNum = select / 10 * 10;
			for (int i = -1; i < 11; i++) {
				if (pageNum + i > 0 && pageNum + i <= full) {
					if (select != pageNum + i) {
						sb.append("<td><button type=\"button\" class=\"ButtonListPage\" ");
						sb.append("onclick=\"doSubmitKey(document.form, '");
						sb.append(command);
						sb.append("', '");
						sb.append(pageNum + i);
						sb.append("', '')\">");
						sb.append(pageNum + i);
						sb.append("</button></td>");
					} else if (select == pageNum + i) {
						sb.append("<td>");
						sb.append(pageNum + i);
						sb.append("</td>");
					}
				}
			}
		}
		sb.append("<td>");
		if (select + 1 <= full) {
			sb.append("<button type=\"button\" onclick=\"doSubmitKey(document.form, '");
			sb.append(command);
			sb.append("', '");
			sb.append(select + 1);
			sb.append("', '')\">");
		} else {
			sb.append("<button type=\"button\" disabled=\"disabled\">");
		}
		sb.append("</button>");
		sb.append("</td>");
		sb.append("</tr>");
		sb.append("</table>");
		sb.append("</div>");
		return sb.toString();
	}
	
	/**
	 * a\ݒ
	 * <p>	2009/02/25	m.yoshida	ǉ		</p>
	 * @param list			aݒ胊Xg
	 * @param aryEra a\z
	 * @param targetDate	Ώ۔N
	 * @return a\
	 * @throws MospException	MosPOꍇ
	 */
	public String getJapaneseDate(List<MosPConfDto> list, String[][] aryEra, Date targetDate) throws MospException {
		return getDateString(list, aryEra, targetDate);
	}
	
	@Override
	public int getIntParam(String input) {
		return NumberUtil.getIntParam(input);
	}
	
	/**
	 * gJS̃Zbg
	 */
	protected void setExtraJs() {
		// gJS̐ݒ
		String appExtraJs = cfg.getProperty(CommonConst.PPT_APP_EXTRA_JS);
		List<String> extraJs = getExtraJs();
		if (StringUtil.isNotNull(appExtraJs) && VariousUtil.isNotNull(extraJs) && !extraJs.contains(appExtraJs)) {
			extraJs.add(0, appExtraJs);
		}
	}
	
	/**
	 * prototype.jsAscriptaculous.jsZbg
	 */
	protected void setPrototypeLibrary() {
		// prototype.jsZbg
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_APP_PROTOTYPE_JS))) {
			addExtraJs(cfg.getProperty(CommonConst.PPT_APP_PROTOTYPE_JS));
		}
		// scriptaculous.jsZbg
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_APP_SCRIPT_ACULO_US))) {
			addExtraJs(cfg.getProperty(CommonConst.PPT_APP_SCRIPT_ACULO_US));
		}
	}
	
	/**
	 * jQueryAjQuery UIZbg
	 */
	protected void setJQueryLibrary() {
		// jQueryZbg
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_APP_JQUERY))) {
			addExtraJs(cfg.getProperty(CommonConst.PPT_APP_JQUERY));
		}
		// jQuery UIZbg
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_APP_JQUERY_UI))) {
			addExtraJs(cfg.getProperty(CommonConst.PPT_APP_JQUERY_UI));
		}
		// jQuery UIpCSSZbg
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_APP_JQUERY_UI_CSS))) {
			addExtraCss(cfg.getProperty(CommonConst.PPT_APP_JQUERY_UI_CSS));
		}
	}
	
	/**
	 * @return	lblKCode
	 */
	public String getEscLblKCode() {
		return escapeHTML(lblKCode);
	}
	
	/**
	 * @return	lblKName
	 */
	public String getEscLblKName() {
		return escapeHTML(lblKName);
	}
	
	/**
	 * @return	lblSectionName
	 */
	public String getEscLblSectionName() {
		return escapeHTML(lblSectionName);
	}
	
	/**
	 * @param lblKCode	ZbglblKCode
	 */
	public void setLblKCode(String lblKCode) {
		this.lblKCode = lblKCode;
	}
	
	/**
	 * @param lblKName	ZbglblKName
	 */
	public void setLblKName(String lblKName) {
		this.lblKName = lblKName;
	}
	
	/**
	 * @param lblSectionName	ZbglblSectionName
	 */
	public void setLblSectionName(String lblSectionName) {
		this.lblSectionName = lblSectionName;
	}
	
	/**
	 * tB[hݒB
	 * @param list	ΏۃXg
	 * @throws Exception  Oꍇ
	 */
	public void setFields(List<?> list) throws Exception {
		// list̓eVoɃZbgB
	}
	
	/**
	 * @param menuCommand j[֑JڂR}hNo.
	 * @param addButton {^̒ǉtO
	 */
	protected void createAryMenu(String menuCommand, boolean addButton) {
		aryMenu = new String[0][0];
		aryMenu = StringUtil.addArrayFirstRowValue(aryMenu, menuCommand, CommonConst.NAM_TO_MENU);
		if (addButton) {
			aryMenu = StringUtil.addArrayLastRowValue(aryMenu, getName(C_MENU_BTN_CMD), getName(C_MENU_BTN_NAM));
		}
	}
	
	/**
	 * @param menuCommand j[֑JڂR}hNo.
	 * @param aryCommandInfo ǉ{^̔z
	 */
	protected void createAryMenu(String menuCommand, String[] aryCommandInfo) {
		createAryMenu(menuCommand, aryCommandInfo[0], aryCommandInfo[1]);
	}
	
	/**
	 * @param menuCommand j[֑JڂR}hNo.
	 */
	protected void createAryMenu(String menuCommand) {
		createAryMenu(menuCommand, false);
	}
	
	/**
	 * @param menuCommand  j[֑JڂR}hNo.
	 * @param btnCmd ǉ{^̃R}hNo.
	 * @param btnNam ǉ{^̖
	 */
	protected void createAryMenu(String menuCommand, String btnCmd, String btnNam) {
		boolean addButton = false;
		if (StringUtil.isNotNull(btnCmd) && StringUtil.isNotNull(btnNam)) {
			addButton = true;
			nam.setProperty(C_MENU_BTN_CMD, btnCmd);
			nam.setProperty(C_MENU_BTN_NAM, btnNam);
		}
		createAryMenu(menuCommand, addButton);
	}
	
}
