/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import javax.naming.NamingException;

import jp.mosp.common.common.BaseAction;
import jp.mosp.common.common.BaseDto;
import jp.mosp.common.common.InstanceFactory;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.part.BasePart;
import jp.mosp.common.part.BaseStore;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.part.PartManager;
import jp.mosp.common.part.PartStore;
import jp.mosp.common.utils.CsvUtil;
import jp.mosp.common.utils.DataSourceUtil;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.common.vo.ExclusiveVo;

import org.apache.commons.csv.CSVParser;
import org.apache.commons.fileupload.FileItem;

/**
 * MosP̃x[XƂȂActionNX
 * @author yoshida
 *	@version	1.4
 */
public abstract class MosPAction extends BaseAction {
	
	// r֘AtB[h
	private boolean						needExclusive;
	private List<ExclusiveVo>			listExclusive;
	
	// tB[h
	/**
	 * OC[Ul{
	 */
	protected HumanBasisDtoInterface	userBasis;
	
	/**
	 * BufferedReader
	 */
	protected BufferedReader			br;
	

	/**
	 * RXgN^
	 */
	public MosPAction() {
		super();
		setCheckAuth(false);
		setNeedExclusive(false);
	}
	
	/**
	 * 
	 * <p>
	 * ActionVoŕKvȏLqB<br>
	 * {@link MosPAction}gNXŃI[o[ChėpB
	 * </p>
	 * @since	1.2
	 * @throws Exception Oꍇ
	 */
	protected void init() throws Exception {
		// 
	}
	
	/**
	 * \iVKj
	 * <p>
	 * ɉʂ̏\sB<br>
	 * {@link MosPAction}gNXŃI[o[ChėpB
	 * </p>
	 * @since	1.2
	 * @throws Exception 	Oꍇ
	 */
	protected void show() throws Exception {
		// 
	}
	
	/**
	 * I\(L[ŏ)
	 * <p>
	 * ɏڍ׉ʂ̑I\sB<br>
	 * {@link MosPAction}gNXŃI[o[ChėpB
	 * </p>
	 * @since	1.2
	 * @throws Exception Oꍇ
	 */
	protected void select() throws Exception {
		// 
	}
	
	/**
	 * 
	 * <p>
	 * Ɉꗗʂ̌sB<br>
	 * {@link MosPAction}gNXŃI[o[ChėpB
	 * </p>
	 * @since	1.2
	 * @throws Exception Oꍇ
	 */
	protected void search() throws Exception {
		// 
	}
	
	/**
	 * Č
	 * <p>
	 * Ɉꗗʂ̍ČsB<br>
	 * {@link MosPAction}gNXŃI[o[ChėpB
	 * </p>
	 * @since	1.2
	 * @throws Exception Oꍇ
	 */
	protected void research() throws Exception {
		// 
	}
	
	/**
	 * rNX擾
	 * <p>
	 * \[gɗprNX擾B<br>
	 * {@link MosPAction}gNXŃI[o[ChėpB
	 * </p>
	 * @since	1.2
	 * @param  key \[gL[
	 * @return	rNX
	 * @throws MospException MosPOꍇ
	 */
	protected Comparator<Object> getComparator(String key) throws MospException {
		return null;
	}
	
	/**
	 * f[^}
	 * <p>
	 * ɏڍ׉ʂ̓o^sB<br>
	 * {@link MosPAction}gNXŃI[o[ChėpB<br>
	 * </p>
	 * @since	1.2
	 * @throws Exception Oꍇ
	 */
	protected void insert() throws Exception {
		// 
	}
	
	/**
	 * f[^XV
	 * <p>
	 * ɏڍ׉ʂ̍XVsB<br>
	 * {@link MosPAction}gNXŃI[o[ChėpB<br>
	 * </p>
	 * @since	1.2
	 * @throws Exception Oꍇ
	 */
	protected void update() throws Exception {
		// 
	}
	
	/**
	 * \[g
	 * @param key \[gL[
	 * @throws Exception   Oꍇ
	 */
	protected void sortList(String key) throws Exception {
		MosPVo vo = (MosPVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	/**
	 * \[g(VÕL[Ń\[g)
	 * @throws Exception  Oꍇ
	 */
	protected void sortList() throws Exception {
		MosPVo vo = (MosPVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	/**
	 * ANV㏈
	 * @throws SQLException  SQLOꍇ
	 */
	@Override
	protected void afterAction() throws SQLException {
		// 
		partClear();
		// ㏈
		super.afterAction();
		if (!needExclusive) {
			if (VariousUtil.isNotNull(user)) {
				deleteExclusive(user.getUserId());
			}
		}
	}
	
	/**
	 * CmAspUserDto̐
	 */
	protected void createAspUser() {
		aspUser = new CmAspUserDto();
		aspUser.setAspUserId(cfg.getProperty(MospConst.PPT_ASP_ASPUSER));
		aspUser.setAspName(cfg.getProperty(MospConst.PPT_ASP_ASPNAME));
		aspUser.setDbDriver(cfg.getProperty(MospConst.PPT_ASP_DBDRIVER));
		aspUser.setDbUrl(cfg.getProperty(MospConst.PPT_ASP_DBURL));
		aspUser.setDbUser(cfg.getProperty(MospConst.PPT_ASP_DBUSER));
		aspUser.setDbPass(cfg.getProperty(MospConst.PPT_ASP_DBPASS));
	}
	
	/**
	 * St@Cp۔f
	 */
	protected void setUseLogo() {
		boolean useLogoFlag = false;
		String useLogo = cfg.getProperty(CommonConst.PPT_USE_LOGO);
		StringBuffer filepath = new StringBuffer();
		filepath.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		filepath.append(System.getProperty("file.separator"));
		filepath.append("pub");
		filepath.append(System.getProperty("file.separator"));
		filepath.append(CommonConst.FILE_LOGO);
		if (StringUtil.isNotNull(useLogo) && Boolean.parseBoolean(useLogo) && new File(filepath.toString()).exists()) {
			useLogoFlag = true;
		}
		cfg.setProperty(CommonConst.PPT_USE_LOGO, String.valueOf(useLogoFlag));
	}
	

	/**
	 * PartClass
	 * @since	1.0
	 */
	private PartInfo	partInfo;
	

	/**
	 * PartInfoCX^X̐
	 * <p>	xꍇAg܂킷B	</p>
	 * @return	PartInfoCX^X
	 * @throws SQLException  SQLOꍇ
	 * @throws ClassNotFoundException 	 NXȂꍇ
	 * @since	1.0
	 */
	protected PartInfo partInfo() throws ClassNotFoundException, SQLException {
		if (VariousUtil.isNull(partInfo)) {
			// DBRlNV擾
			if (VariousUtil.isNull(conn)) {
				getConnection();
			}
			partInfo = PartManager.createPartInfo(cfg, cmd, aspUser, user, conn);
		}
		return partInfo;
	}
	
	/**
	 * 폜tOXg擾
	 * @return 폜tOXg
	 */
	protected String[][] getDeleteArray() {
		return VariousUtil.getDeleteArray();
	}
	
	/**
	 * KptOXg擾
	 * @return 폜tOXg
	 */
	protected String[][] getApplicableFlagArray() {
		return VariousUtil.getApplicableFlagArray();
	}
	
	/**
	 * ݒ胊Xg擾(MOSP_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getConfArray(String confId) throws Exception {
		return part().mospconf().getConfArray(confId);
	}
	
	/**
	 * ݒ胊Xg擾(MOSP_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws Exception Oꍇ
	 */
	protected List<MosPConfDto> getConfList(String confId) throws Exception {
		return part().mospconf().getConfList(confId);
	}
	
	/**
	 * R[hXg擾(CM_CODE)
	 * @param tId R[h敪
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	@Override
	protected String[][] getCodeArray(String tId) throws Exception {
		return part().cmcode().getCodeArray(tId);
	}
	
	/**
	 * R[h敪擾(CM_CODE)
	 * @return R[h敪Xg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getCodeArray() throws Exception {
		return part().cmcode().getCodeArray();
	}
	
	/**
	 * R[h敪̎擾(CM_CODE)
	 * @param	tId R[h敪
	 * @return	tId R[h敪
	 * @throws Exception Oꍇ
	 */
	protected String getCodeTypeName(String tId) throws Exception {
		return part().cmcode().getCodeTypeName(tId);
	}
	
	/**
	 * R[hXg擾(CM_AUTHORITY)
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getArrangeAuthArray() throws Exception {
		return part().authority().getArrangeAuthArray();
	}
	
	/**
	 * SR[hXg擾(CM_AUTHORITY)
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getArrangeAuthArrayAll() throws Exception {
		return part().authority().getArrangeAuthArrayAll();
	}
	
	/**
	 * R[h敪擾(M_CODE)
	 * @return R[h敪Xg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getMosPCodeArray() throws Exception {
		return part().mospcode().getMosPCodeArray();
	}
	
	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @param tid R[hID
	 * @throws Exception Oꍇ
	 */
	protected String[][] getMosPCodeArray(String tid) throws Exception {
		return part().mospcode().getMosPCodeArray(tid);
	}
	
	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @param tcode R[h
	 * @throws Exception Oꍇ
	 */
	protected String[][] getMosPCodeArray(String tid, String tcode) throws Exception {
		return part().mospcode().getMosPCodeArray(tid, tcode);
	}
	
	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @param tcode R[h
	 * @throws Exception Oꍇ
	 */
	protected String[] getMosPCode(String tid, String tcode) throws Exception {
		return part().mospcode().getMosPCode(tid, tcode);
	}
	
	/**
	 * R敪擾(M_CODE)
	 * @param tid R[hID
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws Exception Oꍇ
	 */
	protected String[][] getReasonCodeArray(String tid) throws Exception {
		return part().mospcode().getReasonCodeArray(tid);
	}
	
	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws Exception Oꍇ
	 */
	protected String[] getMosPCode(String tid) throws Exception {
		return part().mospcode().getMosPCode(tid);
	}
	
	/**
	 * [U[擾(CM_USER)
	 * @param userId 擾Ώۃ[U[ID
	 * @return [U[(CmUserDto)
	 * @throws Exception Oꍇ
	 */
	protected CmUserDto getUserInfo(String userId) throws Exception {
		return part().mospuser().getUserInfo(userId);
	}
	
	/**
	 * [U[擾(MOSP_USER)
	 * @param kcode		擾ΏێЈR[h
	 * @return [U[(CmUserDto)
	 * @throws Exception Oꍇ
	 */
	protected CmUserDto getUserInfoForKCode(String kcode) throws Exception {
		return part().mospuser().getUserInfoForKCode(kcode);
	}
	
	/**
	 * MANAGERmF
	 * @return TRAINERL(trueFLAfalseF)
	 * @throws Exception Oꍇ
	 */
	protected boolean hasManagerAuth() throws Exception {
		return part().authority().hasManagerAuth();
	}
	
	/**
	 * MANAGERmF
	 * @throws Exception Oꍇ
	 */
	protected void confirmManagerAuth() throws Exception {
		if (!hasManagerAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}
	
	/**
	 * PAYROLLmF
	 * @return PAYROLLL(trueFLAfalseF)
	 * @throws Exception Oꍇ
	 */
	protected boolean hasPayrollAuth() throws Exception {
		return part().authority().hasPayrollAuth();
	}
	
	/**
	 * PAYROLLmF
	 * @throws Exception Oꍇ
	 */
	protected void confirmPayrollAuth() throws Exception {
		if (!hasPayrollAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}
	
	/**
	 * HUMANmF
	 * @return PAYROLLL(trueFLAfalseF)
	 * @throws Exception Oꍇ
	 */
	protected boolean hasHumanAuth() throws Exception {
		return part().authority().hasHumanAuth();
	}
	
	/**
	 * HUMANmF
	 * @throws Exception Oꍇ
	 */
	protected void confirmHumanAuth() throws Exception {
		if (!hasHumanAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}
	
	/**
	 * CALCULATEmF
	 * @return CALCULATEL(trueFLAfalseF)
	 * @throws Exception Oꍇ
	 */
	protected boolean hasCalculateAuth() throws Exception {
		return part().authority().hasCalculateAuth();
	}
	
	/**
	 * CALCULATEmF
	 * @throws Exception Oꍇ
	 */
	protected void confirmCalculateAuth() throws Exception {
		if (!hasCalculateAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}
	
	/**
	 * SYSTEMmF
	 * @return SYSTEML(trueFLAfalseF)
	 * @throws Exception Oꍇ
	 */
	protected boolean hasSystemAuth() throws Exception {
		return part().authority().hasSystemAuth();
	}
	
	/**
	 * SYSTEMmF
	 * @throws Exception Oꍇ
	 */
	protected void confirmSystemAuth() throws Exception {
		if (!hasSystemAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}
	
	/**
	 * L[l擾(L[)
	 * @param keyIndex L[CfbNX
	 * @return L[l
	 */
	protected String getKeyValue(int keyIndex) {
		return VariousUtil.getKeyValue(key2, keyIndex);
	}
	
	/**
	 * r擾
	 * @param exclusiveType r敪
	 * @param userId        Ώۃ[U[ID
	 * @return ҏW҃R[h(ҏW҂ȂA܂͎̏ꍇnull)
	 * ServletContext𗘗p邽߁AJVMł͕̓ۏႵȂB
	 */
	@SuppressWarnings("unchecked")
	protected String getExclusive(int exclusiveType, String userId) {
		listExclusive = (List<ExclusiveVo>)ctx.getAttribute(CommonConst.ATT_EXCLUSIVE);
		ExclusiveVo exclusiveVo;
		if (listExclusive == null) {
			return null;
		}
		for (int i = listExclusive.size() - 1; i >= 0; i--) {
			exclusiveVo = listExclusive.get(i);
			if (exclusiveVo.getExclusiveType() == exclusiveType) {
				if (exclusiveVo.getUserId().equals(userId)) {
					// ̔rf[^폜
					listExclusive.remove(i);
					continue;
				}
				return exclusiveVo.getUserId();
			}
		}
		return null;
	}
	
	/**
	 * rݒ
	 * @param exclusiveType r敪
	 * @param userId        Ώۃ[U[ID
	 * @param target        ҏWΏ
	 * @return ҏW҃R[h(ҏW҂ȂA܂͎̏ꍇnull)
	 * ServletContext𗘗p邽߁AJVMł͕̓ۏႵȂB
	 */
	@SuppressWarnings("unchecked")
	protected String setExclusive(int exclusiveType, String userId, String target) {
		listExclusive = (List<ExclusiveVo>)ctx.getAttribute(CommonConst.ATT_EXCLUSIVE);
		ExclusiveVo exclusiveVo;
		String editor = null;
		if (listExclusive == null) {
			listExclusive = new ArrayList<ExclusiveVo>();
			ctx.setAttribute(CommonConst.ATT_EXCLUSIVE, listExclusive);
		}
		deleteExclusive(userId);
		for (int i = listExclusive.size() - 1; i >= 0; i--) {
			exclusiveVo = listExclusive.get(i);
			if (exclusiveVo.getExclusiveType() == exclusiveType && exclusiveVo.getTarget().equals(target)) {
				editor = exclusiveVo.getUserId();
			}
		}
		addList(listExclusive, new ExclusiveVo(exclusiveType, userId, target));
		return editor;
	}
	
	/**
	 * r폜
	 * @param userId Ώۃ[U[ID
	 * ServletContext𗘗p邽߁AJVMł͕̓ۏႵȂB
	 */
	@SuppressWarnings("unchecked")
	protected void deleteExclusive(String userId) {
		listExclusive = (List<ExclusiveVo>)ctx.getAttribute(CommonConst.ATT_EXCLUSIVE);
		ExclusiveVo exclusiveVo;
		if (listExclusive == null) {
			return;
		}
		for (int i = listExclusive.size() - 1; i >= 0; i--) {
			exclusiveVo = listExclusive.get(i);
			if (VariousUtil.getTimeRemainder(new Date(), exclusiveVo.getDate()) * 60 > Integer.parseInt(cfg
				.getProperty(MospConst.PPT_APP_INTERVAL))) {
				// ZbVێԈȏoĂrf[^폜
				listExclusive.remove(i);
			} else if (exclusiveVo.getUserId().equals(userId)) {
				// ̔rf[^폜
				listExclusive.remove(i);
			}
		}
	}
	
	/**
	 * t@C쐬
	 * @param upfile Abv[ht@C
	 * @return file
	 * @throws Exception	Exception
	 */
	protected File getUploadFile(FileItem upfile) throws Exception {
		// It@C擾
		File file = new File(upfile.getFieldName());
		// t@Cւ̏o
		upfile.write(file);
		return file;
	}
	
	/**
	 * t@C쐬(CSV)
	 * @param csvFile Abv[hCSVt@C
	 * @return CSVt@Ce
	 * @throws Exception Oꍇ
	 */
	protected File getCSVFileData(FileItem csvFile) throws Exception {
		return getUploadFile(csvFile);
	}
	
	/**
	 * CSVf[^p[X
	 * @param csvFile	CSVt@C
	 * @return CSVt@Ce
	 * @throws Exception Oꍇ
	 */
	protected CSVParser parseCSVData(File csvFile) throws Exception {
		br = CsvUtil.getCsvFileReader(csvFile);
		return new CSVParser(br);
	}
	
	/**
	 * CSVwb_[쐬
	 * @param parser	CSVParser
	 * @return wb_z
	 * @throws MospException MosPOꍇ
	 */
	protected String[] getCSVHeadData(CSVParser parser) throws MospException {
		String[] line;
		try {
			line = parser.getLine();
		} catch (IOException e) {
			// `G[
			addErrMessage(getMessage(CommonConst.MSG_INVALID_HEAD_TYPE, ""));
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		return line;
	}
	
	/**
	 * CSVf[^쐬
	 * @param parser	CSVParser
	 * @param idx		CfbNX
	 * @return@f[^z
	 * @throws MospException MosPOꍇ
	 */
	protected String[] getCSVData(CSVParser parser, int idx) throws MospException {
		String[] line;
		try {
			line = parser.getAllValues()[idx];
		} catch (IOException e) {
			// `G[
			addErrMessage(getMessage(CommonConst.MSG_INVALID_DATA_TYPE, String.valueOf(idx + 1)));
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		return line;
	}
	
	/**
	 * f[^݊mF
	 * @param dto mFΏDTO
	 * @return boolean	ΏDTOݗL
	 */
	protected boolean chkExistDto(BaseDto dto) {
		return VariousUtil.chkExistDto(dto);
	}
	
	/**
	 * f[^݊mF
	 * @param obj mFΏObject
	 * @return boolean	ΏObjectݗL
	 */
	protected boolean chkExistObject(Object obj) {
		return VariousUtil.chkExistObject(obj);
	}
	
	/**
	 * jݒ
	 * @param dayOfWeek j
	 * @return j
	 */
	protected String getDayOfWeek(int dayOfWeek) {
		return VariousUtil.getDayOfWeek(dayOfWeek);
	}
	
	/**
	 * ԃtH[}bg
	 * @param hour 
	 * @return ()
	 */
	protected String getHourString(double hour) {
		return VariousUtil.getHourString(hour);
	}
	
	/**
	 * LJz
	 * @return	String[]	LJz
	 * <p>
	 * [0]...JzA
	 * [1]...JzA
	 * [2]...Jz敪
	 * </p>
	 * @throws Exception Oꍇ
	 */
	protected String[] getPaidHolidayInfo() throws Exception {
		return part().mospcode().getPaidHolidayInfo();
	}
	
	/**
	 * LxɎx
	 * @return [0]cΑNA[1]cx
	 * @throws Exception Oꍇ
	 */
	protected String[][] getPaidHolidayArray() throws Exception {
		return part().mospcode().getPaidHolidayArray();
	}
	
	/**
	 * o͔͈̓v_EXg
	 * @return	String[][]	o͔͈͔z
	 */
	protected String[][] getOutputScopeArray() {
		return VariousUtil.getOutputScopeArray();
	}
	
	/**
	 * ΑӏF@\󋵎擾(M_CODE)
	 * @return	boolean 	ΑӏF@\̗L
	 * @throws Exception Oꍇ
	 */
	protected boolean isAttendanceApprovalFunction() throws Exception {
		return part().mospcode().isAttendanceApprovalFunction();
	}
	
	/**
	 * pX[hL
	 * @return	int		pX[hL
	 * @throws Exception Oꍇ
	 */
	protected int getPasswordTerm() throws Exception {
		return part().mospcode().getPasswordTerm();
	}
	
	/**
	 * tB[h̓̃f[^擾
	 *  0 : t@CID
	 *  1 : Ǘԍ
	 *  2 : tB[hID
	 *  3 : tB[h
	 * @param csvString J}؂̕
	 * @param i ΏۃCfbNX
	 * @return 
	 */
	protected String getEFnameItem(String csvString, int i) {
		return VariousUtil.getCsvSplitInfo(csvString, i);
	}
	
	/**
	 * YtOz
	 * @return YtOz
	 */
	protected String[][] getCorrespondFlagArray() {
		return VariousUtil.getCorrespondFlagArray();
	}
	
	/**
	 * az
	 * @return	az
	 * @throws Exception Oꍇ
	 */
	protected String[][] getJPCalendarGengo() throws Exception {
		return part().cmcode().getJPCalendarGengo();
	}
	
	/**
	 * DTOꐫ`FbN
	 * @param formerDto		ΏDTO
	 * @param currentDto	ΏDTO
	 * @return
	 * <p>
	 * XV̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws MospException MosPOꍇ
	 */
	protected boolean chkIdentityDto(BaseDto formerDto, BaseDto currentDto) throws MospException {
		return VariousUtil.chkIdentityDto(formerDto, currentDto);
	}
	
	/**
	 * Ώ۔NΏ۔Nx擾
	 * @param year		Ώ۔N
	 * @param month		Ώی
	 * @param startmonth	NxJn
	 * @return	Ώ۔Nx
	 * @throws Exception Oꍇ
	 */
	protected int getTargetFiscalYear(int year, int month, int startmonth) throws Exception {
		return VariousUtil.getTargetFiscalYear(year, month, startmonth);
	}
	
	/**
	 * Ώ۔NxΏ۔N擾
	 * @param fiscalyear		Ώ۔Nx
	 * @param month				Ώی
	 * @param startmonth		NxJn
	 * @return	Ώ۔N
	 */
	protected int getTargetYear(int fiscalyear, int month, int startmonth) {
		return VariousUtil.getTargetYear(fiscalyear, month, startmonth);
	}
	
	/**
	 * Ώ۔NxJn擾
	 * @param fiscalyear Ώ۔Nx
	 * @param startMonth NxJn
	 * @return Ώ۔NxJn
	 * @throws Exception Oꍇ
	 */
	protected Date getFiscalStartDate(int fiscalyear, int startMonth) throws Exception {
		return DateUtil.getFiscalStartDate(fiscalyear, startMonth);
	}
	
	/**
	 * Ώ۔NxI擾
	 * @param fiscalyear Ώ۔Nx
	 * @param startMonth NxJn
	 * @return Ώ۔NxI
	 * @throws Exception Oꍇ
	 */
	protected Date getFiscalEndDate(int fiscalyear, int startMonth) throws Exception {
		return DateUtil.getFiscalEndDate(fiscalyear, startMonth);
	}
	
	/**
	 * a\ݒ
	 * @param targetDate	Ώ۔N
	 * @return	a\
	 * @throws Exception Oꍇ
	 */
	protected String getJapaneseDate(Date targetDate) throws Exception {
		return part().jpdate().getJapaneseDate(targetDate);
	}
	
	/**
	 * a\ݒ
	 * @param targetDate	Ώ۔N(yyyy-MM-dd)
	 * @return	a\
	 * @throws Exception Oꍇ
	 */
	protected String getJapaneseDate(String targetDate) throws Exception {
		return part().jpdate().getJapaneseDate(targetDate);
	}
	
	/**
	 * FXe[^XR[hXg擾
	 * @return FXe[^XR[hXgz
	 */
	protected String[] getApprovalStatusCodeArray() {
		return VariousUtil.getApprovalStatusCodeArray();
	}
	
	/**
	 * XVɂrmFB<br>
	 * @since	1.3
	 * currentDtoɑ΂{@link #chkExist(BaseDto)}sA
	 * formerDtocurrentDto̍XVrB<br>
	 * XVłȂꍇA{@link MospException}𔭍sB<br>
	 * @param formerDto XVΏDTO(ҏWO)
	 * @param currentDto XVΏDTO(ŐV)
	 * @throws MospException MosPOꍇ
	 */
	protected void chkExclusive(BaseDto formerDto, BaseDto currentDto) throws MospException {
		super.chkExclusive(formerDto, currentDto, getVo());
	}
	
	/**
	 * f[^dmFB<br>
	 * @since	1.3
	 * dtonullłȂꍇA{@link MospException}𔭍sB<br>
	 * @param dto mFΏDTO
	 * @throws MospException MosPOꍇ
	 */
	protected void chkDuplicate(BaseDto dto) throws MospException {
		super.chkDuplicate(dto, getVo());
	}
	
	/**
	 * bZ[W擾
	 * @param msgCode 	bZ[WR[h
	 * @param rep		u(ꍇ̓J}؂)
	 * @return	bZ[W
	 * @throws MospException MosPOꍇ
	 */
	protected String getMessage(String msgCode, String rep) throws MospException {
		return MospUtility.getMessage(msg, msgCode, rep);
	}
	
	/**
	 * ZbVɕێĂDTO̎擾B<br>
	 * {@link MospConst#ATT_DTO}
	 * @return ZbVɕێĂDTO
	 */
	protected BaseDto getSessionDto() {
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		return obj instanceof BaseDto ? (BaseDto)obj : null;
	}
	
	/**
	 * ZbVDTOZbgB<br>
	 * {@link MospConst#ATT_DTO}
	 * @param dto ZbVɕێDTO
	 */
	protected void setSessionDto(BaseDto dto) {
		session.setAttribute(MospConst.ATT_DTO, dto);
	}
	
	/**
	 * ZbVɕێĂDTOB
	 */
	protected void removeSessionDto() {
		session.removeAttribute(MospConst.ATT_DTO);
	}
	
	@Override
	protected void getConnection() throws ClassNotFoundException, SQLException {
		boolean isDefault = true;
		// DataSourcepł邩f
		if (canUseDataSource()) {
			try {
				getConnection(cfg.getProperty(MospConst.PPT_ASP_DSOURCE));
			} catch (NamingException e) {
				// G[Oɏo͂B
				LogUtility.log(cfg, "", "", cmd, 5, MospConst.LOG_MOSPERR, MospConst.LOG_MSG_5003);
				e.printStackTrace();
			} catch (SQLException e) {
				// G[Oɏo͂B
				LogUtility.log(cfg, "", "", cmd, 5, MospConst.LOG_MOSPERR, MospConst.LOG_MSG_5003);
				e.printStackTrace();
			} finally {
				if (VariousUtil.isNotNull(conn)) {
					isDefault = false;
				} else {
					// ݒ肪G[̏ꍇAftHg̐ڑ𗘗pB
					cfg.setProperty(CommonConst.PPT_USE_DATA_SOURCE, String.valueOf(false));
				}
			}
		}
		if (isDefault) {
			super.getConnection();
		}
	}
	
	/**
	 * DataSourcep۔f
	 * @return
	 * <p>
	 * DataSourcepłꍇtrueAłȂꍇfalse<br>
	 * xfAcfgɃZbg񂩂炻𗘗pB
	 * </p>
	 */
	protected boolean canUseDataSource() {
		// ݒt@C̃vpeB擾
		String pptDataSource = cfg.getProperty(CommonConst.PPT_USE_DATA_SOURCE);
		if (pptDataSource == null) {
			// vpeBɖꍇAݒ肷B
			boolean dsourceFlag = false;
			if (DataSourceUtil.canUseDataSource(cfg.getProperty(MospConst.PPT_ASP_DSOURCE))) {
				dsourceFlag = true;
				LogUtility.log(cfg, "", "", "", 4, MospConst.LOG_MOSPINF, DataSourceUtil.USE_DATA_SOURCE_MESSAGE);
			}
			cfg.setProperty(CommonConst.PPT_USE_DATA_SOURCE, String.valueOf(dsourceFlag));
			pptDataSource = String.valueOf(dsourceFlag);
		}
		return Boolean.valueOf(pptDataSource);
	}
	
	/**
	 * R}h擾B<br>
	 * @param invalidProcSeq V[PXstO
	 * @return R}h
	 */
	@Override
	protected String getIndexCommand(boolean invalidProcSeq) {
		try {
			// ASP[U[擾(ݒt@CASPݒŔf)
			switch (MospUtility.getAspFlag(cfg)) {
				case 0:
				case 1:
					// 0FASP(x[U[:1Av)
					// 1FASP(1[U[:1Av)
					return "C3011";
				case 2:
					// 2FASP
					//return MospConst.CMD_INDEX;
				default:
					return MospConst.CMD_INDEX;
			}
		} catch (MospException e) {
			return MospConst.CMD_INDEX;
		}
	}
	
	/*
	 * ȉAIvV֘Ã\bh
	 */

	/**
	 * OptionConst擾
	 * @return	OptionConst̃NXIuWFNg
	 * @throws ClassNotFoundException 	 NXȂꍇ
	 */
	protected Class<?> getOptionConstClass() throws ClassNotFoundException {
		return Class.forName(CommonConst.OPTION_CONST_FULLNAME);
	}
	
	/**
	 * IvV@\L
	 * <p>2008/12/10	m.yoshida	ǉ</p>
	 * @return useOption
	 * <p>
	 * IvV@\𗘗p邱ƂłꍇtrueA<br>
	 * łȂꍇfalse
	 * </p>
	 */
	protected boolean canUseOptionPackage() {
		// ݒt@C̃vpeB擾
		try {
			if (cfg.getProperty(CommonConst.PPT_USE_OPTION) == null) {
				// OptionConstNX݂邩mF
				Class<?> cls = getOptionConstClass();
				// vpeBɖꍇAݒ肷B
				if (cls != null) {
					cfg.setProperty(CommonConst.PPT_USE_OPTION, String.valueOf(true));
				}
			}
		} catch (ClassNotFoundException e) {
			cfg.setProperty(CommonConst.PPT_USE_OPTION, String.valueOf(false));
		}
		return Boolean.valueOf(cfg.getProperty(CommonConst.PPT_USE_OPTION));
	}
	
	// ANZT\bh
	/**
	 * @param needExclusive		rtO
	 */
	protected void setNeedExclusive(boolean needExclusive) {
		this.needExclusive = needExclusive;
	}
	
	/* Part֘A */

	/**
	 * ςPartNXCX^X擾
	 * @param partClassName		ΏPartNX
	 * @return	ΏۏςPartNXCX^X
	 * @throws Exception Oꍇ
	 */
	protected BasePart getPart(String partClassName) throws Exception {
		return part().get(partClassName);
	}
	
	/**
	 * ςPartNXCX^X擾
	 * @param cls ΏPartNX
	 * @return	ΏۏςPartNXCX^X
	 * @throws Exception Oꍇ
	 */
	protected BasePart getPart(Class<?> cls) throws Exception {
		return part().get(cls);
	}
	

	private BaseStore	baseStore;
	

	/**
	 * PartStoreCX^X擾
	 * @return	PartStoreCX^X
	 * @throws MospException  MosPOꍇ
	 * @throws SQLException   SQLOꍇ
	 * @throws ClassNotFoundException  NXȂꍇ
	 */
	protected PartStore part() throws MospException, ClassNotFoundException, SQLException {
		return (PartStore)getBaseStore(PartStore.class);
	}
	
	/**
	 * BaseStoreCX^X擾
	 * @since 0.1.4
	 * @param cls BaseStorepNX
	 * @return BaseStoreCX^X
	 * @throws SQLException   SQLOꍇ
	 * @throws ClassNotFoundException  NXȂꍇ
	 * @throws MospException  MosPOꍇ
	 */
	protected BaseStore getBaseStore(Class<?> cls) throws MospException, ClassNotFoundException, SQLException {
		if (VariousUtil.isNull(baseStore)) {
			baseStore = (BaseStore)InstanceFactory.loadInstance(cls.getCanonicalName());
			baseStore.setPartInfo(partInfo());
		}
		return baseStore;
	}
	
	/**
	 * ێĂPartNXB
	 */
	private void partClear() {
		if (VariousUtil.isNotNull(baseStore)) {
			baseStore.clear();
			baseStore = null;
		}
	}
	
}
