<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "16kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.system.vo.YukyuInformationCardVo"
%><%
YukyuInformationCardVo vo = (YukyuInformationCardVo)request.getAttribute(MospConst.ATT_VO);
String[] aryStandard = vo.getAryTxtStandard();
String[] aryDays = vo.getAryTxtDays();
String[] aryInfo = vo.getAryTxtInfo();
%>
<%=HtmlUtility.getHeader(vo)%>
<%=HtmlUtility.getSubTitle(vo)%>
<div class="Body" id="YukyuInformationCard">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Card">
		<table class="Top">
			<thead>
				<tr>
					<th colspan="2"><%= vo.NAM_PROCESS_SET_UP %></th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td class="TitleTd"><%=HtmlUtility.getRequiredMark()%><%= vo.NAM_CF_MONTH %><%=CommonConst.STR_TITLE_SEPARATOR%></td>
					<td >
						<select id="<%= YukyuInformationCardVo.PRM_PLT_CF_MONTH %>" name="<%= YukyuInformationCardVo.PRM_PLT_CF_MONTH %>">
							<%=HtmlUtility.getSelectOption(vo.aryPltCFMonth , vo.getPltCFMonth())%>
						</select>
						<%= CommonConst.NAM_MONTH %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%=HtmlUtility.getRequiredMark()%><%= vo.NAM_CF_DAYS %><%=CommonConst.STR_TITLE_SEPARATOR%></td>
					<td >
						<input type="text" class="NumberTextBox" id="<%= YukyuInformationCardVo.PRM_TXT_CF_DAYS %>" name="<%= YukyuInformationCardVo.PRM_TXT_CF_DAYS %>" value="<%= vo.getEscTxtCFDays() %>" />
						<%= CommonConst.NAM_DAY %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%=HtmlUtility.getRequiredMark()%><%= vo.NAM_CF_KBN %><%=CommonConst.STR_TITLE_SEPARATOR%></td>
					<td >
						<select id="<%= YukyuInformationCardVo.PRM_PLT_CF_KBN %>" name="<%= YukyuInformationCardVo.PRM_PLT_CF_KBN %>">
							<%=HtmlUtility.getSelectOption(vo.aryPltCFKbn , vo.getPltCFKbn())%>
						</select>
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%=HtmlUtility.getRequiredMark()%><%= vo.NAM_SUPPLY_MODEL %><%=CommonConst.STR_TITLE_SEPARATOR%></td>
					<td >
						<select id="<%= YukyuInformationCardVo.PRM_PLT_SUPPLY_MODEL %>" name="<%= YukyuInformationCardVo.PRM_PLT_SUPPLY_MODEL %>">
							<%=HtmlUtility.getSelectOption(vo.aryPltSupplyModel , vo.getPltSupplyModel())%>
						</select>
					</td>
				</tr>
			</tbody>
		</table>
		<table class="Bottom">
			<thead>				
				<tr>			
					<th colspan="4"><%= vo.NAM_SUPPLY_CONDITION %></th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td class="NumberTd"><%=CommonConst.NAM_COMMON_BANGO%></td>
					<td class="StandardTd"><%= vo.NAM_STANDARD %></td>
					<td class="DaysTd"><%= vo.NAM_DAYS %></td>
					<td class="InfoTd"><%= vo.NAM_INFO %></td>
				</tr>
<%
for (int i = 0; i < 20; i++) {
%>
				<tr>
					<td class="NumberTd">
						<%= i + 1 %>
					</td>
					<td class="StandardTd">
						<input type="text" class="NumberTextBox" id="<%= YukyuInformationCardVo.PRM_TXT_STANDARD + i %>" name="<%= YukyuInformationCardVo.PRM_TXT_STANDARD %>" value="<%= aryStandard[i] %>" />
						<%= CommonConst.NAM_YEAR %>
					</td>
					<td class="DaysTd">
						<input type="text" class="NumberTextBox" id="<%= YukyuInformationCardVo.PRM_TXT_DAYS + i %>" name="<%= YukyuInformationCardVo.PRM_TXT_DAYS %>" value="<%= aryDays[i] %>" />
						<%= CommonConst.NAM_DAY %>
					</td>
					<td class="InfoTd">
						<input type="text" class="TextBox" id="<%= YukyuInformationCardVo.PRM_TXT_INFO + i %>" name="<%= YukyuInformationCardVo.PRM_TXT_INFO %>" value="<%= aryInfo[i] %>" />
					</td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
</div>
<div class="Footer">
	<button type="button" class="ExecuteButton" onclick="submitForm(document.form)"><%= CommonConst.NAM_REGIST %></button>
	<button type="button" class="MenuButton" onclick="doSubmit(document.form, 'S2910')"><%= CommonConst.NAM_TO_MENU %></button>
</div>
<%= HtmlUtility.getFooter(vo) %>
