/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.spreadsheet.BytesProducer;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableCell<D extends ODDocument>
extends Cell<D> {
    private static final DateFormat TextPDateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private static final NumberFormat TextPFloatFormat = new DecimalFormat(",##0.00");
    private final int x;

    MutableCell(Row<D> row, Element element, int n) {
        super(row, element);
        this.x = n;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.getRow().getY();
    }

    private void setValueAttributes(ODValueType oDValueType, Object object) {
        if (oDValueType == null) {
            Attribute attribute = this.getElement().getAttribute("value-type", this.getValueNS());
            if (attribute != null) {
                attribute.detach();
                this.getElement().removeAttribute(ODValueType.get(attribute.getValue()).getValueAttribute(), this.getValueNS());
            }
        } else {
            this.getElement().setAttribute("value-type", oDValueType.getName(), this.getValueNS());
            this.getElement().setAttribute(oDValueType.getValueAttribute(), oDValueType.format(object), this.getValueNS());
        }
    }

    private void setTextP(String string) {
        if (string == null) {
            this.getElement().removeContent();
        } else {
            Element element = new Element("p", this.getNS().getTEXT());
            element.addContent(string);
            this.getElement().setContent(element);
        }
    }

    private void setValue(ODValueType oDValueType, Object object, String string) {
        this.setValueAttributes(oDValueType, object);
        this.setTextP(string);
    }

    public void clearValue() {
        this.setValue(null, null, null);
    }

    public void setValue(Object object) {
        if (object instanceof Number) {
            this.setValue(ODValueType.FLOAT, object, TextPFloatFormat.format(object));
        } else if (object instanceof Date) {
            this.setValue(ODValueType.DATE, object, TextPDateFormat.format(object));
        } else {
            this.setValue(null, null, object.toString());
        }
    }

    public void replaceBy(String string, String string2) {
        this.replaceContentBy(this.getElement(), string, string2);
    }

    private void replaceContentBy(Element element, String string, String string2) {
        List list = element.getContent();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof Text) {
                Text text = (Text)e;
                text.setText(text.getText().replaceAll(string, string2));
                continue;
            }
            if (!(e instanceof Element)) continue;
            this.replaceContentBy((Element)e, string, string2);
        }
    }

    @Override
    public final String getStyleName() {
        return this.getRow().getSheet().getStyleNameAt(this.getX(), this.getY());
    }

    public void setStyleName(String string) {
        this.getElement().setAttribute("style-name", string, this.getNS().getTABLE());
    }

    public void setImage(File file) throws IOException {
        this.setImage(file, false);
    }

    public void setImage(File file, boolean bl) throws IOException {
        this.setImage(file.getName(), new BytesProducer.ByteArrayProducer(FileUtils.readBytes(file), bl));
    }

    public void setImage(String string, Image image) throws IOException {
        this.setImage(string, image == null ? null : new BytesProducer.ImageProducer(image, true));
    }

    private void setImage(String string, BytesProducer bytesProducer) {
        Element element;
        Namespace namespace = this.getNS().getNS("draw");
        Element element2 = this.getElement().getChild("frame", namespace);
        Element element3 = element = element2 == null ? null : element2.getChild("image", namespace);
        if (element != null) {
            Attribute attribute = element.getAttribute("href", this.getNS().getNS("xlink"));
            this.getODDocument().getPackage().putFile(attribute.getValue(), null);
            if (bytesProducer == null) {
                element2.detach();
            } else {
                attribute.setValue("Pictures/" + string + (bytesProducer.getFormat() != null ? "." + bytesProducer.getFormat() : ""));
                this.getODDocument().getPackage().putFile(attribute.getValue(), bytesProducer.getBytes(element2));
            }
        } else if (bytesProducer != null) {
            throw new IllegalStateException("this cell doesn't contain an image: " + this);
        }
    }
}

