/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.system.dto.MCodeDto;

public class ApprovalFunctionCardVo extends ApprovalMenuVo {

	private static final long serialVersionUID = -6334613963777191151L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/workflow/approvalFunctionCard.jsp";
	private static final String EXTRA_JS   = "/pub/workflow/js/approvalFunctionCard.js";
	private static final String EXTRA_CSS  = "/pub/workflow/css/approvalFunctionCard.css";

	// ʃTu^Cg	
	public final String SUB_TITLE 		= CommonConst.TTL_APPROVAL_FUNCTION;

	// p[^
	public static final String PRM_PLT_ATTENDANCE		= "pltAttendance";
	public static final String PRM_LBL_ATTENDANCE		= "lblAttendance";

	// tB[h
	private String pltAttendance;
	private String lblAttendance;

	// tB[hyѐ
	public static final String NAM_STATE		= CommonConst.NAM_NOW_STATUS;
	public static final String NAM_ATTENDANCE	= CommonConst.NAM_DELETE_FLAG;
	public static final String NAM_SELECT		= CommonConst.NAM_SELECT;

	public static final String REG_DELETE	= CommonConst.REG_DELETE;

	// v_EXg
	public String[][] aryPltState;

	/**
	 * RXgN^
	 */
	public ApprovalFunctionCardVo() {
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		pltAttendance = request.getParameter(PRM_PLT_ATTENDANCE);
	}

	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(MCodeDto dto) {
		pltAttendance = dto.getTName();
		lblAttendance = getCodeName(pltAttendance, aryPltState);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MCodeDto dto) {
		dto.setTId(CommonConst.TID_APPROVAL_FUNCTION);
		dto.setTCode(CommonConst.TCD_ATTENDANCE_APPROVAL);
		dto.setTName(pltAttendance);
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired	(pltAttendance	, NAM_ATTENDANCE	, PRM_PLT_ATTENDANCE	);
		// ^CvmF
		checkRegex		(pltAttendance	, REG_DELETE	, NAM_ATTENDANCE	, PRM_PLT_ATTENDANCE);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String getPltAttendance()	{ return pltAttendance; }
	public void setPltAttendance	(String pltAttendance) { this.pltAttendance = pltAttendance; }

	public String getEscLblAttendance() { return escapeHTML(lblAttendance); }

}
