/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import java.util.Properties;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

public class ApplicationMenuVo extends MosPVo {

	private static final long serialVersionUID = 5831631444403783909L;

	// tB[h
	private String[][] aryApplicationMenu ;

	private static final String NAM_SUB_TITLE = "e\";

	/**
	 * RXgN^
	 * @param cfg
	 * @param msg
	 * @param nam
	 * @param cmd
	 * @param aspUser
	 * @param user
	 */
	public ApplicationMenuVo(
			Properties cfg,
			Properties msg,
			Properties nam,
			String cmd,
			CmAspUserDto aspUser,
			CmUserDto user
	) {
		super(cfg, msg, nam, cmd, aspUser, user);
		setViewPath(getClassName());
		aryApplicationMenu = new String[0][0];
	}

	public void setSubTitle() {
		subTitle = NAM_SUB_TITLE;
		aryMenu = new String[][] {
				{ CMD_MENU_INPUT, CommonConst.NAM_TO_MENU },
		};
	}

	/**
	 * tB[hݒ
	 * @param aryApplicationMenu	e\j[{^z 
	 * @throws MospException
	 */
	public void setFields(String [][] aryApplicationMenu) {
		this.aryApplicationMenu = escapeArray(aryApplicationMenu.clone());
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[][] getEscAryApplicationMenu() {
		return aryApplicationMenu.clone();
	}

}
