/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.dao;

import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.MospConst;

import jp.mosp.human.dao.MKihonDao;

import jp.mosp.workflow.dto.AttendanceRouteDto;

public class AttendanceRouteDao extends PmAttendanceDao {

	// e[uyуL[
	/**
	 * AM_ROUTE
	 */
	public static final String TABLE_2		= "AM_ROUTE"		;

	// 
	public static final String COL_LAYER1 			= "LAYER1"		;	// PF
	public static final String COL_LAST_LAYER		= "LASTLAYER"	;	// QF

	/**
	 * RXgN^
	 */
	public AttendanceRouteDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<AttendanceRouteDto> mappingAll() throws SQLException {
		List<AttendanceRouteDto> all = new ArrayList<AttendanceRouteDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return PmAttendanceDto pm_attendanceR[h
	 * @throws SQLException
	 */
	private AttendanceRouteDto mapping() throws SQLException {
		AttendanceRouteDto dto = new AttendanceRouteDto();
		dto.setRouteId		(rs.getInt    (COL_ROUTE_ID)	);	// [gID
		dto.setSCode		(rs.getString (COL_S_CODE)		);	// R[h
		dto.setKCode		(rs.getString (COL_K_CODE)		);	// ЈR[h
		dto.setJCode		(rs.getString (COL_J_CODE)		);	// ƏR[h
		dto.setLayer1		(rs.getString (COL_LAYER1)		);	// PF
		dto.setLastLayer	(rs.getString (COL_LAST_LAYER)	);	// QF
		return dto;
	}

	/**
	 * ɂf[^擾
	 * @param sCode		R[h
	 * @param kCode		ЈR[h
	 * @param kName		Ј
	 * @param rtCode	[gR[h
	 * @return	list	(DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String sCode,
			String kCode,
			String kName,
			String rtCode			
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_ROUTE_ID		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_S_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_K_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_J_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAYER1		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAST_LAYER								);
		sb.append(" FROM ");
		sb.append( TABLE );
		sb.append(" LEFT JOIN ");
		sb.append(TABLE_2 );
		sb.append(" ON ");
		sb.append(TABLE + "." + COL_RT_CODE );
		sb.append(" = ");
		sb.append(TABLE_2 + "." + COL_RT_CODE );
		sb.append(" WHERE ");
		sb.append(TABLE + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(TABLE_2 + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF + " ");
		if (!sCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_S_CODE);
			sb.append(" LIKE ? ");
		}
		if (!kCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_K_CODE);
			sb.append(" LIKE ? ");
		}
		if (!kName.equals("")) {
			sb.append(" AND ");
			sb.append(COL_K_CODE + " IN (" + MKihonDao.getSearchKNameSubQuery() + ") ");
		}
		if (!rtCode.equals("")) {
			sb.append(" AND ");
			sb.append(TABLE + "." + COL_RT_CODE);
			sb.append(" LIKE ? ");
		}
		try {
			prepareStatement(sb.toString() + getOrderForKey(getClass()));
			if (!sCode.equals("")) {
				setParam(index++,	sCode + "%");
			}
			if (!kCode.equals("")) {
				setParam(index++,	kCode + "%");
			}
			if (!kName.equals("")) {
				setParam(index++,	"%" + kName+ "%");
			}
			if (!rtCode.equals("")) {
				setParam(index++,	rtCode + "%");
			}
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param sCode		R[h
	 * @param kCode		ЈR[h
	 * @param kName		Ј
	 * @param rtCode	[gR[h
	 * @return	list	(DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String sCode,
			String kCode,
			String kName,
			String rtCode,
			String jCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_ROUTE_ID		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_S_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_K_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_J_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAYER1		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAST_LAYER								);
		sb.append(" FROM ");
		sb.append( TABLE );
		sb.append(" LEFT JOIN ");
		sb.append(TABLE_2 );
		sb.append(" ON ");
		sb.append(TABLE + "." + COL_RT_CODE );
		sb.append(" = ");
		sb.append(TABLE_2 + "." + COL_RT_CODE );
		sb.append(" WHERE ");
		sb.append(TABLE + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(TABLE_2 + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF + " ");
		if (!sCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_S_CODE);
			sb.append(" = ? ");
		}
		if (!kCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_K_CODE);
			sb.append(" LIKE ? ");
		}
		if (!kName.equals("")) {
			sb.append(" AND ");
			sb.append(COL_K_CODE + " IN (" + MKihonDao.getSearchKNameSubQuery() + ") ");
		}
		if (!rtCode.equals("")) {
			sb.append(" AND ");
			sb.append(TABLE + "." + COL_RT_CODE);
			sb.append(" = ? ");
		}
		if (!jCode.equals("")) {
			sb.append(" AND ");
			sb.append(TABLE + "." + COL_J_CODE);
			sb.append(" = ? ");
		}
		try {
			prepareStatement(sb.toString() + getOrderForKey(getClass()));
			if (!sCode.equals("")) {
				setParam(index++,	sCode);
			}
			if (!kCode.equals("")) {
				setParam(index++,	kCode + "%");
			}
			if (!kName.equals("")) {
				setParam(index++,	"%" + kName+ "%");
			}
			if (!rtCode.equals("")) {
				setParam(index++,	rtCode);
			}
			if (!jCode.equals("")) {
				setParam(index++,	jCode);
			}
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode			ЈR[h
	 * @param startDate		Jn
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<AttendanceRouteDto> findForAvailable(
			String kcode,
			String startDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_ROUTE_ID		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_S_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_K_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_J_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAYER1		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAST_LAYER								);
		sb.append(" FROM ");
		sb.append( TABLE );
		sb.append(" LEFT JOIN ");
		sb.append(TABLE_2 );
		sb.append(" ON ");
		sb.append(TABLE + "." + COL_RT_CODE );
		sb.append(" = ");
		sb.append(TABLE_2 + "." + COL_RT_CODE );
		sb.append(" WHERE ");
		sb.append(TABLE + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(TABLE_2 + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(" ( ");
		sb.append(		COL_LAYER1 + " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");
		sb.append(		" OR ");
		sb.append(		COL_LAST_LAYER + " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");
		sb.append(" ) ");
		try {
			prepareStatement(sb.toString() + getOrderForKey(getClass()));
			setParam(index++,	kcode);
			setParam(index++,	kcode);
			setParam(index++,	Date.valueOf(startDate));				
			setParam(index++,	kcode);
			setParam(index++,	kcode);
			setParam(index++,	Date.valueOf(startDate));				
			executeQuery();
			List<AttendanceRouteDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForAvailable() throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_ROUTE_ID		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_S_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_K_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_J_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAYER1		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAST_LAYER								);
		sb.append(" FROM ");
		sb.append( TABLE );
		sb.append(" LEFT JOIN ");
		sb.append(TABLE_2 );
		sb.append(" ON ");
		sb.append(TABLE + "." + COL_RT_CODE );
		sb.append(" = ");
		sb.append(TABLE_2 + "." + COL_RT_CODE );
		sb.append(" WHERE ");
		sb.append(TABLE + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(TABLE_2 + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF + " ");
		try {
			prepareStatement(sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param sCode ΏۏR[h
	 * @param startDate JnN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<AttendanceRouteDto> findForBelongAvailable(
			String sCode,
			String startDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_ROUTE_ID		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_S_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_K_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_J_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAYER1		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAST_LAYER								);
		sb.append(" FROM ");
		sb.append( TABLE );
		sb.append(" LEFT JOIN ");
		sb.append(TABLE_2 );
		sb.append(" ON ");
		sb.append(TABLE + "." + COL_RT_CODE );
		sb.append(" = ");
		sb.append(TABLE_2 + "." + COL_RT_CODE );
		sb.append(" WHERE ");
		sb.append(TABLE + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(TABLE_2 + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_S_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_K_CODE);
		sb.append(" = '' ");
		sb.append(" AND ");
		sb.append(" ( ");
		sb.append(		COL_LAYER1 + " IN ( " + AmUnitDao.getSearchSubQueryByStartDate() + " ) ");
		sb.append(		" OR ");
		sb.append(		COL_LAST_LAYER + " IN ( " + AmUnitDao.getSearchSubQueryByStartDate() + " ) ");
		sb.append(" ) ");
		try {
			prepareStatement(sb.toString() + getOrderForKey(getClass()));
			setParam(index++,	sCode);
			setParam(index++,	startDate);
			setParam(index++,	startDate);
			executeQuery();
			List<AttendanceRouteDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode			ЈR[h
	 * @param scode			R[h
	 * @param jcode			ƏR[h
	 * @param startDate		Jn
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<AttendanceRouteDto> findForApproval(
			String kcode,
			String scode,
			String jcode,
			String startDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_ROUTE_ID		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_S_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_K_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_J_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAYER1		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAST_LAYER								);
		sb.append(" FROM ");
		sb.append( TABLE );
		sb.append(" LEFT JOIN ");
		sb.append(TABLE_2 );
		sb.append(" ON ");
		sb.append(TABLE + "." + COL_RT_CODE );
		sb.append(" = ");
		sb.append(TABLE_2 + "." + COL_RT_CODE );
		sb.append(" WHERE ");
		sb.append(TABLE + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(TABLE_2 + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(	"(");
		sb.append(		"(");
		// R[h
		sb.append(			TABLE + "." + COL_S_CODE);
		sb.append(			" = ? ");
		sb.append(			" AND ");
		// ƏR[h
		sb.append(			TABLE + "." + COL_J_CODE);
		sb.append(			" = ? ");
		sb.append(			" AND ");
		sb.append(				"(");
		sb.append(					COL_LAYER1 + " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");
		sb.append(					" OR ");
		sb.append(					COL_LAST_LAYER + " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");
		sb.append(				")");
		sb.append(		")");
		sb.append(	" OR ");
		sb.append(		"(");
		sb.append(			COL_LAYER1 + " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");
		sb.append(			" OR ");
		sb.append(			COL_LAST_LAYER + " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");
		sb.append(		")");
		sb.append(	") ");
		try {
			prepareStatement(sb.toString() + getOrderForKey(getClass()));
			// R[h
			setParam(index++,	scode);
			// ƏR[h
			setParam(index++,	jcode);
			setParam(index++,	kcode);
			setParam(index++,	kcode);
			setParam(index++,	Date.valueOf(startDate));
			setParam(index++,	kcode);
			setParam(index++,	kcode);
			setParam(index++,	Date.valueOf(startDate));
			setParam(index++,	kcode);
			setParam(index++,	kcode);
			setParam(index++,	Date.valueOf(startDate));
			setParam(index++,	kcode);
			setParam(index++,	kcode);
			setParam(index++,	Date.valueOf(startDate));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param startDate JnN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public AttendanceRouteDto findForKCodeAvailable(
			String kCode,
			String startDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_ROUTE_ID		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_S_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_K_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_J_CODE		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAYER1		+ MospConst.DATA_SEPARATOR	);
		sb.append(COL_LAST_LAYER								);
		sb.append(" FROM ");
		sb.append( TABLE );
		sb.append(" LEFT JOIN ");
		sb.append(TABLE_2 );
		sb.append(" ON ");
		sb.append(TABLE + "." + COL_RT_CODE );
		sb.append(" = ");
		sb.append(TABLE_2 + "." + COL_RT_CODE );
		sb.append(" WHERE ");
		sb.append(TABLE + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(TABLE_2 + "." + COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(" ( ");
		sb.append(		COL_LAYER1 + " IN ( " + AmUnitDao.getSearchSubQueryByStartDate() + " ) ");
		sb.append(		" OR ");
		sb.append(		COL_LAST_LAYER + " IN ( " + AmUnitDao.getSearchSubQueryByStartDate() + " ) ");
		sb.append(" ) ");
		try {
			prepareStatement(sb.toString() + getOrderForKey(getClass()));
			setParam(index++,	kCode);
			setParam(index++,	startDate);
			setParam(index++,	startDate);
			executeQuery();
			AttendanceRouteDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

}
