/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.StringPart;


import jp.mosp.workflow.dto.AmRouteDto;
import jp.mosp.workflow.dto.PmAttendanceDto;
import jp.mosp.workflow.vo.AttendanceRouteCardVo;

public class AttendanceRouteCardAction extends MosPWorkflowAction {

	// R}h
	private static final String CMD_ROUTE_CARD_SHOW   = "S2835";	// \(ǉ)
	private static final String CMD_ROUTE_CARD_SELECT = "S2836";	// \(I)
	private static final String CMD_ROUTE_CARD_INSERT = "S2837";	// o^
	private static final String CMD_ROUTE_CARD_UPDATE = "S2838";	// XV

	/**
	 * RXgN^
	 */
	public AttendanceRouteCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾yѐݒ
		AttendanceRouteCardVo vo = new AttendanceRouteCardVo();
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		PmAttendanceDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof PmAttendanceDto ? (PmAttendanceDto)obj : null;
		// v_ẼZbg
		setPulldownList(vo);
		// R}h̏
		if (cmd.equals(CMD_ROUTE_CARD_SHOW)) {
			vo.setDefaultValues();
			// [hݒ
			setMode(vo);	
		} else if (cmd.equals(CMD_ROUTE_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = pmAttendDao().findForKey(key1);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			vo.setMode(AttendanceRouteCardVo.MODE_UPDATE);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_ROUTE_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_ROUTE_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * v_E̐ݒ
	 * @param vo
	 * @throws Exception
	 */
	private void setPulldownList(AttendanceRouteCardVo vo) throws Exception {
		// ƏR[hꗗ
		vo.aryPltOffice = StringPart.addArrayFirstRowSpace(getOfficeArrayAll());
		// R[hꗗ
		vo.aryPltSection = util.addArrayFirstRowSpace(getSectionArrayAll());
		// ΑӗpF[gR[hꗗ
		vo.aryPltRoute	= getRouteArrayAvailable();
		// l{
		vo.aryUser	= getBasisArrayAll();
		// mFpz
		vo.aryBelongSection = getBasisArrayAllWithSectionCode();
		vo.aryBelongOffice = getBasisArrayAllWithOfficeCode();
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private PmAttendanceDto insert(AttendanceRouteCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// ݃`FbN
		chkDuplicate(pmAttendDao().findForCondition(vo.getPltSection(), vo.getTxtKCode(), vo.getPltRouteCode()), vo);
		if (!vo.getTxtKCode().equals("")) {
			chkDuplicate(pmAttendDao().findForKCode(vo.getTxtKCode()), vo);
		}
		// őlZbg
		String maxEno =	pmAttendDao().findForMax();
		if (maxEno == null || maxEno.equals("")) {
			maxEno = "-1";
		} else {
			pmAttendDao().findForUpdate(maxEno);
		}
		// DTȌ
		PmAttendanceDto dto = new PmAttendanceDto();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		vo.setDtoFields(dto);
		dto.setRouteId(Integer.parseInt(maxEno) + 1);
		// f[^̑}
		pmAttendDao().insert(dto);
		// DTO̍Ď擾
		dto = pmAttendDao().findForKey(String.valueOf(dto.getRouteId()));
		// R~bg
		commit();
		// [hݒ
		vo.setMode(AttendanceRouteCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return dto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private PmAttendanceDto update(AttendanceRouteCardVo vo, PmAttendanceDto dto) throws Exception {
		vo.setHidRouteid(String.valueOf(dto.getRouteId()));
		// p[^̑ÓmF
		vo.validate();
		// rmF
		chkExclusive(dto, pmAttendDao().findForUpdate(vo.getHidRouteid()), vo);
		// őlZbg
		String maxRouteId =	pmAttendDao().findForMax();
		if (maxRouteId == null || maxRouteId.equals("")) {
			maxRouteId = "-1";
		} else {
			pmAttendDao().findForUpdate(maxRouteId);
		}
		if (pmAttendDao().findForUpdate(String.valueOf(dto.getRouteId())) != null) {
			dto.setDeleteFlag(MospConst.DELETE_FLAG_ON);
			// _폜
			pmAttendDao().update(dto);
		}
		// DTȌ
		vo.setDtoFields(dto);
		dto.setRouteId(Integer.parseInt(maxRouteId) + 1);
		// f[^̍XV
		pmAttendDao().insert(dto);
		// DTO̍Ď擾
		PmAttendanceDto retDto = pmAttendDao().findForKey(String.valueOf(dto.getRouteId()));
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(AttendanceRouteCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * ΑӗpF[gR[hꗗiꎟAŏIj
	 * @return	String[][]	[gR[hz
	 * @throws Exception
	 */
	private String[][] getRouteArrayAvailable() throws Exception {
		// ̎擾
		List<AmRouteDto> listRoute = routeDao().findForAttendanceRoute();
		// z̍쐬		
		String[][] aryRouteList = new String[listRoute.size()][2];
		String[][] aryUnit = getCurrentUnitArray();
		for (int i = 0; i < listRoute.size(); i++) {
			aryRouteList[i][0] = listRoute.get(i).getRtCode();
			StringBuffer sb = new StringBuffer();
			sb.append(CommonConst.MSG_APPROVAL_FIRST);
			sb.append(util.getCodeName(listRoute.get(i).getLayer1(), aryUnit));
			sb.append(CommonConst.MSG_APPROVAL_SECOND);
			sb.append(util.getCodeName(listRoute.get(i).getLastLayer(), aryUnit));
			aryRouteList[i][1] = sb.toString();
		}
		return aryRouteList;
	}

	/**
	 * [hݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void setMode(AttendanceRouteCardVo vo) throws Exception {
		// [hݒ
		if (vo.aryPltRoute.length == 0) {
			vo.setMode(AttendanceRouteCardVo.MODE_IMPOSSIBLE);
		} else {
			vo.setMode(AttendanceRouteCardVo.MODE_INSERT);
		}
	}

}
