/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.common.common.MospConst;

public class CmCodeListVo extends MosPVo {

	private static final long serialVersionUID = 123422132321L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/system/cmcodeList.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/cmcodeList.js";
	private static final String EXTRA_CSS  = "/pub/system/css/cmcodeList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_COMMON_CODE_MASTER;

	// p[^
	public static final String PRM_PLT_T_ID       = "pltTId";
	public static final String PRM_TXT_T_CODE     = "txtTCode";
	public static final String PRM_TXT_T_NAME     = "txtTName";
	public static final String PRM_TXT_VIEW_INDEX = "txtViewIndex";
	public static final String PRM_PLT_DELETE     = "pltDelete";

	// tB[h
	private String[] aryTId;
	private String[] aryTIdName;
	private String[] aryTCode;
	private String[] aryTName;
	private String[] aryViewIndex;
	private String[] aryDelete;
	private String   pltTId;
	private String   txtTCode;
	private String   txtTName;
	private String   txtViewIndex;
	private String   pltDelete;

	// tB[hyѐ
	public static final String NAM_CODE_ID = CommonConst.NAM_COMMON_CODE + CommonConst.NAM_COMMON_TYPE;
	public static final String NAM_CODE    = CommonConst.NAM_COMMON_CODE;
	public static final String NAM_NAME    = CommonConst.NAM_COMMON_MEISYO;
	public static final String NAM_INDEX   = CommonConst.NAM_SHOW_ORDER;
	public static final String NAM_DELETE  = CommonConst.NAM_DELETE_FLAG;
	public static final int    LEN_CODE_ID = 10;
	public static final int    LEN_CODE    = 8;
	public static final int    LEN_NAME    = 16;

	// \[gL[
	public final String KEY_T_ID      = "keyTId";
	public final String KEY_T_CODE    = "keyTCode";
	public final String KEY_T_NAME    = "keyTName";
	public final String KEY_VIEWINDEX = "keyViewIndex";
	public final String KEY_DELETE    = "keyDelete";

	// v_EXg
	public String[][] aryPltTId;

	// [h(0FȂA1F)
	private int searchmode;

	/**
	 * RXgN^
	 */
	public CmCodeListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		pltTId       = "";
		txtTCode     = "";
		txtTName     = "";
		txtViewIndex = "";
		pltDelete    = "";
		aryTId       = new String[0];
		aryTIdName   = new String[0];
		aryTCode     = new String[0];
		aryTName     = new String[0];
		aryViewIndex = new String[0];
		aryDelete    = new String[0];
		setFormerKey(KEY_T_ID);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltTId       = request.getParameter(PRM_PLT_T_ID);
		txtTCode     = request.getParameter(PRM_TXT_T_CODE);
		txtTName     = request.getParameter(PRM_TXT_T_NAME);
		txtViewIndex = request.getParameter(PRM_TXT_VIEW_INDEX);
		pltDelete    = request.getParameter(PRM_PLT_DELETE);
	}

	/**
	 * tB[hݒ
	 * @param listUmUser [U[Xg
	 */
	public void setFields(List listUmUser) {
		// Xg̐ݒ
		list = listUmUser;
		// f[^̎擾
		count = listUmUser.size();
		// z̏
		aryTId       = new String[count];
		aryTCode     = new String[count];
		aryTName     = new String[count];
		aryViewIndex = new String[count];
		aryDelete    = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listUmUser.iterator();
		while (it.hasNext()) {
			CmCodeDto dto   = (CmCodeDto)it.next();
			aryTId[i]       = escapeHTML(dto.getTId());
			aryTCode[i]     = escapeHTML(dto.getTCode());
			aryTName[i]     = escapeHTML(dto.getTName());
			aryViewIndex[i] = String.valueOf(dto.getViewIndex());
			aryDelete[i]    = String.valueOf(dto.getDeleteFlag());
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			}
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[] getEscAryTId      () { return aryTId.clone()		; }
	public String[] getAryTIdName     () { return aryTIdName.clone()	; }
	public String[] getEscAryTCode    () { return aryTCode.clone()		; }
	public String[] getEscAryTName    () { return aryTName.clone()		; }
	public String[] getEscAryViewIndex() { return aryViewIndex.clone()	; }
	public String[] getEscAryDelete   () { return aryDelete.clone()	; }
	public void setAryTIdName(String[] aryTIdName) { this.aryTIdName = aryTIdName.clone(); }
	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

	public String getPltTId      () { return pltTId      ; }
	public String getTxtTCode    () { return txtTCode    ; }
	public String getTxtTName    () { return txtTName    ; }
	public String getTxtViewIndex() { return txtViewIndex; }
	public String getPltDelete   () { return pltDelete   ; }
	public String getEscPltTId      () { return escapeHTML(pltTId      ); }
	public String getEscTxtTCode    () { return escapeHTML(txtTCode    ); }
	public String getEscTxtTName    () { return escapeHTML(txtTName    ); }
	public String getEscTxtViewIndex() { return escapeHTML(txtViewIndex); }
	public void setPltDelete(int pltDelete) { this.pltDelete = String.valueOf(pltDelete); }

}
