/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.dao.MCodeDao;
import jp.mosp.system.dto.MCodeDto;
import jp.mosp.system.vo.CodeMasterCardVo;
import jp.mosp.system.vo.HolidayMasterCardVo;

public class HolidayMasterCardAction extends MosPAction {

	// R}h
	private static final String CMD_HOLIDAY_MASTER_CARD_SHOW   = "S2715";	// \(ǉ)
	private static final String CMD_HOLIDAY_MASTER_CARD_SELECT = "S2716";	// \(I)
	private static final String CMD_HOLIDAY_MASTER_CARD_INSERT = "S2717";	// o^
	private static final String CMD_HOLIDAY_MASTER_CARD_UPDATE = "S2718";	// XV
	private static final String CMD_HOLIDAY_MASTER_CARD_DELETE = "S2719";	// 폜

	/**
	 * RXgN^
	 */
	public HolidayMasterCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾yѐݒ
		HolidayMasterCardVo vo = new HolidayMasterCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DAȌ
		MCodeDao dao;
		dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO̎擾
		MCodeDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MCodeDto ? (MCodeDto)obj : null;
		// v_E̐ݒ
		vo.aryPltMonth = util.getMonthArray();
		vo.aryPltDay = util.getDayArray();
		// R}h̏
		if (cmd.equals(CMD_HOLIDAY_MASTER_CARD_SHOW)) {
			// lݒ
			vo.setTxtHolidayYear(String.valueOf(MospUtility.getYear(util.getSystemDate())));
			vo.setPltHolidayMonth(String.valueOf(MospUtility.getMonth(util.getSystemDate())));
			vo.setPltHolidayDay(String.valueOf(MospUtility.getDay(util.getSystemDate())));
			vo.setTxtHolidayName("");
			// [hݒ
			vo.setMode(CodeMasterCardVo.MODE_INSERT);
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = dao.findForKey(CommonConst.NAM_HOLIDAY, key1);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			// [hݒ
			setMode(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_CARD_DELETE)) {
			// 폜
			delete(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MCodeDto insert(HolidayMasterCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		if (vo.getTxtHolidayYear().equals("")) {
			chkDuplicate(dao.findForKey(CommonConst.TID_HOLIDAY,
					util.addZero(vo.getPltHolidayMonth())
					+ CommonConst.SEPARATOR_DATE
					+ util.addZero(vo.getPltHolidayDay()))
					, vo);
		} else {
			chkDuplicate(dao.findForKey(CommonConst.TID_HOLIDAY, util.convStringDateFormatted(
					vo.getTxtHolidayYear(),
					vo.getPltHolidayMonth(),
					vo.getPltHolidayDay())), vo
			);
		}
		// DTȌ
		MCodeDto dto = new MCodeDto();
		vo.setDtoFields(dto);
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(CommonConst.TID_HOLIDAY, dto.getTCode());
		chkInsert(dto);
		// R~bg
		commit();
		// [hݒ
		setMode(vo);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return dto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MCodeDto update(HolidayMasterCardVo vo, MCodeDto dto) throws Exception {
		String holiday = dto.getTCode();
		if (holiday.startsWith("0")
				|| holiday.startsWith("1")) {
			vo.setTxtHolidayYear("");
			vo.setPltHolidayMonth(util.removeZero(holiday.split(CommonConst.SEPARATOR_DATE)[0]));
			vo.setPltHolidayDay(util.removeZero(holiday.split(CommonConst.SEPARATOR_DATE)[1]));
		} else {
			vo.setTxtHolidayYear(String.valueOf(MospUtility.getYear(util.convStringDateToDate(dto.getTCode()))));
			vo.setPltHolidayMonth(String.valueOf(MospUtility.getMonth(util.convStringDateToDate(dto.getTCode()))));
			vo.setPltHolidayDay(String.valueOf(MospUtility.getDay(util.convStringDateToDate(dto.getTCode()))));
		}
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dao.findForKey(dto.getTId(), dto.getTCode()), dao.findForUpdate(dto.getTId(), dto.getTCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MCodeDto retDto = dao.findForKey(CommonConst.TID_HOLIDAY, dto.getTCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode(vo);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * f[^폜
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @throws Exception
	 */
	private void delete(HolidayMasterCardVo vo, MCodeDto dto) throws Exception {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dao.findForKey(dto.getTId(), dto.getTCode()), dao.findForUpdate(dto.getTId(), dto.getTCode()), vo);
		// f[^̍폜
		dao.delete(dto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(CodeMasterCardVo.MODE_INSERT);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
	}

	/**
	 * [hݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void setMode(HolidayMasterCardVo vo) throws Exception {
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(HolidayMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(HolidayMasterCardVo.MODE_UPDATE);
		}
	}

}
