/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.bean.OdsBean;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.part.StringPart;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.Payment;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.payment.vo.PaymentReportVo;

/**
 * ^ׂ̏o͂sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_REPORT}
 * </li></ul>
 */
public class PaySlipOutputAction extends PayrollAction {
	
	/**
	 * ^׏o̓R}hB<br><br>
	 * ɂA^ׂExcelŏo͂B<br>
	 */
	public static final String CMD_REPORT = "P1245";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public PaySlipOutputAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PaymentReportVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_REPORT)) {
			// ^׏o
			if (StringPart.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
				report();
			} else {
				reportXls();
			}
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * [o͏sB<br><br>
	 * @throws Exception 
	 */
	private void report() throws Exception {
		// RlNV擾
		getConnection();
		// Ј擾
		Employee employee = getEmployee(key1);
		// ׏擾
		Payment payment = getPayment(key1, MospUtility.getDate(key2));
		// [쐬
		OdsBean odsBean = new OdsBean(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TPL_PAYMENT_SLIP_ODS);
		// wb_[
		int row = 4;
		int col = 1;
		odsBean.setValue(col     , row, employee.getSectionCode());	// R[h
		odsBean.setValue(col + 10, row, employee.getKCode      ());	// ЈR[h
		odsBean.setValue(col + 20, row, employee.getKName      ());	// Ј
		odsBean.setValue(col + 66, row, payment.getPayDate     ());	// x
		// ΑӍ
		row = 6;
		col = 4;
		String[][] aryTime = payment.getTimeArray(true);
		for (int i = 0; i < aryTime.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			odsBean.setValue(col, row    , aryTime[i][1]);
			odsBean.setValue(col, row + 1, aryTime[i][2]);
		}
		// x
		row = 11;
		col =  4;
		String[][] aryAllowance = payment.getAllowanceArray(true);
		for (int i = 0; i < aryAllowance.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			odsBean.setValue(col, row    , aryAllowance[i][1]);
			odsBean.setValue(col, row + 1, new Integer(aryAllowance[i][2]));
		}
		// T
		row = 22;
		col =  4;
		String[][] aryDeduction = payment.getDeductionArray(true);
		for (int i = 0; i < aryDeduction.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			odsBean.setValue(col, row    , aryDeduction[i][1]);
			odsBean.setValue(col, row + 1, new Integer(aryDeduction[i][2]));
		}
		// v
		row = 33;
		col =  4;
		String[][] arySum = payment.getSumArray(true);
		for (int i = 0; i < arySum.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			odsBean.setValue(col, row    , arySum[i][1]);
			odsBean.setValue(col, row + 1, new Integer(arySum[i][2]));
		}
		// o͓eݒ
		String fileName =
			MospUtility.getYear (payment.getCalcMonth()) + PayrollConst.FILE_NAME_SEPARATOR +
			MospUtility.getMonth(payment.getCalcMonth()) + PayrollConst.FILE_NAME_SEPARATOR +
			payment.getKCode()                          + PayrollConst.FILE_NAME_SEPARATOR +
			PayrollConst.FILE_PAYMENT_SLIP_OO;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, odsBean.getSpreadSheet());
	}
	
	/**
	 * [o͏sB<br><br>
	 * @throws Exception 
	 */
	private void reportXls() throws Exception {
		// RlNV擾
		getConnection();
		// Ј擾
		Employee employee = getEmployee(key1);
		// ׏擾
		Payment payment = getPayment(key1, MospUtility.getDate(key2));
		// [쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TPL_PAYMENT_SLIP_XLS);
		poi.prtItem(4,  1, employee.getSectionCode());	// R[h
		poi.prtItem(4, 11, employee.getKCode      ());	// ЈR[h
		poi.prtItem(4, 21, employee.getKName      ());	// Ј
		poi.prtItem(4, 67, payment.getPayDate     ());	// x
		// ΑӍ
		int row = 6;
		int col = 4;
		String[][] aryTime = payment.getTimeArray(true);
		for (int i = 0; i < aryTime.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			poi.prtItem(row    ,  col, aryTime[i][1]);
			poi.prtItem(row + 1,  col, aryTime[i][2]);
		}
		// x
		row = 11;
		col =  4;
		String[][] aryAllowance = payment.getAllowanceArray(true);
		for (int i = 0; i < aryAllowance.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			poi.prtItem(row    ,  col, aryAllowance[i][1]);
			poi.prtItem(row + 1,  col, Integer.parseInt(aryAllowance[i][2]));
		}
		// T
		row = 22;
		col =  4;
		String[][] aryDeduction = payment.getDeductionArray(true);
		for (int i = 0; i < aryDeduction.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			poi.prtItem(row    ,  col, aryDeduction[i][1]);
			poi.prtItem(row + 1,  col, Integer.parseInt(aryDeduction[i][2]));
		}
		// v
		row = 33;
		col =  4;
		String[][] arySum = payment.getSumArray(true);
		for (int i = 0; i < arySum.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			poi.prtItem(row    ,  col, arySum[i][1]);
			poi.prtItem(row + 1,  col, Integer.parseInt(arySum[i][2]));
		}
		
		// o͓eݒ
		String fileName =
			MospUtility.getYear (payment.getCalcMonth()) + PayrollConst.FILE_NAME_SEPARATOR +
			MospUtility.getMonth(payment.getCalcMonth()) + PayrollConst.FILE_NAME_SEPARATOR +
			payment.getKCode()                          + PayrollConst.FILE_NAME_SEPARATOR +
			PayrollConst.FILE_PAYMENT_SLIP;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}

	
}
