/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.base;

import java.sql.Connection;
import java.util.Properties;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 *  MosP^vZpDao̊{@\񋟂B<br><br>
 */
public abstract class PayrollDao extends BaseDao {
	
	/**
	 * ^vZVXeDAOʏsB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link BaseDao#INSERT_DATE} ݒ
	 * </li><li>
	 * {@link BaseDao#INSERT_USER} ݒ
	 * </li><li>
	 * {@link BaseDao#UPDATE_DATE} ݒ
	 * </li><li>
	 * {@link BaseDao#UPDATE_USER} ݒ
	 * </li></ul>
	 */
	public PayrollDao() {
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ^vZVXeDAOʏsB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link BaseDao#BaseDao(java.util.Properties, String, jp.mosp.common.dto.CmAspUserDto, jp.mosp.common.dto.CmUserDto, java.sql.Connection)}
	 * </li><li>
	 * {@link BaseDao#INSERT_DATE} ݒ
	 * </li><li>
	 * {@link BaseDao#INSERT_USER} ݒ
	 * </li><li>
	 * {@link BaseDao#UPDATE_DATE} ݒ
	 * </li><li>
	 * {@link BaseDao#UPDATE_USER} ݒ
	 * </li></ul>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public PayrollDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		super(cfg, cmd, aspUser, user, conn);
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
}
