/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

import jp.mosp.kintai.dto.MSyukkinboDto;

public class AttendanceMenuVo extends MosPVo {

	private static final long serialVersionUID = 3059406656261478934L;

	// p[^
	public static final String PRM_HID_SELECT_CMD 	= "hidSelectCmd";

	public static final String PRM_HID_K_CODE = "hidKCode"	;
	public static final String PRM_HID_K_NAME = "hidKName"	;
	public static final String PRM_HID_YEAR 	= "hidYear";
	public static final String PRM_HID_MONTH 	= "hidMonth";
	public static final String PRM_HID_DAY	 	= "hidDay";

	// ҏW[htO
	public static final int MODE_INSERT 		= 0;
	public static final int MODE_EDIT			= 1;
	public static final int MODE_APPROVED		= 2;

	// ҏW[h
	public static final String NAM_MODE_INSERT		= CommonConst.NAM_MODE_INSERT;
	public static final String NAM_MODE_EDIT		= CommonConst.NAM_MODE_EDIT;
	public static final String NAM_MODE_APPROVED	= CommonConst.NAM_MODE_APPROVED;

	// tB[h
	protected String lblKCode;
	protected String lblKName;

	protected String lblYear;
	protected String lblMonth;
	protected String lblDay;

	// tB[h(ʑJڗp)
	private String hidKCode;
	private String hidKName;
	private String hidYear;
	private String hidMonth;
	private String hidDay;
	private String hidDate;

	// {^e
	private String hidSelectCmd ;

	// o΃{^R}h
	private String cmdStartButton;

	// ދ΃{^R}h
	private String cmdQuitButton;

	// xɃ{^R}h
	private String cmdHolidayButton;

	// ҏW[h(0FVKo^A1FXVA2:F)
	protected int mode;

	// Tu^Cgj[R}h
	private String cmdMenuButton;
	private String cmdListButton;
	private String namListButton;

	// ҏW[h
	public static final String NAM_APPLICATION_TIME 	= CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_REQUEST_STATUS 		= CommonConst.NAM_APPROVAL_STATE;

	// cƐ\
	private String applicationTime;
	private String requestStatus;

	/**
	 * RXgN^
	 */
	public AttendanceMenuVo() {
		super();
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		hidSelectCmd 	= request.getParameter(PRM_HID_SELECT_CMD);
		hidKCode		= request.getParameter(PRM_HID_K_CODE);
		hidKName		= request.getParameter(PRM_HID_K_NAME);
		hidYear			= request.getParameter(PRM_HID_YEAR);
		hidMonth		= request.getParameter(PRM_HID_MONTH);
		hidDay			= request.getParameter(PRM_HID_DAY);
		hidDate			= util.convStringDateFormatted(hidYear, hidMonth, hidDay);
		lblKCode 		= hidKCode;
		lblKName 		= hidKName;
		lblYear 		= hidYear;
		lblMonth 		= hidMonth;
		lblDay 			= hidDay;
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto	ΏDTO
	 */
	public void setDtoFields(MSyukkinboDto dto) {
		dto.setKCode(getHidKCode());
		dto.setHizuke(util.convStringDateFormatted(getHidYear(), getHidMonth(), getHidDay()));
		dto.setNen(Integer.parseInt(getHidYear()));
		dto.setTuki(Integer.parseInt(getHidMonth()));
		dto.setHi(Integer.parseInt(getHidDay()));
	}

	/**
	 * tB[hݒiTxpj
	 * @param dto
	 */
	public void setWeekHolidayDtoFields(MSyukkinboDto dto) {
		dto.setKCode(getHidKCode());
		dto.setHizuke(util.convStringDateFormatted(getHidYear(), getHidMonth(), getHidDay()));
		dto.setNen(Integer.parseInt(getHidYear()));
		dto.setTuki(Integer.parseInt(getHidMonth()));
		dto.setHi(Integer.parseInt(getHidDay()));
		dto.setKinmu(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
		dto.setSyJikoku("");
		dto.setTaJikoku("");
		dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
		dto.setUpdtTimes(util.getDateTime(util.getNowDate()));
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var SELECT_CMD = \"");
		sb.append(hidSelectCmd);
		sb.append("\";");
		return sb.toString();
	}

	// ANZT\bh
	public String getEscLblKCode	() { return escapeHTML(lblKCode		); }
	public String getEscLblKName	() { return escapeHTML(lblKName		); }

	public String getEscLblDay		() { return escapeHTML(lblDay		); }
	public String getEscLblMonth	() { return escapeHTML(lblMonth		); }
	public String getEscLblYear		() { return escapeHTML(lblYear		); }

	public void	setLblKCode		(String lblKCode	) { this.lblKCode	= lblKCode	; }
	public void	setLblKName		(String lblKName	) { this.lblKName	= lblKName	; }

	public void 	setLblDay		(String lblDay		) { this.lblDay 	= lblDay	; }
	public void 	setLblMonth		(String lblMonth	) { this.lblMonth 	= lblMonth	; }
	public void 	setLblYear		(String lblYear		) { this.lblYear 	= lblYear	; }

	public String getHidKCode		() { return hidKCode	; }
	public String getHidKName		() { return hidKName	; }
	public String getHidYear		() { return hidYear		; }
	public String getHidMonth		() { return hidMonth	; }
	public String getHidDay			() { return hidDay		; }

	public String getEscHidKCode		() { return escapeHTML(hidKCode				); }
	public String getEscHidKName		() { return escapeHTML(hidKName				); }
	public String getEscHidYear			() { return escapeHTML(hidYear				); }
	public String getEscHidMonth		() { return escapeHTML(hidMonth				); }
	public String getEscHidDay			() { return escapeHTML(hidDay				); }

	public void setHidKCode	(String hidKCode) { this.hidKCode	= hidKCode	; }
	public void setHidKName	(String hidKName) { this.hidKName	= hidKName	; }
	public void setHidYear		(String hidYear ) { this.hidYear	= hidYear	; }
	public void setHidMonth	(String hidMonth) { this.hidMonth	= hidMonth	; }
	public void setHidDay		(String hidDay  ) { this.hidDay		= hidDay	; }

	public void setHidSelectCmd(String hidSelectCmd) { this.hidSelectCmd = hidSelectCmd; }
	public String getHidSelectCmd() { return hidSelectCmd; }

	public String getHidDate() { return hidDate; }
	public String getEscHidDate() { return escapeHTML(hidDate); }
	public void setHidDate(String hidDate) { this.hidDate = hidDate; }

	public String getCmdHolidayButton	() { return cmdHolidayButton	; }
	public String getCmdQuitButton		() { return cmdQuitButton		; }
	public String getCmdStartButton		() { return cmdStartButton		; }

	public void setCmdHolidayButton(String cmdHolidayButton) 	{ this.cmdHolidayButton 	= cmdHolidayButton	; }
	public void setCmdQuitButton	(String cmdQuitButton) 		{ this.cmdQuitButton 		= cmdQuitButton		; }
	public void setCmdStartButton	(String cmdStartButton) 	{ this.cmdStartButton 		= cmdStartButton	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

	public String getCmdMenuButton() { return cmdMenuButton; }
	public String getCmdListButton() { return cmdListButton; }
	public String getNamListButton() { return namListButton; }

	public void setCmdMenuButton(String cmdMenuButton) { this.cmdMenuButton = cmdMenuButton; }
	public void setCmdListButton(String cmdListButton) { this.cmdListButton = cmdListButton; }
	public void setNamListButton(String namListButton) { this.namListButton = namListButton; }

	public String getEscApplicationTime() { return escapeHTML(applicationTime); }
	public String getEscRequestStatus() { return escapeHTML(requestStatus); }

	public void setApplicationTime(String overTime) { this.applicationTime = overTime; }
	public void setRequestStatus(String requestStatus) { this.requestStatus = requestStatus; }

}
