/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.CommonUtility;
import jp.mosp.common.common.MospException;

import jp.mosp.human.dto.MEmergencyDto;
import jp.mosp.human.dto.MKihonDto;
import jp.mosp.human.dto.MKojinDto;

public class HumanPersonalCardVo extends HumanCardVo {

	private static final long serialVersionUID = 767129584113797363L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/human/humanPersonal.jsp";
	private static final String EXTRA_JS   = "/pub/human/js/humanPersonal.js";
	private static final String EXTRA_CSS  = "/pub/human/css/humanPersonal.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_HUMAN_KOJIN;

	// p[^
	public static final String PRM_PLT_GENDER					= "pltGender"				;
	public static final String PRM_PLT_BIRTH_YEAR				= "pltBirthYear"			;
	public static final String PRM_PLT_BIRTH_MONTH			= "pltBirthMonth"			;
	public static final String PRM_PLT_BIRTH_DAY				= "pltBirthDay"				;
	public static final String PRM_TXT_POSTAL_CODE1 			= "txtPostalCode1"			;
	public static final String PRM_TXT_POSTAL_CODE2 			= "txtPostalCode2"			;
	public static final String PRM_PLT_PREFECTURE 			= "pltPrefecture"			;
	public static final String PRM_TXT_ADRESS1 				= "txtAdress1"				;
	public static final String PRM_TXT_ADRESS2 				= "txtAdress2"				;
	public static final String PRM_TXT_ADRESS3 				= "txtAdress3"				;
	public static final String PRM_TXT_EMERGENCY_CODE 		= "txtEMCode"				;
	public static final String PRM_TXT_EMERGENCY_NAME 		= "txtEmName"				;
	public static final String PRM_TXT_EMERGENCY_TEL1 		= "txtEmTel1"				;
	public static final String PRM_TXT_EMERGENCY_TEL2 		= "txtEmTel2"				;
	public static final String PRM_TXT_EMERGENCY_TEL3 		= "txtEmTel3"				;
	public static final String PRM_TXT_EMERGENCY_PHONE1 		= "txtEmPhone1"				;
	public static final String PRM_TXT_EMERGENCY_PHONE2 		= "txtEmPhone2"				;
	public static final String PRM_TXT_EMERGENCY_PHONE3 		= "txtEmPhone3"				;
	public static final String PRM_TXT_EMERGENCY_POSTAL_CODE1 = "txtEmPostalCode1"		;
	public static final String PRM_TXT_EMERGENCY_POSTAL_CODE2 = "txtEmPostalCode2"		;
	public static final String PRM_PLT_EMERGENCY_PREFECTURE 	= "pltEmPrefecture"			;
	public static final String PRM_TXT_EMERGENCY_ADRESS1		= "txtEmAdress1"			;
	public static final String PRM_TXT_EMERGENCY_ADRESS2 		= "txtEmAdress2"			;
	public static final String PRM_TXT_EMERGENCY_ADRESS3 		= "txtEmAdress3"			;
	public static final String PRM_TXT_TEL1 					= "txtTel1"					;
	public static final String PRM_TXT_TEL2 					= "txtTel2"					;
	public static final String PRM_TXT_TEL3 					= "txtTel3"					;
	public static final String PRM_TXT_FAX1 					= "txtFax1"					;
	public static final String PRM_TXT_FAX2 					= "txtFax2"					;
	public static final String PRM_TXT_FAX3 					= "txtFax3"					;
	public static final String PRM_TXT_PHONE1 				= "txtPhone1"				;
	public static final String PRM_TXT_PHONE2 				= "txtPhone2"				;
	public static final String PRM_TXT_PHONE3 				= "txtPhone3"				;
	public static final String PRM_PLT_BLOOD_TYPE				= "pltBloodType"			;
	public static final String PRM_TXT_LICENSE 				= "txtLicense"				;
	public static final String PRM_TXT_RECAPITULATION 		= "txtRecapitulation"		;
	public static final String PRM_TXT_HEALTH 				= "txtHealth"				;
	public static final String PRM_PLT_SALARY_KB				= "pltSalaryKb"				;
	public static final String PRM_PLT_TAX_KB					= "pltTaxKb"				;	
	public static final String PRM_PLT_UNION_KB				= "pltUnionKb"				;	
	public static final String PRM_PLT_PART_KB				= "pltPartKb"				;
	public static final String PRM_PLT_PAYMENT_KB				= "pltPaymentKb"			;
	public static final String PRM_PLT_DELETE     			= "pltDelete"				;

	public static final String PRM_HID_GENDER					= "hidGender"				;
	public static final String PRM_HID_BIRTH_YEAR				= "hidBirthYear"			;
	public static final String PRM_HID_BIRTH_MONTH			= "hidBirthMonth"			;
	public static final String PRM_HID_BIRTH_DAY				= "hidBirthDay"				;
	public static final String PRM_HID_POSTAL_CODE1 			= "hidPostalCode1"			;
	public static final String PRM_HID_POSTAL_CODE2 			= "hidPostalCode2"			;
	public static final String PRM_HID_PREFECTURE 			= "hidPrefecture"			;
	public static final String PRM_HID_ADRESS1 				= "hidAdress1"				;
	public static final String PRM_HID_ADRESS2 				= "hidAdress2"				;
	public static final String PRM_HID_ADRESS3 				= "hidAdress3"				;
	public static final String PRM_HID_EMERGENCY_CODE 		= "hidEMCode"				;
	public static final String PRM_HID_EMERGENCY_NAME 		= "hidEmName"				;
	public static final String PRM_HID_EMERGENCY_TEL1 		= "hidEmTel1"				;
	public static final String PRM_HID_EMERGENCY_TEL2 		= "hidEmTel2"				;
	public static final String PRM_HID_EMERGENCY_TEL3 		= "hidEmTel3"				;
	public static final String PRM_HID_EMERGENCY_PHONE1 		= "hidEmPhone1"				;
	public static final String PRM_HID_EMERGENCY_PHONE2 		= "hidEmPhone2"				;
	public static final String PRM_HID_EMERGENCY_PHONE3 		= "hidEmPhone3"				;
	public static final String PRM_HID_EMERGENCY_POSTAL_CODE1	= "hidEmPostalCode1"		;
	public static final String PRM_HID_EMERGENCY_POSTAL_CODE2 = "hidEmPostalCode2"		;
	public static final String PRM_HID_EMERGENCY_PREFECTURE 	= "hidEmPrefecture"			;
	public static final String PRM_HID_EMERGENCY_ADRESS1		= "hidEmAdress1"			;
	public static final String PRM_HID_EMERGENCY_ADRESS2 		= "hidEmAdress2"			;
	public static final String PRM_HID_EMERGENCY_ADRESS3 		= "hidEmAdress3"			;
	public static final String PRM_HID_TEL1 					= "hidTel1"					;
	public static final String PRM_HID_TEL2 					= "hidTel2"					;
	public static final String PRM_HID_TEL3 					= "hidTel3"					;
	public static final String PRM_HID_FAX1 					= "hidFax1"					;
	public static final String PRM_HID_FAX2 					= "hidFax2"					;
	public static final String PRM_HID_FAX3 					= "hidFax3"					;
	public static final String PRM_HID_PHONE1 				= "hidPhone1"				;
	public static final String PRM_HID_PHONE2 				= "hidPhone2"				;
	public static final String PRM_HID_PHONE3 				= "hidPhone3"				;
	public static final String PRM_HID_BLOOD_TYPE				= "hidBloodType"			;
	public static final String PRM_HID_LICENSE 				= "hidLicense"				;
	public static final String PRM_HID_RECAPITULATION 		= "hidRecapitulation"		;
	public static final String PRM_HID_HEALTH 				= "hidHealth"				;
	public static final String PRM_HID_SALARY_KB				= "hidSalaryKb"				;
	public static final String PRM_HID_TAX_KB					= "hidTaxKb"				;	
	public static final String PRM_HID_UNION_KB				= "hidUnionKb"				;	
	public static final String PRM_HID_PART_KB				= "hidPartKb"				;
	public static final String PRM_HID_PAYMENT_KB				= "hidPaymentKb"			;
	public static final String PRM_HID_DELETE     			= "hidDelete"				;

	// tB[hyѐ
	public static final String NAM_K_CODE     		= CommonConst.NAM_K_CODE										;
	public static final String NAM_K_NAME				= CommonConst.NAM_K_NAME										;
	public static final String NAM_K_KANA				= CommonConst.NAM_K_KANA										;
	public static final String NAM_GENDER				= CommonConst.NAM_GENDER										;
	public static final String NAM_BIRTH_DATE			= CommonConst.NAM_BIRTH_DATE									;
	public static final String NAM_POSTAL1			= CommonConst.NAM_POSTAL_CODE + CommonConst.NAM_POSTAL_FRONT	;
	public static final String NAM_POSTAL2			= CommonConst.NAM_POSTAL_CODE + CommonConst.NAM_POSTAL_BACK		;	
	public static final String NAM_ADDRESS			= CommonConst.NAM_ADDRESS										;
	public static final String NAM_POSTAL_CODE		= CommonConst.NAM_POSTAL_CODE									;
	public static final String NAM_PREFECTURE			= CommonConst.NAM_PREFECTURE 									;
	public static final String NAM_ADRESS1			= CommonConst.NAM_CITIES										;
	public static final String NAM_ADRESS2			= CommonConst.NAM_HOUSE_NUMBER  								;
	public static final String NAM_ADRESS3			= CommonConst.NAM_HOUSE_NAME									;
	public static final String NAM_TEL				= CommonConst.NAM_PHONE_NUMBER									;
	public static final String NAM_TEL1				= CommonConst.NAM_PHONE_NUMBER + CommonConst.NAM_AREA_NUMBER		;
	public static final String NAM_TEL2				= CommonConst.NAM_PHONE_NUMBER + CommonConst.NAM_LOCAL_AREA_NUMBER	;
	public static final String NAM_TEL3				= CommonConst.NAM_PHONE_NUMBER + CommonConst.NAM_SUBSCRIBER_NUMBER	;
	public static final String NAM_FAX				= CommonConst.NAM_FAX											;
	public static final String NAM_FAX1				= CommonConst.NAM_FAX + CommonConst.NAM_AREA_NUMBER				;
	public static final String NAM_FAX2				= CommonConst.NAM_FAX + CommonConst.NAM_LOCAL_AREA_NUMBER		;
	public static final String NAM_FAX3				= CommonConst.NAM_FAX + CommonConst.NAM_SUBSCRIBER_NUMBER		;
	public static final String NAM_PHONE				= CommonConst.NAM_CELLPHONE_NUMBER								;
	public static final String NAM_PHONE1				= CommonConst.NAM_CELLPHONE_NUMBER + CommonConst.NAM_AREA_NUMBER		;
	public static final String NAM_PHONE2				= CommonConst.NAM_CELLPHONE_NUMBER + CommonConst.NAM_LOCAL_AREA_NUMBER	;
	public static final String NAM_PHONE3				= CommonConst.NAM_CELLPHONE_NUMBER + CommonConst.NAM_SUBSCRIBER_NUMBER	;
	public static final String NAM_BLOOD_TYPE			= CommonConst.NAM_BLOOD_TYPE									;
	public static final String NAM_SALARY_KB			= CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_COMMON_TYPE	;
	public static final String NAM_TAX_KB				= CommonConst.NAM_INCOME_TAX_TYPE								;
	public static final String NAM_UNION_KB			= CommonConst.NAM_UNION + CommonConst.NAM_COMMON_TYPE			;
	public static final String NAM_PART_KB			= CommonConst.NAM_PARTTIME_TYPE									;
	public static final String NAM_PAYMENT_KB			= CommonConst.NAM_PAYMENT_TYPE 									;
	public static final String NAM_LICENSE			= CommonConst.NAM_LICENSE										;
	public static final String NAM_RECAPITULATION		= CommonConst.NAM_RECAPITULATION								;
	public static final String NAM_HEALTH				= CommonConst.NAM_HEALTH										;

	public static final String NAM_EMERGENCY_ADRESS	= CommonConst.NAM_EMERGENCY																;
	public static final String NAM_EMERGENCY_NAME		= CommonConst.NAM_FAMILY_NAME															;	
	public static final String NAM_EMERGENCY_POSTAL1	= CommonConst.NAM_EMERGENCY + CommonConst.NAM_POSTAL_CODE + CommonConst.NAM_POSTAL_FRONT;
	public static final String NAM_EMERGENCY_POSTAL2	= CommonConst.NAM_EMERGENCY + CommonConst.NAM_POSTAL_CODE + CommonConst.NAM_POSTAL_BACK	;
	public static final String NAM_EMERGENCY_TEL		= CommonConst.NAM_EMERGENCY + CommonConst.NAM_PHONE_NUMBER								;
	public static final String NAM_EMERGENCY_TEL1		= CommonConst.NAM_EMERGENCY + CommonConst.NAM_PHONE_NUMBER + CommonConst.NAM_AREA_NUMBER			;
	public static final String NAM_EMERGENCY_TEL2		= CommonConst.NAM_EMERGENCY + CommonConst.NAM_PHONE_NUMBER + CommonConst.NAM_LOCAL_AREA_NUMBER		;
	public static final String NAM_EMERGENCY_TEL3		= CommonConst.NAM_EMERGENCY + CommonConst.NAM_PHONE_NUMBER + CommonConst.NAM_SUBSCRIBER_NUMBER		;
	public static final String NAM_EMERGENCY_PHONE	= CommonConst.NAM_EMERGENCY + CommonConst.NAM_CELLPHONE_NUMBER										;
	public static final String NAM_EMERGENCY_PHONE1	= CommonConst.NAM_EMERGENCY + CommonConst.NAM_CELLPHONE_NUMBER + CommonConst.NAM_AREA_NUMBER		;
	public static final String NAM_EMERGENCY_PHONE2	= CommonConst.NAM_EMERGENCY + CommonConst.NAM_CELLPHONE_NUMBER + CommonConst.NAM_LOCAL_AREA_NUMBER	;
	public static final String NAM_EMERGENCY_PHONE3	= CommonConst.NAM_EMERGENCY + CommonConst.NAM_CELLPHONE_NUMBER + CommonConst.NAM_SUBSCRIBER_NUMBER	;

	public static final int		LEN_K_CODE			= CommonConst.LEN_K_CODE										;
	public static final int		LEN_NAME			= CommonConst.LEN_K_NAME										;
	public static final int		LEN_POSTAL_CODE1	= 3																;
	public static final int		LEN_POSTAL_CODE2	= 4																;
	public static final int		LEN_PHONE_NUMBER	= 4																;
	public static final int		LEN_ADDRESS			= 50															;
	public static final int		LEN_LICENSE			= 230															;
	public static final int		LEN_RECAPITULATION	= 230															;
	public static final int		LEN_HEALTH			= 230															;
	public static final String 	REG_DELETE  		= CommonConst.REG_DELETE										;

	// ҏW[htO
	public static final int MODE_INSERT		= 0;
	public static final int MODE_UPDATE		= 1;

	// ҏW[h
	public static final String NAM_MODE_INSERT	 = CommonConst.NAM_HU_MODE_INSERT;
	public static final String NAM_MODE_UPDATE	 = CommonConst.NAM_HU_MODE_UPDATE;

	// tB[h
	private String eMCode				;
	private String pltGender    		;
	private String pltBirthYear    		;
	private String pltBirthMonth   		;
	private String pltBirthDay    		;
	private String txtPostalCode1    	;
	private String txtPostalCode2    	;
	private String pltPrefecture    	;
	private String txtAdress1    		;
	private String txtAdress2    		;
	private String txtAdress3    		;
	private String txtEmName    		;
	private String txtEmTel1    		;
	private String txtEmTel2    		;
	private String txtEmTel3    		;
	private String txtEmPhone1    		;
	private String txtEmPhone2    		;
	private String txtEmPhone3    		;
	private String txtEmPostalCode1    	;
	private String txtEmPostalCode2    	;
	private String pltEmPrefecture    	;
	private String txtEmAdress1    		;
	private String txtEmAdress2    		;
	private String txtEmAdress3    		;
	private String txtTel1    			;
	private String txtTel2    			;
	private String txtTel3    			;
	private String txtFax1    			;
	private String txtFax2    			;
	private String txtFax3    			;
	private String txtPhone1    		;
	private String txtPhone2    		;
	private String txtPhone3    		;
	private String pltBloodType    		;
	private String txtLicense    		;
	private String txtRecapitulation 	;
	private String txtHealth    		;
	private String pltSalaryKb    		;
	private String pltTaxKb    			;
	private String pltUnionKb    		;
	private String pltPartKb    		;
	private String pltPaymentKb    		;

	// tB[h(\̂)
	private String lblGender    		;
	private String lblBirthYear    		;
	private String lblBirthMonth    	;
	private String lblBirthDay    		;
	private String lblPostalCode1   	;
	private String lblPostalCode2    	;
	private String lblPrefecture    	;
	private String lblAdress1    		;
	private String lblAdress2    		;
	private String lblAdress3    		;
	private String lblEmName    		;
	private String lblEmTel    			;
	private String lblEmPhone    		;
	private String lblEmPostalCode1    	;
	private String lblEmPostalCode2    	;
	private String lblEmPrefecture    	;
	private String lblEmAdress1    		;
	private String lblEmAdress2    		;
	private String lblEmAdress3    		;
	private String lblTel    			;
	private String lblFax    			;
	private String lblPhone    			;
	private String lblBloodType    		;
	private String lblLicense    		;
	private String lblRecapitulation 	;
	private String lblHealth    		;
	private String lblSalaryKb    		;
	private String lblTaxKb    			;
	private String lblUnionKb    		;
	private String lblPartKb    		;
	private String lblPaymentKb    		;

	// tB[h(ύXmFp)
	private String hidGender    		;
	private String hidBirthYear    		;
	private String hidBirthMonth  		;
	private String hidBirthDay    		;
	private String hidPostalCode1    	;
	private String hidPostalCode2    	;
	private String hidPrefecture    	;
	private String hidAdress1    		;
	private String hidAdress2    		;
	private String hidAdress3    		;
	private String hidEmName    		;
	private String hidEmTel1    		;
	private String hidEmTel2    		;
	private String hidEmTel3    		;
	private String hidEmPhone1    		;
	private String hidEmPhone2    		;
	private String hidEmPhone3    		;
	private String hidEmPostalCode1    	;
	private String hidEmPostalCode2    	;
	private String hidEmPrefecture    	;
	private String hidEmAdress1    		;
	private String hidEmAdress2    		;
	private String hidEmAdress3    		;
	private String hidTel1    			;
	private String hidTel2    			;
	private String hidTel3    			;
	private String hidFax1    			;
	private String hidFax2    			;
	private String hidFax3    			;
	private String hidPhone1    		;
	private String hidPhone2    		;
	private String hidPhone3   			;
	private String hidBloodType    		;
	private String hidLicense    		;
	private String hidRecapitulation 	;
	private String hidHealth    		;
	private String hidSalaryKb    		;
	private String hidTaxKb    			;
	private String hidUnionKb    		;
	private String hidPartKb    		;
	private String hidPaymentKb    		;

	// ҏW[h(0FVKo^A1FXV)
	private int mode;

	// v_EXg
	public String[][] aryPltGender;
	public String[][] aryPltBirthYear;
	public String[][] aryPltBirthMonth;
	public String[][] aryPltBirthDay;
	public String[][] aryPltPrefecture;
	public String[][] aryPltBloodType;
	public String[][] aryPltSalaryKb;
	public String[][] aryPltTaxKb;
	public String[][] aryPltUnionKb;
	public String[][] aryPltPartKb;
	public String[][] aryPltPaymentKb;

	/**
	 * RXgN^
	 */
	public HumanPersonalCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		pltGender  			= request.getParameter(PRM_PLT_GENDER);
		pltBirthYear   		= request.getParameter(PRM_PLT_BIRTH_YEAR);
		pltBirthMonth  		= request.getParameter(PRM_PLT_BIRTH_MONTH);
		pltBirthDay    		= request.getParameter(PRM_PLT_BIRTH_DAY);
		txtPostalCode1     	= request.getParameter(PRM_TXT_POSTAL_CODE1 );
		txtPostalCode2     	= request.getParameter(PRM_TXT_POSTAL_CODE2 );
		pltPrefecture      	= request.getParameter(PRM_PLT_PREFECTURE );
		txtAdress1         	= request.getParameter(PRM_TXT_ADRESS1 );
		txtAdress2         	= request.getParameter(PRM_TXT_ADRESS2 );
		txtAdress3         	= request.getParameter(PRM_TXT_ADRESS3 );
		txtEmName         	= request.getParameter(PRM_TXT_EMERGENCY_NAME );
		txtEmTel1      		= request.getParameter(PRM_TXT_EMERGENCY_TEL1);
		txtEmTel2      		= request.getParameter(PRM_TXT_EMERGENCY_TEL2);
		txtEmTel3      		= request.getParameter(PRM_TXT_EMERGENCY_TEL3);
		txtEmPhone1         = request.getParameter(PRM_TXT_EMERGENCY_PHONE1 );
		txtEmPhone2         = request.getParameter(PRM_TXT_EMERGENCY_PHONE2 );
		txtEmPhone3         = request.getParameter(PRM_TXT_EMERGENCY_PHONE3 );
		txtEmPostalCode1    = request.getParameter(PRM_TXT_EMERGENCY_POSTAL_CODE1 );
		txtEmPostalCode2    = request.getParameter(PRM_TXT_EMERGENCY_POSTAL_CODE2 );
		pltEmPrefecture     = request.getParameter(PRM_PLT_EMERGENCY_PREFECTURE );
		txtEmAdress1        = request.getParameter(PRM_TXT_EMERGENCY_ADRESS1 );
		txtEmAdress2        = request.getParameter(PRM_TXT_EMERGENCY_ADRESS2 );
		txtEmAdress3        = request.getParameter(PRM_TXT_EMERGENCY_ADRESS3 );
		txtTel1         	= request.getParameter(PRM_TXT_TEL1 );
		txtTel2         	= request.getParameter(PRM_TXT_TEL2 );
		txtTel3         	= request.getParameter(PRM_TXT_TEL3 );
		txtFax1      		= request.getParameter(PRM_TXT_FAX1 );
		txtFax2      		= request.getParameter(PRM_TXT_FAX2 );
		txtFax3      		= request.getParameter(PRM_TXT_FAX3 );
		txtPhone1         	= request.getParameter(PRM_TXT_PHONE1 );
		txtPhone2         	= request.getParameter(PRM_TXT_PHONE2 );
		txtPhone3         	= request.getParameter(PRM_TXT_PHONE3 );
		pltBloodType        = request.getParameter(PRM_PLT_BLOOD_TYPE);
		txtLicense         	= request.getParameter(PRM_TXT_LICENSE );
		txtRecapitulation   = request.getParameter(PRM_TXT_RECAPITULATION );
		txtHealth      		= request.getParameter(PRM_TXT_HEALTH );
		pltSalaryKb         = request.getParameter(PRM_PLT_SALARY_KB);
		pltTaxKb         	= request.getParameter(PRM_PLT_TAX_KB);
		pltUnionKb         	= request.getParameter(PRM_PLT_UNION_KB);
		pltPartKb         	= request.getParameter(PRM_PLT_PART_KB);
		pltPaymentKb      	= request.getParameter(PRM_PLT_PAYMENT_KB);

		String EMCODE = request.getParameter(PRM_TXT_EMERGENCY_CODE);
		if (EMCODE == null) {
			eMCode = "0";
		} else {
			eMCode = EMCODE;
		}
	}

	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 * @throws MospException 
	 */
	public void setFields(MKihonDto dto) throws MospException {
		// f[^̐ݒ
		pltSalaryKb = dto.getKyKubun();
		pltTaxKb 	= dto.getTxKubun();
		pltUnionKb 	= dto.getKmKubun();
		pltPartKb 	= dto.getPtKubun();
		pltPaymentKb= dto.getShKubun();	

		hidSalaryKb = dto.getKyKubun();
		hidTaxKb 	= dto.getTxKubun();
		hidUnionKb 	= dto.getKmKubun();
		hidPartKb 	= dto.getPtKubun();
		hidPaymentKb= dto.getShKubun();	

		lblKName 	= dto.getSimei();
		lblKKana 	= dto.getFurigana();
		lblSalaryKb = getCodeName(dto.getKyKubun(), aryPltSalaryKb);
		lblTaxKb 	= getCodeName(dto.getTxKubun(), aryPltTaxKb);
		lblUnionKb 	= getCodeName(dto.getKmKubun(), aryPltUnionKb);
		lblPartKb 	= getCodeName(dto.getPtKubun(), aryPltPartKb);
		lblPaymentKb= getCodeName(dto.getShKubun(), aryPltPaymentKb);	
	}

	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 * @throws MospException 
	 */
	public void setFields(MKojinDto dto) throws MospException {
		// f[^̐ݒ
		pltGender          	= dto.getSeibetu();	
		pltBirthYear        = util.convIntegerDateToArray(dto.getSeinenbi())[0];
		pltBirthMonth       = util.convIntegerDateToArray(dto.getSeinenbi())[1];
		pltBirthDay         = util.convIntegerDateToArray(dto.getSeinenbi())[2];
		txtPostalCode1      = util.divideYubinCodeForward(dto.getYubinban());
		txtPostalCode2      = util.divideYubinCodeBackward(dto.getYubinban());
		pltPrefecture       = String.valueOf(dto.getPrefectures());	
		txtAdress1          = dto.getJyuusyo1();
		txtAdress2          = dto.getJyuusyo2();
		txtAdress3          = dto.getJyuusyo3();
		txtTel1            	= util.divideByHyphen(dto.getTel(), 2)[0];
		txtTel2            	= util.divideByHyphen(dto.getTel(), 2)[1];
		txtTel3            	= util.divideByHyphen(dto.getTel(), 2)[2];
		txtFax1            	= util.divideByHyphen(dto.getFax(), 2)[0];
		txtFax2            	= util.divideByHyphen(dto.getFax(), 2)[1];
		txtFax3            	= util.divideByHyphen(dto.getFax(), 2)[2];
		txtPhone1        	= util.divideByHyphen(dto.getKeitai(), 2)[0];
		txtPhone2        	= util.divideByHyphen(dto.getKeitai(), 2)[1];
		txtPhone3        	= util.divideByHyphen(dto.getKeitai(), 2)[2];
		pltBloodType        = dto.getKetueki();
		txtLicense          = dto.getSikaku();
		txtRecapitulation   = dto.getTekiyou();
		txtHealth           = dto.getKenkou();

		hidGender          	= dto.getSeibetu();	
		hidBirthYear        = util.convIntegerDateToArray(dto.getSeinenbi())[0];
		hidBirthMonth       = util.convIntegerDateToArray(dto.getSeinenbi())[1];
		hidBirthDay         = util.convIntegerDateToArray(dto.getSeinenbi())[2];
		hidPostalCode1      = util.divideYubinCodeForward(dto.getYubinban());
		hidPostalCode2      = util.divideYubinCodeBackward(dto.getYubinban());
		hidPrefecture       = String.valueOf(dto.getPrefectures());	
		hidAdress1          = dto.getJyuusyo1();
		hidAdress2          = dto.getJyuusyo2();
		hidAdress3          = dto.getJyuusyo3();
		hidTel1            	= util.divideByHyphen(dto.getTel(), 2)[0];
		hidTel2           	= util.divideByHyphen(dto.getTel(), 2)[1];
		hidTel3            	= util.divideByHyphen(dto.getTel(), 2)[2];
		hidFax1            	= util.divideByHyphen(dto.getFax(), 2)[0];
		hidFax2            	= util.divideByHyphen(dto.getFax(), 2)[1];
		hidFax3            	= util.divideByHyphen(dto.getFax(), 2)[2];
		hidPhone1        	= util.divideByHyphen(dto.getKeitai(), 2)[0];
		hidPhone2        	= util.divideByHyphen(dto.getKeitai(), 2)[1];
		hidPhone3        	= util.divideByHyphen(dto.getKeitai(), 2)[2];
		hidBloodType        = dto.getKetueki();
		hidLicense          = dto.getSikaku();
		hidRecapitulation   = dto.getTekiyou();
		hidHealth           = dto.getKenkou();

		lblGender          	= getCodeName(dto.getSeibetu(), aryPltGender);	
		lblBirthYear        = util.convIntegerDateToArray(dto.getSeinenbi())[0];
		lblBirthMonth       = util.convIntegerDateToArray(dto.getSeinenbi())[1];
		lblBirthDay         = util.convIntegerDateToArray(dto.getSeinenbi())[2];
		lblPostalCode1      = util.divideYubinCodeForward(dto.getYubinban());
		lblPostalCode2      = util.divideYubinCodeBackward(dto.getYubinban());
		lblPrefecture       = getCodeName(String.valueOf(dto.getPrefectures()),aryPltPrefecture);	
		lblAdress1          = dto.getJyuusyo1();
		lblAdress2          = dto.getJyuusyo2();
		lblAdress3          = dto.getJyuusyo3();
		lblTel            	= txtTel1 + "-" + txtTel2 + "-" + txtTel3;
		lblFax            	= txtFax1 + "-" + txtFax2 + "-" + txtFax3;
		lblPhone        	= txtPhone1 + "-" + txtPhone2 + "-" + txtPhone3;
		lblBloodType        = getCodeName(dto.getKetueki(), aryPltBloodType);
		lblLicense          = dto.getSikaku();
		lblRecapitulation   = dto.getTekiyou();
		lblHealth           = dto.getKenkou();
	}

	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 * @throws MospException 
	 */
	public void setFields(MEmergencyDto dto) throws MospException {
		// f[^̐ݒ
		txtEmName          	= dto.getName();
		txtEmTel1       	= util.divideByHyphen(dto.getPhone(), 2)[0];
		txtEmTel2       	= util.divideByHyphen(dto.getPhone(), 2)[1];
		txtEmTel3       	= util.divideByHyphen(dto.getPhone(), 2)[2];
		txtEmPhone1         = util.divideByHyphen(dto.getCell(), 2)[0];
		txtEmPhone2         = util.divideByHyphen(dto.getCell(), 2)[1];
		txtEmPhone3         = util.divideByHyphen(dto.getCell(), 2)[2];
		txtEmPostalCode1    = util.divideYubinCodeForward(dto.getPostalCode());
		txtEmPostalCode2    = util.divideYubinCodeBackward(dto.getPostalCode());
		pltEmPrefecture     = String.valueOf(dto.getPrefectures());
		txtEmAdress1        = dto.getJyuusyo1();
		txtEmAdress2        = dto.getJyuusyo2();
		txtEmAdress3        = dto.getJyuusyo3();

		hidEmName          	= dto.getName();
		hidEmTel1       	= util.divideByHyphen(dto.getPhone(), 2)[0];
		hidEmTel2       	= util.divideByHyphen(dto.getPhone(), 2)[1];
		hidEmTel3       	= util.divideByHyphen(dto.getPhone(), 2)[2];
		hidEmPhone1         = util.divideByHyphen(dto.getCell(), 2)[0];
		hidEmPhone2         = util.divideByHyphen(dto.getCell(), 2)[1];
		hidEmPhone3         = util.divideByHyphen(dto.getCell(), 2)[2];
		hidEmPostalCode1    = util.divideYubinCodeForward(dto.getPostalCode());
		hidEmPostalCode2    = util.divideYubinCodeBackward(dto.getPostalCode());
		hidEmPrefecture     = String.valueOf(dto.getPrefectures());
		hidEmAdress1        = dto.getJyuusyo1();
		hidEmAdress2        = dto.getJyuusyo2();
		hidEmAdress3        = dto.getJyuusyo3();

		lblEmName          	= dto.getName();
		lblEmTel       		= txtEmTel1 + "-" + txtEmTel2 + "-" + txtEmTel3;
		lblEmPhone			= txtEmPhone1 + "-" + txtEmPhone2 + "-" + txtEmPhone3;
		lblEmPostalCode1    = util.divideYubinCodeForward(dto.getPostalCode());
		lblEmPostalCode2    = util.divideYubinCodeBackward(dto.getPostalCode());
		lblEmPrefecture     = getCodeName(pltEmPrefecture, aryPltPrefecture);
		lblEmAdress1        = dto.getJyuusyo1();
		lblEmAdress2        = dto.getJyuusyo2();
		lblEmAdress3        = dto.getJyuusyo3();
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto	ΏDTO
	 */
	public void setDtoFields(MKihonDto dto) {
		dto.setKCode(txtChangeKCode);
		dto.setKyKubun(pltSalaryKb);
		dto.setTxKubun(pltTaxKb);
		dto.setKmKubun(pltUnionKb);
		dto.setPtKubun(pltPartKb);
		dto.setShKubun(pltPaymentKb);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param  dto	ΏDTO
	 */
	public void setDtoFields(MKojinDto dto) {
		dto.setSeibetu(pltGender);
		dto.setSeinenbi(util.convStringDateToInteger(pltBirthYear, pltBirthMonth, pltBirthDay));
		dto.setYubinban(txtPostalCode1 + CommonConst.NAM_POSTAL_SEPARATOR + txtPostalCode2);
		dto.setPrefectures(Integer.parseInt(pltPrefecture));
		dto.setJyuusyo1(txtAdress1);
		dto.setJyuusyo2(txtAdress2);
		dto.setJyuusyo3(txtAdress3);
		dto.setTel(txtTel1 + "-" + txtTel2 + "-" + txtTel3);
		dto.setFax(txtFax1 + "-" + txtFax2 + "-" + txtFax3);
		dto.setKeitai(txtPhone1 + "-" + txtPhone2 + "-" + txtPhone3);
		dto.setKetueki(pltBloodType);
		dto.setSikaku(txtLicense);
		dto.setTekiyou(txtRecapitulation);
		dto.setKenkou(txtHealth);		
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param  dto	ΏDTO
	 */
	public void setDtoFields(MEmergencyDto dto) {
		dto.setKCode(txtChangeKCode);
		dto.setName(txtEmName);
		dto.setPhone(txtEmTel1 + "-" + txtEmTel2 + "-" + txtEmTel3);
		dto.setCell(txtEmPhone1 + "-" + txtEmPhone2 + "-" + txtEmPhone3);
		dto.setPostalCode(txtEmPostalCode1 + CommonConst.NAM_POSTAL_SEPARATOR + txtEmPostalCode2);
		dto.setPrefectures(Integer.parseInt(pltEmPrefecture));
		dto.setJyuusyo1(txtEmAdress1);
		dto.setJyuusyo2(txtEmAdress2);
		dto.setJyuusyo3(txtEmAdress3);
	}

	/**
	 * tB[h
	 */
	@Override
	public void initFields() {
		super.initFields();
		pltGender           = "";
		pltBirthYear        = "";
		pltBirthMonth       = "";
		pltBirthDay   		= "";
		txtPostalCode1      = "";
		txtPostalCode2      = "";
		pltPrefecture       = "";
		txtAdress1    		= "";
		txtAdress2         	= "";
		txtAdress3        	= "";
		txtEmName          	= "";
		txtEmTel1       	= "";
		txtEmTel2       	= "";
		txtEmTel3       	= "";
		txtEmPhone1      	= "";
		txtEmPhone2      	= "";
		txtEmPhone3      	= "";
		txtEmPostalCode1    = "";
		txtEmPostalCode2    = "";
		pltEmPrefecture     = "";
		txtEmAdress1    	= "";
		txtEmAdress2        = "";
		txtEmAdress3        = "";
		txtTel1             = "";
		txtTel2             = "";
		txtTel3             = "";
		txtFax1             = "";
		txtFax2             = "";
		txtFax3             = "";
		lblKKana            = "";
		txtPhone1    		= "";
		txtPhone2    		= "";
		txtPhone3    		= "";
		pltBloodType        = "";
		txtLicense          = "";
		txtRecapitulation   = "";
		txtHealth         	= "";
		pltSalaryKb       	= "";
		pltTaxKb    		= "";
		pltUnionKb          = "";
		pltPartKb           = "";
		pltPaymentKb    	= "";

		hidGender           = "";
		hidBirthYear        = "";
		hidBirthMonth       = "";
		hidBirthDay   		= "";
		hidPostalCode1      = "";
		hidPostalCode2      = "";
		hidPrefecture       = "";
		hidAdress1    		= "";
		hidAdress2         	= "";
		hidAdress3        	= "";
		hidEmName          	= "";
		hidEmTel1       	= "";
		hidEmTel2       	= "";
		hidEmTel3       	= "";
		hidEmPhone1      	= "";
		hidEmPhone2      	= "";
		hidEmPhone3      	= "";
		hidEmPostalCode1    = "";
		hidEmPostalCode2    = "";
		hidEmPrefecture     = "";
		hidEmAdress1    	= "";
		hidEmAdress2        = "";
		hidEmAdress3        = "";
		hidTel1             = "";
		hidTel2             = "";
		hidTel3             = "";
		hidFax1             = "";
		hidFax2             = "";
		hidFax3             = "";
		lblKKana            = "";
		hidPhone1    		= "";
		hidPhone2    		= "";
		hidPhone3    		= "";
		hidBloodType        = "";
		hidLicense          = "";
		hidRecapitulation   = "";
		hidHealth         	= "";
		hidSalaryKb       	= "";
		hidTaxKb    		= "";
		hidUnionKb          = "";
		hidPartKb           = "";
		hidPaymentKb    	= "";

		lblGender           = "";
		lblBirthYear        = "";
		lblBirthMonth       = "";
		lblBirthDay   		= "";
		lblPostalCode1      = "";
		lblPostalCode2      = "";
		lblPrefecture       = "";
		lblAdress1    		= "";
		lblAdress2         	= "";
		lblAdress3        	= "";
		lblEmName          	= "";
		lblEmTel       		= "";
		lblEmPhone      	= "";
		lblEmPostalCode1    = "";
		lblEmPostalCode2    = "";
		lblEmPrefecture     = "";
		lblEmAdress1    	= "";
		lblEmAdress2        = "";
		lblEmAdress3        = "";
		lblTel 				= "";
		lblFax 				= "";
		lblKKana            = "";
		lblPhone    		= "";
		lblBloodType        = "";
		lblLicense          = "";
		lblRecapitulation   = "";
		lblHealth         	= "";
		lblSalaryKb       	= "";
		lblTaxKb    		= "";
		lblUnionKb          = "";
		lblPartKb           = "";
		lblPaymentKb    	= "";
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtChangeKCode, NAM_K_CODE	, PRM_TXT_CHANGE_K_CODE);
		// mF
		checkLength(txtChangeKCode	, LEN_K_CODE	, NAM_K_CODE	, PRM_TXT_CHANGE_K_CODE);
		//lmF
		checkNumber(txtTel1		, NAM_TEL1				, PRM_TXT_TEL1				);
		checkNumber(txtTel2		, NAM_TEL2				, PRM_TXT_TEL2				);
		checkNumber(txtTel3		, NAM_TEL3				, PRM_TXT_TEL3				);
		checkNumber(txtFax1		, NAM_FAX1				, PRM_TXT_FAX1				);
		checkNumber(txtFax2		, NAM_FAX2				, PRM_TXT_FAX2				);
		checkNumber(txtFax3		, NAM_FAX3				, PRM_TXT_FAX3				);
		checkNumber(txtPhone1	, NAM_PHONE1			, PRM_TXT_PHONE1			);
		checkNumber(txtPhone2	, NAM_PHONE2			, PRM_TXT_PHONE2			);
		checkNumber(txtPhone3	, NAM_PHONE3			, PRM_TXT_PHONE3			);
		checkNumber(txtEmTel1	, NAM_EMERGENCY_TEL1	, PRM_TXT_EMERGENCY_TEL1	);
		checkNumber(txtEmTel2	, NAM_EMERGENCY_TEL2	, PRM_TXT_EMERGENCY_TEL2	);
		checkNumber(txtEmTel3	, NAM_EMERGENCY_TEL3	, PRM_TXT_EMERGENCY_TEL3	);
		checkNumber(txtEmPhone1	, NAM_EMERGENCY_PHONE1	, PRM_TXT_EMERGENCY_PHONE1	);
		checkNumber(txtEmPhone2	, NAM_EMERGENCY_PHONE2	, PRM_TXT_EMERGENCY_PHONE2	);
		checkNumber(txtEmPhone3	, NAM_EMERGENCY_PHONE3	, PRM_TXT_EMERGENCY_PHONE3	);
		// tmF
		checkDate(getIntParam(pltBirthYear), getIntParam(pltBirthMonth), getIntParam(pltBirthDay),
				NAM_BIRTH_DATE, PRM_PLT_BIRTH_YEAR + PRM_PLT_BIRTH_MONTH + PRM_PLT_BIRTH_DAY);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getPltGender 				() { return pltGender 				; }
	public String getPltBirthYear    		() { return pltBirthYear    		; }
	public String getPltBirthMonth    		() { return pltBirthMonth    		; }
	public String getPltBirthDay    		() { return pltBirthDay    			; }
	public String getTxtPostalCode    		() { return txtPostalCode1         	; }
	public String getTxtPostalCode2    		() { return txtPostalCode2         	; }
	public String getPltPrefecture        	() { return pltPrefecture          	; }
	public String getTxtAdress1    			() { return txtAdress1    			; }
	public String getTxtAdress2    			() { return txtAdress2    			; }
	public String getTxtAdress3    			() { return txtAdress3    			; }
	public String getEMCode 				() { return eMCode 					; }	//A
	public String getTxtEName    			() { return txtEmName    			; }
	public String getTxtETel1    			() { return txtEmTel1    			; }
	public String getTxtETel2    			() { return txtEmTel2    			; }
	public String getTxtETel3    			() { return txtEmTel3    			; }
	public String getTxtEPhone1    			() { return txtEmPhone1    			; }
	public String getTxtEPhone2    			() { return txtEmPhone2    			; }
	public String getTxtEPhone3    			() { return txtEmPhone3    			; }
	public String getTxtEmPostalCode1    	() { return txtEmPostalCode1       	; }
	public String getTxtEmPostalCode2    	() { return txtEmPostalCode2       	; }
	public String getPltEmPrefecture       	() { return pltEmPrefecture        	; }
	public String getTxtEmAdress1    		() { return txtEmAdress1    		; }
	public String getTxtEmAdress2    		() { return txtEmAdress2    		; }
	public String getTxtEmAdress3    		() { return txtEmAdress3    		; }
	public String getTxtTel1    			() { return txtTel1    				; }
	public String getTxtTel2    			() { return txtTel2    				; }
	public String getTxtTel3    			() { return txtTel3    				; }
	public String getTxtFax1    			() { return txtFax1    				; }
	public String getTxtFax2    			() { return txtFax2    				; }
	public String getTxtFax3    			() { return txtFax3    				; }
	public String getTxtPhone1    			() { return txtPhone1    			; }
	public String getTxtPhone2    			() { return txtPhone2    			; }
	public String getTxtPhone3    			() { return txtPhone3   			; }
	public String getPltBloodType    		() { return pltBloodType    		; }
	public String gettxtLicense    			() { return txtLicense				; }
	public String gettxtRecapitulation    	() { return txtRecapitulation    	; }
	public String gettxtHealth    			() { return txtHealth    			; }
	public String getPltSalaryKb    		() { return pltSalaryKb    			; }
	public String getPltTaxKb    			() { return pltTaxKb    			; }
	public String getPltUnionKb    			() { return pltUnionKb    			; }
	public String getPltPartKb    			() { return pltPartKb    			; }
	public String getPltPaymentKb    		() { return pltPaymentKb    		; }	

	public String getEscPltGender 				() { return escapeHTML(pltGender 				); }
	public String getEscPltBirthYear    		() { return escapeHTML(pltBirthYear    			); }
	public String getEscPltBirthMonth    		() { return escapeHTML(pltBirthMonth    		); }
	public String getEscPltBirthDay    			() { return escapeHTML(pltBirthDay    			); }
	public String getEscTxtPostalCode1    		() { return escapeHTML(txtPostalCode1         	); }
	public String getEscTxtPostalCode2    		() { return escapeHTML(txtPostalCode2         	); }
	public String getEscPltPrefecture        	() { return escapeHTML(pltPrefecture          	); }
	public String getEscTxtAdress1    			() { return escapeHTML(txtAdress1    			); }
	public String getEscTxtAdress2    			() { return escapeHTML(txtAdress2    			); }
	public String getEscTxtAdress3    			() { return escapeHTML(txtAdress3    			); }
	public String getEscTxtEmName    			() { return escapeHTML(txtEmName    			); }
	public String getEscTxtEmTel1    			() { return escapeHTML(txtEmTel1    			); }
	public String getEscTxtEmTel2    			() { return escapeHTML(txtEmTel2    			); }
	public String getEscTxtEmTel3    			() { return escapeHTML(txtEmTel3   				); }
	public String getEscTxtEmPhone1    			() { return escapeHTML(txtEmPhone1    			); }
	public String getEscTxtEmPhone2    			() { return escapeHTML(txtEmPhone2    			); }
	public String getEscTxtEmPhone3    			() { return escapeHTML(txtEmPhone3    			); }
	public String getEscTxtEmPostalCode1   		() { return escapeHTML(txtEmPostalCode1        	); }
	public String getEscTxtEmPostalCode2    	() { return escapeHTML(txtEmPostalCode2       	); }
	public String getEscPltEmPrefecture       	() { return escapeHTML(pltEmPrefecture        	); }
	public String getEscTxtEmAdress1    		() { return escapeHTML(txtEmAdress1    			); }
	public String getEscTxtEmAdress2    		() { return escapeHTML(txtEmAdress2    			); }
	public String getEscTxtEmAdress3    		() { return escapeHTML(txtEmAdress3    			); }
	public String getEscTxtTel1    				() { return escapeHTML(txtTel1    				); }
	public String getEscTxtTel2    				() { return escapeHTML(txtTel2    				); }
	public String getEscTxtTel3    				() { return escapeHTML(txtTel3    				); }
	public String getEscTxtFax1    				() { return escapeHTML(txtFax1    				); }
	public String getEscTxtFax2    				() { return escapeHTML(txtFax2    				); }
	public String getEscTxtFax3    				() { return escapeHTML(txtFax3    				); }
	public String getEscTxtPhone1    			() { return escapeHTML(txtPhone1    			); }
	public String getEscTxtPhone2    			() { return escapeHTML(txtPhone2    			); }
	public String getEscTxtPhone3    			() { return escapeHTML(txtPhone3    			); }
	public String getEscPltBloodType    		() { return escapeHTML(pltBloodType    			); }
	public String getEscTxtLicense    			() { return escapeHTML(txtLicense				); }
	public String getEscTxtRecapitulation    	() { return escapeHTML(txtRecapitulation    	); }
	public String getEscTxtHealth    			() { return escapeHTML(txtHealth    			); }
	public String getEscPltSalaryKb    			() { return escapeHTML(pltSalaryKb    			); }
	public String getEscPltTaxKb    			() { return escapeHTML(pltTaxKb    				); }
	public String getEscPltUnionKb    			() { return escapeHTML(pltUnionKb    			); }
	public String getEscPltPartKb    			() { return escapeHTML(pltPartKb    			); }
	public String getEscPltPaymentKb    		() { return escapeHTML(pltPaymentKb    			); }

	public String getEscHidGender 				() { return escapeHTML(hidGender 				); }
	public String getEscHidBirthYear    		() { return escapeHTML(hidBirthYear    			); }
	public String getEscHidBirthMonth    		() { return escapeHTML(hidBirthMonth    		); }
	public String getEscHidBirthDay    			() { return escapeHTML(hidBirthDay    			); }
	public String getEscHidPostalCode    		() { return escapeHTML(hidPostalCode1         	); }
	public String getEscHidPostalCode2    		() { return escapeHTML(hidPostalCode2         	); }
	public String getEscHidPrefecture        	() { return escapeHTML(hidPrefecture          	); }
	public String getEscHidAdress1    			() { return escapeHTML(hidAdress1    			); }
	public String getEscHidAdress2    			() { return escapeHTML(hidAdress2    			); }
	public String getEscHidAdress3    			() { return escapeHTML(hidAdress3    			); }
	public String getEscHidEmName    			() { return escapeHTML(hidEmName    			); }
	public String getEscHidEmTel1    			() { return escapeHTML(hidEmTel1    			); }
	public String getEscHidEmTel2    			() { return escapeHTML(hidEmTel2    			); }
	public String getEscHidEmTel3    			() { return escapeHTML(hidEmTel3    			); }
	public String getEscHidEmPhone1    			() { return escapeHTML(hidEmPhone1    			); }
	public String getEscHidEmPhone2    			() { return escapeHTML(hidEmPhone2    			); }
	public String getEscHidEmPhone3    			() { return escapeHTML(hidEmPhone3    			); }
	public String getEscHidEmPostalCode1   		() { return escapeHTML(hidEmPostalCode1        	); }
	public String getEscHidEmPostalCode2    	() { return escapeHTML(hidEmPostalCode2       	); }
	public String getEscHidEmPrefecture       	() { return escapeHTML(hidEmPrefecture        	); }
	public String getEscHidEmAdress1    		() { return escapeHTML(hidEmAdress1    			); }
	public String getEscHidEmAdress2    		() { return escapeHTML(hidEmAdress2    			); }
	public String getEscHidEmAdress3    		() { return escapeHTML(hidEmAdress3    			); }
	public String getEscHidTel1    				() { return escapeHTML(hidTel1    				); }
	public String getEscHidTel2    				() { return escapeHTML(hidTel2    				); }
	public String getEscHidTel3    				() { return escapeHTML(hidTel3    				); }
	public String getEscHidFax1    				() { return escapeHTML(hidFax1    				); }
	public String getEscHidFax2    				() { return escapeHTML(hidFax2    				); }
	public String getEscHidFax3    				() { return escapeHTML(hidFax3    				); }
	public String getEscHidPhone1    			() { return escapeHTML(hidPhone1    			); }
	public String getEscHidPhone2    			() { return escapeHTML(hidPhone2    			); }
	public String getEscHidPhone3    			() { return escapeHTML(hidPhone3    			); }
	public String getEscHidBloodType    		() { return escapeHTML(hidBloodType    			); }
	public String getEscHidLicense    			() { return escapeHTML(hidLicense				); }
	public String getEscHidRecapitulation    	() { return escapeHTML(hidRecapitulation    	); }
	public String getEscHidHealth    			() { return escapeHTML(hidHealth    			); }
	public String getEscHidSalaryKb    			() { return escapeHTML(hidSalaryKb    			); }
	public String getEscHidTaxKb    			() { return escapeHTML(hidTaxKb    				); }
	public String getEscHidUnionKb    			() { return escapeHTML(hidUnionKb    			); }
	public String getEscHidPartKb    			() { return escapeHTML(hidPartKb    			); }
	public String getEscHidPaymentKb    		() { return escapeHTML(hidPaymentKb    			); }

	public String getEscLblGender 				() { return escapeHTML(lblGender 					); }
	public String getEscLblBirthYear    		() { return escapeHTML(lblBirthYear    				); }
	public String getEscLblBirthMonth    		() { return escapeHTML(lblBirthMonth   				); }
	public String getEscLblBirthDay    			() { return escapeHTML(lblBirthDay    				); }
	public String getEscLblPostalCode1    		() { return escapeHTML(lblPostalCode1         		); }
	public String getEscLblPostalCode2    		() { return escapeHTML(lblPostalCode2         		); }
	public String getEscLblPrefecture        	() { return escapeHTML(lblPrefecture          		); }
	public String getEscLblAdress1    			() { return escapeHTML(lblAdress1    				); }
	public String getEscLblAdress2    			() { return escapeHTML(lblAdress2    				); }
	public String getEscLblAdress3    			() { return escapeHTML(lblAdress3    				); }
	public String getEscLblEmName    			() { return escapeHTML(lblEmName    				); }
	public String getEscLblEmTel    			() { return escapeHTML(lblEmTel    					); }
	public String getEscLblEmPhone    			() { return escapeHTML(lblEmPhone    				); }
	public String getEscLblEmPostalCode1    	() { return escapeHTML(lblEmPostalCode1        		); }
	public String getEscLblEmPostalCode2    	() { return escapeHTML(lblEmPostalCode2       		); }
	public String getEscLblEmPrefecture       	() { return escapeHTML(lblEmPrefecture        		); }
	public String getEscLblEmAdress1    		() { return escapeHTML(lblEmAdress1    				); }
	public String getEscLblEmAdress2    		() { return escapeHTML(lblEmAdress2    				); }
	public String getEscLblEmAdress3    		() { return escapeHTML(lblEmAdress3    				); }
	public String getEscLblTel    				() { return escapeHTML(lblTel    					); }
	public String getEscLblFax    				() { return escapeHTML(lblFax    					); }
	public String getEscLblPhone    			() { return escapeHTML(lblPhone    					); }
	public String getEscLblBloodType    		() { return escapeHTML(lblBloodType    				); }
	public String getEscLblLicense    			() { return CommonUtility.brHTML(lblLicense			); }
	public String getEscLblRecapitulation    	() { return CommonUtility.brHTML(lblRecapitulation 	); }
	public String getEscLblHealth    			() { return CommonUtility.brHTML(lblHealth    		); }
	public String getEscLblSalaryKb    			() { return escapeHTML(lblSalaryKb    				); }
	public String getEscLblTaxKb    			() { return escapeHTML(lblTaxKb    					); }
	public String getEscLblUnionKb    			() { return escapeHTML(lblUnionKb    				); }
	public String getEscLblPartKb    			() { return escapeHTML(lblPartKb    				); }
	public String getEscLblPaymentKb    		() { return escapeHTML(lblPaymentKb    				); }

	public void setPltGender 			(String pltGender         	) { this.pltGender 			= pltGender 		; }
	public void setPltBirthYear    	(String pltBirthYear     	) { this.pltBirthYear    	= pltBirthYear    	; }
	public void setPltBirthMonth    	(String pltBirthMonth       ) { this.pltBirthMonth    	= pltBirthMonth    	; }
	public void setPltBirthDay    		(String pltBirthDay     	) { this.pltBirthDay    	= pltBirthDay    	; }
	public void setTxtPostalCode1    	(String txtPostalCode1    	) { this.txtPostalCode1    	= txtPostalCode1    ; }
	public void setTxtPostalCode2    	(String txtPostalCode2    	) { this.txtPostalCode2    	= txtPostalCode2   	; }
	public void setPltPrefecture		(String pltPrefecture	  	) { this.pltPrefecture		= pltPrefecture		; }
	public void setTxtAdress1    		(String txtAdress1          ) { this.txtAdress1    		= txtAdress1    	; }
	public void setTxtAdress2			(String txtAdress2 			) { this.txtAdress2			= txtAdress2		; }
	public void setTxtAdress3    		(String txtAdress3    		) { this.txtAdress3    		= txtAdress3    	; }
	public void setEMCode 				(String EMCode 				) { this.eMCode  			= EMCode 			; }	//A
	public void setTxtEmName    		(String txtEmName      		) { this.txtEmName    		= txtEmName    		; }
	public void setTxtEmTel1    		(String txtEmTel1      		) { this.txtEmTel1    		= txtEmTel1    		; }
	public void setTxtEmTel2    		(String txtEmTel2      		) { this.txtEmTel2    		= txtEmTel2    		; }
	public void setTxtEmTel3    		(String txtEmTel3      		) { this.txtEmTel3    		= txtEmTel3    		; }
	public void setTxtEmPhone1			(String txtEmPhone1         ) { this.txtEmPhone1    	= txtEmPhone1    	; }
	public void setTxtEmPhone2			(String txtEmPhone2         ) { this.txtEmPhone2    	= txtEmPhone2    	; }
	public void setTxtEmPhone3			(String txtEmPhone3         ) { this.txtEmPhone3    	= txtEmPhone3    	; }
	public void setTxtEmPostalCode1	(String txtEmPostalCode1    ) { this.txtEmPostalCode1  	= txtEmPostalCode1  ; }
	public void setTxtEmPostalCode2	(String txtEmPostalCode2    ) { this.txtEmPostalCode2  	= txtEmPostalCode2  ; }
	public void setPltEmPrefecture		(String pltEmPrefecture	  	) { this.pltEmPrefecture	= pltEmPrefecture	; }
	public void setTxtEmAdress1    	(String txtEmAdress1        ) { this.txtEmAdress1    	= txtEmAdress1    	; }
	public void setTxtEmAdress2		(String txtEmAdress2 		) { this.txtEmAdress2		= txtEmAdress2		; }
	public void setTxtEmAdress3    	(String txtEmAdress3    	) { this.txtEmAdress3    	= txtEmAdress3    	; }
	public void setTxtTel1    			(String txtTel1      		) { this.txtTel1			= txtTel1    		; }
	public void setTxtTel2    			(String txtTel2      		) { this.txtTel2			= txtTel2    		; }
	public void setTxtTel3    			(String txtTel3      		) { this.txtTel3			= txtTel3    		; }
	public void setTxtFax1    			(String txtPhone1        	) { this.txtPhone1        	= txtPhone1    		; }
	public void setTxtFax2    			(String txtPhone2        	) { this.txtPhone2        	= txtPhone2    		; }
	public void setTxtFax3    			(String txtPhone3        	) { this.txtPhone3        	= txtPhone3    		; }
	public void setPltBloodType    	(String pltBloodType      	) { this.pltBloodType    	= pltBloodType    	; }
	public void setTxtLicense			(String txtLicense       	) { this.txtLicense			= txtLicense		; }
	public void setTxtRecapitulation  	(String txtRecapitulation   ) { this.txtRecapitulation 	= txtRecapitulation ; }
	public void setTxtHealth    		(String txtHealth    		) { this.txtHealth    		= txtHealth    		; }
	public void setPltSalaryKb    		(String pltSalaryKb      	) { this.pltSalaryKb    	= pltSalaryKb    	; }
	public void setPltTaxKb    		(String pltTaxKb            ) { this.pltTaxKb    		= pltTaxKb    		; }
	public void setPltUnionKb    		(String pltUnionKb     		) { this.pltUnionKb    		= pltUnionKb    	; }
	public void setPltPartKb			(String pltPartKb			) { this.pltPartKb        	= pltPartKb    		; }
	public void setPltPaymentKb    	(String pltPaymentKb      	) { this.pltPaymentKb    	= pltPaymentKb    	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() {return mode; }

}
