/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dao.CmAuthorityDao;

import jp.mosp.common.dto.CmAuthorityDto;
import jp.mosp.common.dto.CmComponentDto;

/**
 * ɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class AuthorityPart extends BasePart {

	/**
	 * RXgN^
	 */
	public AuthorityPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public AuthorityPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * CM_AUTHORITYe[upDAO擾
	 * @return	ςCmAuthorityDaoCX^X
	 * @throws Exception
	 */
	public CmAuthorityDao getCmAuthorityDao() throws Exception {
		return (CmAuthorityDao)getPreparedDao(CmAuthorityDao.class.getCanonicalName());
	}

	/**
	 * ̎擾
	 * @param userAuth	ΏیR[h
	 * @return			
	 * @throws Exception
	 */
	public CmAuthorityDto findForKey(String userAuth) throws Exception {
		return	getCmAuthorityDao().findForKey(userAuth);
	}

	/**
	 * R[hXg擾(CM_AUTHORITY)
	 * @return R[hXg
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws MospException 
	 * @throws ClassNotFoundException 
	 */
	public String[][] getArrangeAuthArray() throws Exception {
		// f[^̎擾
		List<CmAuthorityDto> list = getCmAuthorityDao().findForAvailable();
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			CmAuthorityDto dto = list.get(i);
			array[i][0] = dto.getAuthCode();
			array[i][1] = dto.getAuthName();
		}
		return array;
	}

	/**
	 * SR[hXg擾(CM_AUTHORITY)
	 * @return R[hXg
	 * @throws Exception 
	 */
	public String[][] getArrangeAuthArrayAll() throws Exception {
		// f[^̎擾
		List<CmAuthorityDto> list = getCmAuthorityDao().findAll();
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			CmAuthorityDto dto = list.get(i);
			array[i][0] = dto.getAuthCode();
			array[i][1] = dto.getAuthName();
		}
		return array;
	}


	/**
	 * MANAGERmF
	 * @return TRAINERL(trueFLAfalseF)
	 * @throws Exception
	 */
	public boolean hasManagerAuth() throws Exception {
		// MANAGERmF
		boolean hasAuth = false;
		String userAuth = user.getAuthority();
		CmAuthorityDto dto = findForKey(userAuth);
		// ftHgR[h̐ݒ
		if (dto == null 
				&& (userAuth.equals(CommonConst.AUTHORITY_MANAGER) 
						|| userAuth.equals(CommonConst.AUTHORITY_SENIORS)
				)
		) {
			dto = new CmAuthorityDto();
			dto.setManager(CommonConst.CONF_ID_MANAGER);	
		}
		if (dto != null && !dto.getManager().equals("")) {
			hasAuth = true;
		}		
		return hasAuth;
	}

	/**
	 * PAYROLLmF
	 * @return PAYROLLL(trueFLAfalseF)
	 * @throws Exception
	 */
	public boolean hasPayrollAuth() throws Exception {
		// PAYROLLmF
		boolean hasAuth = false;
		String userAuth = user.getAuthority();
		CmAuthorityDto dto = findForKey(userAuth);
		// ftHgR[h̐ݒ
		if (dto == null
				&& (userAuth.equals(CommonConst.AUTHORITY_PAYROLL) 
						|| userAuth.equals(CommonConst.AUTHORITY_SENIORS)
						|| userAuth.equals(CommonConst.AUTHORITY_CALCULATE)
				)
		) {
			dto = new CmAuthorityDto();
			dto.setPayroll(CommonConst.CONF_ID_PAYROLL);	
		}
		if (dto != null && !dto.getPayroll().equals("")) {
			hasAuth = true;
		}		
		return hasAuth;
	}


	/**
	 * HUMANmF
	 * @return PAYROLLL(trueFLAfalseF)
	 * @throws Exception
	 */
	public boolean hasHumanAuth() throws Exception {
		// HUMANmF
		boolean hasAuth = false;
		String userAuth = user.getAuthority();
		CmAuthorityDto dto = findForKey(userAuth);
		// ftHgR[h̐ݒ
		if (dto == null 
				&& (userAuth.equals(CommonConst.AUTHORITY_HUMAN) 
						|| userAuth.equals(CommonConst.AUTHORITY_SENIORS)
				)
		) {
			dto = new CmAuthorityDto();
			dto.setHuman(CommonConst.CONF_ID_HUMAN);
		}
		if (dto != null && !dto.getHuman().equals("")) {
			hasAuth = true;
		}
		return hasAuth;
	}

	/**
	 * CALCULATEmF
	 * @return CALCULATEL(trueFLAfalseF)
	 * @throws Exception
	 */
	public boolean hasCalculateAuth() throws Exception {
		// CALCULATEmF
		boolean hasAuth = false;
		String userAuth = user.getAuthority();
		CmComponentDto cmComponentDto = null;
		CmAuthorityDto cmAuthorityDto = findForKey(userAuth);
		if (cmAuthorityDto != null) {
			cmComponentDto = component().findForDto(cmAuthorityDto.getPayroll(), CommonConst.CONF_ID_PAYROLL);
		}
		if (userAuth.equals(CommonConst.AUTHORITY_CALCULATE)) {
			// ftHgR[h̐ݒ
			if (cmAuthorityDto == null) {
				cmAuthorityDto = new CmAuthorityDto();
				cmAuthorityDto.setPayroll(CommonConst.CONF_ID_CALCULATE);	
				cmComponentDto = component().findForDto(cmAuthorityDto.getPayroll(), CommonConst.CONF_ID_PAYROLL);
			}
			// ftHgR[h̐ݒ
			if (cmComponentDto == null) {
				cmComponentDto = new CmComponentDto();
				cmComponentDto.setComponent(MosPMenuConst.getCalcCmdArray()[1]);	
			}			
		}
		if (cmComponentDto != null) {
			String [] aryCmd = StringPart.divideByComma(cmComponentDto.getComponent());
			for (int i = 0; i < aryCmd.length ; i++) {
				if (aryCmd[i].equals(MosPMenuConst.getCalcCmdArray()[1])
						|| aryCmd[i].equals(MosPMenuConst.getCalcCmdArray()[5])
						|| aryCmd[i].equals(MosPMenuConst.getPayrollCmdArray()[7][0])
						|| aryCmd[i].equals(MosPMenuConst.getPayrollCmdArray()[8][0])		
				) {
					hasAuth = true;
					break;
				}			
			}
		}
		return hasAuth;
	}

	/**
	 * R[h擾(͈͂ɂω)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	public String[][] getSectionScopeArrayForPayroll() throws Exception {
		CmComponentDto cmComponentDto = new CmComponentDto();
		String userAuth = user.getAuthority();
		CmAuthorityDto cmAuthorityDto = findForKey(userAuth);
		String [][] ary = null ;
		if (cmAuthorityDto != null) {
			cmComponentDto = component().findForKey(cmAuthorityDto.getPayroll());
		}
		// ftHg̐ݒ
		if (userAuth.equals(CommonConst.AUTHORITY_CALCULATE)) {
			cmComponentDto.setManage(VariousPart.getManageCode()[2]);
		} else if (userAuth.equals(CommonConst.AUTHORITY_PAYROLL)) {
			cmComponentDto.setManage(VariousPart.getManageCode()[0]);
		}
		// v_Eݒ
		if (cmComponentDto.getManage() == VariousPart.getManageCode()[0]) {
			ary = section().getSectionArrayForManager();			
		} else if (cmComponentDto.getManage() == VariousPart.getManageCode()[1]) {
			ary = section().getSectionArrayAll();
		} else {
			ary = StringPart.addArrayFirstRowValue(
					section().getSectionArrayAll(),
					CommonConst.NAM_COMMON_STRING_INITIAL_VALUE,
					CommonConst.NAM_ALL_SECTION);
		}
		return ary;
	}

	/**
	 * SYSTEMmF
	 * @return SYSTEML(trueFLAfalseF)
	 * @throws Exception 
	 */
	public boolean hasSystemAuth() throws Exception {
		// ADMINmF
		return user.getAuthority().equals(CommonConst.AUTH_SYSTEM);
	}

}
