/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.TableLockUtility;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.VoInterface;
import jp.mosp.common.dao.CtWorkflowCommentDao;
import jp.mosp.common.dao.CtWorkflowDao;
import jp.mosp.common.dto.CtWorkflowCommentDto;
import jp.mosp.common.dto.CtWorkflowDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.PartManager;
import jp.mosp.common.part.StringPart;
import jp.mosp.common.part.VariousPart;
import jp.mosp.common.part.WorkflowPart;
import jp.mosp.common.vo.MosPWorkFlowVo;

import jp.mosp.human.dto.MKihonDto;

import jp.mosp.kintai.dto.MSyukkinboDto;

import jp.mosp.workflow.dao.AmRouteDao;
import jp.mosp.workflow.dao.AmUnitDao;
import jp.mosp.workflow.dao.AttendanceRouteDao;
import jp.mosp.workflow.dao.CtOvertimeRequestDao;
import jp.mosp.workflow.dao.PmAttendanceDao;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;

public abstract class MosPWorkflowAction extends AttendanceTotalAction {

	// tB[h
	private AmUnitDao unitDao;
	private AmRouteDao routeDao;
	private AttendanceRouteDao atRouteDao;

	private PmAttendanceDao pmAttendDao;

	/**
	 * cƐ\DAO
	 */
	private CtOvertimeRequestDao overRequestDao;

	/**
	 * [Nt[DAO
	 */
	private CtWorkflowDao workflowDao;


	/**
	 * FpjbgDAȌ
	 * @throws Exception
	 */
	private void prepareAmUnitDao() throws Exception {
		// DAO
		if (unitDao !=null) {
			return;
		}
		unitDao = PartManager.approval(partInfo()).getAmUnitDao();
	}

	/**
	 * FpjbgDAO擾
	 * @return	ςAmUnitDaoCX^X
	 * @throws Exception
	 */
	protected AmUnitDao unitDao() throws Exception {
		// FpjbgDAȌ 
		prepareAmUnitDao();
		return unitDao;
	}

	/**
	 * Fp[gDAȌ
	 * @throws Exception
	 */
	private void prepareAmRouteDao() throws Exception {
		// DAO
		if (routeDao !=null) {
			return;
		}
		routeDao = PartManager.approval(partInfo()).getAmRouteDao();
	}

	/**
	 * Fp[gDAO̎擾
	 * @return	ςAmRouteDaoCX^X
	 * @throws Exception
	 */
	protected AmRouteDao routeDao() throws Exception {
		// Fp[gDAȌ 
		prepareAmRouteDao();
		return routeDao;
	}

	/**
	 * ΑӏFp[gDAȌ
	 * @throws Exception
	 */
	private void prepareAttendanceRouteDao() throws Exception {
		// DAO
		if (atRouteDao !=null) {
			return;
		}
		atRouteDao = PartManager.kintaiapproval(partInfo()).getAttendanceRouteDao();
	}

	/**
	 * ΑӏFp[gDAO̎擾
	 * @return	ςAttendanceRouteDaoCX^X
	 * @throws Exception
	 */
	protected AttendanceRouteDao atRouteDao() throws Exception {
		prepareAttendanceRouteDao();
		return atRouteDao;
	}

	/**
	 * ΑӏFp[g}X^DAȌ
	 * @throws Exception
	 */
	private void preparePmAttendanceDao() throws Exception {
		// DAO
		if (pmAttendDao != null) {
			return;
		}
		pmAttendDao = PartManager.kintaiapproval(partInfo()).getPmAttendanceDao();
	}

	/**
	 * ΑӏFp[g}X^DAO̎擾
	 * @return	ςPmAttendanceDaoCX^X
	 * @throws Exception
	 */
	protected PmAttendanceDao pmAttendDao() throws Exception {
		// ΑӏFp[g}X^DAȌ
		preparePmAttendanceDao();
		return pmAttendDao;
	}

	/**
	 * cƐ\e[uDAȌ
	 * @throws Exception
	 */
	private void prepareCtOvertimeRequestDao() throws Exception {
		// cƐ\e[uDAȌ
		if (overRequestDao != null) {
			return;
		}
		overRequestDao = PartManager.overtime(partInfo()).getCtOvertimeRequestDao();
	}

	/**
	 * cƐ\e[uDAO̎擾
	 * @return	ςCtOvertimeRequestDaoCX^X
	 * @throws Exception
	 */
	protected CtOvertimeRequestDao overRequestDao() throws Exception {
		// cƐ\e[uDAȌ
		prepareCtOvertimeRequestDao();
		return overRequestDao;
	}

	/**
	 * [Nt[e[uDAȌ
	 * @throws Exception
	 */
	private void prepareCtWorkflowDao() throws Exception {
		// [Nt[e[uDAȌ
		if (workflowDao != null) {
			return;
		}
		workflowDao = PartManager.workflow(partInfo()).getCtWorkflowDao();
	}

	/**
	 * [Nt[e[uDAO̎擾
	 * @return	ςCtWorkflowDaoCX^X
	 * @throws Exception
	 */
	protected CtWorkflowDao workflowDao() throws Exception {
		// [Nt[e[uDAȌ
		prepareCtWorkflowDao();
		return workflowDao;
	}

	/**
	 * 󏳔FjbgR[hꗗiAM_UNITj
	 * @return@̏FjbgR[hXg
	 * @throws Exception
	 */
	protected String[][] getCurrentUnitArray() throws Exception {
		return PartManager.approval(partInfo()).getCurrentUnitArray();
	}

	/**
	 * p\ΑӏF[gꗗ
	 * @param kcode ΏێЈR[h
	 * @return 󏊑FjbgR[hXg
	 * @throws Exception
	 */
	protected String[][] getBelongRouteInfoArray(String kcode, Date targetDate) throws Exception {
		return PartManager.kintaiapproval(partInfo()).getBelongRouteInfoArray(kcode, targetDate);
	}

	/**
	 * p\ΑӏF[gꗗ
	 * @param kcode ΏێЈR[h
	 * @return 󏊑FjbgR[hXg
	 * <p>
	 * [0]cꎟF[gR[h
	 * [1]c񎟏F[gR[h
	 * </p>
	 * @throws Exception
	 */
	protected String[] getTargetRouteInfo(String kcode, Date targetDate) throws Exception {
		return PartManager.kintaiapproval(partInfo()).getTargetRouteInfo(kcode, targetDate);
	}

	/**
	 * ΑӏF
	 * @param kcode			Ώێ
	 * @param targetDate	Ώ۔N
	 * @param reason		FR
	 * @param comment		FRg
	 * @param approver		F
	 * @throws Exception
	 */
	protected void runApprovalProcess(
			String kcode,
			String targetDate,
			String reason,
			String comment,
			String approver
	) throws Exception {
		// ̎擾
		MSyukkinboDto dto = getSyukkinboInfo(kcode, targetDate, true);
		// rmF
		chkExist(dto);
		// Fݒ
		dto.setNinsyo(approver);
		dto.setSnRiyuu(reason);
		dto.setSnComent(comment);
		dto.setSnTimes(util.getDateTime(util.getNowDate()));
		dto.setUpdtTimes(util.getDateTime(util.getNowDate()));
		// F
		syukkinboDao().update(dto);
		// DTO̍Ď擾
		chkUpdate(getSyukkinboInfo(dto.getKCode(), dto.getHizuke()));
	}

	/**
	 * e[ubNp[eBeB
	 */
	private TableLockUtility tableLock = null;

	/**
	 * e[ubNJn
	 */
	protected void prepareTableLock() throws Exception {
		tableLock = new TableLockUtility(cfg, cmd, aspUser, user, conn);
		// Ώۃe[uǉ
		addTargetTable(workflowDao(), true);
		addTargetTable(AmRouteDao.TABLE, false);
	}

	/**
	 * e[ubNΏDAOǉ
	 * @param dao		Ώۃe[uDAO
	 * @param isWrite	WRITȄꍇtrueAREAD̏ꍇfalse
	 */
	protected void addTargetTable(BaseDao dao, boolean isWrite) {
		tableLock.addTargetTable(dao, isWrite);
	}

	/**
	 * e[ubNΏDAOǉ
	 * @param tablename		Ώۃe[u
	 * @param isWrite	WRITȄꍇtrueAREAD̏ꍇfalse
	 */
	protected void addTargetTable(String tablename, boolean isWrite) {
		tableLock.addTargetTable(tablename, isWrite);
	}

	/**
	 * [Nt[o^pe[ubN
	 * @throws Exception
	 */
	protected void lockTables() throws Exception {
		tableLock.lockTables();
	}

	/**
	 * [Nt[o^pe[ubN
	 * @throws Exception
	 */
	protected void unLockTables() throws Exception {
		tableLock.unLockTables();
	}

	/**
	 * [Nt[擾
	 * @param workflow		[Nt[ԍ
	 * @return	(DTO)
	 * @throws Exception
	 */
	protected CtWorkflowDto getWorkflowDto(long workflow) throws Exception {
		return workflowDao().findForKey(workflow);
	}

	/**
	 * [Nt[擾
	 * @param workflow
	 * @return (DTO)
	 * @throws Exception
	 */
	protected CtWorkflowDto getWorkflowDto(String workflow) throws Exception {
		return getWorkflowDto(Long.parseLong(workflow));
	}

	/**
	 * F󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	F󋵂̐
	 * @throws Exception 
	 */
	protected boolean isStatusRequest(long workflow) throws Exception {
		return PartManager.workflow(partInfo()).isStatusRequest(workflow);
	}	

	/**
	 * Fςݏ󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	Fςݏ󋵂̐
	 * @throws Exception 
	 */
	protected boolean isStatusApproved(long workflow) throws Exception {
		return PartManager.workflow(partInfo()).isStatusApproved(workflow);
	}

	/**
	 * ߏ󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	ߏ󋵂̐
	 * @throws Exception 
	 */
	protected boolean isStatusReturned(long workflow) throws Exception {
		return PartManager.workflow(partInfo()).isStatusReturned(workflow);
	}

	/**
	 * 󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	󋵂̐
	 * @throws Exception
	 */
	protected boolean isStatusDraft(long workflow) throws Exception {
		return PartManager.workflow(partInfo()).isStatusDraft(workflow);
	}

	/**
	 * FΏێ҈ꗗ擾
	 * @param targetDate
	 * @return
	 * @throws Exception
	 */
	protected List<MKihonDto> getApprovalEmployeeList(Date targetDate) throws Exception {
		return PartManager.kintaiapproval(partInfo())
		.getApprovalEmployeeList(
				mKihon.getKCode(),
				targetDate
		);
	}

	/**
	 * \o^
	 * <p>
	 * K{@link #unLockTables()}s邱ƁB
	 * </p>
	 * @param kCode		ΏێЈR[h
	 * @return workflow		[Nt[ԍ
	 * @throws Exception
	 */
	protected long requestRegist(String kCode, boolean isDraft) throws Exception {
		CtWorkflowDto dto = new CtWorkflowDto();
		// ݒ
		if (isDraft) {
			// 
			dto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[4]);
		} else {
			// \
			dto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[0]);
		}
		// FKwݒ
		dto.setLayerNumber(0);
		String targetRouteCode = PartManager.kintaiapproval(partInfo()).getRequestRouteCode(kCode);
		dto.setRtCode(targetRouteCode);
		long workflow = 0;
		// e[ubN
		lockTables();
		// [gR[hݒ
		if (StringPart.isNotNull(targetRouteCode)) {
			String maxNo = workflowDao().findForMax();
			if (maxNo == null || maxNo.equals("")) {
				maxNo = "-1";
			}
			// őlZbg
			dto.setWorkflow(Long.parseLong(maxNo) + 1);
			workflowDao().insert(dto);
			workflow = dto.getWorkflow();
		}
		return workflow;
	}

	/**
	 * [Nt[XV
	 * @param dto			Ώۃ[Nt[DTO
	 * @param vo			G[bZ[W\VO
	 * @throws Exception
	 */
	protected boolean workflowRegist(CtWorkflowDto dto, VoInterface vo) throws Exception {
		// [gR[hmF
		if (VariousPart.chkExistDto(routeDao().findForKey(dto.getRtCode()))) {
			chkExclusive(workflowDao().findForUpdate(dto.getWorkflow()), dto, vo);
			workflowDao().update(dto);
			chkUpdate(getWorkflowDto(dto.getWorkflow()));
			return true;
		}
		// G[bZ[W
		vo.addErrMessage(MospUtility.getMessage(msg,
				CommonConst.MSG_TARGET_NOT_EXIST,
				CommonConst.NAM_APPROVAL_ROUTE)
		);
		return false;
	}

	/**
	 * [Nt[󋵂F֕ύX
	 * @param dto		Ώۃ[Nt[DTO
	 * @return
	 * @throws Exception 
	 */
	protected CtWorkflowDto shiftApproved(CtWorkflowDto dto) throws Exception {
		dto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[1]);
		dto.setLayerNumber(CommonConst.NUM_LAST_LAYER);
		return dto;
	}

	/**
	 * ߃Rgꗗ
	 * @param vo			ΏVO
	 * @param target		ΏێЈR[h
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @throws Exception
	 */
	protected void setReturnedComment(
			MosPWorkFlowVo vo,
			String target,
			long workflow
	) throws Exception {
		vo.setCommentFields(PartManager.workflow(partInfo())
				.getWorkflowCommentArray(target, workflow)
		);
	}

	/**
	 * [Nt[Rgo^
	 * @param workflow			[Nt[ԍ
	 * @param kcode				ЈR[h
	 * @param targetKCode		Ώێ
	 * @param comment			Rg
	 * @throws Exception
	 */
	protected void registComment(
			long workflow,
			String kcode,
			String targetKCode,
			String comment
	) throws Exception {
		CtWorkflowCommentDto dto = new CtWorkflowCommentDto();
		dto.setWorkflow(workflow);
		dto.setKCode(kcode);
		dto.setTarget(targetKCode);
		dto.setAuthorComment(comment);
		// [Nt[RgpDAO
		CtWorkflowCommentDao dao = PartManager.workflow(partInfo()).getCtWorkflowCommentDao();
		String maxCommentId = dao.findForMax();
		if (maxCommentId == null || maxCommentId.equals("")) {
			maxCommentId = "-1";
		} else {
			dao.findForUpdate(Long.parseLong(maxCommentId));
		}
		// őlZbg
		dto.setCommentId(Long.parseLong(maxCommentId) + 1);
		dao.insert(dto);
		chkInsert(dao.findForKey(dto.getCommentId()));
	}

	/**
	 * ŐVΏێЈRg擾
	 * @param kCode			ΏێЈR[h
	 * @param workflow		Ώۃ[Nt[
	 * @return
	 * @throws MospException
	 * @throws Exception
	 */
	protected String getCurrentWorkflowComment(String kCode, long workflow) throws MospException, Exception {
		CtWorkflowCommentDto dto = PartManager.workflow(partInfo()).getWorkflowCommentForTarget(
				kCode,
				workflow
		);
		if (chkExistDto(dto)) {
			return dto.getAuthorComment();
		}
		return "";
	}

	/**
	 * ΑӏFXe[^XR[h擾 
	 * @param workflow			Ώۃ[Nt[ԍ
	 * @return	ΑӏFXe[^XR[h
	 * @throws MospException
	 * @throws Exception
	 */
	protected String toKintaiApprovalStatus(long workflow) throws MospException, Exception {
		return PartManager.workflow(partInfo()).toKintaiApprovalStatus(workflow);
	}

	/**
	 * ΑӏF󋵖̎擾
	 * @param snRiyuu			ΑӏF󋵃R[h
	 * @return	ΑӏF󋵖
	 * @throws MospException
	 * @throws Exception
	 */
	protected String getApprovalName(String snRiyuu) throws MospException, Exception {
		return PartManager.kintaiapproval(partInfo()).getApprovalName(snRiyuu);
	}

	/**
	 * Ώ۔NΏۃjbgR[hFҔf
	 * @param unitcode		ΏۃjbgR[h
	 * @param targetDate	Ώ۔N
	 * @return
	 * <p>
	 * Ώ۔NFjbgDTOꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean isApprover(String unitcode, Date targetDate) throws Exception {
		return PartManager.approval(partInfo()).isApprover(unitcode, targetDate);
	}

	/**
	 * cƐ\擾
	 * @param voucher		Ώۓ`[ԍ
	 * @return	cƐ\DTO
	 * @throws Exception
	 */
	protected CtOvertimeRequestDto getOverTimeRequest(int voucher) throws Exception {
		return overRequestDao().findForKey(voucher);
	}

	/**
	 * Ώ۔NcƐ\擾
	 * @param kCode				ΏێЈR[h
	 * @param targetDate		Ώ۔N
	 * @return	cƐ\DTO
	 * @throws Exception
	 */
	protected CtOvertimeRequestDto getTargetOverTimeRequest(
			String kCode,
			Date targetDate
	) throws Exception {
		return overRequestDao().findForWorkDate(
				kCode,
				DatePart.convDateFormattedByHyphen(targetDate)
		);
	}

	/**
	 * \ޔz擾
	 * @return	\ޔz
	 */
	protected String[][] getApplicationArray() {
		return new String[][] {
				// Α
				//{ CommonConst.CODE_DAILY_APPROVAL, CommonConst.NAM_DAILY_APPROVAL },
				// cƐ\
				{ CommonConst.CODE_OVER_TIME_REQUEST, CommonConst.NAM_OVER_TIME_REQUEST },
				// xɐ\
				//{ CommonConst.CODE_HOLIDAY_REQUEST, CommonConst.NAM_HOLIDAY_REQUEST },
		};
	}

	/**
	 * cƐ\F
	 * @param vo		ΏVO
	 * @param dto		ΏDTO
	 * @return
	 * @throws Exception 
	 */
	protected boolean runOverTimeRequestApproved(
			CtOvertimeRequestDto dto,
			VoInterface vo
	) throws Exception {
		long workflow = dto.getWorkflow();
		// [Nt[擾
		CtWorkflowDto workflowDto = workflowDao().findForUpdate(workflow);
		// F[g擾
		String[] aryRouteInfo = getTargetRouteInfo(dto.getKCode(), dto.getWorkDate());
		// FtO
		boolean canApproval = false;
		// ꎟF
		if (workflowDto.getLayerNumber() == CommonConst.NUM_REQUEST_LAYER) {
			if (isApprover(aryRouteInfo[0], dto.getWorkDate())) {
				if (isStatusRequest(workflow)) {
					workflowDto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[1]);
					workflowDto.setLayerNumber(CommonConst.NUM_LAYER1);
					canApproval = true;
				}
			} else {
				StringBuffer sb = new StringBuffer();
				sb.append(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
				sb.append(CommonConst.NAM_OVER_TIME_REQUEST);
				vo.addErrMessage(MospUtility.getMessage(
						msg,
						CommonConst.MSG_CODE_DENY_APPROVAL,
						sb.toString())
				);
			}
		} 
		// 񎟏F
		else if (workflowDto.getLayerNumber() == CommonConst.NUM_LAYER1) {
			if (isApprover(aryRouteInfo[1], dto.getWorkDate())) {
				if (isStatusApproved(workflow)) {
					workflowDto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[1]);
					workflowDto.setLayerNumber(CommonConst.NUM_LAST_LAYER);
					canApproval = true;
				}
			} else {
				StringBuffer sb = new StringBuffer();
				sb.append(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
				sb.append(CommonConst.NAM_OVER_TIME_REQUEST);
				vo.addErrMessage(MospUtility.getMessage(
						msg,
						CommonConst.MSG_CODE_DENY_APPROVAL,
						sb.toString())
				);
			}
		} else {
			if (isStatusApproved(workflow)) {
				StringBuffer sb = new StringBuffer();
				sb.append(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
				sb.append(CommonConst.MSG_OF);
				sb.append(CommonConst.NAM_OVER_TIME_REQUEST);
				// G[bZ[W
				vo.addErrMessage(MospUtility.getMessage(msg, 
						CommonConst.MSG_CODE_SELECT_ALREADY_APPROVED,
						sb.toString())
				);
			}
		}
		// ߂̏ꍇ
		if (isStatusReturned(workflow)) {
			StringBuffer sb = new StringBuffer();
			sb.append(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
			sb.append(CommonConst.MSG_OF);
			sb.append(CommonConst.NAM_OVER_TIME_REQUEST);
			// G[bZ[W
			vo.addErrMessage(MospUtility.getMessage(msg, 
					CommonConst.MSG_CODE_SELECT_ALREADY_RETURNED,
					sb.toString())
			);
		}
		// [Nt[̍XV
		if (canApproval && workflowRegist(workflowDto, vo)) {
			return true;
		}
		return false;
	}

}
