/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * ʓǍǉ
 * @param 
 * @return 
 * @throws sO
 */
function onLoadExtra() {
	// ڔwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID    , COLOR_FIELD_NORMAL);
	setFieldsBgColor(ARY_ERR_FIELDS_ID, COLOR_FIELD_ERROR );
	// ڒݒ
	setMaxLength(PRM_TXT_STATUTORY_HOUR 		, LEN_STATUTORY);
	setMaxLength(PRM_TXT_STATUTORY_WEEK 		, LEN_STATUTORY);
	setMaxLength(PRM_TXT_STATUTORY_MONTH_HOURS	, LEN_STATUTORY);
	setMaxLength(PRM_TXT_STATUTORY_MONTH_DAYS 	, LEN_STATUTORY);
	setMaxLength(PRM_TXT_CALCULATION_DAYS 		, LEN_DAYS);
	setMaxLength(PRM_TXT_PROVIDED_DAYS 			, LEN_DAYS);
	setMaxLength(PRM_TXT_INPUT_UNIT_TIMES 		, LEN_TIME);
	setMaxLength(PRM_TXT_ALL_HOLIDAY_HOUR 		, LEN_TIME);
	setMaxLength(PRM_TXT_ALL_HOLIDAY_MIN 		, LEN_TIME);
	setMaxLength(PRM_TXT_HALF_HOLIDAY_HOUR 		, LEN_TIME);
	setMaxLength(PRM_TXT_HALF_HOLIDAY_MIN 		, LEN_TIME);
	setMaxLength(PRM_TXT_LATE_NIGHT_START_HOUR 	, LEN_TIME);
	setMaxLength(PRM_TXT_LATE_NIGHT_START_MIN 	, LEN_TIME);
	setMaxLength(PRM_TXT_LATE_NIGHT_TIME_HOUR 	, LEN_TIME);
	setMaxLength(PRM_TXT_LATE_NIGHT_TIME_MIN 	, LEN_TIME);
	
	setMaxLength(PRM_TXT_PASSWORD_TERM 	, LEN_DAYS);
	// tH[JXݒ
	setFocus(PRM_TXT_STATUTORY_HOUR);
}

/**
 * T[o[ʐM
 * @param 
 * @return 
 * @throws sO
 */
function submitForm(objForm) {
	// ̓`FbN
	if (validate()) {
		// T[o[ʐM(̓G[̏ꍇ)
		doSubmitMessage(objForm, 'S2508', 'QC0001', '');
	}
}

/**
 * ̓`FbN
 * @param 
 * @return `FbN(trueFOKAfalseFNG)
 * @throws sO
 */
function validate() {
	// tB[hwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID, COLOR_FIELD_NORMAL);
	// ̓`FbN
	var aryMessage = new Array();
	checkRequired(PRM_TXT_STATUTORY_HOUR		, NAM_STATUTORY_HOUR			, aryMessage);
	checkRequired(PRM_TXT_STATUTORY_WEEK		, NAM_STATUTORY_WEEK			, aryMessage);
	checkRequired(PRM_TXT_STATUTORY_MONTH_HOURS	, NAM_STATUTORY_MONTH_HOURS		, aryMessage);
	checkRequired(PRM_TXT_STATUTORY_MONTH_DAYS	, NAM_STATUTORY_MONTH_DAYS		, aryMessage);
	checkRequired(PRM_TXT_CALCULATION_DAYS		, NAM_CALCULATION				, aryMessage);
	checkRequired(PRM_TXT_PROVIDED_DAYS			, NAM_PROVIDED					, aryMessage);
	checkRequired(PRM_TXT_INPUT_UNIT_TIMES		, NAM_INPUT_UNIT_TIMES			, aryMessage);
	checkRequired(PRM_TXT_ALL_HOLIDAY_HOUR		, NAM_HOLIDAY_HOURS_ALL_HOUR	, aryMessage);
	checkRequired(PRM_TXT_ALL_HOLIDAY_MIN		, NAM_HOLIDAY_HOURS_ALL_MIN		, aryMessage);
	checkRequired(PRM_TXT_HALF_HOLIDAY_HOUR		, NAM_HOLIDAY_HOURS_HALF_HOUR	, aryMessage);
	checkRequired(PRM_TXT_HALF_HOLIDAY_MIN		, NAM_HOLIDAY_HOURS_HALF_MIN	, aryMessage);
	checkRequired(PRM_TXT_LATE_NIGHT_START_HOUR	, NAM_LATE_NIGHT_START_HOUR		, aryMessage);
	checkRequired(PRM_TXT_LATE_NIGHT_START_MIN	, NAM_LATE_NIGHT_START_MIN		, aryMessage);
	checkRequired(PRM_TXT_LATE_NIGHT_TIME_HOUR	, NAM_LATE_NIGHT_HOURS_HOUR		, aryMessage);
	checkRequired(PRM_TXT_LATE_NIGHT_TIME_MIN	, NAM_LATE_NIGHT_HOURS_MIN		, aryMessage);

	checkDecimal(PRM_TXT_STATUTORY_HOUR 		, LEN_INTEGER2 , LEN_DECIMAL , NAM_STATUTORY_HOUR 			, aryMessage);
	checkDecimal(PRM_TXT_STATUTORY_WEEK 		, LEN_INTEGER3 , LEN_DECIMAL , NAM_STATUTORY_WEEK 			, aryMessage);
	checkDecimal(PRM_TXT_STATUTORY_MONTH_HOURS 	, LEN_INTEGER3 , LEN_DECIMAL , NAM_STATUTORY_MONTH_HOURS 	, aryMessage);
	checkDecimal(PRM_TXT_STATUTORY_MONTH_DAYS 	, LEN_INTEGER2 , LEN_DECIMAL , NAM_STATUTORY_MONTH_DAYS 	, aryMessage);
	
	checkNumber(PRM_TXT_CALCULATION_DAYS		, NAM_CALCULATION				, aryMessage);
	checkNumber(PRM_TXT_PROVIDED_DAYS			, NAM_PROVIDED					, aryMessage);
	checkNumber(PRM_TXT_INPUT_UNIT_TIMES		, NAM_INPUT_UNIT_TIMES			, aryMessage);
	checkNumber(PRM_TXT_ALL_HOLIDAY_HOUR		, NAM_HOLIDAY_HOURS_ALL_HOUR	, aryMessage);
	checkNumber(PRM_TXT_ALL_HOLIDAY_MIN			, NAM_HOLIDAY_HOURS_ALL_MIN		, aryMessage);
	checkNumber(PRM_TXT_HALF_HOLIDAY_HOUR		, NAM_HOLIDAY_HOURS_HALF_HOUR	, aryMessage);
	checkNumber(PRM_TXT_HALF_HOLIDAY_MIN		, NAM_HOLIDAY_HOURS_HALF_MIN	, aryMessage);
	checkNumber(PRM_TXT_LATE_NIGHT_START_HOUR	, NAM_LATE_NIGHT_START_HOUR		, aryMessage);
	checkNumber(PRM_TXT_LATE_NIGHT_START_MIN	, NAM_LATE_NIGHT_START_MIN		, aryMessage);
	checkNumber(PRM_TXT_LATE_NIGHT_TIME_HOUR	, NAM_LATE_NIGHT_HOURS_HOUR		, aryMessage);
	checkNumber(PRM_TXT_LATE_NIGHT_TIME_MIN		, NAM_LATE_NIGHT_HOURS_MIN		, aryMessage);
	//ԁA̍vl`FbN
	checkTimeValue(PRM_TXT_ALL_HOLIDAY_HOUR		,PRM_TXT_ALL_HOLIDAY_MIN		, 24 , NAM_HOLIDAY_HOURS_ALL	,aryMessage);
	checkTimeValue(PRM_TXT_HALF_HOLIDAY_HOUR	,PRM_TXT_HALF_HOLIDAY_MIN		, 24 , NAM_HOLIDAY_HOURS_HALF	,aryMessage);
	checkTimeValue(PRM_TXT_LATE_NIGHT_START_HOUR,PRM_TXT_LATE_NIGHT_START_MIN	, 36 , NAM_LATE_NIGHT_START		,aryMessage);
	checkTimeValue(PRM_TXT_LATE_NIGHT_TIME_HOUR	,PRM_TXT_LATE_NIGHT_TIME_MIN	, 24 , NAM_LATE_NIGHT_HOURS		,aryMessage);

	//ΑӒ
	var calcDay = getFormValue(PRM_TXT_CALCULATION_DAYS);
	if ((calcDay > 31) || (calcDay < 0)) {
		setBgColor(PRM_TXT_CALCULATION_DAYS, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0006", NAM_CALCULATION));
	}
	
	//^x
	var provide = getFormValue(PRM_TXT_PROVIDED_DAYS);
	if ((provide > 31) || (provide < 1)) {
		setBgColor(PRM_TXT_PROVIDED_DAYS, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0006", NAM_PROVIDED));
	}
	
	//͒P
	var unit = getFormValue(PRM_TXT_INPUT_UNIT_TIMES);
	if ((unit > 60) || (unit < 1)) {
		setBgColor(PRM_TXT_INPUT_UNIT_TIMES, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC2029", NAM_INPUT_UNIT_TIMES));
	}

	//J
	var statutoryHour = getFormValue(PRM_TXT_STATUTORY_HOUR);
	if ((statutoryHour > 24) || (statutoryHour < 0.5)) {
		setBgColor(PRM_TXT_STATUTORY_HOUR, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_STATUTORY_HOUR));
	}

	//TԏJ
	var statutoryWeek = getFormValue(PRM_TXT_STATUTORY_WEEK);
	if ((statutoryWeek > 168) || (statutoryWeek < 0.5)) {
		setBgColor(PRM_TXT_STATUTORY_WEEK, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_STATUTORY_WEEK));
	}
	
	//ԏJ
	var statutoryMonth = getFormValue(PRM_TXT_STATUTORY_MONTH_HOURS);
	if ((statutoryMonth > 744) || (statutoryMonth < 0.5)) {
		setBgColor(PRM_TXT_STATUTORY_MONTH_HOURS, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_STATUTORY_MONTH_HOURS));
	}

	//ԏJ
	var statutoryDays = getFormValue(PRM_TXT_STATUTORY_MONTH_DAYS);
	if ((statutoryDays > 31) || (statutoryDays < 1)) {
		setBgColor(PRM_TXT_STATUTORY_MONTH_DAYS, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0005", NAM_STATUTORY_MONTH_DAYS));
	}

	//SxExr`FbN
	var allHoliday = (getFormValue(PRM_TXT_ALL_HOLIDAY_HOUR) * 60 ) + eval(getFormValue(PRM_TXT_ALL_HOLIDAY_MIN));
	var halfHoliday = (getFormValue(PRM_TXT_HALF_HOLIDAY_HOUR) * 60 ) + eval(getFormValue(PRM_TXT_HALF_HOLIDAY_MIN));
	if (halfHoliday > allHoliday) {
		aryMessage.push("x͑SxԐ𒴂ȂłB");
	}

	checkRegLength(PRM_TXT_INPUT_UNIT_TIMES, LEN_TIME, NAM_INPUT_UNIT_TIMES, aryMessage);

	checkRequired(PRM_TXT_PASSWORD_TERM	, NAM_PASSWORD_TERM		, aryMessage);
	checkNumber(PRM_TXT_PASSWORD_TERM	, NAM_PASSWORD_TERM		, aryMessage);

	if (aryMessage.length == 0) {
		return true;
	} else {
		showMessage(aryMessage);
		return false;
	}
}
