/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.system.dto.MSyozokuDto;

public class SyozokuMasterCardVo extends MosPVo {

	private static final long serialVersionUID = 9059074237970050656L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/syozokuMasterCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/syozokuMasterCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/syozokuMasterCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_UNIT_MASTER;

	// 萔
	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;
	public static final int MODE_SYSTEM = 2;

	//p[^[
	public static final String PRM_TXT_S_CODE1 = "txtSCode1";
	public static final String PRM_TXT_S_CODE2 = "txtSCode2";
	public static final String PRM_TXT_S_CODE3 = "txtSCode3";
	public static final String PRM_TXT_S_NAME  = "txtSName";

	//tB[h
	private String txtSCode1;
	private String txtSCode2;
	private String txtSCode3;
	private String txtSName;

	// [h(0FVKo^A1FXV)
	private int mode;

	//tB[hyѐ
	public static final String NAM_S_CODE		= CommonConst.NAM_STATION_CODE;
	public static final String NAM_S_CODE1	 	= CommonConst.NAM_STATION_CODE + "1";
	public static final String NAM_S_CODE2 	= CommonConst.NAM_STATION_CODE + "2";
	public static final String NAM_S_CODE3	 	= CommonConst.NAM_STATION_CODE + "3";
	public static final String NAM_S_NAME 	= CommonConst.NAM_COMMON_MEISYO;

	public static final int LEN_S_CODE1 = 2;
	public static final int LEN_S_CODE2 = 2;
	public static final int LEN_S_CODE3 = 2;
	public static final int LEN_S_NAME  = 20;

	public SyozokuMasterCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		txtSCode1 = request.getParameter(PRM_TXT_S_CODE1);
		txtSCode2 = request.getParameter(PRM_TXT_S_CODE2);
		txtSCode3 = request.getParameter(PRM_TXT_S_CODE3);
		txtSName  = request.getParameter(PRM_TXT_S_NAME);
	}

	/**
	 * tB[hݒ
	 * @param dto Xg
	 */
	public void setFields(MSyozokuDto dto) {
		//f[^̐ݒ
		//dto.getSCode()̒ɂĂRɕ
		txtSCode1 = dto.getSCode().substring(0, 2);		
		if (dto.getSCode().length() > 3){		
			txtSCode2 = dto.getSCode().substring(2, 4);
		} if (dto.getSCode().length() > 5){		
			txtSCode3 = dto.getSCode().substring(4, 6);	
		}
		txtSName  = dto.getSName();
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MSyozokuDto dto) {
		dto.setSCode(txtSCode1 + txtSCode2 + txtSCode3);
		dto.setSName(txtSName);
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate(boolean isInsert) throws MospException {
		// ÓmFJn
		startValidation();
		//K{mF
		checkRequired(txtSCode1, NAM_S_CODE1, PRM_TXT_S_CODE1);
		checkRequired(txtSName,  NAM_S_NAME, PRM_TXT_S_NAME);
		//^CvmF
		checkCode(txtSCode1, NAM_S_CODE1, PRM_TXT_S_CODE1);
		checkCode(txtSCode2, NAM_S_CODE2, PRM_TXT_S_CODE2);
		checkCode(txtSCode3, NAM_S_CODE3, PRM_TXT_S_CODE3);
		//񒷊mF
		checkLength(txtSCode1, LEN_S_CODE1, NAM_S_CODE1, PRM_TXT_S_CODE1);
		checkLength(txtSCode2, LEN_S_CODE2, NAM_S_CODE2, PRM_TXT_S_CODE2);
		checkLength(txtSCode3, LEN_S_CODE3, NAM_S_CODE3, PRM_TXT_S_CODE3);
		checkLength(txtSName,  LEN_S_NAME,  NAM_S_NAME, PRM_TXT_S_NAME);	
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	//ANZTb\h
	public void setTxtSCode1 (String pTxtSCode1	) {this.txtSCode1 	= pTxtSCode1;}
	public void setTxtSCode2 (String pTxtSCode2	) {this.txtSCode2 	= pTxtSCode2;}
	public void setTxtSCode3 (String pTxtSCode3	) {this.txtSCode3 	= pTxtSCode3;}
	public void setTxtSName  (String pTxtSName		) {this.txtSName 	= pTxtSName	;}

	public String getTxtSCode1 (){return txtSCode1;}
	public String getTxtSCode2 (){return txtSCode2;}
	public String getTxtSCode3 (){return txtSCode3;}
	public String getTxtSName  (){return txtSName;}

	public String getEscTxtSCode1() {return escapeHTML(txtSCode1);}
	public String getEscTxtSCode2() {return escapeHTML(txtSCode2);}
	public String getEscTxtSCode3() {return escapeHTML(txtSCode3);}
	public String getEscTxtSName()  {return escapeHTML(txtSName);}	

	public void	setMode(int mode)	{ this.mode = mode; }
	public int	 	getMode()			{ return mode; }		

}	
