/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.system.dto.MKaisyaDto;

public class KaisyaMasterCardVo extends MosPVo {

	private static final long serialVersionUID = -5456388474414301215L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/kaisyaMasterCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/kaisyaMasterCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/kaisyaMasterCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_COMPANY_MASTER;

	// 萔
	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;
	public static final int MODE_SYSTEM = 2;	

	// p[^
	public static final String PRM_TXT_JCODE		= "txtJCode";
	public static final String PRM_TXT_KAIMEI		= "txtKaiMei";
	public static final String PRM_TXT_KAIFURI	= "txtKaiFuri";
	public static final String PRM_TXT_KJIGYONUSI	= "txtKJigyoNusi";
	public static final String PRM_TXT_KAIYUBIN1	= "txtKaiYubin1";
	public static final String PRM_TXT_KAIYUBIN2	= "txtKaiYubin2";
	public static final String PRM_TXT_KAIJYUSYO	= "txtKaiJyusyo";
	public static final String PRM_TXT_KAITEL1	= "txtKaiTel1";
	public static final String PRM_TXT_KAITEL2	= "txtKaiTel2";
	public static final String PRM_TXT_KAITEL3	= "txtKaiTel3";
	public static final String PRM_TXT_KAIFAX1	= "txtKaiFax1";
	public static final String PRM_TXT_KAIFAX2	= "txtKaiFax2";
	public static final String PRM_TXT_KAIFAX3	= "txtKaiFax3";
	public static final String PRM_HID_RODOUBI	= "hidRodouBi";
	public static final String PRM_HID_ROUDOUJI	= "hidRoudouJi";
	public static final String PRM_HID_ROUDOUJI1	= "hidRoudouJi1";
	public static final String PRM_HID_ZARITU		= "hidZaRitu";
	public static final String PRM_HID_KSRITU		= "hidKsRitu";
	public static final String PRM_HID_SNRITU		= "hidSnRitu";
	public static final String PRM_HID_ZANTANKBN	= "hidZanTanKbn";
	public static final String PRM_TXT_RITKOYOU	= "txtRitKoyou";
	public static final String PRM_TXT_RITKKOYOU	= "txtRitKKoyou";
	public static final String PRM_TXT_RITKENPO	= "txtRitKenpo";
	public static final String PRM_TXT_RITKKENPO	= "txtRitKKenpo";
	public static final String PRM_TXT_RITKAIGO	= "txtRitKaigo";
	public static final String PRM_TXT_RITKKAIGO	= "txtRitKKaigo";
	public static final String PRM_TXT_RITKOSEI	= "txtRitKosei";
	public static final String PRM_TXT_RITKKOSEI	= "txtRitKKosei";
	public static final String PRM_HID_RITKOSEI3	= "hidRitKosei3";
	public static final String PRM_HID_RITKKOSEI3	= "hidRitKKosei3";
	public static final String PRM_HID_KOSEI3KBN	= "hidKosei3Kbn";
	public static final String PRM_PLT_KIKINKBN	= "pltKikinKbn";
	public static final String PRM_TXT_RITKIKIN	= "txtRitKikin";
	public static final String PRM_TXT_RITKKIKIN	= "txtRitKKikin";
	public static final String PRM_HID_RITKIKIN3	= "hidRitKikin3";
	public static final String PRM_HID_RITKKIKIN3	= "hidRitKKikin3";
	public static final String PRM_TXT_SYAHOFUGO	= "txtSyahoFugo";
	public static final String PRM_TXT_SYAHOKIGO	= "txtSyahoKigo";
	public static final String PRM_TXT_SYAHOBANGO	= "txtSyahoBango";
	public static final String PRM_TXT_KENPOJINO	= "txtKenpoJiNo";
	public static final String PRM_TXT_KIKINJINO1	= "txtKikinJiNo1";
	public static final String PRM_TXT_KIKINJINO2	= "txtKikinJiNo2";
	public static final String PRM_HID_KAIBANK	= "hidKaiBank";
	public static final String PRM_HID_SERVER		= "hidServer";	

	// tB[h
	private String 		txtJCode;
	private String		txtKaiMei;
	private String 		txtKaiFuri;
	private String 		txtKJigyoNusi;
	private String 		txtKaiYubin1;
	private String 		txtKaiYubin2;
	private String 		txtKaiJyusyo;
	private String 		txtKaiTel1;
	private String 		txtKaiTel2;
	private String 		txtKaiTel3;
	private String 		txtKaiFax1;
	private String 		txtKaiFax2;
	private String 		txtKaiFax3;
	private String 		hidRodouBi;
	private String 		hidRoudouJi;
	private String 		hidRoudouJi1;
	private String 		hidZaRitu;
	private String 		hidKsRitu;
	private String 		hidSnRitu;
	private String 		hidZantanKbn;
	private String 		txtRitKoyou;
	private String 		txtRitKKoyou;
	private String 		txtRitKenpo;
	private String 		txtRitKKenpo;
	private String 		txtRitKaigo;
	private String 		txtRitKKaigo;
	private String 		txtRitKosei;
	private String 		txtRitKKosei;
	private String 		hidRitKosei3;
	private String 		hidRitKKosei3;
	private String 		hidKosei3Kbn;
	private String 		pltKikinKbn;
	private String 		txtRitKikin;
	private String 		txtRitKKikin;
	private String 		hidRitKikin3;
	private String 		hidRitKKikin3;
	private String 		txtSyahoFugo;
	private String 		txtSyahoKigo;
	private String 		txtSyahoBango;
	private String 		txtKenpoJiNo;
	private String 		txtKikinJiNo1;
	private String 		txtKikinJiNo2;
	private String 		hidKaiBank;
	private String 		hidServer;

	// v_EXg
	public String[][] aryPltKikinKbn;

	// [h(0FVKo^A1FXVA2F폜)
	private int mode;

	// tB[hyѐ
	public static final String NAM_JCODE		= CommonConst.NAM_OFFICE + CommonConst.NAM_COMMON_CODE;
	public static final String NAM_KAIMEI		= CommonConst.NAM_OFFICE_NAME;
	public static final String NAM_KAIFURI	= CommonConst.NAM_OFFICE_KANA;
	public static final String NAM_KJIGYONUSI	= CommonConst.NAM_PROPRIETOR;
	public static final String NAM_KAIYUBIN	= CommonConst.NAM_POSTAL_CODE;
	public static final String NAM_KAIYUBIN1	= CommonConst.NAM_POSTAL_CODE + CommonConst.NAM_POSTAL_FRONT ;
	public static final String NAM_KAIYUBIN2	= CommonConst.NAM_POSTAL_CODE + CommonConst.NAM_POSTAL_BACK ;
	public static final String NAM_KAIJYUSYO	= CommonConst.NAM_OFFICE_ADDLESS ;
	public static final String NAM_KAITEL		= CommonConst.NAM_PHONE_NUMBER ;
	public static final String NAM_KAITEL1	= CommonConst.NAM_PHONE_NUMBER + CommonConst.NAM_AREA_NUMBER;
	public static final String NAM_KAITEL2	= CommonConst.NAM_PHONE_NUMBER + CommonConst.NAM_LOCAL_AREA_NUMBER ;
	public static final String NAM_KAITEL3	= CommonConst.NAM_PHONE_NUMBER + CommonConst.NAM_SUBSCRIBER_NUMBER ;
	public static final String NAM_KAIFAX		= CommonConst.NAM_FAX ;
	public static final String NAM_KAIFAX1	= CommonConst.NAM_FAX + CommonConst.NAM_AREA_NUMBER ;
	public static final String NAM_KAIFAX2	= CommonConst.NAM_FAX + CommonConst.NAM_LOCAL_AREA_NUMBER;
	public static final String NAM_KAIFAX3	= CommonConst.NAM_FAX + CommonConst.NAM_SUBSCRIBER_NUMBER ;
	public static final String NAM_RODOUBI	= CommonConst.NAM_NUMBER_OF_MONTHLY_WORKING_DAYS ;
	public static final String NAM_ROUDOUJI	= CommonConst.NAM_NUMBER_OF_MONTHLY_WORKING_HOURS ;
	public static final String NAM_ROUDOUJI1	= CommonConst.NAM_NUMBER_OF_WORKING_HOURS_PER_DAY ;
	public static final String NAM_ZARITU		= CommonConst.NAM_NORMAL_OVERTIME + CommonConst.NAM_PREMIUM_RATE ;
	public static final String NAM_KSRITU		= CommonConst.NAM_HOLIDAY_OVERTIME + CommonConst.NAM_PREMIUM_RATE ;
	public static final String NAM_SNRITU		= CommonConst.NAM_LATE_NIGHT_OVERTIME + CommonConst.NAM_PREMIUM_RATE ;
	public static final String NAM_ZANTANKBN	= CommonConst.NAM_UNIT_OVERTIME_TYPE ;
	public static final String NAM_RITKOYOU	= CommonConst.NAM_INSURANCE_EMPLOY + CommonConst.NAM_COMMON_PERSONAL + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKKOYOU	= CommonConst.NAM_INSURANCE_EMPLOY + CommonConst.NAM_COMMON_SUM + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKENPO	= CommonConst.NAM_INSURANCE_HEALTH + CommonConst.NAM_COMMON_PERSONAL + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKKENPO	= CommonConst.NAM_INSURANCE_HEALTH + CommonConst.NAM_COMMON_SUM + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKAIGO	= CommonConst.NAM_INSURANCE_NURSING + CommonConst.NAM_COMMON_PERSONAL + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKKAIGO	= CommonConst.NAM_INSURANCE_NURSING + CommonConst.NAM_COMMON_SUM + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKOSEI	= CommonConst.NAM_INSURANCE_PENSION + CommonConst.NAM_COMMON_PERSONAL + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKKOSEI	= CommonConst.NAM_INSURANCE_PENSION + CommonConst.NAM_COMMON_SUM + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKOSEI3	= CommonConst.NAM_INSURANCE_PENSION2 + CommonConst.NAM_TYPE_3 + CommonConst.NAM_COMMON_PERSONAL + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKKOSEI3	= CommonConst.NAM_INSURANCE_PENSION2 + CommonConst.NAM_TYPE_3 + CommonConst.NAM_COMMON_SUM + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_KOSEI3KBN	= CommonConst.NAM_INSURANCE_PENSION2 + CommonConst.NAM_TYPE_3 ;
	public static final String NAM_KIKINKBN	= CommonConst.NAM_INSURANCE_FUND + CommonConst.NAM_JOINING ;
	public static final String NAM_RITKIKIN	= CommonConst.NAM_FOUNDATION + CommonConst.NAM_COMMON_PERSONAL + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKKIKIN	= CommonConst.NAM_FOUNDATION + CommonConst.NAM_COMMON_SUM + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKIKIN3	= CommonConst.NAM_FOUNDATION + CommonConst.NAM_TYPE_3 + CommonConst.NAM_COMMON_PERSONAL + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_RITKKIKIN3	= CommonConst.NAM_FOUNDATION + CommonConst.NAM_TYPE_3 + CommonConst.NAM_COMMON_SUM + CommonConst.NAM_PREMIUMS ;
	public static final String NAM_SYAHOFUGO	= CommonConst.NAM_MUNICIPALITIES + CommonConst.NAM_COMMON_FUGO ;
	public static final String NAM_SYAHOKIGO	= CommonConst.NAM_OFFICE + CommonConst.NAM_COMMON_KIGO ;
	public static final String NAM_SYAHOBANGO	= CommonConst.NAM_OFFICE + CommonConst.NAM_COMMON_BANGO ;
	public static final String NAM_KENPOJINO	= CommonConst.NAM_INSURANCE_HEALTH + CommonConst.NAM_OFFICE + CommonConst.NAM_COMMON_BANGO ;
	public static final String NAM_KIKINJINO	= CommonConst.NAM_INSURANCE_PENSION2 + CommonConst.NAM_OFFICE + CommonConst.NAM_COMMON_BANGO ;
	public static final String NAM_KIKINJINO1	= CommonConst.NAM_FOUNDATION + CommonConst.NAM_COMMON_BANGO;
	public static final String NAM_KIKINJINO2	= CommonConst.NAM_OFFICE + CommonConst.NAM_COMMON_BANGO;
	public static final String NAM_KAIBANK	= CommonConst.NAM_CO_BANK_CODE ;
	public static final String NAM_SERVER		= CommonConst.NAM_SERVER + CommonConst.NAM_COMMON_MEISYO ;

	public static final int	LEN_JCODE		= 4;
	public static final int	LEN_KAIMEI		= 25;
	public static final int	LEN_KAIFURI		= 50;
	public static final int	LEN_KJIGYONUSI 	= 12;
	public static final int	LEN_KAIYUBIN1 	= 3;
	public static final int	LEN_KAIYUBIN2 	= 4;
	public static final int	LEN_KAIJYUSYO 	= 37;
	public static final int	LEN_KAITEL 		= 4;
	public static final int	LEN_KAIFAX 		= 4;
	public static final int	LEN_RITKOYOU 	= 10;
	public static final int	LEN_RITKKOYOU 	= 10;
	public static final int	LEN_RITKENPO 	= 10;
	public static final int	LEN_RITKKENPO 	= 10;
	public static final int	LEN_RITKAIGO 	= 10;
	public static final int	LEN_RITKKAIGO 	= 10;
	public static final int	LEN_RITKOSEI 	= 10;
	public static final int	LEN_RITKKOSEI 	= 10;
	public static final int	LEN_RITKIKIN 	= 10;
	public static final int	LEN_RITKKIKIN 	= 10;
	public static final int	LEN_SYAHOFUGO 	= 2;
	public static final int	LEN_SYAHOKIGO 	= 4;
	public static final int	LEN_SYAHOBANGO 	= 4;
	public static final int	LEN_KENPOJINO 	= 4;
	public static final int	LEN_KIKINJINO1	= 4;
	public static final int	LEN_KIKINJINO2 	= 7;

	/**
	 * RXgN^
	 */
	public KaisyaMasterCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setTxtJCode("");
		setTxtKaiMei("");
		setTxtKaiFuri("");
		setTxtKJigyoNusi("");
		setTxtKaiYubin1("");
		setTxtKaiYubin2("");
		setTxtKaiJyusyo("");
		setTxtKaiTel1("");
		setTxtKaiTel2("");
		setTxtKaiTel3("");
		setTxtKaiFax1("");
		setTxtKaiFax2("");
		setTxtKaiFax3("");
		setHidRodouBi("0");
		setHidRoudouJi("0");
		setHidRoudouJi1("0");
		setHidZaRitu("0");
		setHidKsRitu("0");
		setHidSnRitu("0");
		setHidZantanKbn("");
		setTxtRitKoyou("0");
		setTxtRitKKoyou("0");
		setTxtRitKenpo("0");
		setTxtRitKKenpo("0");
		setTxtRitKaigo("0");
		setTxtRitKKaigo("0");
		setTxtRitKosei("0");
		setTxtRitKKosei("0");
		setHidRitKosei3("0");
		setHidRitKKosei3("0");
		setHidKosei3Kbn("");
		setPltKikinKbn("0");
		setTxtRitKikin("0");
		setTxtRitKKikin("0");
		setHidRitKikin3("0");
		setHidRitKKikin3("0");
		setTxtSyahoFugo("");
		setTxtSyahoKigo("");
		setTxtSyahoBango("");
		setTxtKenpoJiNo("");
		setTxtKikinJiNo1("");
		setTxtKikinJiNo2("");
		setHidKaiBank("");
		setHidServer("");
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		txtJCode 		= request.getParameter(PRM_TXT_JCODE);
		txtKaiMei 		= request.getParameter(PRM_TXT_KAIMEI);
		txtKaiFuri 		= request.getParameter(PRM_TXT_KAIFURI);
		txtKJigyoNusi 	= request.getParameter(PRM_TXT_KJIGYONUSI);
		txtKaiYubin1 	= request.getParameter(PRM_TXT_KAIYUBIN1);
		txtKaiYubin2 	= request.getParameter(PRM_TXT_KAIYUBIN2);
		txtKaiJyusyo 	= request.getParameter(PRM_TXT_KAIJYUSYO);
		txtKaiTel1 		= request.getParameter(PRM_TXT_KAITEL1);
		txtKaiTel2 		= request.getParameter(PRM_TXT_KAITEL2);
		txtKaiTel3 		= request.getParameter(PRM_TXT_KAITEL3);
		txtKaiFax1 		= request.getParameter(PRM_TXT_KAIFAX1);
		txtKaiFax2 		= request.getParameter(PRM_TXT_KAIFAX2);
		txtKaiFax3 		= request.getParameter(PRM_TXT_KAIFAX3);
		hidRodouBi 		= request.getParameter(PRM_HID_RODOUBI);
		hidRoudouJi 	= request.getParameter(PRM_HID_ROUDOUJI);
		hidRoudouJi1 	= request.getParameter(PRM_HID_ROUDOUJI1);
		hidZaRitu 		= request.getParameter(PRM_HID_ZARITU);
		hidKsRitu 		= request.getParameter(PRM_HID_KSRITU);
		hidSnRitu 		= request.getParameter(PRM_HID_SNRITU);
		hidZantanKbn 	= request.getParameter(PRM_HID_ZANTANKBN);
		txtRitKoyou 	= request.getParameter(PRM_TXT_RITKOYOU);
		txtRitKKoyou 	= request.getParameter(PRM_TXT_RITKKOYOU);
		txtRitKenpo 	= request.getParameter(PRM_TXT_RITKENPO);
		txtRitKKenpo 	= request.getParameter(PRM_TXT_RITKKENPO);
		txtRitKaigo 	= request.getParameter(PRM_TXT_RITKAIGO);
		txtRitKKaigo 	= request.getParameter(PRM_TXT_RITKKAIGO);
		txtRitKosei 	= request.getParameter(PRM_TXT_RITKOSEI);
		txtRitKKosei 	= request.getParameter(PRM_TXT_RITKKOSEI);
		hidRitKosei3 	= request.getParameter(PRM_HID_RITKOSEI3);
		hidRitKKosei3 	= request.getParameter(PRM_HID_RITKKOSEI3);
		hidKosei3Kbn 	= request.getParameter(PRM_HID_KOSEI3KBN);
		pltKikinKbn 	= request.getParameter(PRM_PLT_KIKINKBN);
		txtRitKikin 	= request.getParameter(PRM_TXT_RITKIKIN);
		txtRitKKikin 	= request.getParameter(PRM_TXT_RITKKIKIN);
		hidRitKikin3 	= request.getParameter(PRM_HID_RITKIKIN3);
		hidRitKKikin3 	= request.getParameter(PRM_HID_RITKKIKIN3);
		txtSyahoFugo 	= request.getParameter(PRM_TXT_SYAHOFUGO);
		txtSyahoKigo 	= request.getParameter(PRM_TXT_SYAHOKIGO);
		txtSyahoBango 	= request.getParameter(PRM_TXT_SYAHOBANGO);
		txtKenpoJiNo 	= request.getParameter(PRM_TXT_KENPOJINO);
		txtKikinJiNo1 	= request.getParameter(PRM_TXT_KIKINJINO1);
		txtKikinJiNo2 	= request.getParameter(PRM_TXT_KIKINJINO2);
		hidKaiBank 		= request.getParameter(PRM_HID_KAIBANK);
		hidServer 		= request.getParameter(PRM_HID_SERVER);
	}

	/**
	 * tB[hݒ
	 * @param dto 
	 */
	public void setFields(MKaisyaDto dto) {
		txtJCode 		= dto.getId();
		txtKaiMei 		= dto.getKaiMei();
		txtKaiFuri 		= dto.getKaiFuri();
		txtKJigyoNusi 	= dto.getKJigyoNusi();
		txtKaiYubin1 	= util.divideYubinCodeForward(dto.getKaiYubin());
		txtKaiYubin2 	= util.divideYubinCodeBackward(dto.getKaiYubin());
		txtKaiJyusyo 	= dto.getKaiJyusyo();
		txtKaiTel1 		= util.divideByHyphen(dto.getKaiTel(), 2)[0];
		txtKaiTel2 		= util.divideByHyphen(dto.getKaiTel(), 2)[1];
		txtKaiTel3 		= util.divideByHyphen(dto.getKaiTel(), 2)[2];
		txtKaiFax1 		= util.divideByHyphen(dto.getKaiFax(), 2)[0];
		txtKaiFax2 		= util.divideByHyphen(dto.getKaiFax(), 2)[1];
		txtKaiFax3 		= util.divideByHyphen(dto.getKaiFax(), 2)[2];
		hidRodouBi 		= String.valueOf(dto.getRodouBi());
		hidRoudouJi 	= String.valueOf(dto.getRoudouJi());
		hidRoudouJi1 	= String.valueOf(dto.getRoudouJi1());
		hidZaRitu 		= String.valueOf(dto.getZaRitu());
		hidKsRitu 		= String.valueOf(dto.getKsRitu());
		hidSnRitu 		= String.valueOf(dto.getSnRitu());
		hidZantanKbn 	= dto.getZanTanKbn();
		txtRitKoyou 	= String.valueOf(dto.getRitKoyou());
		txtRitKKoyou 	= String.valueOf(dto.getRitKKoyou());
		txtRitKenpo 	= String.valueOf(dto.getRitKenpo());
		txtRitKKenpo 	= String.valueOf(dto.getRitKKenpo());
		txtRitKaigo 	= String.valueOf(dto.getRitKaigo());
		txtRitKKaigo 	= String.valueOf(dto.getRitKKaigo());
		txtRitKosei 	= String.valueOf(dto.getRitKosei());
		txtRitKKosei 	= String.valueOf(dto.getRitKKosei());
		hidRitKosei3 	= String.valueOf(dto.getRitKosei3());
		hidRitKKosei3 	= String.valueOf(dto.getRitKKosei3());
		hidKosei3Kbn 	= dto.getKosei3Kbn();
		pltKikinKbn 	= dto.getKikinKbn();
		txtRitKikin 	= String.valueOf(dto.getRitKikin());
		txtRitKKikin 	= String.valueOf(dto.getRitKKikin());
		hidRitKikin3 	= String.valueOf(dto.getRitKikin3());
		hidRitKKikin3 	= String.valueOf(dto.getRitKKikin3());
		txtSyahoFugo 	= dto.getSyahoFugo();
		txtSyahoKigo 	= dto.getSyahoKigo();
		txtSyahoBango 	= dto.getSyahoBango();
		txtKenpoJiNo 	= dto.getKenpoJiNo();
		txtKikinJiNo1 	= util.divideByHyphen(dto.getKikinJiNo(),1)[0];
		txtKikinJiNo2 	= util.divideByHyphen(dto.getKikinJiNo(),1)[1];
		hidKaiBank 		= dto.getKaiBank();
		hidServer 		= dto.getServer();
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MKaisyaDto dto) {
		dto.setId			(txtJCode);
		dto.setKaiMei		(txtKaiMei);
		dto.setKaiFuri		(txtKaiFuri);
		dto.setKJigyoNusi	(txtKJigyoNusi);
		dto.setKaiYubin		(txtKaiYubin1 + CommonConst.STR_SEPARATOR + txtKaiYubin2);
		dto.setKaiJyusyo	(txtKaiJyusyo);
		dto.setKaiTel		(txtKaiTel1 + CommonConst.STR_SEPARATOR + txtKaiTel2 + CommonConst.STR_SEPARATOR + txtKaiTel3);
		dto.setKaiFax		(txtKaiFax1 + CommonConst.STR_SEPARATOR + txtKaiFax2 + CommonConst.STR_SEPARATOR + txtKaiFax3);
		/*						
		 *  	2008/10/21	m.yoshida	VerΉ
		 */
		/*		
		dto.setRodouBi		(getIntParam(hidRodouBi));
		dto.setRoudouJi		(getIntParam(hidRoudouJi));
		dto.setRoudouJi1	(getIntParam(hidRoudouJi1));
		dto.setZaRitu		(getIntParam(hidZaRitu));
		dto.setKsRitu		(getIntParam(hidKsRitu));
		dto.setSnRitu		(getIntParam(hidSnRitu));
		dto.setZanTanKbn	(hidZantanKbn);
		dto.setRitKoyou		(getDoubleParam(txtRitKoyou));
		dto.setRitKKoyou	(getDoubleParam(txtRitKKoyou));
		dto.setRitKenpo		(getDoubleParam(txtRitKenpo));
		dto.setRitKKenpo	(getDoubleParam(txtRitKKenpo));
		dto.setRitKaigo		(getDoubleParam(txtRitKaigo));
		dto.setRitKKaigo	(getDoubleParam(txtRitKKaigo));
		dto.setRitKosei		(getDoubleParam(txtRitKosei));
		dto.setRitKKosei	(getDoubleParam(txtRitKKosei));
		dto.setRitKosei3	(getDoubleParam(hidRitKosei3));
		dto.setRitKKosei3	(getDoubleParam(hidRitKKosei3));
		dto.setKosei3Kbn	(hidKosei3Kbn);
		dto.setKikinKbn		(pltKikinKbn);
		dto.setRitKikin		(getDoubleParam(txtRitKikin));
		dto.setRitKKikin	(getDoubleParam(txtRitKKikin));
		dto.setRitKikin3	(getDoubleParam(hidRitKikin3));
		dto.setRitKKikin3	(getDoubleParam(hidRitKKikin3));
		dto.setSyahoFugo	(txtSyahoFugo);
		dto.setSyahoKigo	(txtSyahoKigo);
		dto.setSyahoBango	(txtSyahoBango);
		dto.setKenpoJiNo	(txtKenpoJiNo);
		dto.setKikinJiNo	(txtKikinJiNo1 + CommonConst.STR_SEPARATOR + txtKikinJiNo2);
		dto.setKaiBank		(hidKaiBank);
		dto.setServer		(hidServer);
		 */
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtJCode		, NAM_JCODE			, PRM_TXT_JCODE);
		checkRequired(txtKaiMei		, NAM_KAIMEI		, PRM_TXT_KAIMEI);
		checkRequired(txtKaiYubin1	, NAM_KAIYUBIN1		, PRM_TXT_KAIYUBIN1);
		checkRequired(txtKaiYubin2	, NAM_KAIYUBIN2		, PRM_TXT_KAIYUBIN2);
		checkRequired(txtKaiJyusyo	, NAM_KAIJYUSYO		, PRM_TXT_KAIJYUSYO);
		// ^CvmF
		checkCode(txtJCode, NAM_JCODE, PRM_TXT_JCODE);
		// 񒷊mF
		checkLength(txtJCode		, LEN_JCODE			, NAM_JCODE			, PRM_TXT_JCODE);
		checkLength(txtKaiMei		, LEN_KAIMEI		, NAM_KAIMEI		, PRM_TXT_KAIMEI);
		checkLength(txtKaiYubin1	, LEN_KAIYUBIN1		, NAM_KAIYUBIN1		, PRM_TXT_KAIYUBIN1);
		checkLength(txtKaiYubin2	, LEN_KAIYUBIN2		, NAM_KAIYUBIN2		, PRM_TXT_KAIYUBIN2);
		/*						
		 *  	2008/10/21	m.yoshida	VerΉ
		 */
		/*
		checkLength(txtKikinJiNo1	, LEN_KIKINJINO1	, NAM_KIKINJINO1	, PRM_TXT_KIKINJINO1);
		checkLength(txtKikinJiNo2	, LEN_KIKINJINO2	, NAM_KIKINJINO2	, PRM_TXT_KIKINJINO2);
		 */		
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getTxtJCode()			{ return txtJCode		; }
	public String getTxtKaiFuri()		{ return txtKaiFuri		; }
	public String getTxtKaiMei()		{ return txtKaiMei		; }
	public String getTxtKJigyoNusi()	{ return txtKJigyoNusi	; }
	public String getTxtKaiYubin1()		{ return txtKaiYubin1	; }
	public String getTxtKaiYubin2()		{ return txtKaiYubin2	; }
	public String getTxtKaiJyusyo()		{ return txtKaiJyusyo	; }
	public String getTxtKaiTel1()		{ return txtKaiTel1		; }
	public String getTxtKaiTel2()		{ return txtKaiTel2		; }
	public String getTxtKaiTel3()		{ return txtKaiTel3		; }
	public String getTxtKaiFax1()		{ return txtKaiFax1		; }
	public String getTxtKaiFax2()		{ return txtKaiFax2		; }
	public String getTxtKaiFax3()		{ return txtKaiFax3		; }
	public String getHidRodouBi()		{ return hidRodouBi		; }
	public String getHidRoudouJi()		{ return hidRoudouJi	; }
	public String getHidRoudouJi1()		{ return hidRoudouJi1	; }
	public String getHidZaRitu()		{ return hidZaRitu		; }
	public String getHidKsRitu()		{ return hidKsRitu		; }
	public String getHidSnRitu()		{ return hidSnRitu		; }
	public String getHidZantanKbn()		{ return hidZantanKbn	; }
	public String getTxtRitKoyou()		{ return txtRitKoyou	; }
	public String getTxtRitKKoyou()		{ return txtRitKKoyou	; }
	public String getTxtRitKenpo()		{ return txtRitKenpo	; }
	public String getTxtRitKKenpo()		{ return txtRitKKenpo	; }
	public String getTxtRitKaigo()		{ return txtRitKaigo	; }
	public String getTxtRitKKaigo()		{ return txtRitKKaigo	; }
	public String getTxtRitKosei()		{ return txtRitKosei	; }
	public String getTxtRitKKosei()		{ return txtRitKKosei	; }
	public String getHidRitKosei3()		{ return hidRitKosei3	; }
	public String getHidRitKKosei3()	{ return hidRitKKosei3	; }
	public String getHidKosei3Kbn()		{ return hidKosei3Kbn	; }
	public String getPltKikinKbn()		{ return pltKikinKbn	; }
	public String getTxtRitKikin()		{ return txtRitKikin	; }
	public String getTxtRitKKikin()		{ return txtRitKKikin	; }
	public String getHidRitKikin3()		{ return hidRitKikin3	; }
	public String getHidRitKKikin3()	{ return hidRitKKikin3	; }
	public String getTxtSyahoFugo()		{ return txtSyahoFugo	; }
	public String getTxtSyahoKigo()		{ return txtSyahoKigo	; }
	public String getTxtSyahoBango()	{ return txtSyahoBango	; }
	public String getTxtKenpoJiNo()		{ return txtKenpoJiNo	; }
	public String getTxtKikinJiNo1()	{ return txtKikinJiNo1	; }
	public String getTxtKikinJiNo2()	{ return txtKikinJiNo2	; }
	public String getHidKaiBank()		{ return hidKaiBank		; }
	public String getHidServer()		{ return hidServer		; }	

	public String getEscTxtJCode()		{ return escapeHTML(txtJCode)		; }
	public String getEscTxtKaiFuri()	{ return escapeHTML(txtKaiFuri)		; }
	public String getEscTxtKaiMei()		{ return escapeHTML(txtKaiMei)		; }
	public String getEscTxtKJigyoNusi()	{ return escapeHTML(txtKJigyoNusi)	; }
	public String getEscTxtKaiYubin1()	{ return escapeHTML(txtKaiYubin1)	; }
	public String getEscTxtKaiYubin2()	{ return escapeHTML(txtKaiYubin2)	; }
	public String getEscTxtKaiJyusyo()	{ return escapeHTML(txtKaiJyusyo)	; }
	public String getEscTxtKaiTel1()	{ return escapeHTML(txtKaiTel1)		; }
	public String getEscTxtKaiTel2()	{ return escapeHTML(txtKaiTel2)		; }
	public String getEscTxtKaiTel3()	{ return escapeHTML(txtKaiTel3)		; }
	public String getEscTxtKaiFax1()	{ return escapeHTML(txtKaiFax1)		; }
	public String getEscTxtKaiFax2()	{ return escapeHTML(txtKaiFax2)		; }
	public String getEscTxtKaiFax3()	{ return escapeHTML(txtKaiFax3)		; }
	public String getEscHidRodouBi()	{ return escapeHTML(hidRodouBi)		; }
	public String getEscHidRoudouJi()	{ return escapeHTML(hidRoudouJi)	; }
	public String getEscHidRoudouJi1()	{ return escapeHTML(hidRoudouJi1)	; }
	public String getEscHidZaRitu()		{ return escapeHTML(hidZaRitu)		; }
	public String getEscHidKsRitu()		{ return escapeHTML(hidKsRitu)		; }
	public String getEscHidSnRitu()		{ return escapeHTML(hidSnRitu)		; }
	public String getEscHidZantanKbn()	{ return escapeHTML(hidZantanKbn)	; }
	public String getEscTxtRitKoyou()	{ return escapeHTML(txtRitKoyou)	; }
	public String getEscTxtRitKKoyou()	{ return escapeHTML(txtRitKKoyou)	; }
	public String getEscTxtRitKenpo()	{ return escapeHTML(txtRitKenpo)	; }
	public String getEscTxtRitKKenpo()	{ return escapeHTML(txtRitKKenpo)	; }
	public String getEscTxtRitKaigo()	{ return escapeHTML(txtRitKaigo)	; }
	public String getEscTxtRitKKaigo()	{ return escapeHTML(txtRitKKaigo)	; }
	public String getEscTxtRitKosei()	{ return escapeHTML(txtRitKosei)	; }
	public String getEscTxtRitKKosei()	{ return escapeHTML(txtRitKKosei)	; }
	public String getEscHidRitKosei3()	{ return escapeHTML(hidRitKosei3)	; }
	public String getEscHidRitKKosei3()	{ return escapeHTML(hidRitKKosei3)	; }
	public String getEscHidKosei3Kbn()	{ return escapeHTML(hidKosei3Kbn)	; }
	public String getEscPltKikinKbn()	{ return escapeHTML(pltKikinKbn)	; }
	public String getEscTxtRitKikin()	{ return escapeHTML(txtRitKikin)	; }
	public String getEscTxtRitKKikin()	{ return escapeHTML(txtRitKKikin)	; }
	public String getEscHidRitKikin3()	{ return escapeHTML(hidRitKikin3)	; }
	public String getEscHidRitKKikin3()	{ return escapeHTML(hidRitKKikin3)	; }
	public String getEscTxtSyahoFugo()	{ return escapeHTML(txtSyahoFugo)	; }
	public String getEscTxtSyahoKigo()	{ return escapeHTML(txtSyahoKigo)	; }
	public String getEscTxtSyahoBango()	{ return escapeHTML(txtSyahoBango)	; }
	public String getEscTxtKenpoJiNo()	{ return escapeHTML(txtKenpoJiNo)	; }
	public String getEscTxtKikinJiNo1()	{ return escapeHTML(txtKikinJiNo1)	; }
	public String getEscTxtKikinJiNo2()	{ return escapeHTML(txtKikinJiNo2)	; }
	public String getEscHidKaiBank()	{ return escapeHTML(hidKaiBank)		; }
	public String getEscHidServer()		{ return escapeHTML(hidServer)		; }

	public void setTxtJCode		(String txtJCode		)	{ this.txtJCode 		= txtJCode		; }
	public void setTxtKaiFuri		(String txtKaiFuri		)	{ this.txtKaiFuri 		= txtKaiFuri	; }
	public void setTxtKaiMei		(String txtKaiMei		)	{ this.txtKaiMei 		= txtKaiMei		; }
	public void setTxtKJigyoNusi	(String txtKJigyoNusi	)	{ this.txtKJigyoNusi 	= txtKJigyoNusi	; }	
	public void setTxtKaiYubin1	(String txtKaiYubin1	)	{ this.txtKaiYubin1 	= txtKaiYubin1	; }
	public void setTxtKaiYubin2	(String txtKaiYubin2	)	{ this.txtKaiYubin2 	= txtKaiYubin2	; }
	public void setTxtKaiJyusyo	(String txtKaiJyusyo	)	{ this.txtKaiJyusyo 	= txtKaiJyusyo	; }
	public void setTxtKaiTel1		(String txtKaiTel1		)	{ this.txtKaiTel1 		= txtKaiTel1	; }
	public void setTxtKaiTel2		(String txtKaiTel2		)	{ this.txtKaiTel2 		= txtKaiTel2	; }
	public void setTxtKaiTel3		(String txtKaiTel3		)	{ this.txtKaiTel3 		= txtKaiTel3	; }
	public void setTxtKaiFax1		(String txtKaiFax1		)	{ this.txtKaiFax1 		= txtKaiFax1	; }
	public void setTxtKaiFax2		(String txtKaiFax2		)	{ this.txtKaiFax2 		= txtKaiFax2	; }
	public void setTxtKaiFax3		(String txtKaiFax3		)	{ this.txtKaiFax3 		= txtKaiFax3	; }
	public void setHidRodouBi		(String hidRodouBi		)	{ this.hidRodouBi 		= hidRodouBi	; }
	public void setHidRoudouJi		(String hidRoudouJi		)	{ this.hidRoudouJi 		= hidRoudouJi	; }
	public void setHidRoudouJi1	(String hidRoudouJi1	)	{ this.hidRoudouJi1 	= hidRoudouJi1	; }
	public void setHidZaRitu		(String hidZaRitu		)	{ this.hidZaRitu 		= hidZaRitu		; }
	public void setHidKsRitu		(String hidKsRitu		)	{ this.hidKsRitu 		= hidKsRitu		; }
	public void setHidSnRitu		(String hidSnRitu		)	{ this.hidSnRitu 		= hidSnRitu		; }
	public void setHidZantanKbn	(String hidZantanKbn	)	{ this.hidZantanKbn 	= hidZantanKbn	; }
	public void setTxtRitKoyou		(String txtRitKoyou		)	{ this.txtRitKoyou 		= txtRitKoyou	; }
	public void setTxtRitKKoyou	(String txtRitKKoyou	)	{ this.txtRitKKoyou 	= txtRitKKoyou	; }
	public void setTxtRitKenpo		(String txtRitKenpo		)	{ this.txtRitKenpo 		= txtRitKenpo	; }
	public void setTxtRitKKenpo	(String txtRitKKenpo	)	{ this.txtRitKKenpo 	= txtRitKKenpo	; }
	public void setTxtRitKaigo		(String txtRitKaigo		)	{ this.txtRitKaigo 		= txtRitKaigo	; }
	public void setTxtRitKKaigo	(String txtRitKKaigo	)	{ this.txtRitKKaigo 	= txtRitKKaigo	; }
	public void setTxtRitKosei		(String txtRitKosei		)	{ this.txtRitKosei 		= txtRitKosei	; }
	public void setTxtRitKKosei	(String txtRitKKosei	)	{ this.txtRitKKosei 	= txtRitKKosei	; }
	public void setHidRitKosei3	(String hidRitKosei3	)	{ this.hidRitKosei3 	= hidRitKosei3	; }
	public void setHidRitKKosei3	(String hidRitKKosei3	)	{ this.hidRitKKosei3 	= hidRitKKosei3	; }
	public void setHidKosei3Kbn	(String hidKosei3Kbn	)	{ this.hidKosei3Kbn 	= hidKosei3Kbn	; }
	public void setPltKikinKbn		(String pltKikinKbn		)	{ this.pltKikinKbn 		= pltKikinKbn	; }
	public void setTxtRitKikin		(String txtRitKikin		)	{ this.txtRitKikin 		= txtRitKikin	; }
	public void setTxtRitKKikin	(String txtRitKKikin	)	{ this.txtRitKKikin 	= txtRitKKikin	; }
	public void setHidRitKikin3	(String hidRitKikin3	)	{ this.hidRitKikin3 	= hidRitKikin3	; }
	public void setHidRitKKikin3	(String hidRitKKikin3	)	{ this.hidRitKKikin3 	= hidRitKKikin3	; }
	public void setTxtSyahoFugo	(String txtSyahoFugo	)	{ this.txtSyahoFugo 	= txtSyahoFugo	; }
	public void setTxtSyahoKigo	(String txtSyahoKigo	)	{ this.txtSyahoKigo 	= txtSyahoKigo	; }
	public void setTxtSyahoBango	(String txtSyahoBango	)	{ this.txtSyahoBango 	= txtSyahoBango	; }
	public void setTxtKenpoJiNo	(String txtKenpoJiNo	)	{ this.txtKenpoJiNo 	= txtKenpoJiNo	; }
	public void setTxtKikinJiNo1	(String txtKikinJiNo1	)	{ this.txtKikinJiNo1 	= txtKikinJiNo1	; }
	public void setTxtKikinJiNo2	(String txtKikinJiNo2	)	{ this.txtKikinJiNo2 	= txtKikinJiNo2	; }
	public void setHidKaiBank		(String hidKaiBank		)	{ this.hidKaiBank 		= hidKaiBank	; }
	public void setHidServer		(String hidServer		)	{ this.hidServer 		= hidServer		; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
