/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.system.dto.MExportDto;

public class ExportCardVo extends MosPVo {

	private static final long serialVersionUID = -1964891218805898322L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/exportCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/exportCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/exportCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_EXPORT_MASTER;

	// p[^[
	public static final String PRM_PLT_YEAR		= "pltYear";
	public static final String PRM_PLT_MONTH		= "pltMonth";

	// tB[h
	private		String	pltYear ;
	private 	String	pltMonth;

	// tB[hyѐ
	public static final String NAM_KINTAI_INFO 	= CommonConst.NAM_TARGET_MONTH;
	public static final String NAM_PLT_YEAR 		= CommonConst.NAM_YEAR;
	public static final String NAM_PLT_MONTH 		= CommonConst.NAM_MONTH;

	// v_EXg
	public String[][] aryPltYear ;
	public String[][] aryPltMonth;

	// 萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	// p[^[
	public static final String PRM_TXT_E_NAME  = "txtEName";
	public static final String PRM_TXT_E_FILE  = "txtEFile";

	// tB[h
	private String[]	aryEName;
	private String[]	aryEFile;
	private String 		txtEName;
	private String 		txtEFile;
	/*						
	 *  	2009/02/20	m.yoshida	G[Ή
	 */
	private String[] aryENameKey;

	// tB[hyѐ
	public static final String NAM_E_NAME = CommonConst.NAM_COMMON_MEISYO;
	public static final String NAM_E_FILE = CommonConst.NAM_TABLE;

	public static final int LEN_E_NAME = 10;

	// \[gL[
	public final String KEY_E_NAME = "keyEName";

	// [h(0FȂA1F)
	private int searchmode;

	/**
	 * RXgN^
	 */
	public ExportCardVo() {
		super();
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
		pltYear		= "";
		pltMonth	= "";
		aryEName  = new String[0];
		aryEFile  = new String[0];
		setFormerKey(KEY_E_NAME);
		/*						
		 *  	2009/02/20	m.yoshida	G[Ή
		 */
		aryENameKey = new String[0];
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		pltYear		= request.getParameter(PRM_PLT_YEAR 	);
		pltMonth	= request.getParameter(PRM_PLT_MONTH 	);
	}

	/**
	 * tB[hݒ
	 * @param exportList GNX|[g}X^Xg
	 * @throws MospException
	 */
	public void setFields(List exportList) throws MospException {
		//Xg̐ݒ
		list = exportList;
		//f[^̎擾
		count = exportList.size();
		//z̏
		aryEName = new String[count];
		aryEFile = new String[count];
		/*						
		 *  	2009/02/20	m.yoshida	G[Ή
		 */
		aryENameKey = new String[count];
		//f[^̐ݒ
		int i = 0;
		Iterator it = exportList.iterator();
		while (it.hasNext()){
			MExportDto dto = (MExportDto)it.next();
			//aryEName[i] = escapeHTML(dto.getEName());
			String ename = "";
			String[] divName = util.divideByComma(dto.getEName());
			if (divName.length == 1) {
				ename = dto.getEName();
			} else {
				ename = divName[1];
			}
			aryEName[i] = escapeHTML(ename);
			aryEFile[i] = escapeHTML(dto.getEFile());
			aryENameKey[i] = escapeHTML(dto.getEName());
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZTb\h
	public String getPltYear    () { return pltYear    ; }
	public String getPltMonth   () { return pltMonth   ; }
	public String[] getEscAryEName (){ return aryEName.clone(); }
	public String[] getEscAryEFile (){ return aryEFile.clone(); }
	/*						
	 *  	2009/02/20	m.yoshida	G[Ή
	 */
	public String[] getEscAryENameKey (){ return aryENameKey.clone(); }

	public String getEscTxtEName() { return escapeHTML(txtEName); }	
	public String getTxtEName() { return txtEName; }	
	public String getTxtEFile() { return txtEFile; }	

	public void setPltYear 	(String pltYear	) 	{ this.pltYear 		= pltYear	; }
	public void setPltMonth 	(String pltMonth) 	{ this.pltMonth 	= pltMonth	; }	

	public String getEscPltYear    () { return escapeHTML(pltYear    ); }
	public String getEscPltMonth   () { return escapeHTML(pltMonth   ); }

	public void setTxtEName(String ename) { this.txtEName = ename; }
	public void setTxtEFile(String efile) { this.txtEFile = efile; }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

}
