/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.dao;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;

import jp.mosp.system.dto.MExportColumnDto;

public class MExportColumnDao extends BaseDao {

	// 
	public static final String COL_FIELD  		= "FIELD";		//tB[hID
	public static final String COL_COMMENT  	= "COMMENT";	//tB[h

	/**
	 * RXgN^
	 */
	public MExportColumnDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<MExportColumnDto> mappingAll() throws SQLException {
		List<MExportColumnDto> all = new ArrayList<MExportColumnDto>();
		while (rs.next()) {
			MExportColumnDto dto = mapping();
			if (dto.getColumnField().toUpperCase(Locale.JAPANESE).equals(INSERT_DATE.toUpperCase(Locale.JAPANESE))
					|| dto.getColumnField().toUpperCase(Locale.JAPANESE).equals(INSERT_USER.toUpperCase(Locale.JAPANESE))	
					|| dto.getColumnField().toUpperCase(Locale.JAPANESE).equals(UPDATE_DATE.toUpperCase(Locale.JAPANESE))	
					|| dto.getColumnField().toUpperCase(Locale.JAPANESE).equals(UPDATE_USER.toUpperCase(Locale.JAPANESE))	
			) {
				continue;
			}
			all.add(dto);
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return MExportKintaiDto
	 * @throws SQLException
	 */
	private MExportColumnDto mapping() throws SQLException {
		MExportColumnDto dto = new MExportColumnDto();
		dto.setColumnField(rs.getString (COL_FIELD)	);	// tB[hid
		// tB[h
		byte[] bt = rs.getBytes(COL_COMMENT);
		boolean flag = true;
		try {
			String str = new String(bt, "MS932");
			if (str.contains("?")) {
				flag = false;
			}
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		if (flag) {
			dto.setColumnComment(rs.getString(COL_COMMENT));	
		} else {
			dto.setColumnComment(dto.getColumnField());	
		}
		return dto;
	}

	/**
	 * ɂf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException 
	 */
	public List<MExportColumnDto> findForCondition(String tableName) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		index = 1;
		try {
			prepareStatement(getTableDescriptionQuery(tableName));
			executeQuery();
			List<MExportColumnDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

}
