/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.util.List;
import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.ExportPart;

import jp.mosp.system.dao.MExportDao;
import jp.mosp.system.dto.MExportDto;

import jp.mosp.system.vo.ExportMasterCardVo;

public class ExportMasterCardAction extends MosPAction {

	// R}h
	private static final String CMD_EXPORT_MASTER_CARD_SHOW   = "S1215";	// \(ǉ)
	private static final String CMD_EXPORT_MASTER_CARD_SELECT = "S1216";	// \(I)
	private static final String CMD_EXPORT_MASTER_CARD_INSERT = "S1217";	// o^
	private static final String CMD_EXPORT_MASTER_CARD_UPDATE = "S1218";	// XV
	private static final String CMD_EXPORT_MASTER_CARD_DELETE = "S1219";	// 폜

	/**
	 * RXgN^
	 */
	public ExportMasterCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// vZǗmF
		confirmCalculateAuth();
		// VO̎擾
		ExportMasterCardVo vo = getInitVo();
		init(vo);
		// R}h̏
		if (cmd.equals(CMD_EXPORT_MASTER_CARD_SHOW)) {
			// \
			show(vo);
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			select(vo);
			// l񍀖ڐݒ
			crtDataItem(vo);
			// [hݒ
			vo.setMode(ExportMasterCardVo.MODE_UPDATE);
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_INSERT)) {
			// VKo^
			regist(vo);
			// l񍀖ڐݒ
			crtDataItem(vo);
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_UPDATE)) {
			// XV
			regist(vo);
			// l񍀖ڐݒ
			crtDataItem(vo);
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_DELETE)) {
			// 폜
			delete(vo);
			// l񍀖ڐݒ
			vo.aryPltKintaiDataItem = new String[0][2];
			vo.aryPltSelectDataItem = new String[0][2];
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.action.MosPAction#getInitVo()
	 */
	protected ExportMasterCardVo getInitVo() {
		return new ExportMasterCardVo();
	}

	/**
	 * 
	 * @param vo	ΏVO
	 */
	protected void init(ExportMasterCardVo vo) {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		vo.setParams(request);
		vo.aryTargetTable = getArrayTargetTable();
	}

	/**
	 * \
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void show(ExportMasterCardVo vo) throws Exception {
		// VOɏZbg
		vo.setTxtEName("");
		vo.setHidEFile(key1);
		vo.setLblEFile(util.getCodeName(vo.getHidEFile(), vo.aryTargetTable));
		// l񍀖ڐݒ
		vo.aryPltKintaiDataItem = getKintaiDataItem(vo.getHidEFile());
		vo.aryPltSelectDataItem = new String[0][2];
	}

	/**
	 * I
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void select(ExportMasterCardVo vo) throws Exception {
		// VOɏZbg
		vo.setTxtEName(key1);
		vo.setHidEFile(key2);
		vo.setLblEFile(util.getCodeName(vo.getHidEFile(), vo.aryTargetTable));
		// l񍀖ڐݒ
		vo.aryPltKintaiDataItem = getKintaiDataItem(vo.getHidEFile());
		// DAȌ
		MExportDao dao = new MExportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		chkExist(dao.findForKey(vo.getTxtEName(), vo.getHidEFile(), 0));
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	protected void regist(ExportMasterCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MExportDao dao = new MExportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		/*						
		 *  	2009/02/20	m.yoshida	G[Ή
		 */
		List<MExportDto> exportlist = dao.findForCondition(vo.getTxtEName(), vo.getHidEFile());
		if (cmd.equals(CMD_EXPORT_MASTER_CARD_INSERT)) {
			if (exportlist.size() > 0) {
				vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_DUPLICATE, ""));
				return;
			}
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_UPDATE)) {
			if (exportlist.size() > 0) {
				dao.delete(vo.getTxtEName(), vo.getHidEFile());
			}
		}
		for (int i = 0; i < vo.getPltSelected().length; i++) {
			MExportDto dto = new MExportDto();
			vo.setDtoFields(dto, i);
			dao.insert(dto);
		}
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ExportMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
	}

	/**
	 * f[^폜
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void delete(ExportMasterCardVo vo) throws Exception {
		// DAȌ
		MExportDao dao = new MExportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̍XV
		dao.delete(vo.getTxtEName(), vo.getHidEFile());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
	}

	/**
	 * Iڂ̃Xg쐬
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void crtDataItem(ExportMasterCardVo vo) throws Exception {
		// DAȌ
		MExportDao dao = new MExportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// l񍀖ڐݒ
		List<MExportDto> mExportList = dao.findForCondition(vo.getTxtEName(), vo.getHidEFile());
		String [][] aryKintaiDataItem = getKintaiDataItem(vo.getHidEFile());
		// ڂ̑I
		vo.aryPltSelectDataItem = new String[mExportList.size()][2];
		int t = 0;
		for (int i = 0; i < mExportList.size(); i++) {
			MExportDto dto = mExportList.get(i);
			for (int j = 0; j < aryKintaiDataItem.length; j++) {
				if (aryKintaiDataItem[j][0].equals(dto.getEFname())) {
					vo.aryPltSelectDataItem[i][0] = aryKintaiDataItem[j][0];
					vo.aryPltSelectDataItem[i][1] = aryKintaiDataItem[j][1];
					aryKintaiDataItem[j][0] = "";
					t++;
				} 
				else if (!aryKintaiDataItem[j][0].equals("")) {
					vo.aryPltSelectDataItem[i][0] = dto.getEFname();
					vo.aryPltSelectDataItem[i][1] = getEFnameItem(dto.getEFname(), 3);
				}
			}
		}
		String [][] aryPltDataItem = new String[aryKintaiDataItem.length - t][2];
		int n = 0;
		for (int j = 0; j < aryKintaiDataItem.length; j++) {
			if (!aryKintaiDataItem[j][0].equals("") ) {
				aryPltDataItem[n][0] = aryKintaiDataItem[j][0];
				aryPltDataItem[n][1] = aryKintaiDataItem[j][1];
				n++;
			}
		}
		vo.aryPltKintaiDataItem = aryPltDataItem;
	}

	/**
	 * Ώۃe[u̔z
	 * @return	String[][]	Ώۃe[u̔z
	 */
	protected String[][] getArrayTargetTable() {
		String[][] aryTargetTable = new String[4][2];
		aryTargetTable[0][0] = CommonConst.CODE_TABLE_M_KIHON;
		aryTargetTable[0][1] = CommonConst.NAM_TABLE_M_KIHON;
		aryTargetTable[1][0] = CommonConst.CODE_TABLE_M_KINTAI;
		aryTargetTable[1][1] = CommonConst.NAM_TABLE_M_KINTAI;
		aryTargetTable[2][0] = CommonConst.CODE_TABLE_M_SYUKKINBO;
		aryTargetTable[2][1] = CommonConst.NAM_TABLE_M_SYUKKINBO;
		aryTargetTable[3][0] = CommonConst.CODE_TABLE_M_YUKYU;
		aryTargetTable[3][1] = CommonConst.NAM_TABLE_M_YUKYU;
		return aryTargetTable;
	}

	/**
	 * GNX|[g񍀖ڐݒ
	 * @param strFLID	Ώۃe[uR[h
	 * @return	String[][]	GNX|[g񍀖ڔz
	 * @throws Exception
	 */
	protected String[][] getKintaiDataItem(String strFLID) throws Exception {
		return ((ExportPart)getPart(ExportPart.class.getCanonicalName())).getKintaiDataItem(strFLID);
	}

}
