/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.dto.DetailDto;

/**
 * אݒҏWʂɂB<br><br>
 */
public class DetailCardVo extends PayrollVo {
	
	private static final long serialVersionUID = 7009008251901023868L;
	
	// tB[h
	private String pltType  ;
	private String txtCode  ;
	private String txtName  ;
	private String txtAbbr  ;
	private String pltDelete;
	
	// v_E
	private String[][] pitType;
	
	// ʃ[h
	private int mode;
	
	/**
	 * p[^(R[h)B
	 */
	public static final String PRM_PLT_TYPE = "pltType";
	
	/**
	 * p[^(R[h(\))B
	 */
	public static final String PRM_HID_TYPE = "hidType";
	
	/**
	 * p[^(R[h)B
	 */
	public static final String PRM_TXT_CODE = "txtCode";
	
	/**
	 * p[^()B
	 */
	public static final String PRM_TXT_NAME = "txtName";
	
	/**
	 * p[^()B
	 */
	public static final String PRM_TXT_ABBR = "txtAbbr";
	
	/**
	 * p[^(폜tO)B
	 */
	public static final String PRM_PLT_DELETE = "pltDelete";
	
	/**
	 * p[^(폜tO(\))B
	 */
	public static final String PRM_HID_DELETE = "hidDelete";
	
	/**
	 * ڒ(׃R[h)
	 */
	public static final int LEN_CODE = PayrollConst.LEN_DETAIL_CODE;
	
	/**
	 * ڒ(ז)
	 */
	public static final int LEN_NAME = PayrollConst.LEN_DETAIL_NAME;
	
	/**
	 * ڒ(ח)
	 */
	public static final int LEN_ABBR = PayrollConst.LEN_DETAIL_ABBR;
	
	/**
	 * ږ(R[h)B
	 */
	public String NAM_TYPE;
	
	/**
	 * ږ(R[h)B
	 */
	public String NAM_CODE;
	
	/**
	 * ږ()B
	 */
	public String NAM_NAME;
	
	/**
	 * ږ()B
	 */
	public String NAM_ABBR;
	
	/**
	 * ږ(폜tO)B
	 */
	public String NAM_DELETE;
	
	/**
	 * {@link PayrollVo#PayrollVo()}sB
	 */
	public DetailCardVo() {
		super();
	}
	
	/**
	 * ږ̂ݒ肷B
	 */
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		pitType = getDetailTypeArray();
		NAM_TYPE   = getName("P_DETAIL") + getName("P_TYPE"      );
		NAM_CODE   = getName("P_DETAIL") + getName("C_CODE"      );
		NAM_NAME   = getName("P_DETAIL") + getName("C_NAME"      );
		NAM_ABBR   = getName("P_DETAIL") + getName("P_ABBREVIATE");
		NAM_DELETE = getName("P_DELETE_FLAG");
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_DETAIL") + getName("P_SETTING");
		addAryMenu("P1002", getName("P_PAYMENT") +
				getName("P_CALCULATE") + getName("C_MASTER") + getName("C_TO"));
	}
	
	/**
	 * NGXgp[^擾Aݒ肷B
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltType   = request.getParameter(PRM_HID_TYPE  );
		txtCode   = request.getParameter(PRM_TXT_CODE  );
		txtName   = request.getParameter(PRM_TXT_NAME  );
		txtAbbr   = request.getParameter(PRM_TXT_ABBR  );
		pltDelete = request.getParameter(PRM_HID_DELETE);
	}
	
	/**
	 * tB[hݒ肷B<br>
	 * @param dto אݒDTO
	 */
	public void setFields(DetailDto dto) {
		txtCode = dto.getDetailCode();
		txtName = dto.getDetailName();
		txtAbbr = dto.getDetailAbbr();
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @param obj 擾IuWFNg
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = " + mode + ";");
		return sb.toString();
	}
	
	/**
	 * 敪v_EACe擾B
	 * @return 敪v_EACe
	 */
	public String[][] getPitType() {
		return getAryField(pitType);
	}

	/**
	 * 敪v_EACeݒ肷B
	 * @param pitType ݒ肷敪v_EACe
	 */
	public void setPitType(String[][] pitType) {
		this.pitType = getAryField(pitType);
	}

	/**
	 * 폜tO擾B
	 * @return 폜tO
	 */
	public String getPltDelete() {
		return pltDelete;
	}

	/**
	 * 폜tOݒ肷B
	 * @param pltDelete ݒ肷폜tO
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}

	/**
	 * 敪擾B
	 * @return 敪
	 */
	public String getPltType() {
		return pltType;
	}

	/**
	 * 敪ݒ肷B
	 * @param pltType ݒ肷敪
	 */
	public void setPltType(String pltType) {
		this.pltType = pltType;
	}
	
	/**
	 * ̂擾B
	 * @return 
	 */
	public String getTxtAbbr() {
		return txtAbbr;
	}

	/**
	 * ̂ݒ肷B
	 * @param txtAbbr ݒ肷闪
	 */
	public void setTxtAbbr(String txtAbbr) {
		this.txtAbbr = txtAbbr;
	}

	/**
	 * ̂擾B
	 * @return 
	 */
	public String getEscTxtAbbr() {
		return escapeHTML(txtAbbr);
	}

	/**
	 * R[h擾B
	 * @return R[h
	 */
	public String getTxtCode() {
		return txtCode;
	}

	/**
	 * R[hݒ肷B
	 * @param txtCode ݒ肷R[h
	 */
	public void setTxtCode(String txtCode) {
		this.txtCode = txtCode;
	}

	/**
	 * R[h擾B
	 * @return R[h
	 */
	public String getEscTxtCode() {
		return escapeHTML(txtCode);
	}

	/**
	 * ̂擾B
	 * @return 
	 */
	public String getTxtName() {
		return txtName;
	}

	/**
	 * ̂ݒ肷B
	 * @param txtName ݒ肷閼
	 */
	public void setTxtName(String txtName) {
		this.txtName = txtName;
	}
	
	/**
	 * ̂擾B
	 * @return 
	 */
	public String getEscTxtName() {
		return escapeHTML(txtName);
	}
	
	/**
	 * ʃ[hݒ肷B<br><br>
	 * 0:VKA1FXVA2FXV(ҏWs)
	 * @param mode ݒ肷ʃ[h
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
