/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.report.action;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.MosPVo;
import jp.mosp.common.bean.OdsBean;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.AdjustmentCalcVo;
import jp.mosp.payroll.common.vo.AdjustmentListVo;
import jp.mosp.payroll.common.vo.AdjustmentReferVo;
import jp.mosp.payroll.dao.CdAdjustmentDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.report.dto.WithholdingListDto;
import jp.mosp.system.dao.MSyozokuDao;
import jp.mosp.system.dao.MYakusyokuDao;
import jp.mosp.system.dto.MSyozokuDto;
import jp.mosp.system.dto.MYakusyokuDto;

public class WithholdingListAction extends AdjustmentAction{
	
	
	// R}h
	private static final String CMD_WITHHOLDING_LIST_ALL = "P3040";
	private static final String CMD_WITHHOLDING_LIST_ONE = "P3041";
	private static final String CMD_WITHHOLDING_LIST_ALL2= "P3042";
	
	public String[][] aryGender  ;
	// ݒe[u
	public List<MosPConfDto> listConf;
	public String[][] aryEra;
	public String[][] aryStation ;
	public String[][] aryPltIncomeTaxType;
	public String[][] aryPltAdjustmentType;

	/**
	 * RXgN^
	 */
	public WithholdingListAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// DAO
		prepareDao();
		// 擾ϊmF
		if (aryStation != null) {
			return;
		}
		// z擾
		aryStation  = getStationArrayAll() ;
		aryPosition = getPositionArrayAll();
		aryEra      = getCodeArray(PayrollConst.TID_JAPANESE);
		// aݒ擾
		listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		// Ǖw(v) Up
		aryGender  = getCodeArray(PayrollConst.TID_GENDER);
		aryPltIncomeTaxType  = LegalConst.INCOME_TAX_ARRAY;
		aryPltAdjustmentType = LegalConst.ADJUSTMENT_ARRAY;
		if (cmd.equals(CMD_WITHHOLDING_LIST_ALL)) {
			// VO̎擾
			AdjustmentListVo vo = (AdjustmentListVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear   = vo.getPltReportYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate     = getLastDateOfYear(adjustYear);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			Date date = vo.getDate(String.valueOf(vo.getPltReportYear()), String.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH),  String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<WithholdingListDto> list = getWithholdingList(date, null, vo);
			// [쐬
//			String fileName = vo.getPltReportYear ()
//							+ PayrollConst.FILE_WITHHOLDING_LIST;
//			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
//			// [쐬yѐݒ
//			request.setAttribute(MospConst.ATT_FILE_OBJECT, print(
//					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + template, list));
		} else if (cmd.equals(CMD_WITHHOLDING_LIST_ONE)) {
			// VO̎擾
			AdjustmentReferVo vo = (AdjustmentReferVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear   = vo.getHidAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate     = getLastDateOfYear(adjustYear);
			// ЈR[hNULL
			vo.setLblChangeKCode(vo.getHidKCode());
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾
			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<WithholdingListDto> list = getWithholdingListOne(date, vo.getHidKCode(), vo);
			for(int i= 0; i < list.size(); i++){
				WithholdingListDto dto_tmp = list.get(i);
				if (cfg.getProperty(PayrollConst.PPT_PAY_USEXLS) == null) {
					report(vo, dto_tmp);
				} else {
					reportXls(vo, dto_tmp);
				}
			}
		} else if (cmd.equals(CMD_WITHHOLDING_LIST_ALL2)) {
			// VO̎擾
			AdjustmentCalcVo vo = (AdjustmentCalcVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear   = vo.getHidAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate     = getLastDateOfYear(adjustYear);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾(Ώ۔N12/1)
			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH),  String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<WithholdingListDto> list = getWithholdingList(date, null, vo);
			// [쐬
//			String fileName = vo.getHidAdjustYear ()
//							+ PayrollConst.FILE_WITHHOLDING_LIST;
//			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			// [쐬yѐݒ
//			request.setAttribute(MospConst.ATT_FILE_OBJECT, print(
//					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + template, list));
			
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);	
		}
	}
	
	/**
	 * 򒥎f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<WithholdingListDto> getWithholdingList(
			Date targetMonth, String kCode, MosPVo vo
	) throws Exception {
		// 򒥎[f[^擾
		CdAdjustmentDao   dao = new CdAdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ^ǗҌmF
		confirmPayrollAuth();
		// Nf[^쐬
		List<CdAdjustmentDto> listAdjustment = dao.findForWithholdVote(MospUtility.getYear(targetMonth), kCode);
		// 򒥎[f[^쐬
		List<WithholdingListDto> list = new ArrayList<WithholdingListDto>();
		// Ѓf[^ݒ
		setCompanyDataInfo();
		int j = 0;
		for (Iterator<CdAdjustmentDto> it = listAdjustment.iterator(); it.hasNext();) {
			cdAdjustmentDto = it.next();
			// lݒ
			setHumanInfo(cdAdjustmentDto);
			// ^Aܗ^擾
			setPaymentBonusInfo();
			// Nf[^ݒ
			WithholdingListDto dto = new WithholdingListDto(
					adjustYear      ,
					cdAdjustmentDto ,
					mKihonDto      ,
					mKojinDto      ,
					cmIncomeTaxDto  ,
					cmMidwayEnterDto,
					listPaymentData ,
					listBonusData   ,
					pdPayDeductionDao,
					cmCompanyDto
			);
			// 敪ݒ
			setMonthType(dto);
			// taݒ
			setJapanDate(dto);
			// R[hݒ
			setDtoCodeName(dto);
		
			// Xgɐݒ
			list.add(dto);
			j++;
		}
		// ^f[^mF
		if (list.size() == 0) {
			setVo(vo);
			setUrl(vo.getRetUrl());
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_ADJUST_REPORT, "");
			addErrMessage(errMessage);
			throw new MospException(PayrollConst.EX_NO_PAYMENT_DETAIL, errMessage);
		}
		
		return list;
	}
	
	/**
	 * 򒥎f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<WithholdingListDto> getWithholdingListOne(
			Date targetMonth, String kCode, MosPVo vo
	) throws Exception {
		// 򒥎[f[^擾
		CdAdjustmentDao   dao = new CdAdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ^ǗҌmF
		confirmPayrollAuth();
		// Nf[^쐬
		List<CdAdjustmentDto> listAdjustment = dao.findForWithholdVote(MospUtility.getYear(targetMonth), kCode);
		// 򒥎[f[^쐬
		List<WithholdingListDto> list = new ArrayList<WithholdingListDto>();
		// Ѓf[^ݒ
		setCompanyDataInfo();
		for (Iterator<CdAdjustmentDto> it = listAdjustment.iterator(); it.hasNext();) {
			cdAdjustmentDto = it.next();
		}
		// ^f[^mF
		if (listAdjustment.size() == 0) {
			// 
			cdAdjustmentDto = new CdAdjustmentDto();
			cdAdjustmentDto.setKCode(kCode);
		}
		setVo(vo);
		setUrl(vo.getRetUrl());
		// lݒ
		setHumanInfo(cdAdjustmentDto);
		// ^Aܗ^擾
		setPaymentBonusInfo();
		// Nf[^ݒ
		WithholdingListDto dto = new WithholdingListDto(
				adjustYear      ,
				cdAdjustmentDto ,
				mKihonDto      ,
				mKojinDto      ,
				cmIncomeTaxDto  ,
				cmMidwayEnterDto,
				listPaymentData ,
				listBonusData   ,
				pdPayDeductionDao,
				cmCompanyDto
		);
		// {lݒ
		setWidowType(dto);
		// 敪ݒ
		setMonthType(dto);
		// taݒ
		setJapanDate(dto);
		// R[hݒ
		setDtoCodeName(dto);
		// Xgɐݒ
		list.add(dto);
		
		return list;
	}
	
	/**
	 * {l敪ݒ
	 * @param dto
	 */
	private void setWidowType(WithholdingListDto dto) {
		if (cmIncomeTaxDto != null) {
			String widowType   = cmIncomeTaxDto.getSelfWidowType();
			// Ǖw(v)̏ꍇ͐ʂŔfĐݒAݒȂ̏ꍇ͈ʉǕw
			if (widowType.equals(LegalConst.WIDOW_GENERAL)) {
				dto.setWidow(PayrollConst.ADJ_APPLICABLE);
				// DTOmF
//				if (mKojinDto != null) {
//					String gender = mKojinDto.getGender();
//					// Ǖv
//					if (gender.equals(aryGender[0][0])) {
//						dto.setWidow(PayrollConst.ADJ_APPLICABLE);
//					}
//					// ʉǕw
//					if (gender.equals(aryGender[1][0])) {
//						dto.setGeWidow(PayrollConst.ADJ_APPLICABLE);
//					}
//				} else {
//					// ʂ̐ݒ肪Ȃꍇ͈ʉǕwɐݒ
//					dto.setGeWidow(PayrollConst.ADJ_APPLICABLE);
//				}
			} else if (widowType.equals(LegalConst.WIDOW_SPECIAL)) {
				// ʉǕw
				dto.setSpWidow(PayrollConst.ADJ_APPLICABLE);
			}
		}
	}
	
	/**
	 * 敪ݒ
	 * @param dto
	 */
	private void setMonthType(WithholdingListDto dto) {
		dto.setMonthType_01("1");
		dto.setMonthType_02("2");
		dto.setMonthType_03("3");
		dto.setMonthType_04("4");
		dto.setMonthType_05("5");
		dto.setMonthType_06("6");
		dto.setMonthType_07("7");
		dto.setMonthType_08("8");
		dto.setMonthType_09("9");
		dto.setMonthType_10("10");
		dto.setMonthType_11("11");
		dto.setMonthType_12("12");
		
	}
	
	/**
	 * ^Aܗ^擾
	 * @param vo
	 * @throws Exception 
	 */
	private void setPaymentBonusInfo() throws Exception {
		// vZΏۋ^f[^擾
		listPaymentData = phPaymentDao.findForConditionDate(kCode,targetBefDate, targetAffDate);
		// vZΏۏܗ^f[^擾
		listBonusData = phBonusDao.findForConditionDate(kCode, startAdjDate, lastDate);
		// ^f[^mF
		setTargetPaymentData();
		// Ώۃf[^ŌvZ(o^Ȃ)
		calcTargetIncomeTax(false);
	}
	
	/**
	 * lݒ
	 * @param vo ݒΏVO
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 * @throws MospException 
	 */
	private void setHumanInfo(
			CdAdjustmentDto dto
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		if (dto != null) {
			// ЈR[hݒ
			kCode = dto.getKCode();
			// NŏI𗚗擾ΏیƂĎgp
			Date targetDate = getLastDateOfYear(adjustYear);
			// l{擾
//			mKihonDto = mKihonPayrollDao.findForDate(kCode, targetDate);
			mKihonDto = mKihonPayrollDao.findForKey(kCode);
			if (mKihonDto == null) {
				// l{񂪖ꍇ
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_HUMAN_DATA, "");
				addErrMessage(errMessage);
			}
			// l{ݒ
			// lǗ擾
			mKojinDto       = mKojinDao.findForKey(kCode);
			
			// l^擾
			cmIncomeTaxDto   = cmIncomeTaxDao  .findForEmployeeDate(kCode, targetDate);
			cmMidwayEnterDto = cmMidwayEnterDao.findForKey         (kCode          );
		}
	}
		
	/**
	 * Џݒ
	 * @param dto
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private void setCompanyDataInfo() throws SQLException, IllegalAccessException, NoSuchFieldException {
			CmCompanyDao dao = new CmCompanyDao();
			dao.initDao(cfg, cmd, aspUser, user, conn);
			cmCompanyDto = dao.findAll();
	}
	
	/**
	 * at擾
	 * @param dto
	 * @throws MospException
	 */
	private void setJapanDate(WithholdingListDto dto) throws MospException {
		String strDate[];
		// \pN擾(Ώ۔N)
		if (targetAffDate != null) {
			strDate = getJpImperialCal(listConf, targetAffDate);
			strDate[0]       = getCodeName(strDate[0], aryEra);
			dto.setAdjustYear(strDate[0] + strDate[1]);
			dto.setAdjustYear_YY(strDate[1]);
			
		}
		if (mKojinDto != null) {
			if (mKojinDto.getSeinenbi() != 0) {
				// N
				strDate          = 
					getJpImperialCal(listConf, DatePart.convIntegerDateToDate(mKojinDto.getSeinenbi()));

				strDate[0]       = getCodeName(strDate[0], aryEra);
				dto.setBirthDate(strDate[0] + " " + strDate[1] + PayrollConst.NAM_YEAR + " " +  strDate[2]
				                 + " " + PayrollConst.NAM_MONTH + " " + strDate[3] + PayrollConst.NAM_DAY);
			} else {
				dto.setBirthDate(" " + " " + " " + PayrollConst.NAM_YEAR + " " +  " "
	                    + " " + PayrollConst.NAM_MONTH + " " + " " + PayrollConst.NAM_DAY);

			}
		}
	}
	
	/**
	 * R[h̐ݒ
	 * @param dto
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private void setDtoCodeName(WithholdingListDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException {
		MSyozokuDto mSyozokuDto;		
		MYakusyokuDto mYakusyokuDto;
		String PositionName;
		String StationName;

		// gpDTȌ
		MSyozokuDao mSyozokuDao = new MSyozokuDao();		
		mSyozokuDao.initDao(cfg, cmd, aspUser, user, conn);
		MYakusyokuDao mYakusyokuDao = new MYakusyokuDao(); 
		mYakusyokuDao.initDao(cfg, cmd, aspUser, user, conn);
		
		mSyozokuDto = mSyozokuDao.findForKey(dto.getStationCode());
		if(mSyozokuDto != null){
			StationName  = mSyozokuDto.getSName();
		}else{
			StationName  = "";
		}

		mYakusyokuDto = mYakusyokuDao.findForKey(dto.getPositionCode(), dto.getTouKyu());
		if(mYakusyokuDto != null){
			PositionName  = mYakusyokuDto.getYName();
			}else{
			PositionName  = "";
		}
		
		if (cmIncomeTaxDto != null) {
			// ېŋ敪
			dto.setIncomeTaxType(getCodeName(dto.getIncomeTaxType(), aryPltIncomeTaxType));
			// N敪
			dto.setAdjustmentType(getCodeName(dto.getAdjustmentType(), aryPltAdjustmentType));
		}
		if (mKihonDto != null ) {
			// R[h
			String stationCode = dto.getPositionCode() + " - " + dto.getStationCode();
			// 
			dto.setStationCode(stationCode);
			//dto.setPositionCode("");
			dto.setStationName(StationName);
			dto.setPositionName(PositionName);

		
		}
	}


	/**
	 * [o͏sB(Excel)<br><br>
	 * @throws Exception 
	 */
	private void reportXls(AdjustmentReferVo vo , WithholdingListDto dto) throws Exception {
		int Line;
		int Column;
		int Sum_tmp;
		// RlNV擾
		getConnection();
		// [쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_WITHHOLDINGLIST_XLS);

		// wb_[
		poi.prtItem(     9,  1, dto.getAdjustYear_YY());		// ΏۘaNxNx(gO^Cg)

		Line   = 1;
		poi.prtItem( Line ,  4, dto.getStationName());			// 
		poi.prtItem( Line ,  9, dto.getPositionName());		// E
		poi.prtItem( Line , 17, dto.getPostalCode());			// X֔ԍ
		poi.prtItem( Line , 33, dto.getFName());				// tKi
		poi.prtItem( Line , 42, dto.getKCode());				// ԍ
		
		Line   = 2;
		poi.prtItem( Line , 14, dto.getAddress());				// Z
		poi.prtItem( Line , 33, dto.getKName());				// 		
		
		poi.prtItem(    4 , 33, dto.getBirthDate());			// N		

		/* ^ */
		// xi^j
		Line   = 7;
		Column = 4;
		if(null != dto.getPaymentMonth_01()) poi.prtItem( Line     , Column, dto.getPaymentMonth_01());
		if(null != dto.getPaymentMonth_02()) prtItem_chk( poi, Line +  2, Column, dto.getPaymentMonth_02());
		if(null != dto.getPaymentMonth_03()) prtItem_chk( poi, Line +  4, Column, dto.getPaymentMonth_03());
		if(null != dto.getPaymentMonth_04()) prtItem_chk( poi, Line +  6, Column, dto.getPaymentMonth_04());
		if(null != dto.getPaymentMonth_05()) prtItem_chk( poi, Line +  8, Column, dto.getPaymentMonth_05());
		if(null != dto.getPaymentMonth_06()) prtItem_chk( poi, Line + 10, Column, dto.getPaymentMonth_06());
		if(null != dto.getPaymentMonth_07()) prtItem_chk( poi, Line + 12, Column, dto.getPaymentMonth_07());
		if(null != dto.getPaymentMonth_08()) prtItem_chk( poi, Line + 14, Column, dto.getPaymentMonth_08());
		if(null != dto.getPaymentMonth_09()) prtItem_chk( poi, Line + 16, Column, dto.getPaymentMonth_09());
		if(null != dto.getPaymentMonth_10()) prtItem_chk( poi, Line + 18, Column, dto.getPaymentMonth_10());
		if(null != dto.getPaymentMonth_11()) prtItem_chk( poi, Line + 20, Column, dto.getPaymentMonth_11());
		if(null != dto.getPaymentMonth_12()) prtItem_chk( poi, Line + 22, Column, dto.getPaymentMonth_12());

		// xi^j
		Line   = 7;
		Column = 5;
		if(null != dto.getPaymentPayDay_01()) prtItem_chk( poi, Line     , Column, dto.getPaymentPayDay_01());
		if(null != dto.getPaymentPayDay_02()) prtItem_chk( poi, Line +  2, Column, dto.getPaymentPayDay_02());
		if(null != dto.getPaymentPayDay_03()) prtItem_chk( poi, Line +  4, Column, dto.getPaymentPayDay_03());
		if(null != dto.getPaymentPayDay_04()) prtItem_chk( poi, Line +  6, Column, dto.getPaymentPayDay_04());
		if(null != dto.getPaymentPayDay_05()) prtItem_chk( poi, Line +  8, Column, dto.getPaymentPayDay_05());
		if(null != dto.getPaymentPayDay_06()) prtItem_chk( poi, Line + 10, Column, dto.getPaymentPayDay_06());
		if(null != dto.getPaymentPayDay_07()) prtItem_chk( poi, Line + 12, Column, dto.getPaymentPayDay_07());
		if(null != dto.getPaymentPayDay_08()) prtItem_chk( poi, Line + 14, Column, dto.getPaymentPayDay_08());
		if(null != dto.getPaymentPayDay_09()) prtItem_chk( poi, Line + 16, Column, dto.getPaymentPayDay_09());
		if(null != dto.getPaymentPayDay_10()) prtItem_chk( poi, Line + 18, Column, dto.getPaymentPayDay_10());
		if(null != dto.getPaymentPayDay_11()) prtItem_chk( poi, Line + 20, Column, dto.getPaymentPayDay_11());
		if(null != dto.getPaymentPayDay_12()) prtItem_chk( poi, Line + 22, Column, dto.getPaymentPayDay_12());

		// xzi^j
		Line   = 7;
		Column = 7;
		if(null != dto.getPayTotalAllowance_01()) prtItem_chk( poi, Line     , Column, dto.getPayTotalAllowance_01());
		if(null != dto.getPayTotalAllowance_02()) prtItem_chk( poi, Line +  2, Column, dto.getPayTotalAllowance_02());
		if(null != dto.getPayTotalAllowance_03()) prtItem_chk( poi, Line +  4, Column, dto.getPayTotalAllowance_03());
		if(null != dto.getPayTotalAllowance_04()) prtItem_chk( poi, Line +  6, Column, dto.getPayTotalAllowance_04());
		if(null != dto.getPayTotalAllowance_05()) prtItem_chk( poi, Line +  8, Column, dto.getPayTotalAllowance_05());
		if(null != dto.getPayTotalAllowance_06()) prtItem_chk( poi, Line + 10, Column, dto.getPayTotalAllowance_06());
		if(null != dto.getPayTotalAllowance_07()) prtItem_chk( poi, Line + 12, Column, dto.getPayTotalAllowance_07());
		if(null != dto.getPayTotalAllowance_08()) prtItem_chk( poi, Line + 14, Column, dto.getPayTotalAllowance_08());
		if(null != dto.getPayTotalAllowance_09()) prtItem_chk( poi, Line + 16, Column, dto.getPayTotalAllowance_09());
		if(null != dto.getPayTotalAllowance_10()) prtItem_chk( poi, Line + 18, Column, dto.getPayTotalAllowance_10());
		if(null != dto.getPayTotalAllowance_11()) prtItem_chk( poi, Line + 20, Column, dto.getPayTotalAllowance_11());
		if(null != dto.getPayTotalAllowance_12()) prtItem_chk( poi, Line + 22, Column, dto.getPayTotalAllowance_12());

		// Љی̍Tzi^j
		Line   = 7;
		Column = 10;
		if(null != dto.getPaySocInsDeduction_01()) prtItem_chk( poi, Line     , Column, dto.getPaySocInsDeduction_01());
		if(null != dto.getPaySocInsDeduction_02()) prtItem_chk( poi, Line +  2, Column, dto.getPaySocInsDeduction_02());
		if(null != dto.getPaySocInsDeduction_03()) prtItem_chk( poi, Line +  4, Column, dto.getPaySocInsDeduction_03());
		if(null != dto.getPaySocInsDeduction_04()) prtItem_chk( poi, Line +  6, Column, dto.getPaySocInsDeduction_04());
		if(null != dto.getPaySocInsDeduction_05()) prtItem_chk( poi, Line +  8, Column, dto.getPaySocInsDeduction_05());
		if(null != dto.getPaySocInsDeduction_06()) prtItem_chk( poi, Line + 10, Column, dto.getPaySocInsDeduction_06());
		if(null != dto.getPaySocInsDeduction_07()) prtItem_chk( poi, Line + 12, Column, dto.getPaySocInsDeduction_07());
		if(null != dto.getPaySocInsDeduction_08()) prtItem_chk( poi, Line + 14, Column, dto.getPaySocInsDeduction_08());
		if(null != dto.getPaySocInsDeduction_09()) prtItem_chk( poi, Line + 16, Column, dto.getPaySocInsDeduction_09());
		if(null != dto.getPaySocInsDeduction_10()) prtItem_chk( poi, Line + 18, Column, dto.getPaySocInsDeduction_10());
		if(null != dto.getPaySocInsDeduction_11()) prtItem_chk( poi, Line + 20, Column, dto.getPaySocInsDeduction_11());
		if(null != dto.getPaySocInsDeduction_12()) prtItem_chk( poi, Line + 22, Column, dto.getPaySocInsDeduction_12());

		// ЉیT̋^̋zi^j		
		Line   = 7;
		Column = 12;
		if(null != dto.getPayPayInsDeduction_01()) prtItem_chk( poi, Line     , Column, dto.getPayPayInsDeduction_01());
		if(null != dto.getPayPayInsDeduction_02()) prtItem_chk( poi, Line +  2, Column, dto.getPayPayInsDeduction_02());
		if(null != dto.getPayPayInsDeduction_03()) prtItem_chk( poi, Line +  4, Column, dto.getPayPayInsDeduction_03());
		if(null != dto.getPayPayInsDeduction_04()) prtItem_chk( poi, Line +  6, Column, dto.getPayPayInsDeduction_04());
		if(null != dto.getPayPayInsDeduction_05()) prtItem_chk( poi, Line +  8, Column, dto.getPayPayInsDeduction_05());
		if(null != dto.getPayPayInsDeduction_06()) prtItem_chk( poi, Line + 10, Column, dto.getPayPayInsDeduction_06());
		if(null != dto.getPayPayInsDeduction_07()) prtItem_chk( poi, Line + 12, Column, dto.getPayPayInsDeduction_07());
		if(null != dto.getPayPayInsDeduction_08()) prtItem_chk( poi, Line + 14, Column, dto.getPayPayInsDeduction_08());
		if(null != dto.getPayPayInsDeduction_09()) prtItem_chk( poi, Line + 16, Column, dto.getPayPayInsDeduction_09());
		if(null != dto.getPayPayInsDeduction_10()) prtItem_chk( poi, Line + 18, Column, dto.getPayPayInsDeduction_10());
		if(null != dto.getPayPayInsDeduction_11()) prtItem_chk( poi, Line + 20, Column, dto.getPayPayInsDeduction_11());
		if(null != dto.getPayPayInsDeduction_12()) prtItem_chk( poi, Line + 22, Column, dto.getPayPayInsDeduction_12());
		
		// }{e̐i^j		
		Line   = 7;
		Column = 14;
		if(null != dto.getPayDependentCount_01()) prtItem_chk( poi, Line     , Column, dto.getPayDependentCount_01());
		if(null != dto.getPayDependentCount_02()) prtItem_chk( poi, Line +  2, Column, dto.getPayDependentCount_02());
		if(null != dto.getPayDependentCount_03()) prtItem_chk( poi, Line +  4, Column, dto.getPayDependentCount_03());
		if(null != dto.getPayDependentCount_04()) prtItem_chk( poi, Line +  6, Column, dto.getPayDependentCount_04());
		if(null != dto.getPayDependentCount_05()) prtItem_chk( poi, Line +  8, Column, dto.getPayDependentCount_05());
		if(null != dto.getPayDependentCount_06()) prtItem_chk( poi, Line + 10, Column, dto.getPayDependentCount_06());
		if(null != dto.getPayDependentCount_07()) prtItem_chk( poi, Line + 12, Column, dto.getPayDependentCount_07());
		if(null != dto.getPayDependentCount_08()) prtItem_chk( poi, Line + 14, Column, dto.getPayDependentCount_08());
		if(null != dto.getPayDependentCount_09()) prtItem_chk( poi, Line + 16, Column, dto.getPayDependentCount_09());
		if(null != dto.getPayDependentCount_10()) prtItem_chk( poi, Line + 18, Column, dto.getPayDependentCount_10());
		if(null != dto.getPayDependentCount_11()) prtItem_chk( poi, Line + 20, Column, dto.getPayDependentCount_11());
		if(null != dto.getPayDependentCount_12()) prtItem_chk( poi, Line + 22, Column, dto.getPayDependentCount_12());
		
		// ZoŊziŊzji^j
		Line   = 7;
		Column = 17;
		if(null != dto.getPayIncomeTax_01()) prtItem_chk( poi, Line     , Column, dto.getPayIncomeTax_01());
		if(null != dto.getPayIncomeTax_02()) prtItem_chk( poi, Line +  2, Column, dto.getPayIncomeTax_02());
		if(null != dto.getPayIncomeTax_03()) prtItem_chk( poi, Line +  4, Column, dto.getPayIncomeTax_03());
		if(null != dto.getPayIncomeTax_04()) prtItem_chk( poi, Line +  6, Column, dto.getPayIncomeTax_04());
		if(null != dto.getPayIncomeTax_05()) prtItem_chk( poi, Line +  8, Column, dto.getPayIncomeTax_05());
		if(null != dto.getPayIncomeTax_06()) prtItem_chk( poi, Line + 10, Column, dto.getPayIncomeTax_06());
		if(null != dto.getPayIncomeTax_07()) prtItem_chk( poi, Line + 12, Column, dto.getPayIncomeTax_07());
		if(null != dto.getPayIncomeTax_08()) prtItem_chk( poi, Line + 14, Column, dto.getPayIncomeTax_08());
		if(null != dto.getPayIncomeTax_09()) prtItem_chk( poi, Line + 16, Column, dto.getPayIncomeTax_09());
		if(null != dto.getPayIncomeTax_10()) prtItem_chk( poi, Line + 18, Column, dto.getPayIncomeTax_10());
		if(null != dto.getPayIncomeTax_11()) prtItem_chk( poi, Line + 20, Column, dto.getPayIncomeTax_11());
		if(null != dto.getPayIncomeTax_12()) prtItem_chk( poi, Line + 22, Column, dto.getPayIncomeTax_12());
		
		// NɂߕsŊzi^j
		Line   = 7;
		Column = 21;
		if(null != dto.getPayAdjCalcGap_01()) prtItem_chk( poi, Line     , Column, dto.getPayAdjCalcGap_01());
		if(null != dto.getPayAdjCalcGap_02()) prtItem_chk( poi, Line +  2, Column, dto.getPayAdjCalcGap_02());
		if(null != dto.getPayAdjCalcGap_03()) prtItem_chk( poi, Line +  4, Column, dto.getPayAdjCalcGap_03());
		if(null != dto.getPayAdjCalcGap_04()) prtItem_chk( poi, Line +  6, Column, dto.getPayAdjCalcGap_04());
		if(null != dto.getPayAdjCalcGap_05()) prtItem_chk( poi, Line +  8, Column, dto.getPayAdjCalcGap_05());
		if(null != dto.getPayAdjCalcGap_06()) prtItem_chk( poi, Line + 10, Column, dto.getPayAdjCalcGap_06());
		if(null != dto.getPayAdjCalcGap_07()) prtItem_chk( poi, Line + 12, Column, dto.getPayAdjCalcGap_07());
		if(null != dto.getPayAdjCalcGap_08()) prtItem_chk( poi, Line + 14, Column, dto.getPayAdjCalcGap_08());
		if(null != dto.getPayAdjCalcGap_09()) prtItem_chk( poi, Line + 16, Column, dto.getPayAdjCalcGap_09());
		if(null != dto.getPayAdjCalcGap_10()) prtItem_chk( poi, Line + 18, Column, dto.getPayAdjCalcGap_10());
		if(null != dto.getPayAdjCalcGap_11()) prtItem_chk( poi, Line + 20, Column, dto.getPayAdjCalcGap_11());
		if(null != dto.getPayAdjCalcGap_12()) prtItem_chk( poi, Line + 22, Column, dto.getPayAdjCalcGap_12());
		
		// Ŋzi^j		
		Line   = 7;
		Column = 23;
		if(null != dto.getPayPaymentTax_01()) prtItem_chk( poi, Line +  0, Column, dto.getPayPaymentTax_01());
		if(null != dto.getPayPaymentTax_02()) prtItem_chk( poi, Line +  2, Column, dto.getPayPaymentTax_02());
		if(null != dto.getPayPaymentTax_03()) prtItem_chk( poi, Line +  4, Column, dto.getPayPaymentTax_03());
		if(null != dto.getPayPaymentTax_04()) prtItem_chk( poi, Line +  6, Column, dto.getPayPaymentTax_04());
		if(null != dto.getPayPaymentTax_05()) prtItem_chk( poi, Line +  8, Column, dto.getPayPaymentTax_05());
		if(null != dto.getPayPaymentTax_06()) prtItem_chk( poi, Line + 10, Column, dto.getPayPaymentTax_06());
		if(null != dto.getPayPaymentTax_07()) prtItem_chk( poi, Line + 12, Column, dto.getPayPaymentTax_07());
		if(null != dto.getPayPaymentTax_08()) prtItem_chk( poi, Line + 14, Column, dto.getPayPaymentTax_08());
		if(null != dto.getPayPaymentTax_09()) prtItem_chk( poi, Line + 16, Column, dto.getPayPaymentTax_09());
		if(null != dto.getPayPaymentTax_10()) prtItem_chk( poi, Line + 18, Column, dto.getPayPaymentTax_10());
		if(null != dto.getPayPaymentTax_11()) prtItem_chk( poi, Line + 20, Column, dto.getPayPaymentTax_11());
		if(null != dto.getPayPaymentTax_12()) prtItem_chk( poi, Line + 22, Column, dto.getPayPaymentTax_12());

		Line   = 31;
		prtItem_chk( poi, Line ,   7, dto.getTotalPayTotalAllowance());		// xzvi^j
		prtItem_chk( poi, Line ,  10, dto.getTotalPaySocInsDeduction());		// ^Љیvi^j
		prtItem_chk( poi, Line ,  12, dto.getTotalPayPayInsDeduction());		// ^ЉیT̋^̋zvi^j
		prtItem_chk( poi, Line ,  17, dto.getTotalPayIncomeTax());			// ^ōvi^j
		prtItem_chk( poi, Line ,  21, dto.getTotalPayAdjCalcGap());			// ^Nɂߕsvi^j
		prtItem_chk( poi, Line ,  23, dto.getTotalPayIncomeTax() + dto.getTotalPayAdjCalcGap()); // Ŋzi^j		

		/* ܗ^ */
		// xiܗ^j
		Line   = 33;
		Column = 3;
		if(null != dto.getBonusMonth_01())   prtItem_chk( poi, Line +  0, Column, dto.getBonusMonth_01());
		if(null != dto.getBonusMonth_02())   prtItem_chk( poi, Line +  2, Column, dto.getBonusMonth_02());
		if(null != dto.getBonusMonth_03())   prtItem_chk( poi, Line +  4, Column, dto.getBonusMonth_03());
		if(null != dto.getBonusMonth_04())   prtItem_chk( poi, Line +  6, Column, dto.getBonusMonth_04());
		if(null != dto.getBonusMonth_05())   prtItem_chk( poi, Line +  8, Column, dto.getBonusMonth_05());
//		if(null != dto.getBonusMonth_06())   prtItem_chk( poi, Line + 10, Column, dto.getBonusMonth_06());
		Column = 4;
		if(null != dto.getBonusMonth_01())   prtItem_chk( poi, Line +  0, Column, dto.getBonusMonth_01());
		if(null != dto.getBonusMonth_02())   prtItem_chk( poi, Line +  2, Column, dto.getBonusMonth_02());
		if(null != dto.getBonusMonth_03())   prtItem_chk( poi, Line +  4, Column, dto.getBonusMonth_03());
		if(null != dto.getBonusMonth_04())   prtItem_chk( poi, Line +  6, Column, dto.getBonusMonth_04());
		if(null != dto.getBonusMonth_05())   prtItem_chk( poi, Line +  8, Column, dto.getBonusMonth_05());
//		if(null != dto.getBonusMonth_06())   prtItem_chk( poi, Line + 10, Column, dto.getBonusMonth_06());

		// xiܗ^j
		Column = 5;
		if(null != dto.getBonusPayDay_01())  prtItem_chk( poi, Line +  0, Column,  dto.getBonusPayDay_01());
		if(null != dto.getBonusPayDay_02())  prtItem_chk( poi, Line +  2, Column,  dto.getBonusPayDay_02());
		if(null != dto.getBonusPayDay_03())  prtItem_chk( poi, Line +  4, Column,  dto.getBonusPayDay_03());
		if(null != dto.getBonusPayDay_04())  prtItem_chk( poi, Line +  6, Column,  dto.getBonusPayDay_04());
		if(null != dto.getBonusPayDay_05())  prtItem_chk( poi, Line +  8, Column,  dto.getBonusPayDay_05());
//		if(null != dto.getBonusPayDay_06())  prtItem_chk( poi, Line + 10, Column,  dto.getBonusPayDay_06());

		//xziܗ^j
		Line   = 33;
		Column = 7;
		if(null != dto.getBonTotalAllowance_01())  prtItem_chk( poi, Line +  0, Column,   dto.getBonTotalAllowance_01());
		if(null != dto.getBonTotalAllowance_02())  prtItem_chk( poi, Line +  2, Column,   dto.getBonTotalAllowance_02());
		if(null != dto.getBonTotalAllowance_03())  prtItem_chk( poi, Line +  4, Column,   dto.getBonTotalAllowance_03());
		if(null != dto.getBonTotalAllowance_04())  prtItem_chk( poi, Line +  6, Column,   dto.getBonTotalAllowance_04());
		if(null != dto.getBonTotalAllowance_05())  prtItem_chk( poi, Line +  8, Column,   dto.getBonTotalAllowance_05());
//		if(null != dto.getBonTotalAllowance_06())  prtItem_chk( poi, Line + 10, Column,   dto.getBonTotalAllowance_06());

		// 
		// Љی̍Tziܗ^j
		Line   = 33;
		Column = 10;
		if(null != dto.getBonSocInsDeduction_01())  prtItem_chk( poi, Line +  0, Column,   dto.getBonSocInsDeduction_01());
		if(null != dto.getBonSocInsDeduction_02())  prtItem_chk( poi, Line +  2, Column,   dto.getBonSocInsDeduction_02());
		if(null != dto.getBonSocInsDeduction_03())  prtItem_chk( poi, Line +  4, Column,   dto.getBonSocInsDeduction_03());
		if(null != dto.getBonSocInsDeduction_04())  prtItem_chk( poi, Line +  6, Column,   dto.getBonSocInsDeduction_04());
		if(null != dto.getBonSocInsDeduction_05())  prtItem_chk( poi, Line +  8, Column,   dto.getBonSocInsDeduction_05());
//		if(null != dto.getBonSocInsDeduction_06())  prtItem_chk( poi, Line + 10, Column,   dto.getBonSocInsDeduction_06());
		
		// ЉیT̋^̋ziܗ^j		
		Line   = 33;
		Column = 12;
		if(null != dto.getBonPayInsDeduction_01()) prtItem_chk( poi, Line +  0, Column,   dto.getBonPayInsDeduction_01());
		if(null != dto.getBonPayInsDeduction_02()) prtItem_chk( poi, Line +  2, Column,   dto.getBonPayInsDeduction_02());
		if(null != dto.getBonPayInsDeduction_03()) prtItem_chk( poi, Line +  4, Column,   dto.getBonPayInsDeduction_03());
		if(null != dto.getBonPayInsDeduction_04()) prtItem_chk( poi, Line +  6, Column,   dto.getBonPayInsDeduction_04());
		if(null != dto.getBonPayInsDeduction_05()) prtItem_chk( poi, Line +  8, Column,   dto.getBonPayInsDeduction_05());
//		if(null != dto.getBonPayInsDeduction_06()) prtItem_chk( poi, Line + 10, Column,   dto.getBonPayInsDeduction_06());
		
		// }{e̐iܗ^j
		Line   = 33;
		Column = 14;
		if(null != dto.getBonDependentCount_01()) prtItem_chk( poi, Line +  0, Column,   dto.getBonDependentCount_01());
		if(null != dto.getBonDependentCount_02()) prtItem_chk( poi, Line +  2, Column,   dto.getBonDependentCount_02());
		if(null != dto.getBonDependentCount_03()) prtItem_chk( poi, Line +  4, Column,   dto.getBonDependentCount_03());
		if(null != dto.getBonDependentCount_04()) prtItem_chk( poi, Line +  6, Column,   dto.getBonDependentCount_04());
		if(null != dto.getBonDependentCount_05()) prtItem_chk( poi, Line +  8, Column,   dto.getBonDependentCount_05());
//		if(null != dto.getBonDependentCount_06()) prtItem_chk( poi, Line + 10, Column,   dto.getBonDependentCount_06());
		
		// ZoŊziŊzjiܗ^j
		Line   = 34;
		Column = 17;
		if(null != dto.getBonIncomeTax_01()) prtItem_chk( poi, Line +  0, Column,   dto.getBonIncomeTax_01());
		if(null != dto.getBonIncomeTax_02()) prtItem_chk( poi, Line +  2, Column,   dto.getBonIncomeTax_02());
		if(null != dto.getBonIncomeTax_03()) prtItem_chk( poi, Line +  4, Column,   dto.getBonIncomeTax_03());
		if(null != dto.getBonIncomeTax_04()) prtItem_chk( poi, Line +  6, Column,   dto.getBonIncomeTax_04());
		if(null != dto.getBonIncomeTax_05()) prtItem_chk( poi, Line +  8, Column,   dto.getBonIncomeTax_05());
//		if(null != dto.getBonIncomeTax_06()) prtItem_chk( poi, Line + 10, Column,   dto.getBonIncomeTax_06());
		
		
		// NɂߕsŊziܗ^j
		Line   = 33;
		Column = 21;
		if(null != dto.getBonAdjCalcGap_01()) prtItem_chk( poi, Line +  0, Column,   dto.getBonAdjCalcGap_01());
		if(null != dto.getBonAdjCalcGap_02()) prtItem_chk( poi, Line +  2, Column,   dto.getBonAdjCalcGap_02());
		if(null != dto.getBonAdjCalcGap_03()) prtItem_chk( poi, Line +  4, Column,   dto.getBonAdjCalcGap_03());
		if(null != dto.getBonAdjCalcGap_04()) prtItem_chk( poi, Line +  6, Column,   dto.getBonAdjCalcGap_04());
		if(null != dto.getBonAdjCalcGap_05()) prtItem_chk( poi, Line +  8, Column,   dto.getBonAdjCalcGap_05());
//		if(null != dto.getBonAdjCalcGap_06()) prtItem_chk( poi, Line + 10, Column,   dto.getBonAdjCalcGap_06());
		
		// Ŋziܗ^j		
		Line   = 33;
		Column = 23;
		if(null != dto.getBonPaymentTax_01()) prtItem_chk( poi, Line +  0, Column, dto.getBonPaymentTax_01());
		if(null != dto.getBonPaymentTax_02()) prtItem_chk( poi, Line +  2, Column, dto.getBonPaymentTax_02());
		if(null != dto.getBonPaymentTax_03()) prtItem_chk( poi, Line +  4, Column, dto.getBonPaymentTax_03());
		if(null != dto.getBonPaymentTax_04()) prtItem_chk( poi, Line +  6, Column, dto.getBonPaymentTax_04());
		if(null != dto.getBonPaymentTax_05()) prtItem_chk( poi, Line +  8, Column, dto.getBonPaymentTax_05());
//		if(null != dto.getBonPaymentTax_06()) prtItem_chk( poi, Line + 10, Column, dto.getBonPaymentTax_06());

		// Őŗ
		Line   = 33;
		Column = 18;
		if(null != dto.getBonIncomeTaxRate_01()) prtItem_chk( poi, Line +  0, Column, dto.getBonIncomeTaxRate_01());
		if(null != dto.getBonIncomeTaxRate_02()) prtItem_chk( poi, Line +  2, Column, dto.getBonIncomeTaxRate_02());
		if(null != dto.getBonIncomeTaxRate_03()) prtItem_chk( poi, Line +  4, Column, dto.getBonIncomeTaxRate_03());
		if(null != dto.getBonIncomeTaxRate_04()) prtItem_chk( poi, Line +  6, Column, dto.getBonIncomeTaxRate_04());
		if(null != dto.getBonIncomeTaxRate_05()) prtItem_chk( poi, Line +  8, Column, dto.getBonIncomeTaxRate_05());
//		if(null != dto.getBonIncomeTaxRate_06()) prtItem_chk( poi, Line + 10, Column, dto.getBonIncomeTaxRate_06());
		
		Line   = 43;
		prtItem_chk( poi, Line ,   7, dto.getTotalBonTotalAllowance());	// xzviܗ^j
		prtItem_chk( poi, Line ,  10, dto.getTotalBonSocInsDeduction());	//^Љیviܗ^j
		prtItem_chk( poi, Line ,  12, dto.getTotalBonPayInsDeduction());	// ^ЉیT̋^̋zviܗ^j
		prtItem_chk( poi, Line ,  17, dto.getTotalBonIncomeTax());			// ^ōviܗ^j
		prtItem_chk( poi, Line ,  21, dto.getTotalBonAdjCalcGap());		// ^Nɂߕsv
		prtItem_chk( poi, Line ,  23, dto.getTotalBonIncomeTax() + dto.getTotalBonAdjCalcGap()); // Ŋziܗ^j		

		/* ONJz */
		Line   = 7;
		prtItem_chk( poi, Line ,  31, 0);	// ҕt͒Ŋz F0
		prtItem_chk( poi, Line ,  35, 0);	// c F0
		prtItem_chk( poi, Line ,  40, 0);	// ҕt͒Ŋz		
		prtItem_chk( poi, Line ,  43, 0);	// c

		/* }{T̐\ */
		// }{e		
		Line   = 12;
		if(null != dto.	getGeneralDependent()) prtItem_chk( poi, Line ,  31, dto.getGeneralDependent());	// ҕt͒Ŋz F0
		if((null != dto.getSpouseGe()) && (dto.getSpouseGe().equals(PayrollConst.ADJ_APPLICABLE))){	// TΏ۔z(ʔzҁȋjL)
			prtItem_chk( poi, Line ,  28, PayrollConst.PRESENCE_ON);
		}else{
			prtItem_chk( poi, Line ,  28, PayrollConst.PRESENCE_OFF);
		}
		if((null != dto.getSpouseEl()) && (dto.getSpouseEl().equals(PayrollConst.ADJ_APPLICABLE))){	// TΏ۔z(VlzҗL)
			prtItem_chk( poi, Line ,  30, PayrollConst.PRESENCE_ON);
		}else{
			prtItem_chk( poi, Line ,  30, PayrollConst.PRESENCE_OFF);
		}
		if(null !=  dto.getGeneralDependent())	prtItem_chk( poi, Line ,  31, dto.getGeneralDependent());	// ʂ̕}{e		
		if(null !=  dto.getSpecificDependent())	prtItem_chk( poi, Line ,  33, dto.getSpecificDependent());	// }{e	
		if(null !=  dto.getLiveWithEldRel())	prtItem_chk( poi, Line ,  35, dto.getLiveWithEldRel());		// Vl}{e(Ve)
		if(null !=  dto.getElderlyDependent())	prtItem_chk( poi, Line ,  37, dto.getElderlyDependent());	// Vl}{e(̑)
		if(null !=  dto.getTotallHandicap())	prtItem_chk( poi, Line ,  39, dto.getTotallHandicap());		// QҌv		

		if(null !=  dto.getTotallDeduction())	prtItem_chk( poi,   14 ,  43, dto.getTotallDeduction());		// ]鋋^TΏ۔z҂ƕ}{e̍v
		if(null !=  dto.getConsortFlg())		prtItem_chk( poi,   15 ,  45, dto.getConsortFlg());			// z҂̗L

		/* N */
		Line   = 18;
		prtItem_chk( poi, Line +  0 , 35, dto.getTotalPayTotalAllowance());		// ^E蓖Fz
		prtItem_chk( poi, Line +  0 , 41, dto.getTotalPayIncomeTax());			// ^E蓖FŊz
		prtItem_chk( poi, Line +  1 , 35, dto.getTotalBonTotalAllowance());		// ܗ^Fz
		prtItem_chk( poi, Line +  1 , 41, dto.getTotalBonIncomeTax());			// ܗ^FŊz
		prtItem_chk( poi, Line +  2 , 35, dto.getTotalAllowance());				// zv
		prtItem_chk( poi, Line +  2 , 41, dto.getIncomeTax());					// Ŋzv
		Column = 35;
		prtItem_chk( poi, Line +  3 , Column , dto.getAfterDeductIncome());		// ^T̋^̋z	
		prtItem_chk( poi, Line +  4 , Column , dto.getPayInsDeduction());		// ЉیTzF^̍T
		prtItem_chk( poi, Line +  5 , Column , 0 );								// ЉیTzF\ɂЉی̍T(:0)
		prtItem_chk( poi, Line +  6 , Column , 0 );								// ЉیTzF\ɂ鏬K͊Ƌϓ|̍T(:0)
		prtItem_chk( poi, Line +  8 , Column , dto.getLifeInsDeduction());		// ی̍Tz
		prtItem_chk( poi, Line +  9 , Column , dto.getEarthquakeIns());			// nkی̍Tz
		prtItem_chk( poi, Line + 10 , Column , dto.getSpouseSpDeduction());		// zғʍTz
		prtItem_chk( poi, Line + 11 , Column , dto.getDependentsDeduction());	// zҍTzA}{TzAbTzyяQғ̍Tz̍vz

		// Tz̍v
		Sum_tmp = dto.getPayInsDeduction() + dto.getLifeInsDeduction() + dto.getEarthquakeIns() + dto.getSpouseSpDeduction() + dto.getDependentsDeduction();
		prtItem_chk( poi, Line + 13 , 35, Sum_tmp );								// Tz̍vz
		// ېŋ^		
		Sum_tmp = (int)round( dto.getAfterDeductIncome() - Sum_tmp, -3, BigDecimal.ROUND_DOWN);
		prtItem_chk( poi, Line + 16 , 35, Sum_tmp );								// ېŋ^z

		Line   = 22;
		Column = 41;
		prtItem_chk( poi, Line +  0 , Column , dto.getSpouseSumIncome());		// z҂̍vz		
		prtItem_chk( poi, Line +  2 , Column , dto.getPrivatePension());			// lNیxz		
		prtItem_chk( poi, Line +  4 , Column , dto.getLongTermDamageIns()); 		// Qیxz					
		prtItem_chk( poi, Line +  7 , Column , dto.getMutualAidDeduction());		// K͊Ƌϓ|̋z					
		prtItem_chk( poi, Line + 10 , Column , 0 );								// Nی					
		prtItem_chk( poi, Line + 12 , Column , dto.getCalcIncomeTax());			// ZoNŊz
		prtItem_chk( poi, Line + 13 , Column , dto.getHouseLoanDeduction());		// ZؓʍTz
		prtItem_chk( poi, Line + 14 , Column , dto.getAdjustedIncomeTax());		// NNŊz		

		// z
		int Sum_tmp_sashihiki = dto.getAdjustedIncomeTax() - dto.getIncomeTax();
		prtItem_chk( poi, Line + 15 , Column , Sum_tmp_sashihiki);							// z
		if(0 < Sum_tmp_sashihiki ){
			prtItem_chk( poi, Line + 15 , 29 , PayrollConst.BALANCE_LOW);		// Fsz
		}else{
			prtItem_chk( poi, Line + 15 , 29 , PayrollConst.BALANCE_OVER);		// Fߊz
		}

		Line   = 38;
		Column = 41;
		prtItem_chk( poi, Line +  0 , Column , 0);		// {NŌ̋^璥Ŋzɏ[z
		prtItem_chk( poi, Line +  1 , Column , 0);		// ^ɌW関̐Ŋzɏ[z
		
		// ҕtz
		// izj|i{NŌ̋^璥Ŋzɏ[zj|i^ɌW関̐Ŋzɏ[zj
		Sum_tmp = Sum_tmp_sashihiki - 0 - 0;
		prtItem_chk( poi, Line +  2 , Column , Sum_tmp);		// ҕtz
		prtItem_chk( poi, Line +  3 , Column , Sum_tmp);		// {NɊҕtz
		prtItem_chk( poi, Line +  3 , Column , 0);			// NɂĊҕtz
		prtItem_chk( poi, Line +  4 , Column , 0);			// {NŌ̋^璥z
		prtItem_chk( poi, Line +  5 , Column , 0);			// NɌJzĒz
		
		// o͓eݒ
		String fileName = String.valueOf(vo.getHidAdjustYear()) + 
										PayrollConst.FILE_NAME_SEPARATOR +
										dto.getKCode()	+
										PayrollConst.FILE_NAME_SEPARATOR +
										PayrollConst.FILE_WITHHOLDINGLIST_XLS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}


	/**
	 * [o͏sB(OpenOffice Calc)<br><br>
	 * @throws Exception 
	 */
	private void report(AdjustmentReferVo vo , WithholdingListDto dto) throws Exception {
		int Line;
		int Column;
		int Sum_tmp;

		// RlNV擾
		getConnection();
		// [쐬
		OdsBean odsBean = new OdsBean(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_WITHHOLDINGLIST_ODS);

		// wb_[
		odsBean.setValue(     1,  9, dto.getAdjustYear_YY());		// ΏۘaNxNx(gO^Cg)

		Line   = 1;
		setValue_chk( odsBean,  4, Line , dto.getStationName());			// 
		setValue_chk( odsBean,  9, Line , dto.getPositionName());		// E
		setValue_chk( odsBean, 17, Line , dto.getPostalCode());			// X֔ԍ
		setValue_chk( odsBean, 33, Line , dto.getFName());				// tKi
		setValue_chk( odsBean, 42, Line , dto.getKCode());				// ԍ
		
		Line   = 2;
		setValue_chk( odsBean, 14, Line , dto.getAddress());				// Z
		setValue_chk( odsBean, 33, Line , dto.getKName());				// 		
		
		setValue_chk( odsBean, 33 ,  4, dto.getBirthDate());			// N		

		/* ^ */
		// xi^j
		Line   = 7;
		Column = 4;
		if(null != dto.getPaymentMonth_01()) setValue_chk( odsBean, Column, Line     , dto.getPaymentMonth_01());
		if(null != dto.getPaymentMonth_02()) setValue_chk( odsBean, Column, Line +  2, dto.getPaymentMonth_02());
		if(null != dto.getPaymentMonth_03()) setValue_chk( odsBean, Column, Line +  4, dto.getPaymentMonth_03());
		if(null != dto.getPaymentMonth_04()) setValue_chk( odsBean, Column, Line +  6, dto.getPaymentMonth_04());
		if(null != dto.getPaymentMonth_05()) setValue_chk( odsBean, Column, Line +  8, dto.getPaymentMonth_05());
		if(null != dto.getPaymentMonth_06()) setValue_chk( odsBean, Column, Line + 10, dto.getPaymentMonth_06());
		if(null != dto.getPaymentMonth_07()) setValue_chk( odsBean, Column, Line + 12, dto.getPaymentMonth_07());
		if(null != dto.getPaymentMonth_08()) setValue_chk( odsBean, Column, Line + 14, dto.getPaymentMonth_08());
		if(null != dto.getPaymentMonth_09()) setValue_chk( odsBean, Column, Line + 16, dto.getPaymentMonth_09());
		if(null != dto.getPaymentMonth_10()) setValue_chk( odsBean, Column, Line + 18, dto.getPaymentMonth_10());
		if(null != dto.getPaymentMonth_11()) setValue_chk( odsBean, Column, Line + 20, dto.getPaymentMonth_11());
		if(null != dto.getPaymentMonth_12()) setValue_chk( odsBean, Column, Line + 22, dto.getPaymentMonth_12());

		// xi^j
		Line   = 7;
		Column = 5;
		if(null != dto.getPaymentPayDay_01()) setValue_chk( odsBean, Column, Line     , dto.getPaymentPayDay_01());
		if(null != dto.getPaymentPayDay_02()) setValue_chk( odsBean, Column, Line +  2, dto.getPaymentPayDay_02());
		if(null != dto.getPaymentPayDay_03()) setValue_chk( odsBean, Column, Line +  4, dto.getPaymentPayDay_03());
		if(null != dto.getPaymentPayDay_04()) setValue_chk( odsBean, Column, Line +  6, dto.getPaymentPayDay_04());
		if(null != dto.getPaymentPayDay_05()) setValue_chk( odsBean, Column, Line +  8, dto.getPaymentPayDay_05());
		if(null != dto.getPaymentPayDay_06()) setValue_chk( odsBean, Column, Line + 10, dto.getPaymentPayDay_06());
		if(null != dto.getPaymentPayDay_07()) setValue_chk( odsBean, Column, Line + 12, dto.getPaymentPayDay_07());
		if(null != dto.getPaymentPayDay_08()) setValue_chk( odsBean, Column, Line + 14, dto.getPaymentPayDay_08());
		if(null != dto.getPaymentPayDay_09()) setValue_chk( odsBean, Column, Line + 16, dto.getPaymentPayDay_09());
		if(null != dto.getPaymentPayDay_10()) setValue_chk( odsBean, Column, Line + 18, dto.getPaymentPayDay_10());
		if(null != dto.getPaymentPayDay_11()) setValue_chk( odsBean, Column, Line + 20, dto.getPaymentPayDay_11());
		if(null != dto.getPaymentPayDay_12()) setValue_chk( odsBean, Column, Line + 22, dto.getPaymentPayDay_12());

		// xzi^j
		Line   = 7;
		Column = 7;
		if(null != dto.getPayTotalAllowance_01()) setValue_chk( odsBean, Column, Line     , dto.getPayTotalAllowance_01());
		if(null != dto.getPayTotalAllowance_02()) setValue_chk( odsBean, Column, Line +  2, dto.getPayTotalAllowance_02());
		if(null != dto.getPayTotalAllowance_03()) setValue_chk( odsBean, Column, Line +  4, dto.getPayTotalAllowance_03());
		if(null != dto.getPayTotalAllowance_04()) setValue_chk( odsBean, Column, Line +  6, dto.getPayTotalAllowance_04());
		if(null != dto.getPayTotalAllowance_05()) setValue_chk( odsBean, Column, Line +  8, dto.getPayTotalAllowance_05());
		if(null != dto.getPayTotalAllowance_06()) setValue_chk( odsBean, Column, Line + 10, dto.getPayTotalAllowance_06());
		if(null != dto.getPayTotalAllowance_07()) setValue_chk( odsBean, Column, Line + 12, dto.getPayTotalAllowance_07());
		if(null != dto.getPayTotalAllowance_08()) setValue_chk( odsBean, Column, Line + 14, dto.getPayTotalAllowance_08());
		if(null != dto.getPayTotalAllowance_09()) setValue_chk( odsBean, Column, Line + 16, dto.getPayTotalAllowance_09());
		if(null != dto.getPayTotalAllowance_10()) setValue_chk( odsBean, Column, Line + 18, dto.getPayTotalAllowance_10());
		if(null != dto.getPayTotalAllowance_11()) setValue_chk( odsBean, Column, Line + 20, dto.getPayTotalAllowance_11());
		if(null != dto.getPayTotalAllowance_12()) setValue_chk( odsBean, Column, Line + 22, dto.getPayTotalAllowance_12());

		// Љی̍Tzi^j
		Line   = 7;
		Column = 10;
		if(null != dto.getPaySocInsDeduction_01()) setValue_chk( odsBean, Column, Line     , dto.getPaySocInsDeduction_01());
		if(null != dto.getPaySocInsDeduction_02()) setValue_chk( odsBean, Column, Line +  2, dto.getPaySocInsDeduction_02());
		if(null != dto.getPaySocInsDeduction_03()) setValue_chk( odsBean, Column, Line +  4, dto.getPaySocInsDeduction_03());
		if(null != dto.getPaySocInsDeduction_04()) setValue_chk( odsBean, Column, Line +  6, dto.getPaySocInsDeduction_04());
		if(null != dto.getPaySocInsDeduction_05()) setValue_chk( odsBean, Column, Line +  8, dto.getPaySocInsDeduction_05());
		if(null != dto.getPaySocInsDeduction_06()) setValue_chk( odsBean, Column, Line + 10, dto.getPaySocInsDeduction_06());
		if(null != dto.getPaySocInsDeduction_07()) setValue_chk( odsBean, Column, Line + 12, dto.getPaySocInsDeduction_07());
		if(null != dto.getPaySocInsDeduction_08()) setValue_chk( odsBean, Column, Line + 14, dto.getPaySocInsDeduction_08());
		if(null != dto.getPaySocInsDeduction_09()) setValue_chk( odsBean, Column, Line + 16, dto.getPaySocInsDeduction_09());
		if(null != dto.getPaySocInsDeduction_10()) setValue_chk( odsBean, Column, Line + 18, dto.getPaySocInsDeduction_10());
		if(null != dto.getPaySocInsDeduction_11()) setValue_chk( odsBean, Column, Line + 20, dto.getPaySocInsDeduction_11());
		if(null != dto.getPaySocInsDeduction_12()) setValue_chk( odsBean, Column, Line + 22, dto.getPaySocInsDeduction_12());

		// ЉیT̋^̋zi^j		
		Line   = 7;
		Column = 12;
		if(null != dto.getPayPayInsDeduction_01()) setValue_chk( odsBean, Column, Line     , dto.getPayPayInsDeduction_01());
		if(null != dto.getPayPayInsDeduction_02()) setValue_chk( odsBean, Column, Line +  2, dto.getPayPayInsDeduction_02());
		if(null != dto.getPayPayInsDeduction_03()) setValue_chk( odsBean, Column, Line +  4, dto.getPayPayInsDeduction_03());
		if(null != dto.getPayPayInsDeduction_04()) setValue_chk( odsBean, Column, Line +  6, dto.getPayPayInsDeduction_04());
		if(null != dto.getPayPayInsDeduction_05()) setValue_chk( odsBean, Column, Line +  8, dto.getPayPayInsDeduction_05());
		if(null != dto.getPayPayInsDeduction_06()) setValue_chk( odsBean, Column, Line + 10, dto.getPayPayInsDeduction_06());
		if(null != dto.getPayPayInsDeduction_07()) setValue_chk( odsBean, Column, Line + 12, dto.getPayPayInsDeduction_07());
		if(null != dto.getPayPayInsDeduction_08()) setValue_chk( odsBean, Column, Line + 14, dto.getPayPayInsDeduction_08());
		if(null != dto.getPayPayInsDeduction_09()) setValue_chk( odsBean, Column, Line + 16, dto.getPayPayInsDeduction_09());
		if(null != dto.getPayPayInsDeduction_10()) setValue_chk( odsBean, Column, Line + 18, dto.getPayPayInsDeduction_10());
		if(null != dto.getPayPayInsDeduction_11()) setValue_chk( odsBean, Column, Line + 20, dto.getPayPayInsDeduction_11());
		if(null != dto.getPayPayInsDeduction_12()) setValue_chk( odsBean, Column, Line + 22, dto.getPayPayInsDeduction_12());
		
		// }{e̐i^j		
		Line   = 7;
		Column = 14;
		if(null != dto.getPayDependentCount_01()) setValue_chk( odsBean, Column, Line     , dto.getPayDependentCount_01());
		if(null != dto.getPayDependentCount_02()) setValue_chk( odsBean, Column, Line +  2, dto.getPayDependentCount_02());
		if(null != dto.getPayDependentCount_03()) setValue_chk( odsBean, Column, Line +  4, dto.getPayDependentCount_03());
		if(null != dto.getPayDependentCount_04()) setValue_chk( odsBean, Column, Line +  6, dto.getPayDependentCount_04());
		if(null != dto.getPayDependentCount_05()) setValue_chk( odsBean, Column, Line +  8, dto.getPayDependentCount_05());
		if(null != dto.getPayDependentCount_06()) setValue_chk( odsBean, Column, Line + 10, dto.getPayDependentCount_06());
		if(null != dto.getPayDependentCount_07()) setValue_chk( odsBean, Column, Line + 12, dto.getPayDependentCount_07());
		if(null != dto.getPayDependentCount_08()) setValue_chk( odsBean, Column, Line + 14, dto.getPayDependentCount_08());
		if(null != dto.getPayDependentCount_09()) setValue_chk( odsBean, Column, Line + 16, dto.getPayDependentCount_09());
		if(null != dto.getPayDependentCount_10()) setValue_chk( odsBean, Column, Line + 18, dto.getPayDependentCount_10());
		if(null != dto.getPayDependentCount_11()) setValue_chk( odsBean, Column, Line + 20, dto.getPayDependentCount_11());
		if(null != dto.getPayDependentCount_12()) setValue_chk( odsBean, Column, Line + 22, dto.getPayDependentCount_12());
		
		// ZoŊziŊzji^j
		Line   = 7;
		Column = 17;
		if(null != dto.getPayIncomeTax_01()) setValue_chk( odsBean, Column, Line     , dto.getPayIncomeTax_01());
		if(null != dto.getPayIncomeTax_02()) setValue_chk( odsBean, Column, Line +  2, dto.getPayIncomeTax_02());
		if(null != dto.getPayIncomeTax_03()) setValue_chk( odsBean, Column, Line +  4, dto.getPayIncomeTax_03());
		if(null != dto.getPayIncomeTax_04()) setValue_chk( odsBean, Column, Line +  6, dto.getPayIncomeTax_04());
		if(null != dto.getPayIncomeTax_05()) setValue_chk( odsBean, Column, Line +  8, dto.getPayIncomeTax_05());
		if(null != dto.getPayIncomeTax_06()) setValue_chk( odsBean, Column, Line + 10, dto.getPayIncomeTax_06());
		if(null != dto.getPayIncomeTax_07()) setValue_chk( odsBean, Column, Line + 12, dto.getPayIncomeTax_07());
		if(null != dto.getPayIncomeTax_08()) setValue_chk( odsBean, Column, Line + 14, dto.getPayIncomeTax_08());
		if(null != dto.getPayIncomeTax_09()) setValue_chk( odsBean, Column, Line + 16, dto.getPayIncomeTax_09());
		if(null != dto.getPayIncomeTax_10()) setValue_chk( odsBean, Column, Line + 18, dto.getPayIncomeTax_10());
		if(null != dto.getPayIncomeTax_11()) setValue_chk( odsBean, Column, Line + 20, dto.getPayIncomeTax_11());
		if(null != dto.getPayIncomeTax_12()) setValue_chk( odsBean, Column, Line + 22, dto.getPayIncomeTax_12());
		
		// NɂߕsŊzi^j
		Line   = 7;
		Column = 21;
		if(null != dto.getPayAdjCalcGap_01()) setValue_chk( odsBean, Column, Line     , dto.getPayAdjCalcGap_01());
		if(null != dto.getPayAdjCalcGap_02()) setValue_chk( odsBean, Column, Line +  2, dto.getPayAdjCalcGap_02());
		if(null != dto.getPayAdjCalcGap_03()) setValue_chk( odsBean, Column, Line +  4, dto.getPayAdjCalcGap_03());
		if(null != dto.getPayAdjCalcGap_04()) setValue_chk( odsBean, Column, Line +  6, dto.getPayAdjCalcGap_04());
		if(null != dto.getPayAdjCalcGap_05()) setValue_chk( odsBean, Column, Line +  8, dto.getPayAdjCalcGap_05());
		if(null != dto.getPayAdjCalcGap_06()) setValue_chk( odsBean, Column, Line + 10, dto.getPayAdjCalcGap_06());
		if(null != dto.getPayAdjCalcGap_07()) setValue_chk( odsBean, Column, Line + 12, dto.getPayAdjCalcGap_07());
		if(null != dto.getPayAdjCalcGap_08()) setValue_chk( odsBean, Column, Line + 14, dto.getPayAdjCalcGap_08());
		if(null != dto.getPayAdjCalcGap_09()) setValue_chk( odsBean, Column, Line + 16, dto.getPayAdjCalcGap_09());
		if(null != dto.getPayAdjCalcGap_10()) setValue_chk( odsBean, Column, Line + 18, dto.getPayAdjCalcGap_10());
		if(null != dto.getPayAdjCalcGap_11()) setValue_chk( odsBean, Column, Line + 20, dto.getPayAdjCalcGap_11());
		if(null != dto.getPayAdjCalcGap_12()) setValue_chk( odsBean, Column, Line + 22, dto.getPayAdjCalcGap_12());
		
		// Ŋzi^j		
		Line   = 7;
		Column = 23;
		if(null != dto.getPayPaymentTax_01()) setValue_chk( odsBean, Column, Line +  0, dto.getPayPaymentTax_01());
		if(null != dto.getPayPaymentTax_02()) setValue_chk( odsBean, Column, Line +  2, dto.getPayPaymentTax_02());
		if(null != dto.getPayPaymentTax_03()) setValue_chk( odsBean, Column, Line +  4, dto.getPayPaymentTax_03());
		if(null != dto.getPayPaymentTax_04()) setValue_chk( odsBean, Column, Line +  6, dto.getPayPaymentTax_04());
		if(null != dto.getPayPaymentTax_05()) setValue_chk( odsBean, Column, Line +  8, dto.getPayPaymentTax_05());
		if(null != dto.getPayPaymentTax_06()) setValue_chk( odsBean, Column, Line + 10, dto.getPayPaymentTax_06());
		if(null != dto.getPayPaymentTax_07()) setValue_chk( odsBean, Column, Line + 12, dto.getPayPaymentTax_07());
		if(null != dto.getPayPaymentTax_08()) setValue_chk( odsBean, Column, Line + 14, dto.getPayPaymentTax_08());
		if(null != dto.getPayPaymentTax_09()) setValue_chk( odsBean, Column, Line + 16, dto.getPayPaymentTax_09());
		if(null != dto.getPayPaymentTax_10()) setValue_chk( odsBean, Column, Line + 18, dto.getPayPaymentTax_10());
		if(null != dto.getPayPaymentTax_11()) setValue_chk( odsBean, Column, Line + 20, dto.getPayPaymentTax_11());
		if(null != dto.getPayPaymentTax_12()) setValue_chk( odsBean, Column, Line + 22, dto.getPayPaymentTax_12());

		Line   = 31;
		setValue_chk( odsBean,   7, Line , dto.getTotalPayTotalAllowance());		// xzvi^j
		setValue_chk( odsBean,  10, Line , dto.getTotalPaySocInsDeduction());		// ^Љیvi^j
		setValue_chk( odsBean,  12, Line , dto.getTotalPayPayInsDeduction());		// ^ЉیT̋^̋zvi^j
		setValue_chk( odsBean,  17, Line , dto.getTotalPayIncomeTax());			// ^ōvi^j
		setValue_chk( odsBean,  21, Line , dto.getTotalPayAdjCalcGap());			// ^Nɂߕsvi^j
		setValue_chk( odsBean,  23, Line , dto.getTotalPayIncomeTax() + dto.getTotalPayAdjCalcGap()); // Ŋzi^j		

		/* ܗ^ */
		// xiܗ^j
		Line   = 33;
		Column = 3;
		if(null != dto.getBonusMonth_01())   setValue_chk( odsBean, Column, Line +  0, dto.getBonusMonth_01());
		if(null != dto.getBonusMonth_02())   setValue_chk( odsBean, Column, Line +  2, dto.getBonusMonth_02());
		if(null != dto.getBonusMonth_03())   setValue_chk( odsBean, Column, Line +  4, dto.getBonusMonth_03());
		if(null != dto.getBonusMonth_04())   setValue_chk( odsBean, Column, Line +  6, dto.getBonusMonth_04());
		if(null != dto.getBonusMonth_05())   setValue_chk( odsBean, Column, Line +  8, dto.getBonusMonth_05());
//		if(null != dto.getBonusMonth_06())   setValue_chk( odsBean, Column, Line + 10, dto.getBonusMonth_06());
		Column = 4;
		if(null != dto.getBonusMonth_01())   setValue_chk( odsBean, Column, Line +  0, dto.getBonusMonth_01());
		if(null != dto.getBonusMonth_02())   setValue_chk( odsBean, Column, Line +  2, dto.getBonusMonth_02());
		if(null != dto.getBonusMonth_03())   setValue_chk( odsBean, Column, Line +  4, dto.getBonusMonth_03());
		if(null != dto.getBonusMonth_04())   setValue_chk( odsBean, Column, Line +  6, dto.getBonusMonth_04());
		if(null != dto.getBonusMonth_05())   setValue_chk( odsBean, Column, Line +  8, dto.getBonusMonth_05());
//		if(null != dto.getBonusMonth_06())   setValue_chk( odsBean, Column, Line + 10, dto.getBonusMonth_06());

		// xiܗ^j
		Column = 5;
		if(null != dto.getBonusPayDay_01())  setValue_chk( odsBean, Column, Line +  0,  dto.getBonusPayDay_01());
		if(null != dto.getBonusPayDay_02())  setValue_chk( odsBean, Column, Line +  2,  dto.getBonusPayDay_02());
		if(null != dto.getBonusPayDay_03())  setValue_chk( odsBean, Column, Line +  4,  dto.getBonusPayDay_03());
		if(null != dto.getBonusPayDay_04())  setValue_chk( odsBean, Column, Line +  6,  dto.getBonusPayDay_04());
		if(null != dto.getBonusPayDay_05())  setValue_chk( odsBean, Column, Line +  8,  dto.getBonusPayDay_05());
//		if(null != dto.getBonusPayDay_06())  setValue_chk( odsBean, Column, Line + 10,  dto.getBonusPayDay_06());

		//xziܗ^j
		Line   = 33;
		Column = 7;
		if(null != dto.getBonTotalAllowance_01())  setValue_chk( odsBean, Column, Line +  0,   dto.getBonTotalAllowance_01());
		if(null != dto.getBonTotalAllowance_02())  setValue_chk( odsBean, Column, Line +  2,   dto.getBonTotalAllowance_02());
		if(null != dto.getBonTotalAllowance_03())  setValue_chk( odsBean, Column, Line +  4,   dto.getBonTotalAllowance_03());
		if(null != dto.getBonTotalAllowance_04())  setValue_chk( odsBean, Column, Line +  6,   dto.getBonTotalAllowance_04());
		if(null != dto.getBonTotalAllowance_05())  setValue_chk( odsBean, Column, Line +  8,   dto.getBonTotalAllowance_05());
//		if(null != dto.getBonTotalAllowance_06())  setValue_chk( odsBean, Column, Line + 10,   dto.getBonTotalAllowance_06());

		// 
		// Љی̍Tziܗ^j
		Line   = 33;
		Column = 10;
		if(null != dto.getBonSocInsDeduction_01())  setValue_chk( odsBean, Column, Line +  0,   dto.getBonSocInsDeduction_01());
		if(null != dto.getBonSocInsDeduction_02())  setValue_chk( odsBean, Column, Line +  2,   dto.getBonSocInsDeduction_02());
		if(null != dto.getBonSocInsDeduction_03())  setValue_chk( odsBean, Column, Line +  4,   dto.getBonSocInsDeduction_03());
		if(null != dto.getBonSocInsDeduction_04())  setValue_chk( odsBean, Column, Line +  6,   dto.getBonSocInsDeduction_04());
		if(null != dto.getBonSocInsDeduction_05())  setValue_chk( odsBean, Column, Line +  8,   dto.getBonSocInsDeduction_05());
//		if(null != dto.getBonSocInsDeduction_06())  setValue_chk( odsBean, Column, Line + 10,   dto.getBonSocInsDeduction_06());
		
		// ЉیT̋^̋ziܗ^j		
		Line   = 33;
		Column = 12;
		if(null != dto.getBonPayInsDeduction_01()) setValue_chk( odsBean, Column, Line +  0,   dto.getBonPayInsDeduction_01());
		if(null != dto.getBonPayInsDeduction_02()) setValue_chk( odsBean, Column, Line +  2,   dto.getBonPayInsDeduction_02());
		if(null != dto.getBonPayInsDeduction_03()) setValue_chk( odsBean, Column, Line +  4,   dto.getBonPayInsDeduction_03());
		if(null != dto.getBonPayInsDeduction_04()) setValue_chk( odsBean, Column, Line +  6,   dto.getBonPayInsDeduction_04());
		if(null != dto.getBonPayInsDeduction_05()) setValue_chk( odsBean, Column, Line +  8,   dto.getBonPayInsDeduction_05());
//		if(null != dto.getBonPayInsDeduction_06()) setValue_chk( odsBean, Column, Line + 10,   dto.getBonPayInsDeduction_06());
		
		// }{e̐iܗ^j
		Line   = 33;
		Column = 14;
		if(null != dto.getBonDependentCount_01()) setValue_chk( odsBean, Column, Line +  0,   dto.getBonDependentCount_01());
		if(null != dto.getBonDependentCount_02()) setValue_chk( odsBean, Column, Line +  2,   dto.getBonDependentCount_02());
		if(null != dto.getBonDependentCount_03()) setValue_chk( odsBean, Column, Line +  4,   dto.getBonDependentCount_03());
		if(null != dto.getBonDependentCount_04()) setValue_chk( odsBean, Column, Line +  6,   dto.getBonDependentCount_04());
		if(null != dto.getBonDependentCount_05()) setValue_chk( odsBean, Column, Line +  8,   dto.getBonDependentCount_05());
//		if(null != dto.getBonDependentCount_06()) setValue_chk( odsBean, Column, Line + 10,   dto.getBonDependentCount_06());
		
		// ZoŊziŊzjiܗ^j
		Line   = 34;
		Column = 17;
		if(null != dto.getBonIncomeTax_01()) setValue_chk( odsBean, Column, Line +  0,   dto.getBonIncomeTax_01());
		if(null != dto.getBonIncomeTax_02()) setValue_chk( odsBean, Column, Line +  2,   dto.getBonIncomeTax_02());
		if(null != dto.getBonIncomeTax_03()) setValue_chk( odsBean, Column, Line +  4,   dto.getBonIncomeTax_03());
		if(null != dto.getBonIncomeTax_04()) setValue_chk( odsBean, Column, Line +  6,   dto.getBonIncomeTax_04());
		if(null != dto.getBonIncomeTax_05()) setValue_chk( odsBean, Column, Line +  8,   dto.getBonIncomeTax_05());
//		if(null != dto.getBonIncomeTax_06()) setValue_chk( odsBean, Column, Line + 10,   dto.getBonIncomeTax_06());
		
		
		// NɂߕsŊziܗ^j
		Line   = 33;
		Column = 21;
		if(null != dto.getBonAdjCalcGap_01()) setValue_chk( odsBean, Column, Line +  0,   dto.getBonAdjCalcGap_01());
		if(null != dto.getBonAdjCalcGap_02()) setValue_chk( odsBean, Column, Line +  2,   dto.getBonAdjCalcGap_02());
		if(null != dto.getBonAdjCalcGap_03()) setValue_chk( odsBean, Column, Line +  4,   dto.getBonAdjCalcGap_03());
		if(null != dto.getBonAdjCalcGap_04()) setValue_chk( odsBean, Column, Line +  6,   dto.getBonAdjCalcGap_04());
		if(null != dto.getBonAdjCalcGap_05()) setValue_chk( odsBean, Column, Line +  8,   dto.getBonAdjCalcGap_05());
//		if(null != dto.getBonAdjCalcGap_06()) setValue_chk( odsBean, Column, Line + 10,   dto.getBonAdjCalcGap_06());
		
		// Ŋziܗ^j		
		Line   = 33;
		Column = 23;
		if(null != dto.getBonPaymentTax_01()) setValue_chk( odsBean, Column, Line +  0, dto.getBonPaymentTax_01());
		if(null != dto.getBonPaymentTax_02()) setValue_chk( odsBean, Column, Line +  2, dto.getBonPaymentTax_02());
		if(null != dto.getBonPaymentTax_03()) setValue_chk( odsBean, Column, Line +  4, dto.getBonPaymentTax_03());
		if(null != dto.getBonPaymentTax_04()) setValue_chk( odsBean, Column, Line +  6, dto.getBonPaymentTax_04());
		if(null != dto.getBonPaymentTax_05()) setValue_chk( odsBean, Column, Line +  8, dto.getBonPaymentTax_05());
//		if(null != dto.getBonPaymentTax_06()) setValue_chk( odsBean, Column, Line + 10, dto.getBonPaymentTax_06());

		// Őŗ
		Line   = 33;
		Column = 18;
		if(null != dto.getBonIncomeTaxRate_01()) setValue_chk( odsBean, Column, Line +  0, dto.getBonIncomeTaxRate_01());
		if(null != dto.getBonIncomeTaxRate_02()) setValue_chk( odsBean, Column, Line +  2, dto.getBonIncomeTaxRate_02());
		if(null != dto.getBonIncomeTaxRate_03()) setValue_chk( odsBean, Column, Line +  4, dto.getBonIncomeTaxRate_03());
		if(null != dto.getBonIncomeTaxRate_04()) setValue_chk( odsBean, Column, Line +  6, dto.getBonIncomeTaxRate_04());
		if(null != dto.getBonIncomeTaxRate_05()) setValue_chk( odsBean, Column, Line +  8, dto.getBonIncomeTaxRate_05());
//		if(null != dto.getBonIncomeTaxRate_06()) setValue_chk( odsBean, Column, Line + 10, dto.getBonIncomeTaxRate_06());
		
		Line   = 43;
		setValue_chk( odsBean,   7, Line , dto.getTotalBonTotalAllowance());	// xzviܗ^j
		setValue_chk( odsBean,  10, Line , dto.getTotalBonSocInsDeduction());	//^Љیviܗ^j
		setValue_chk( odsBean,  12, Line , dto.getTotalBonPayInsDeduction());	// ^ЉیT̋^̋zviܗ^j
		setValue_chk( odsBean,  17, Line , dto.getTotalBonIncomeTax());			// ^ōviܗ^j
		setValue_chk( odsBean,  21, Line , dto.getTotalBonAdjCalcGap());		// ^Nɂߕsv
		setValue_chk( odsBean,  23, Line , dto.getTotalBonIncomeTax() + dto.getTotalBonAdjCalcGap()); // Ŋziܗ^j		

		/* ONJz */
		Line   = 7;
		setValue_chk( odsBean,  31, Line , 0);	// ҕt͒Ŋz F0
		setValue_chk( odsBean,  35, Line , 0);	// c F0
		setValue_chk( odsBean,  40, Line , 0);	// ҕt͒Ŋz		
		setValue_chk( odsBean,  43, Line , 0);	// c

		/* }{T̐\ */
		// }{e		
		Line   = 12;
		if(null != dto.	getGeneralDependent()) setValue_chk( odsBean, Line ,  31, dto.getGeneralDependent());	// ҕt͒Ŋz F0
		if((null != dto.getSpouseGe()) && (dto.getSpouseGe().equals(PayrollConst.ADJ_APPLICABLE))){	// TΏ۔z(ʔzҁȋjL)
			setValue_chk( odsBean, 28 , Line , PayrollConst.PRESENCE_ON);
		}else{
			setValue_chk( odsBean, 28 , Line , PayrollConst.PRESENCE_OFF);
		}
		if((null != dto.getSpouseEl()) && (dto.getSpouseEl().equals(PayrollConst.ADJ_APPLICABLE))){	// TΏ۔z(VlzҗL)
			setValue_chk( odsBean, 30 , Line , PayrollConst.PRESENCE_ON);
		}else{
			setValue_chk( odsBean, 30 , Line , PayrollConst.PRESENCE_OFF);
		}
		if(null !=  dto.getGeneralDependent())	setValue_chk( odsBean,  31, Line , dto.getGeneralDependent());	// ʂ̕}{e		
		if(null !=  dto.getSpecificDependent())	setValue_chk( odsBean,  33, Line , dto.getSpecificDependent());	// }{e	
		if(null !=  dto.getLiveWithEldRel())	setValue_chk( odsBean,  35, Line , dto.getLiveWithEldRel());		// Vl}{e(Ve)
		if(null !=  dto.getElderlyDependent())	setValue_chk( odsBean,  37, Line , dto.getElderlyDependent());	// Vl}{e(̑)
		if(null !=  dto.getTotallHandicap())	setValue_chk( odsBean,  39, Line , dto.getTotallHandicap());		// QҌv		

		if(null !=  dto.getTotallDeduction())	setValue_chk( odsBean,  43,   14 , dto.getTotallDeduction());		// ]鋋^TΏ۔z҂ƕ}{e̍v
		if(null !=  dto.getConsortFlg())		setValue_chk( odsBean,  45,   15 , dto.getConsortFlg());			// z҂̗L

		/* N */
		Line   = 18;
		setValue_chk( odsBean, 35, Line +  0 , dto.getTotalPayTotalAllowance());		// ^E蓖Fz
		setValue_chk( odsBean, 41, Line +  0 , dto.getTotalPayIncomeTax());			// ^E蓖FŊz
		setValue_chk( odsBean, 35, Line +  1 , dto.getTotalBonTotalAllowance());		// ܗ^Fz
		setValue_chk( odsBean, 41, Line +  1 , dto.getTotalBonIncomeTax());			// ܗ^FŊz
		setValue_chk( odsBean, 35, Line +  2 , dto.getTotalAllowance());				// zv
		setValue_chk( odsBean, 41, Line +  2 , dto.getIncomeTax());					// Ŋzv
		Column = 35;
		setValue_chk( odsBean, Column , Line +  3 , dto.getAfterDeductIncome());		// ^T̋^̋z	
		setValue_chk( odsBean, Column , Line +  4 , dto.getPayInsDeduction());		// ЉیTzF^̍T
		setValue_chk( odsBean, Column , Line +  5 , 0 );								// ЉیTzF\ɂЉی̍T(:0)
		setValue_chk( odsBean, Column , Line +  6 , 0 );								// ЉیTzF\ɂ鏬K͊Ƌϓ|̍T(:0)
		setValue_chk( odsBean, Column , Line +  8 , dto.getLifeInsDeduction());		// ی̍Tz
		setValue_chk( odsBean, Column , Line +  9 , dto.getEarthquakeIns());			// nkی̍Tz
		setValue_chk( odsBean, Column , Line + 10 , dto.getSpouseSpDeduction());		// zғʍTz
		setValue_chk( odsBean, Column , Line + 11 , dto.getDependentsDeduction());	// zҍTzA}{TzAbTzyяQғ̍Tz̍vz

		// Tz̍v
		Sum_tmp = dto.getPayInsDeduction() + dto.getLifeInsDeduction() + dto.getEarthquakeIns() + dto.getSpouseSpDeduction() + dto.getDependentsDeduction();
		setValue_chk( odsBean, 35 , Line + 13 , Sum_tmp );								// Tz̍vz
		// ېŋ^		
		Sum_tmp = (int)round( dto.getAfterDeductIncome() - Sum_tmp, -3, BigDecimal.ROUND_DOWN);
		setValue_chk( odsBean, 35 , Line + 16 , Sum_tmp );								// ېŋ^z

		Line   = 22;
		Column = 41;
		setValue_chk( odsBean, Column , Line +  0 , dto.getSpouseSumIncome());		// z҂̍vz		
		setValue_chk( odsBean, Column , Line +  2 , dto.getPrivatePension());			// lNیxz		
		setValue_chk( odsBean, Column , Line +  4 , dto.getLongTermDamageIns()); 		// Qیxz					
		setValue_chk( odsBean, Column , Line +  7 , dto.getMutualAidDeduction());		// K͊Ƌϓ|̋z					
		setValue_chk( odsBean, Column , Line + 10 , 0 );								// Nی					
		setValue_chk( odsBean, Column , Line + 12 , dto.getCalcIncomeTax());			// ZoNŊz
		setValue_chk( odsBean, Column , Line + 13 , dto.getHouseLoanDeduction());		// ZؓʍTz
		setValue_chk( odsBean, Column , Line + 14 , dto.getAdjustedIncomeTax());		// NNŊz		

		// z
		int Sum_tmp_sashihiki = dto.getAdjustedIncomeTax() - dto.getIncomeTax();
		setValue_chk( odsBean, Column , Line + 15 ,  Sum_tmp_sashihiki);							// z
		if(0 < Sum_tmp_sashihiki ){
			setValue_chk( odsBean, 29 , Line + 15 ,  PayrollConst.BALANCE_LOW);		// Fsz
		}else{
			setValue_chk( odsBean, 29 , Line + 15 ,  PayrollConst.BALANCE_OVER);		// Fߊz
		}

		Line   = 38;
		Column = 41;
		setValue_chk( odsBean, Column , Line +  0 , 0);		// {NŌ̋^璥Ŋzɏ[z
		setValue_chk( odsBean, Column , Line +  1 , 0);		// ^ɌW関̐Ŋzɏ[z
		
		// ҕtz
		// izj|i{NŌ̋^璥Ŋzɏ[zj|i^ɌW関̐Ŋzɏ[zj
		Sum_tmp = Sum_tmp_sashihiki - 0 - 0;
		setValue_chk( odsBean, Column , Line +  2 , Sum_tmp);		// ҕtz
		setValue_chk( odsBean, Column , Line +  3 , Sum_tmp);		// {NɊҕtz
		setValue_chk( odsBean, Column , Line +  3 , 0);			// NɂĊҕtz
		setValue_chk( odsBean, Column , Line +  4 , 0);			// {NŌ̋^璥z
		setValue_chk( odsBean, Column , Line +  5 , 0);			// NɌJzĒz
		
		// o͓eݒ
		String fileName = String.valueOf(vo.getHidAdjustYear()) + 
										PayrollConst.FILE_NAME_SEPARATOR +
										dto.getKCode()	+
										PayrollConst.FILE_NAME_SEPARATOR +
										PayrollConst.FILE_WITHHOLDINGLIST_ODS;

		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, odsBean.getSpreadSheet());
	}

}
