/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.MKintaiDao;
import jp.mosp.payroll.dao.PiPaymentDao;
import jp.mosp.payroll.dto.DetailTimeDto;
import jp.mosp.payroll.dto.MKintaiDto;
import jp.mosp.payroll.payment.vo.ImportTimeVo;

/**
 * ΑӃf[^捞ʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li><li>
 * {@link #CMD_EXECUTE}
 * </li></ul>
 */
public class ImportTimeAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * ^vZ̔N擾A\B<br>
	 * ^vZ̔NȂꍇ́AxB<br>
	 * ^vZ̔Nɂ钆ԃf[^݂ꍇAxB<br>
	 */
	public static final String CMD_SHOW = "P1220";
	
	/**
	 * sR}hB<br><br>
	 * \ꂽvZNɑ΂āAMosPΑӊǗΑӃf[^捞ށB<br>
	 * vZNɂ钆ԃf[^݂ĂꍇA͍폜B<br>
	 */
	public static final String CMD_EXECUTE = "P1225";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public ImportTimeAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new ImportTimeVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else if (this.cmd.equals(CMD_EXECUTE)) {
			// s
			execute();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br>
	 * @throws Exception 
	 */
	private void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		ImportTimeVo vo = (ImportTimeVo)getVo();
		// vZ擾
		Date current = getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT);
		// vZmF
		if (current == null) {
			// ʃ[hݒ
			vo.setMode(1);
			// xbZ[Wݒ
			vo.addErrMessage(MospUtility.getMessage(msg, "WP1210", ""));
			// OX[
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		// ԃf[^݊mF
		List<DetailTimeDto> list = new PiPaymentDao(cfg, cmd, aspUser, user, conn).find(current);
		if (list.size() > 0) {
			// xbZ[Wݒ
			vo.addErrMessage(MospUtility.getMessage(msg, "WP1220",
					MospUtility.getDateString(current, PayrollConst.FORMAT_YEAR_MONTH) +
					MospConst.DATA_SEPARATOR + vo.getName("P_INTERFACE")));
		}
		// VOtB[hݒ
		vo.setCalcDate(current);
		// ʃ[hݒ
		vo.setMode(0);
	}
	
	/**
	 * ΑӃf[^捞sB<br>
	 * @throws Exception 
	 */
	private void execute() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		ImportTimeVo vo = (ImportTimeVo)getVo();
		// Ώ۔N擾
		Date targetMonth = vo.getCalcDate();
		// vZmF
		if (!isCurrent(targetMonth, PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT)) {
			// bZ[Wݒ
			addErrMessage(MospUtility.getMessage(msg, "WP1211", ""));
			return;
		}
		// 捞
		importTime();
		// bZ[Wݒ
		setMessage(MospUtility.getMessage(msg, "IP1220",
				MospUtility.getDateString(vo.getCalcDate(), PayrollConst.FORMAT_YEAR_MONTH)));
		// R}hݒ(^vZʂ)
		setNextCmd(CalcPaymentAction.CMD_SHOW);
	}
	
	/**
	 * ΑӊǗVXeΑӃf[^荞ށB<br>
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private void importTime(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// VO擾
		ImportTimeVo vo = (ImportTimeVo)getVo();
		// Ώ۔N擾
		Date targetMonth = vo.getCalcDate();
		// ΑӊǗVXeDAO
		MKintaiDao dao = new MKintaiDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ΑӊǗVXef[^擾
		List<MKintaiDto> list = dao.findForExport(
				MospUtility.getDateString(targetMonth, PayrollConst.FORMAT_FOR_TIME));
		// o^f[^
		List<DetailTimeDto> listTime = new ArrayList<DetailTimeDto>();
		for (Iterator<MKintaiDto> it = list.iterator(); it.hasNext();) {
			MKintaiDto dto = it.next();
			// ^ԃf[^쐬
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_SNEN        ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_STUKI       ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_SHI         ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_SNISSU      ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_SKAISU      ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_KINMUJI     ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_KYUKEIJI    ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_YUKYU       ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_TOKUKYU     ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_KEKKIN      ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_SKEKKIN     ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_DAIKYU      ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_FURIKAE     ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_SONOTA      ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_TISOKAI     ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_TIJIKAN     ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_ZAJIKAN     ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_KSJIKAN     ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_SNJIKAN     ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_KAIKIN      ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_SYOKUJIKAISU));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_CYOKUKAISU1 ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_CYOKUKAISU2 ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_CYOKUKAISU3 ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_HOKAKAISU1  ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_HOKAKAISU2  ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_HOKAKAISU3  ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_HOKAKAISU4  ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_HOKAKAISU5  ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_SINSEIGAKU  ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_NIJIKYU     ));
			listTime.add(makeTimeDetail(dto, targetMonth, PayrollConst.DTL_WARIMASI1   ));
		}
		// ^vZVXeDAO
		PiPaymentDao ptPaymentDao = new PiPaymentDao(cfg, cmd, aspUser, user, conn);
		// Ώ۔Nf[^폜
		ptPaymentDao.delete(targetMonth);
		// o^
		ptPaymentDao.insert(listTime);
		// R~bg
		commit();
	}
	
	/**
	 * ΑӊǗVXef[^ϊB
	 * @param dto         ΑӊǗVXef[^
	 * @param targetMonth Ώ۔N
	 * @param detailCode  ׃R[h
	 * @return ^vZVXef[^
	 */
	private DetailTimeDto makeTimeDetail(MKintaiDto dto, Date targetMonth, String detailCode) {
		DetailTimeDto detailDto = new DetailTimeDto();
		detailDto.setKCode     (dto.getKCode());
		detailDto.setCalcDate  (targetMonth   );
		detailDto.setDetailCode(detailCode    );
		if (detailCode.equals(PayrollConst.DTL_SNEN)) {
			detailDto.setAmount(dto.getSNen());
		} else if (detailCode.equals(PayrollConst.DTL_STUKI)) {
			detailDto.setAmount(dto.getSTuki());
		} else if (detailCode.equals(PayrollConst.DTL_SHI)) {
			detailDto.setAmount(dto.getSHi());
		} else if (detailCode.equals(PayrollConst.DTL_SNISSU)) {
			detailDto.setAmount((float)dto.getSNissu());
		} else if (detailCode.equals(PayrollConst.DTL_SKAISU)) {
			detailDto.setAmount(dto.getSKaisu());
		} else if (detailCode.equals(PayrollConst.DTL_KINMUJI)) {
			detailDto.setAmount(dto.getKinmuJi());
		} else if (detailCode.equals(PayrollConst.DTL_KYUKEIJI)) {
			detailDto.setAmount(dto.getKyukeiJi());
		} else if (detailCode.equals(PayrollConst.DTL_YUKYU)) {
			detailDto.setAmount((float)dto.getYukyu());
		} else if (detailCode.equals(PayrollConst.DTL_TOKUKYU)) {
			detailDto.setAmount((float)dto.getTokuKyu());
		} else if (detailCode.equals(PayrollConst.DTL_KEKKIN)) {
			detailDto.setAmount((float)dto.getKekkin());
		} else if (detailCode.equals(PayrollConst.DTL_SKEKKIN)) {
			detailDto.setAmount((float)dto.getSKekkin());
		} else if (detailCode.equals(PayrollConst.DTL_DAIKYU)) {
			detailDto.setAmount((float)dto.getDaiKyu());
		} else if (detailCode.equals(PayrollConst.DTL_FURIKAE)) {
			detailDto.setAmount((float)dto.getFurikae());
		} else if (detailCode.equals(PayrollConst.DTL_SONOTA)) {
			detailDto.setAmount(dto.getSonota());
		} else if (detailCode.equals(PayrollConst.DTL_TISOKAI)) {
			detailDto.setAmount(dto.getTiSoKai());
		} else if (detailCode.equals(PayrollConst.DTL_TIJIKAN)) {
			detailDto.setAmount(dto.getTiJikan());
		} else if (detailCode.equals(PayrollConst.DTL_ZAJIKAN)) {
			detailDto.setAmount(dto.getZaJikan());
		} else if (detailCode.equals(PayrollConst.DTL_KSJIKAN)) {
			detailDto.setAmount(dto.getKsJikan());
		} else if (detailCode.equals(PayrollConst.DTL_SNJIKAN)) {
			detailDto.setAmount(dto.getSnJikan());
		} else if (detailCode.equals(PayrollConst.DTL_KAIKIN)) {
			detailDto.setAmount(dto.getKaikin());
		} else if (detailCode.equals(PayrollConst.DTL_SYOKUJIKAISU)) {
			detailDto.setAmount(dto.getSyokujiKaisu());
		} else if (detailCode.equals(PayrollConst.DTL_CYOKUKAISU1)) {
			detailDto.setAmount(dto.getCyokuKaisu1());
		} else if (detailCode.equals(PayrollConst.DTL_CYOKUKAISU2)) {
			detailDto.setAmount(dto.getCyokuKaisu2());
		} else if (detailCode.equals(PayrollConst.DTL_CYOKUKAISU3)) {
			detailDto.setAmount(dto.getCyokuKaisu3());
		} else if (detailCode.equals(PayrollConst.DTL_HOKAKAISU1)) {
			detailDto.setAmount(dto.getHokaKaisu1());
		} else if (detailCode.equals(PayrollConst.DTL_HOKAKAISU2)) {
			detailDto.setAmount(dto.getHokaKaisu2());
		} else if (detailCode.equals(PayrollConst.DTL_HOKAKAISU3)) {
			detailDto.setAmount(dto.getHokaKaisu3());
		} else if (detailCode.equals(PayrollConst.DTL_HOKAKAISU4)) {
			detailDto.setAmount(dto.getHokaKaisu4());
		} else if (detailCode.equals(PayrollConst.DTL_HOKAKAISU5)) {
			detailDto.setAmount(dto.getHokaKaisu5());
		} else if (detailCode.equals(PayrollConst.DTL_SINSEIGAKU)) {
			detailDto.setAmount(dto.getSinseiGaku());
		} else if (detailCode.equals(PayrollConst.DTL_NIJIKYU)) {
			detailDto.setAmount(dto.getNijiKyu());
		} else if (detailCode.equals(PayrollConst.DTL_WARIMASI1)) {
			detailDto.setAmount(dto.getWarimasi1());
		} else {
			detailDto.setAmount(0F);
		}
		return detailDto;
	}
	
}
