/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import jp.mosp.common.common.BaseDto;

public class KintaiCompileDto extends BaseDto {

	private static final long serialVersionUID = 2758325958940292141L;

	// tB[h
	/**
	 * ΖԌv
	 */
	private int totalWork = 0;

	/**
	 * xeԌv
	 */
	private int totalInterbal = 0;

	/**
	 * xԌv
	 */
	private int totalLate = 0;

	/**
	 * ގԌv
	 */
	private int totalLeave = 0;

	/**
	 * cƎԌv
	 */
	private int totalOver = 0;

	/**
	 * xoԌv
	 */
	private int totalHolidayWork = 0;

	/**
	 * [鎞Ԍv
	 */
	private int totalLateNight = 0;

	/**
	 * oΓv
	 */
	private double totalWorkDays = 0;

	/**
	 * oΉ񐔌v
	 */
	private int totalWorkNumber = 0;

	/**
	 * Lxv
	 */
	private double totalPaidHoliday = 0;

	/**
	 * ʋxɌv
	 */
	private int totalParticularHoliday = 0;

	/**
	 * Γv
	 */
	private int totalAbsence = 0;

	/**
	 * axɌv
	 */
	private int totalMedicalLeave = 0;

	/**
	 * xv
	 */
	private int totalCompensationDay = 0;

	/**
	 * U֋xɌv
	 */
	private int totalTransfer = 0;

	/**
	 * xɌv
	 */
	private int totalOther = 0;

	/**
	 * xސ
	 */
	private int leaveAndLate = 0;

	/**
	 * H蓖
	 */
	private int syokuji = 0;

	/**
	 * 1蓖
	 */
	private int cyoku1 = 0;

	/**
	 * 2蓖
	 */
	private int cyoku2 = 0;

	/**
	 * 3蓖
	 */
	private int cyoku3 = 0;

	/**
	 * ̑蓖P
	 */
	private int hoka1 = 0;

	/**
	 * ̑蓖Q
	 */
	private int hoka2 = 0;

	/**
	 * ̑蓖R
	 */
	private int hoka3 = 0;

	/**
	 * ̑蓖S
	 */
	private int hoka4 = 0;

	/**
	 * ̑蓖T
	 */
	private int hoka5 = 0;

	/**
	 * ԒPʔNx
	 */
	private int unitHourHoliday = 0;

	/**
	 * FΎ蓖
	 */
	private boolean isApplyAttendanceAllowance = false;

	/**
	 * 1.00ԍv
	 */
	private int warimasi1 = 0;

	/**
	 * RXgN^
	 */
	public KintaiCompileDto() {
		super();
	}

	// ANZT\bh

	/**
	 * ΖԌv擾
	 * @return	ΖԌv
	 */
	public int getTotalWork() { return totalWork; }

	/**
	 * xeԌv擾
	 * @return	xeԌv
	 */
	public int getTotalInterbal() { return totalInterbal; }

	/**
	 * xԌv擾
	 * @return	xԌv
	 */
	public int getTotalLate() { return totalLate; }

	/**
	 * ގԌv擾
	 * @return	ގԌv
	 */
	public int getTotalLeave() { return totalLeave; }

	/**
	 * cƎԌv擾
	 * @return	cƎԌv
	 */
	public int getTotalOver() { return totalOver; }

	/**
	 * xoԌv擾
	 * @return	xoԌv
	 */
	public int getTotalHolidayWork() { return totalHolidayWork; }

	/**
	 * [鎞Ԍv擾
	 * @return	[鎞Ԍv
	 */
	public int getTotalLateNight() { return totalLateNight; }

	/**
	 * oΓv擾
	 * @return	oΓv
	 */
	public double getTotalWorkDays() { return totalWorkDays; }

	/**
	 * oΉ񐔌v
	 * @return	oΉ񐔌v
	 */
	public int getTotalWorkNumber() { return totalWorkNumber; }

	/**
	 * Lxv擾
	 * @return	Lxv
	 */
	public double getTotalPaidHoliday() { return totalPaidHoliday; }

	/**
	 * ʋxɌv擾
	 * @return	ʋxɌv
	 */
	public int getTotalParticularHoliday() { return totalParticularHoliday; }

	/**
	 * Γv擾
	 * @return	Γv
	 */
	public int getTotalAbsence() { return totalAbsence; }

	/**
	 * axɌv擾
	 * @return	axɌv
	 */
	public int getTotalMedicalLeave() { return totalMedicalLeave; }

	/**
	 * xv擾
	 * @return	xv
	 */
	public int getTotalCompensationDay() { return totalCompensationDay; }

	/**
	 * U֋xɌv擾
	 * @return	U֋xɌv
	 */
	public int getTotalTransfer() { return totalTransfer; }

	/**
	 * xɌv擾
	 * @return	xɌv
	 */
	public int getTotalOther() { return totalOther; }

	/**
	 * xސ擾
	 * @return	xސ
	 */
	public int getLeaveAndLate() { return leaveAndLate; }

	/**
	 * H蓖擾
	 * @return	H蓖
	 */
	public int getSyokuji() { return syokuji; }

	/**
	 * 1蓖擾
	 * @return	1蓖
	 */
	public int getCyoku1() { return cyoku1; }

	/**
	 * 2蓖擾
	 * @return	2蓖
	 */
	public int getCyoku2() { return cyoku2; }

	/**
	 * 3蓖擾
	 * @return	3蓖
	 */
	public int getCyoku3() { return cyoku3; }

	/**
	 * ̑蓖P擾
	 * @return	̑蓖P
	 */
	public int getHoka1() { return hoka1; }

	/**
	 * ̑蓖Q擾
	 * @return	̑蓖Q
	 */
	public int getHoka2() { return hoka2; }

	/**
	 * ̑蓖R擾
	 * @return	̑蓖R
	 */
	public int getHoka3() { return hoka3; }

	/**
	 * ̑蓖S擾
	 * @return	̑蓖S
	 */
	public int getHoka4() { return hoka4; }

	/**
	 * ̑蓖T擾
	 * @return	̑蓖T
	 */
	public int getHoka5() { return hoka5; }

	/**
	 * ԒPʔNx擾
	 * @return	ԒPʔNx
	 */
	public int getUnitHourHoliday() { return unitHourHoliday; }

	/**
	 * FΎ蓖ێ擾
	 * @return	FΎ蓖
	 */
	public boolean isApplyAttendanceAllowance() { return isApplyAttendanceAllowance; }

	/**
	 * 1.00ԍv
	 * @return	1.00ԍv
	 */
	public int getWarimasi1() { return warimasi1; }

	/**
	 * ΖԌvZbg
	 * @param totalWork	ΖԌv
	 */
	public void setTotalWork(int totalWork) { this.totalWork = totalWork; }

	/**
	 * xeԌvZbg
	 * @param totalInterbal	xeԌv
	 */
	public void setTotalInterbal(int totalInterbal) { this.totalInterbal = totalInterbal; }

	/**
	 * xԌvZbg
	 * @param totalLate		xԌv
	 */
	public void setTotalLate(int totalLate) { this.totalLate = totalLate; }

	/**
	 * ގԌvZbg
	 * @param totalLeave	ގԌv
	 */
	public void setTotalLeave(int totalLeave) { this.totalLeave = totalLeave; }

	/**
	 * cƎԌvZbg
	 * @param totalOver		cƎԌv
	 */
	public void setTotalOver(int totalOver) { this.totalOver = totalOver; }

	/**
	 * xoԌvZbg
	 * @param totalHolidayWork	xoԌv
	 */
	public void setTotalHolidayWork(int totalHolidayWork) { this.totalHolidayWork = totalHolidayWork; }

	/**
	 * [鎞Ԍv	Zbg
	 * @param totalLateNight	[鎞Ԍv
	 */
	public void setTotalLateNight(int totalLateNight) { this.totalLateNight = totalLateNight; }

	/**
	 * oΓvZbg
	 * @param totalWorkDays		oΓv
	 */
	public void setTotalWorkDays(double totalWorkDays) { this.totalWorkDays = totalWorkDays; }

	/**
	 * oΉ񐔌vZbg
	 * @param totalWorkNumber	oΉ񐔌v
	 */
	public void setTotalWorkNumber(int totalWorkNumber) { this.totalWorkNumber = totalWorkNumber; }

	/**
	 * LxvZbg
	 * @param totalPaidHoliday	Lxv
	 */
	public void setTotalPaidHoliday(double totalPaidHoliday) { this.totalPaidHoliday = totalPaidHoliday; }

	/**
	 * ʋxɌvZbg
	 * @param totalParticularHoliday	ʋxɌv
	 */
	public void setTotalParticularHoliday(int totalParticularHoliday) { this.totalParticularHoliday = totalParticularHoliday; }

	/**
	 * ΓvZbg
	 * @param totalAbsence		Γv
	 */
	public void setTotalAbsence(int totalAbsence) { this.totalAbsence = totalAbsence; }

	/**
	 * axɌvZbg
	 * @param totalMedicalLeave		axɌv
	 */
	public void setTotalMedicalLeave(int totalMedicalLeave) { this.totalMedicalLeave = totalMedicalLeave; }

	/**
	 * xvZbg
	 * @param totalCompensationDay	xv
	 */
	public void setTotalCompensationDay(int totalCompensationDay) { this.totalCompensationDay = totalCompensationDay; }

	/**
	 * U֋xɌvZbg
	 * @param totalTransfer		U֋xɌv
	 */
	public void setTotalTransfer(int totalTransfer) { this.totalTransfer = totalTransfer; }

	/**
	 * xɌvZbg
	 * @param totalOther		xɌv
	 */
	public void setTotalOther(int totalOther) { this.totalOther = totalOther; }

	/**
	 * xސZbg
	 * @param leaveAndLate	xސ
	 */
	public void setLeaveAndLate(int leaveAndLate) { this.leaveAndLate = leaveAndLate; }

	/**
	 * H蓖Zbg
	 * @param syokuji	H蓖
	 */
	public void setSyokuji(int syokuji) { this.syokuji = syokuji; }

	/**
	 * 1蓖Zbg
	 * @param cyoku1	1蓖
	 */
	public void setCyoku1(int cyoku1) { this.cyoku1 = cyoku1; }

	/**
	 * 2蓖Zbg
	 * @param cyoku2	2蓖
	 */
	public void setCyoku2(int cyoku2) { this.cyoku2 = cyoku2; }

	/**
	 * 3蓖Zbg
	 * @param cyoku3	3蓖
	 */
	public void setCyoku3(int cyoku3) { this.cyoku3 = cyoku3; }

	/**
	 * ̑蓖PZbg
	 * @param hoka1		̑蓖P
	 */
	public void setHoka1(int hoka1) { this.hoka1 = hoka1; }

	/**
	 * ̑蓖QZbg
	 * @param hoka2		̑蓖Q
	 */
	public void setHoka2(int hoka2) { this.hoka2 = hoka2; }

	/**
	 * ̑蓖RZbg
	 * @param hoka3		̑蓖R
	 */
	public void setHoka3(int hoka3) { this.hoka3 = hoka3; }

	/**
	 * ̑蓖SZbg
	 * @param hoka4		̑蓖S
	 */
	public void setHoka4(int hoka4) { this.hoka4 = hoka4; }

	/**
	 * ̑蓖TZbg
	 * @param hoka5		̑蓖T
	 */
	public void setHoka5(int hoka5) { this.hoka5 = hoka5; }

	/**
	 * ԒPʔNxZbg
	 * @param unitHourHoliday	ԒPʔNx
	 */
	public void setUnitHourHoliday(int unitHourHoliday) { this.unitHourHoliday = unitHourHoliday; }

	/**
	 * FΎ蓖ۃZbg
	 * @param isApplyAttendanceAllowance	FΎ蓖
	 */
	public void setApplyAttendanceAllowance(boolean isApplyAttendanceAllowance) { this.isApplyAttendanceAllowance = isApplyAttendanceAllowance; }

	/**
	 * 1.00ԍv
	 * @param warimasi1	1.00ԍv
	 */
	public void setWarimasi1(int warimasi1) { this.warimasi1 = warimasi1; }

}
