/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class AdjustmentDto extends BaseDto {
	
	private static final long serialVersionUID = -4544512011191536993L;
	
	// tB[h
	private String kCode         ;	// ЈR[h
	private String kName         ;	// Ј
	private String kKana         ;	// Јض
	private String stationCode   ;	// R[h
	private String positionCode  ;	// EʃR[h
	private String employmentType;	// ٗp敪
//	private Date   entranceDate  ;	// Г
//	private Date   retirementDate;	// ގГ
	private int   entranceDate  ;	// Г
	private int   retirementDate;	// ގГ
	
	private Date   incExpectedDate  ;	// œKpN
	private String incomeTaxType    ;	// ېŋ敪
	private String adjustmentType   ;	// N敪
	private String selfWidowType    ;	// {lǕw敪
	private String selfHandicapType ;	// {lQ敪
	private String selfStudentType  ;	// {lw敪
	private String spouseIntendType ;	// zҋ敪
	private int    generalDependent ;	// ʕ}{e
	private int    specificDependent;	// }{e
	private int    elderlyDependent ;	// Vl}{e
	private int    liveWithEldRel   ;	// Ve
	private int    liveWithHandiGe  ;	// 
	private int    liveWithHandiSp  ;	// 
	private int    liveWithHandiEl  ;	// Vl
	private int    liveWithHandiEr  ;	// Ve
	private int    generalHandicap  ;	// ʏQ
	private int    specificHandicap ;	// ʏQ
	private int    dependentCount   ;	// }{̐
	
	private String midwayType     ;	// rЋ敪
	private int    formerIncome   ;	// OΖz
	private int    formerInsurance;	// OΖЉیz
	private int    formerTax      ;	// OΖ揊Ŋz
	
	private int    adjustYear         ;	// N
	private String adjustStatus       ;	// NvZ
	private int    generalLifeIns     ;	// ʂ̐ی
	private int    privatePension     ;	// lNی
	private int    lifeInsDeduction   ;	// یTz
	private int    earthquakeIns      ;	// nkی
	private int    longTermDamageIns  ;	// Qی
	private int    damageInsDeduction ;	// QیTz
	private int    socialInsDeduction ;	// ЉیTz
	private int    mutualAidDeduction ;	// K͊Ƌϓ|Tz
	private int    spouseSumIncome    ;	// z҂̖{N̍vžϊz
	private int    spouseSpDeduction  ;	// zғʍTz
	private int    houseLoanDeduction ;	// ZؓʍTz
	private int    allowanceAdjustment;	// xz
	private int    taxFreeAdjustment  ;	// ېŒz
	private int    socInsAdjustment   ;	// Љیz
	private int    taxIncAdjustment   ;	// Œz
	private String withholdSlipNotes  ;	// 򒥎[Ev
	private int    paymentAllowance   ;	// ^A蓖z
	private int    paymentIncomeTax   ;	// ^A蓖Ŋz
	private int    bonusAllowance     ;	// ܗ^z
	private int    bonusIncomeTax     ;	// ܗ^Ŋz
	private int    midwayAdjustIncome ;	// rAz
	private int    midwayAdjustTax    ;	// rAŊz
	private int    afterDeductIncome  ;	// ^T̋^̋z

	private int    payInsDeduction    ;	// Љی^̍T
	private int    dependentsDeduction;	// zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	private int    calcTaxedIncome    ;	// ېŋ^z
	private int    calcIncomeTax      ;	// ZoNŊz
	private int    adjustedIncomeTax  ;	// NNŊz
	private int    deductedIncomeTax  ;	// N藦TzŊz
	private int    finalIncomeTax     ;	// NŊz
	
	/**
	 * RXgN^
	 */
	public AdjustmentDto() {
		super();
	}
	
	// ANZT\bh
	public String getKCode         () { return kCode                       ; }	// ЈR[h
	public String getKName         () { return kName                       ; }	// Ј
	public String getKKana         () { return kKana                       ; }	// Јض
	public String getStationCode   () { return stationCode                 ; }	// R[h
	public String getPositionCode  () { return positionCode                ; }	// EʃR[h
	public String getEmploymentType() { return employmentType              ; }	// ٗp敪
	public int   getEntranceDate  () { return entranceDate					;	}	// Г
	public int   getRetirementDate() { return retirementDate					;	}	// ގГ
	public void setKCode         (String kCode         ) { this.kCode          = kCode                       ; }	// ЈR[h
	public void setKName         (String kName         ) { this.kName          = kName                       ; }	// Ј
	public void setKKana         (String kKana         ) { this.kKana          = kKana                       ; }	// Јض
	public void setStationCode   (String stationCode   ) { this.stationCode    = stationCode                 ; }	// R[h
	public void setPositionCode  (String positionCode  ) { this.positionCode   = positionCode                ; }	// EʃR[h
	public void setEmploymentType(String employmentType) { this.employmentType = employmentType              ; }	// ٗp`
	public void setEntranceDate  (int   entranceDate  ) { this.entranceDate	=	entranceDate	;	}	// Г
	public void setRetirementDate(int   retirementDate) { this.retirementDate	=	retirementDate	;	}	// ގГ
	
	public Date   getIncExpectedDate  () { return getDateField(incExpectedDate); }	// œKpN
	public String getIncomeTaxType    () { return incomeTaxType                ; }	// ېŋ敪
	public String getAdjustmentType   () { return adjustmentType               ; }	// N敪
	public String getSelfWidowType    () { return selfWidowType                ; }	// {lǕw敪
	public String getSelfHandicapType () { return selfHandicapType             ; }	// {lQ敪
	public String getSelfStudentType  () { return selfStudentType              ; }	// {lw敪
	public String getSpouseIntendType () { return spouseIntendType             ; }	// zҋ敪
	public int    getGeneralDependent () { return generalDependent             ; }	// ʕ}{e
	public int    getSpecificDependent() { return specificDependent            ; }	// }{e
	public int    getElderlyDependent () { return elderlyDependent             ; }	// Vl}{e
	public int    getLiveWithEldRel   () { return liveWithEldRel               ; }	// Ve
	public int    getLiveWithHandiGe  () { return liveWithHandiGe              ; }	// 
	public int    getLiveWithHandiSp  () { return liveWithHandiSp              ; }	// 
	public int    getLiveWithHandiEl  () { return liveWithHandiEl              ; }	// Vl
	public int    getLiveWithHandiEr  () { return liveWithHandiEr              ; }	// Ve
	public int    getGeneralHandicap  () { return generalHandicap              ; }	// ʏQ
	public int    getSpecificHandicap () { return specificHandicap             ; }	// ʏQ
	public int    getDependentCount   () { return dependentCount               ; }	// }{̐
	public void setIncExpectedDate  (Date   incExpectedDate  ) { this.incExpectedDate   = getDateField(incExpectedDate); }	// œKpN
	public void setIncomeTaxType    (String incomeTaxType    ) { this.incomeTaxType     = incomeTaxType                ; }	// ېŋ敪
	public void setAdjustmentType   (String adjustmentType   ) { this.adjustmentType    = adjustmentType               ; }	// N敪
	public void setSelfWidowType    (String selfWidowType    ) { this.selfWidowType     = selfWidowType                ; }	// {lǕw敪
	public void setSelfHandicapType (String selfHandicapType ) { this.selfHandicapType  = selfHandicapType             ; }	// {lQ敪
	public void setSelfStudentType  (String selfStudentType  ) { this.selfStudentType   = selfStudentType              ; }	// {lw敪
	public void setSpouseIntendType (String spouseIntendType ) { this.spouseIntendType  = spouseIntendType             ; }	// zҋ敪
	public void setGeneralDependent (int    generalDependent ) { this.generalDependent  = generalDependent             ; }	// ʕ}{e
	public void setSpecificDependent(int    specificDependent) { this.specificDependent = specificDependent            ; }	// }{e
	public void setElderlyDependent (int    elderlyDependent ) { this.elderlyDependent  = elderlyDependent             ; }	// Vl}{e
	public void setLiveWithEldRel   (int    liveWithEldRel   ) { this.liveWithEldRel    = liveWithEldRel               ; }	// Ve
	public void setLiveWithHandiGe  (int    liveWithHandiGe  ) { this.liveWithHandiGe   = liveWithHandiGe              ; }	// 
	public void setLiveWithHandiSp  (int    liveWithHandiSp  ) { this.liveWithHandiSp   = liveWithHandiSp              ; }	// 
	public void setLiveWithHandiEl  (int    liveWithHandiEl  ) { this.liveWithHandiEl   = liveWithHandiEl              ; }	// Vl
	public void setLiveWithHandiEr  (int    liveWithHandiEr  ) { this.liveWithHandiEr   = liveWithHandiEr              ; }	// Ve
	public void setGeneralHandicap  (int    generalHandicap  ) { this.generalHandicap   = generalHandicap              ; }	// ʏQ
	public void setSpecificHandicap (int    specificHandicap ) { this.specificHandicap  = specificHandicap             ; }	// ʏQ
	public void setDependentCount   (int    dependentCount   ) { this.dependentCount    = dependentCount               ; }	// }{̐
	
	public String getMidwayType     () { return midwayType     ; }		// vZP敪
	public int    getFormerIncome   () { return formerIncome   ; }	// vZP敪
	public int    getFormerInsurance() { return formerInsurance; }	// vZP敪
	public int    getFormerTax      () { return formerTax      ; }	// vZP敪
	public void setMidwayType     (String midwayType     ) { this.midwayType      = midwayType     ; }	// vZP敪
	public void setFormerIncome   (int    formerIncome   ) { this.formerIncome    = formerIncome   ; }	// vZP敪
	public void setFormerInsurance(int    formerInsurance) { this.formerInsurance = formerInsurance; }	// vZP敪
	public void setFormerTax      (int    formerTax      ) { this.formerTax       = formerTax      ; }	// vZP敪
	
	public int    getAdjustYear         () { return adjustYear		;	}	// N
	public String getAdjustStatus       () { return adjustStatus		;	}	// NvZ
	public int    getGeneralLifeIns     () { return generalLifeIns     ; }	// ʂ̐ی
	public int    getPrivatePension     () { return privatePension     ; }	// lNی
	public int    getLifeInsDeduction   () { return lifeInsDeduction   ; }	// یTz
	public int    getEarthquakeIns      () { return earthquakeIns      ; }	// nkی
	public int    getLongTermDamageIns  () { return longTermDamageIns  ; }	// Qی
	public int    getDamageInsDeduction () { return damageInsDeduction ; }	// QیTz
	public int    getSocialInsDeduction () { return socialInsDeduction ; }	// ЉیTz
	public int    getMutualAidDeduction () { return mutualAidDeduction ; }	// K͊Ƌϓ|Tz
	public int    getSpouseSumIncome    () { return spouseSumIncome    ; }	// z҂̖{N̍vžϊz
	public int    getSpouseSpDeduction  () { return spouseSpDeduction  ; }	// zғʍTz
	public int    getHouseLoanDeduction () { return houseLoanDeduction ; }	// ZؓʍTz
	public int    getAllowanceAdjustment() { return allowanceAdjustment; }	// xz
	public int    getTaxFreeAdjustment  () { return taxFreeAdjustment  ; }	// ېŒz
	public int    getSocInsAdjustment   () { return socInsAdjustment   ; }	// Љیz
	public int    getTaxIncAdjustment   () { return taxIncAdjustment   ; }	// Œz
	public String getWithholdSlipNotes  () { return withholdSlipNotes	;	}	// 򒥎[Ev
	public int    getPaymentAllowance   () { return paymentAllowance   ; }	// ^A蓖z
	public int    getPaymentIncomeTax   () { return paymentIncomeTax   ; }	// ^A蓖Ŋz
	public int    getBonusAllowance     () { return bonusAllowance     ; }	// ܗ^z
	public int    getBonusIncomeTax     () { return bonusIncomeTax     ; }	// ܗ^Ŋz
	public int    getMidwayAdjustIncome () { return midwayAdjustIncome ; }	// rAz
	public int    getMidwayAdjustTax    () { return midwayAdjustTax    ; }	// rAŊz
	public int    getAfterDeductIncome  () { return afterDeductIncome  ; }	// ^T̋^̋z
	public int    getPayInsDeduction    () { return payInsDeduction    ; }	// Љی^̍T
	public int    getDependentsDeduction() { return dependentsDeduction; }	// zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	public int    getCalcTaxedIncome    () { return calcTaxedIncome    ; }	// ېŋ^z
	public int    getCalcIncomeTax      () { return calcIncomeTax      ; }	// ZoNŊz
	public int    getAdjustedIncomeTax  () { return adjustedIncomeTax  ; }	// NNŊz
	public int    getDeductedIncomeTax  () { return deductedIncomeTax  ; }	// N藦TzŊz
	public int    getFinalIncomeTax     () { return finalIncomeTax     ; }	// NŊz
	public void setAdjustYear         (int    adjustYear         ) { this.adjustYear          = adjustYear         ; }	// N
	public void setAdjustStatus       (String adjustStatus       ) { this.adjustStatus        = adjustStatus       ; }	// NvZ
	public void setGeneralLifeIns     (int    generalLifeIns     ) { this.generalLifeIns      = generalLifeIns     ; }	// ʂ̐ی
	public void setPrivatePension     (int    privatePension     ) { this.privatePension      = privatePension     ; }	// lNی
	public void setLifeInsDeduction   (int    lifeInsDeduction   ) { this.lifeInsDeduction    = lifeInsDeduction   ; }	// یTz
	public void setEarthquakeIns      (int    earthquakeIns      ) { this.earthquakeIns       = earthquakeIns      ; }	// nkی
	public void setLongTermDamageIns  (int    longTermDamageIns  ) { this.longTermDamageIns   = longTermDamageIns  ; }	// Qی
	public void setDamageInsDeduction (int    damageInsDeduction ) { this.damageInsDeduction  = damageInsDeduction ; }	// QیTz
	public void setSocialInsDeduction (int    socialInsDeduction ) { this.socialInsDeduction  = socialInsDeduction ; }	// ЉیTz
	public void setMutualAidDeduction (int    mutualAidDeduction ) { this.mutualAidDeduction  = mutualAidDeduction ; }	// K͊Ƌϓ|Tz
	public void setSpouseSumIncome    (int    spouseSumIncome    ) { this.spouseSumIncome     = spouseSumIncome    ; }	// z҂̖{N̍vžϊz
	public void setSpouseSpDeduction  (int    spouseSpDeduction  ) { this.spouseSpDeduction   = spouseSpDeduction  ; }	// zғʍTz
	public void setHouseLoanDeduction (int    houseLoanDeduction ) { this.houseLoanDeduction  = houseLoanDeduction ; }	// ZؓʍTz
	public void setAllowanceAdjustment(int    allowanceAdjustment) { this.allowanceAdjustment = allowanceAdjustment; }	// xz
	public void setTaxFreeAdjustment  (int    taxFreeAdjustment  ) { this.taxFreeAdjustment   = taxFreeAdjustment  ; }	// ېŒz
	public void setSocInsAdjustment   (int    socInsAdjustment   ) { this.socInsAdjustment    = socInsAdjustment   ; }	// Љیz
	public void setTaxIncAdjustment   (int    taxIncAdjustment   ) { this.taxIncAdjustment    = taxIncAdjustment   ; }	// Œz
	public void setWithholdSlipNotes  (String withholdSlipNotes  ) { this.withholdSlipNotes   = withholdSlipNotes  ; }	// 򒥎[Ev
	public void setPaymentAllowance   (int    paymentAllowance   ) { this.paymentAllowance    = paymentAllowance   ; }	// ^A蓖z
	public void setPaymentIncomeTax   (int    paymentIncomeTax   ) { this.paymentIncomeTax    = paymentIncomeTax   ; }	// ^A蓖Ŋz
	public void setBonusAllowance     (int    bonusAllowance     ) { this.bonusAllowance      = bonusAllowance     ; }	// ܗ^z
	public void setBonusIncomeTax     (int    bonusIncomeTax     ) { this.bonusIncomeTax      = bonusIncomeTax     ; }	// ܗ^Ŋz
	public void setMidwayAdjustIncome (int    midwayAdjustIncome ) { this.midwayAdjustIncome  = midwayAdjustIncome ; }	// rAz
	public void setMidwayAdjustTax    (int    midwayAdjustTax    ) { this.midwayAdjustTax     = midwayAdjustTax    ; }	// rAŊz
	public void setAfterDeductIncome  (int    afterDeductIncome  ) { this.afterDeductIncome   = afterDeductIncome  ; }	// ^T̋^̋z
	public void setPayInsDeduction    (int    payInsDeduction    ) { this.payInsDeduction     = payInsDeduction    ; }	// Љی^̍T
	public void setDependentsDeduction(int    dependentsDeduction) { this.dependentsDeduction = dependentsDeduction; }	// zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	public void setCalcTaxedIncome    (int    calcTaxedIncome    ) { this.calcTaxedIncome     = calcTaxedIncome    ; }	// ېŋ^z
	public void setCalcIncomeTax      (int    calcIncomeTax      ) { this.calcIncomeTax       = calcIncomeTax      ; }	// ZoNŊz
	public void setAdjustedIncomeTax  (int    adjustedIncomeTax  ) { this.adjustedIncomeTax   = adjustedIncomeTax  ; }	// NNŊz
	public void setDeductedIncomeTax  (int    deductedIncomeTax  ) { this.deductedIncomeTax   = deductedIncomeTax  ; }	// N藦TzŊz
	public void setFinalIncomeTax     (int    finalIncomeTax     ) { this.finalIncomeTax      = finalIncomeTax     ; }	// NŊz
	
	public int getTaxGap() {
		return finalIncomeTax - paymentIncomeTax - bonusIncomeTax - midwayAdjustTax;
	}
	
}
