/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common;

import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;


import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.legal.LegalReportUtility;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.FirmBankingOutputVo;
import jp.mosp.payroll.dao.CmCityDao;
import jp.mosp.payroll.dao.CmCoBankDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dao.CtRetireDetailDao;
import jp.mosp.payroll.dao.ResideTransferDao;
import jp.mosp.payroll.dto.CmCityDto;
import jp.mosp.payroll.dto.CmCoBankDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dto.CtRetireDetailDto;
import jp.mosp.payroll.dto.ResideTransferFBDataDto;

public class ResideFBDataOutputAction  extends MosPAction {
	// R}h
	private static final String CMD_RESIDE_FB_DATA_OUTPUT = "P9900";

	protected Date   targetMonth    ;
	
	/**
	 * RXgN^
	 */
	public ResideFBDataOutputAction() {
		super();
		setNeedProcSeq(false);
	}
	int totalPayCount  = 0;
	int totalPayAmount = 0; 
	int totalRetireCount  = 0;
	int totalRetireAmount = 0;
	// ǉR[h
	int lenRecord = 0;
	// R[htH[}bgύXR[h
	int cngRecFormat = 0;
	

	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		FirmBankingOutputVo vo = (FirmBankingOutputVo)session.getAttribute(MospConst.ATT_FORMER_VO);
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// aݒ擾
		vo.listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		if (cmd.equals(CMD_RESIDE_FB_DATA_OUTPUT)) {
			// p[^擾
			vo.setParams(request);
			
			// Џo^
			updateCompanyInfo(vo);
			// ǉR[h擾
			getAddRecordLength(Integer.parseInt(vo.getTxtRecordLength()));
			// Ώ۔N擾
			targetMonth = vo.getDate(vo.getPltSpecifyYear(), vo.getPltSpecifyMonth(), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			
			CmCityDao cmCityDao = new CmCityDao();
			cmCityDao.initDao(cfg, cmd, aspUser, user, conn);	
			// Is撬Xg擾
			List<CmCityDto> list = cmCityDao.findForFirmBanking(vo.getPltCoBankCode());
			// [쐬
			StringBuffer sb = new StringBuffer();
			String fileName = vo.getPltSpecifyYear () + PayrollConst.FILE_NAME_SEPARATOR
							+ vo.getPltSpecifyMonth() + PayrollConst.FILE_NAME_SEPARATOR
							+ vo.getPltSpecifyDay  () + PayrollConst.FILE_NAME_SEPARATOR
							+ vo.getPltCoBankCode  () + PayrollConst.FILE_NAME_SEPARATOR
							+ PayrollConst.FILE_FB_RESIDE_DATA;
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			request.setAttribute(MospConst.ATT_FILE_OBJECT, sb);
			if (list.size() == 0) {
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_RESIDENCE, "");
				sb.append(errMessage);
				return;
			}
			// FBf[^쐬
			getFBDataRecord(sb, list, vo);
		}
	}
	

	
	/**
	 * FBf[^쐬
	 * @param sb
	 * @param list
	 * @throws Exception
	 */
	protected void getFBDataRecord(StringBuffer sb, List<CmCityDto> list, FirmBankingOutputVo vo)
		throws Exception
	{
		// ΏێЈł܂킷
		for (int j = 0; j < list.size(); j++) {
			CmCityDto cmCityDto =list.get(j);
			// f[^ZDTOɐݒ
			ResideTransferFBDataDto dto = setResidenceFBData(cmCityDto);
			if (j == 0) {
				// wb_[R[hݒ
				setHeaderRecordData(sb, vo);
			}
			// f[^R[hݒ
			setDataRecordData(sb, dto, vo);
		}
		if (cngRecFormat == 0) {
			// ׂĊmFIg[[R[hݒ
			LegalReportUtility.getResTrailerRecord(sb
					, String.valueOf(totalPayCount)                   , String.valueOf(totalPayAmount)
					, String.valueOf(totalRetireCount)                , String.valueOf(totalRetireAmount)
					, String.valueOf(totalPayCount + totalRetireCount), String.valueOf(totalPayAmount + totalRetireAmount)
					, checkLineFeed(vo.getPltRecordType()), lenRecord);
		} else if (cngRecFormat == 1) {
			// ׂĊmFIg[[R[hݒ
			getResMizuhoTrailerRecord(
					sb , String.valueOf(list.size())
					, String.valueOf(totalPayAmount + totalRetireAmount)
					, checkLineFeed(vo.getPltRecordType()), lenRecord);
			
		}
		// st^mF
		checkLineFeed(vo.getPltEndRecord());
		// GhR[h쐬
		if (checkLineFeed(vo.getPltEndRecord())) {
			LegalReportUtility.getEndRecord(sb, checkLineFeed(vo.getPltRecordType()), lenRecord);
		}
		// 
		totalPayCount  = 0;
		totalPayAmount = 0; 
		totalRetireCount  = 0;
		totalRetireAmount = 0;
	}
	
	/**
	 * wb_[f[^ݒ
	 * @param sb
	 * @param aryBankCode
	 * @param aryBranchCode
	 * @param cmCompanyDto
	 * @param udPaymentDto
	 * @param cmCoBankDto
	 * @throws Exception 
	 */
	protected void setHeaderRecordData(
			StringBuffer sb, FirmBankingOutputVo vo
	) throws Exception {
		
		Date paymentDate  = vo.getDate(vo.getPltSpecifyYear (), vo.getPltSpecifyMonth (), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
		Date deadlineDate = vo.getDate(vo.getPltDeadlineYear(), vo.getPltDeadlineMonth(), vo.getPltDeadlineDay());
		String[] aryPaymentDate = getJpDate(paymentDate  , vo);
		String[] aryDeadlineDate = getJpDate(deadlineDate, vo);
		
		// Ћs擾
		CmCoBankDao cmCoBankDao = new CmCoBankDao();
		cmCoBankDao.initDao(cfg, cmd, aspUser, user, conn);
		// ЋsR[hЈ̃Xg擾
		// Ћs擾
		CmCoBankDto	cmCoBankDto = cmCoBankDao.findForKey(vo.getPltCoBankCode());
		// tH[}bgmF
		checkRecFormat(cmCoBankDto);
		if (cngRecFormat == 0) {
			LegalReportUtility.getResHeaderRecode(
					sb, vo.getTxtTypeCode()
					, vo.getPltCodeType(), vo.getTxtCompanyCode()
					, cmCoBankDto.getBranchCode()
					, aryDeadlineDate[1], aryDeadlineDate[2], aryDeadlineDate[3]
					, aryPaymentDate[1] , aryPaymentDate[2]
					, getLowerUpKana(vo.getTxtCompanyName())
					, getLowerUpKana(vo.getTxtCoAddress  ())
					, checkLineFeed(vo.getPltRecordType  ()), lenRecord
			);
		} else if (cngRecFormat == 1) {
			getResMizuhoHeaderRecode(
					sb, vo.getTxtCompanyCode()
					, cmCoBankDto.getBranchCode()
					, aryDeadlineDate[1], aryDeadlineDate[2], aryDeadlineDate[3]
					, aryPaymentDate[1] , aryPaymentDate[2]
					, getLowerUpKana(vo.getTxtCompanyName())
					, getLowerUpKana(vo.getTxtCoAddress  ())
					, checkLineFeed(vo.getPltRecordType  ()), lenRecord
			);
		}
		
		

	}
	/**
	 * f[^R[hf[^ݒ
	 * @param sb
	 * @param bankTransferFBDataDto
	 * @throws Exception
	 */
	private void setDataRecordData(
		StringBuffer sb, ResideTransferFBDataDto dto, FirmBankingOutputVo vo
	) throws Exception {
		// st^mF
		checkLineFeed(vo.getPltRecordType());
		if (cngRecFormat == 0) {
			LegalReportUtility.getResFBDataRecord(
					sb, dto.getCityCode(), getLowerUpKana(dto.getCityKana())
					, String.valueOf(dto.getDesignatedNumber()), String.valueOf(dto.getCityChanges  ())
					, String.valueOf(dto.getPaymentCount    ()), String.valueOf(dto.getPaymentTax   ())
					, String.valueOf(dto.getRetireCount     ()), String.valueOf(dto.getRetireTax    ())
					, String.valueOf(dto.getTotalCount      ()), String.valueOf(dto.getTotalTax     ())
					, String.valueOf(dto.getRetireCount     ()), String.valueOf(dto.getCityPayAmount())
					, String.valueOf(dto.getCityTax         ()), String.valueOf(dto.getPrefectureTax())
					, checkLineFeed(vo.getPltRecordType()), lenRecord
			);
		} else if (cngRecFormat == 1) {
			getResMizuhoFBDataRecord(
					sb, dto.getCityCode(), getLowerUpKana(dto.getCityKana())
					, String.valueOf(dto.getDesignatedNumber()), String.valueOf(dto.getPaymentTax   ())
					, String.valueOf(dto.getRetireCount     ()), String.valueOf(dto.getRetireTax    ())
					, String.valueOf(dto.getTotalTax        ()), String.valueOf(dto.getCityTax      ())
					, String.valueOf(dto.getPrefectureTax   ())
					, checkLineFeed(vo.getPltRecordType     ()), lenRecord
			);
			
		}
		totalPayCount     += dto.getPaymentCount();
		totalPayAmount    += Integer.parseInt(dto.getPaymentTax());
		totalRetireCount  += dto.getRetireCount();
		totalRetireAmount += dto.getRetireTax();

		
	}

	/**
	 * ЏXV
	 * @param vo
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	private void updateCompanyInfo(FirmBankingOutputVo vo) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// DAO
		CmCompanyDao cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		// ݊mF
		CmCompanyDto cmCompanyDto = cmCompanyDao.findAll();
		if (cmCompanyDto != null) {
			// cmCompanyDto.setCompanyFbCode(vo.getTxtCompanyCode());
			cmCompanyDto.setCompanyFbAddress(vo.getTxtCoAddress());
			cmCompanyDto.setCompanyFbKana(vo.getTxtCompanyName ());
			// XV
			cmCompanyDao.update(cmCompanyDto);
		} else {
			cmCompanyDto = new CmCompanyDto();
			// cmCompanyDto.setCompanyFbCode(vo.getTxtCompanyCode());
			cmCompanyDto.setCompanyFbAddress(vo.getTxtCoAddress());
			cmCompanyDto.setCompanyFbKana(vo.getTxtCompanyName ());
			// o^
			cmCompanyDao.insert(cmCompanyDto);
		}
		// R~bg
		commit();
	}
	
	/**
	 * st^mF
	 * @param strLineFeed
	 * @return
	 */
	private boolean checkLineFeed(String strLineFeed) {
		// R[h敪ɉsȂ
		if (strLineFeed.equals(PayrollConst.FB_RECORD_TYPE_NONE)) {
			return false;
		}
		// R[h敪ɉs
		return true;
	}
	
	
	/**
	 * ǉR[h擾
	 * @param addLenRecord
	 */
	private void getAddRecordLength(int addLenRecord) {
		// ǉR[h-120(ŏR[h)
		 lenRecord = addLenRecord - PayrollConst.FB_LOWER_LEN_RECORD;
		 if (lenRecord < 0) {
			 lenRecord = 0;
		 }
	}
	
	/**
	 * ǉR[h擾
	 * @param addLenRecord
	 * @throws MospException 
	 */
	private String[] getJpDate(Date targetDate, FirmBankingOutputVo vo)
	throws MospException {
		String[] strDate = getJpImperialCal(vo.listConf, targetDate);
		return strDate;
	}

	
	/**
	 * ZDTOݒ
	 * @param cmCityDto
	 * @param vo
	 * @return
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	private ResideTransferFBDataDto setResidenceFBData(CmCityDto cmCityDto) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// DAO
	
		CtRetireDetailDao ctRetireDetailDao = new CtRetireDetailDao();
		ctRetireDetailDao.initDao(cfg, cmd, aspUser, user, conn);
		ResideTransferDao resideTransferDao = new ResideTransferDao();
		resideTransferDao.initDao(cfg, cmd, aspUser, user, conn);
		ResideTransferFBDataDto resideTransferFBDataDto = new ResideTransferFBDataDto();
		if (cmCityDto != null) {
			// ^̍vA擾
			ResideTransferFBDataDto dto = resideTransferDao.findForFirmBanking(cmCityDto.getCityCode(), targetMonth);
			// ސE̎擾
			CtRetireDetailDto ctRetireDetailDto = ctRetireDetailDao.findForKey(cmCityDto.getCityCode(), targetMonth);
			// s撬̐ݒ
			resideTransferFBDataDto = new ResideTransferFBDataDto(dto, cmCityDto, ctRetireDetailDto);
		}
		
		return resideTransferFBDataDto;
	}
	
	/**
	 * FBf[^̃wb_[R[h擾B(n⋦tH[}bg)
	 * @param sb  @@@  ݒ蕶
	 * @param typeCode@  ʃR[h
	 * @param codeType@  R[h敪
	 * @param companyCode ЃR[h
	 * @param companyName Ж
	 * @param payMonth@  Uw()
	 * @param payDay    @Uw()
	 * @param bankCode  @dsR[h
	 * @param bankName@  ds
	 * @param branchCode@ dxXR[h
	 * @param branchName @dxX
	 * @param accountType a
	 * @param accountNo @ԍ
	 * @return FBf[^wb_[R[h
	 */
	public static   StringBuffer getResMizuhoHeaderRecode(
		StringBuffer  sb  ,
		String companyCode,
		String branchCode,
		String deadlineYear,
		String deadlineMonth,
		String deadlineDay,
		String paymentYear,
		String paymentMonth,
		String companyName,
		String companyAddress,
		boolean isLineFeed,
		int lenRecord
	) {
		sb.append(
				"1"
				+ getZero("95"           , 2 )
				+ getZero(branchCode     , 3 )
				+ getZero(companyCode    , 10)
				+ getZero(deadlineYear   , 2 )
				+ getZero(deadlineMonth  , 2 )
				+ getZero(deadlineDay    , 2 )
				+ getZero(paymentYear    , 2 )
				+ getZero(paymentMonth   , 2 )
				+ getSpace(companyName   , 40)
				+ getSpace(companyAddress, 50)
				+ getZero("1"            , 1 )
				+ getSpace(""            , 1 + lenRecord)
		);
		// sȂst^
		if (isLineFeed) {
			// CZp[g
			sb.append(LegalConst.LINE_SEPARATOR);
		} else {
			// sȂXy[Xt^
			sb.append(getSpace("" , 2));
		}
		return sb;
	}

	/**
	 * FBf[^̃f[^R[h擾B(n⋦tH[}bg)
	 * @param sb  @@@    ݒ蕶
	 * @param bankCode@    dsR[h
	 * @param bankName@    ds
	 * @param branchCode@  dxXR[h
	 * @param branchName @ dxX
	 * @param accountType@ a
	 * @param accountNo     ԍ
	 * @param accountName@ aҖ
	 * @param accountAmount Uz
	 * @param kCode         Јԍ
	 * @param stationCode@ R[h
	 * @return FBf[^R[h
	 */
	public static  StringBuffer getResMizuhoFBDataRecord(
		StringBuffer  sb       ,
		String cityCode        ,
		String cityName        ,
		String designatedNumber,
		String paymentTax      ,
		String retireCount     ,
		String retireTax       ,
		String totalTax        ,
		String cityTax         ,
		String prefectureTax   ,
		boolean isLineFeed    ,
		int lenRecord
	){
		sb.append(
			"2"
			+ getZero (cityCode        , 6 )
			+ getSpace(cityName        , 15)
			+ getSpace(designatedNumber, 15)
			+ getZero (paymentTax      , 10)
			+ getZero (retireCount     , 5 )
			+ getZero (retireTax       , 10)
			+ getZero (cityTax         , 10)
			+ getZero (prefectureTax   , 10)
			+ getZero (cityTax + prefectureTax   , 10)
			+ getZero (totalTax        , 12)
			+ getSpace(""              , 14 + lenRecord)


		);
		// sȂst^
		if (isLineFeed) {
			// CZp[g
			sb.append(LegalConst.LINE_SEPARATOR);
		} else {
			// sȂXy[Xt^
			sb.append(getSpace("" , 2));
		}
		return sb;
		
	}
	
	/**
	 * FBf[^̃g[R[h擾B(n⋦tH[}bg)
	 * @param sb  @@@ݒ蕶
	 * @param total@   v
	 * @param amount@  vz
	 * @return FBf[^g[R[h
	 */
	public static  StringBuffer getResMizuhoTrailerRecord(
		StringBuffer sb,
		String cntlist,
		String totalPayRetTax  ,
		boolean isLineFeed,
		int lenRecord
	) {
		sb.append(
			"8"
			+ getZero (cntlist       , 6 )
			+ getZero (totalPayRetTax, 15)
			+ getSpace(""            , 96 + lenRecord)
		);
		// sȂst^
		if (isLineFeed) {
			sb.append(LegalConst.LINE_SEPARATOR);
		} else {
			// sȂXy[Xt^
			sb.append(getSpace("" , 2));
		}
		return sb;
	}
	
	
	/**
	 * FBf[^̃GhR[h擾B(S⋦tH[}bg)
	 * @param sb ݒ蕶
	 * @return FBf[^GhR[h
	 */
	public static  StringBuffer getResEndRecord(
			StringBuffer sb    ,
			boolean isLineFeed,
			int lenRecord
	) {
		sb.append("9"+ getSpace("" , 117 + lenRecord));
		// sȂst^
		if (isLineFeed) {
			sb.append(LegalConst.LINE_SEPARATOR);
		} else {
			// sȂXy[Xt^
			sb.append(getSpace("" , 2));
		}
		return sb;
	}
	
	
	/**
	 * tH[}bgmF
	 * @param cmCoBankDto
	 */
	private void checkRecFormat(CmCoBankDto cmCoBankDto) {
		if (cmCoBankDto != null) {
			// s̏ꍇADtH[}bgŐݒ
			if (cmCoBankDto.getBankCode().equals("0001")) {
					cngRecFormat = 1; 
			}
		}
	}
	
	
	/**
	 * ɐݒ肵ɃXy[X}B
	 * @param wspace@ݒ蕶
	 * @param i@@@@ݒ茅
	 * @return@@@@Xy[X}㕶
	 */
	public static String getSpace(String wspace, int i) {
		// ݒ菀
		int lenString = 0;
		String targetString = "";
		lenString = i - wspace.length();
		if (lenString > 0) {
			for (int w = 0; w < lenString; w++) {
				targetString += " ";
			}
		}
		return wspace + targetString;
	}
	
	/**
	 * ɐݒ肵̐擪0}B
	 * @param wspace ݒ蕶
	 * @param i      ݒ茅
	 * @return       [}㕶
	 */
	public static  String  getZero(String wspace, int i) {
		// ݒ菀
		int lenString = 0;
		String targetString = "";
		lenString = i - wspace.length();
		if (lenString > 0) {
			for (int w = 0; w < lenString; w++) {
				targetString += "0";
			}
		}
		return targetString + wspace;
	}

	/**
	 * pJiϊ(啶)
	 * @param strTarget
	 * @return@pJi
	 */
	protected String getLowerUpKana(String strTarget) {
		// pJi()
		String[] aryLowerKana = {
				"",  "", "", "", "", "", "", "", ""
		};
		// pJi(啶)
		String[] aryLowerUpKana = {
				"",  "", "", "", "", "", "", "", ""
		};
		// 
		String retString = "";
		String repString = "";
		// ̌ŉ
		for (int i = 0; i < strTarget.length(); i++) {
			// Ԃɕ擾Ă
			repString = strTarget.substring(i, i+1);
			// ԂɊmF
			for (int j = 0; j < aryLowerKana.length; j++) {
				// p()݂啶֕ϊ
				if (aryLowerKana[j].equals(repString)) {
					repString = aryLowerUpKana[j];
					break;
				}
			}
			// 
			retString += repString;
		}
		return retString;
	}
	
	/**
	 * a擾
	 * @param list a񃊃Xg
	 * @param date t
	 * @return tz
	 * @throws MospException 
	 */
	public String[] getJpImperialCal(List<MosPConfDto> list, Date date) throws MospException {
		String[] aryJpDate = new String[4];
		if (date == null) {
			return aryJpDate;
		}
		for (Iterator<MosPConfDto> it = list.iterator(); it.hasNext();) {
			MosPConfDto dto = it.next();
			Date startDate = getDate(dto.getConfCode ());
			Date endDate   = getDate(dto.getConfValue());
			if (startDate.compareTo(date) <= 0 && endDate.compareTo(date) >= 0) {
				int year = MospUtility.getYear(date) - MospUtility.getYear(startDate) + 1;
				aryJpDate[0] = dto.getConfId();
				aryJpDate[1] = String.valueOf(year);
				aryJpDate[2] = String.valueOf(MospUtility.getMonth(date));
				aryJpDate[3] = String.valueOf(MospUtility.getDay  (date));
				return aryJpDate;
			}
		}
		throw new MospException(MospConst.EX_DATE_INVALID);
	}

	/**
	 * t擾(/p)
	 * @param strDate t
	 * @return t
	 * @throws MospException 
	 */
	public Date getDate(String strDate) throws MospException {
		if (strDate == null || strDate.length() != 8) {
			throw new MospException(MospConst.EX_DATE_INVALID);
		}
		return MospUtility.getDate(
				strDate.substring(0, 4) + PayrollConst.SEPARATOR_DATE +
				strDate.substring(4, 6) + PayrollConst.SEPARATOR_DATE +
				strDate.substring(6, 8)
		);
	}
	
}
