/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.part.KintaiApprovalPart;

import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.ApprovalCardVo;

public class ApprovalCardAction extends MosPWorkflowAction {

	// R}h
	private static final String CMD_APPROVAL_CARD_SELECT		= "K2126";
	private static final String CMD_APPROVAL_CARD_REGIST		= "K2127";
	private static final String CMD_APPROVAL_CARD_RETURN		= "K2129";

	/**
	 * RXgN^
	 */
	public ApprovalCardAction() {
		super();
	}

	public void action() throws Exception {
		// RlNV擾
		getConnection();
		// MANAGERmF
		confirmManagerAuth();
		// VO̎擾
		ApprovalCardVo vo;
		vo = (ApprovalCardVo)getStoredVo(CommonConst.VO_APPROVAL_CARD);
		if (vo == null) {
			vo = new ApprovalCardVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_APPROVAL_CARD, vo);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		MSyukkinboDto dto;
		Object objDto = session.getAttribute(MospConst.ATT_DTO);
		dto = objDto instanceof MSyukkinboDto ? (MSyukkinboDto)objDto : null;
		// [U[擾
		getInfo(user.getUserId());
		// v_EXg
		setPulldownList(vo);
		// ΑӊǗR}h
		vo.setCmdMenuButton(vo.CMD_MENU_MAMAGE);
		vo.setCmdListButton(ApprovalListAction.CMD_APPROVAL_LIST_SEARCH);
		vo.setNamListButton(CommonConst.TTL_APPROVAL_LIST);
		// R}h̏
		if (cmd.equals(CMD_APPROVAL_CARD_SELECT)) {
			// oΌ
			dto = searchApproval(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);	
		} else if (cmd.equals(CMD_APPROVAL_CARD_REGIST)) {
			// F
			aprroved(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_APPROVAL_CARD_RETURN)) {
			// 
			returned(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);			
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * v_EXgݒ
	 * @param vo
	 * @throws Exception
	 */
	private void setPulldownList(ApprovalCardVo vo) throws Exception {
		// 蓖ꗗ
		vo.aryAllowance = getMosPCodeArray(CommonConst.TID_ALLOWANCE_NAME);
		// Ζ`ԃv_E
		vo.aryPltWorkType = getWorkTypeArrayWithWeekHoliday();
		// xo敪v_E
		vo.aryPltWorkOnHoliday = getMosPCodeArray(CommonConst.TID_WORK_ON_HOLIDAY_TYPE);
		// oΎx敪v_E
		vo.aryPltStartHalfHoliday = getMosPCodeArray(CommonConst.TID_HALF_HOLIDAY_TYPE);
		// xRv_E
		vo.aryPltLateReason = getMosPCodeArray(CommonConst.TID_LATE_REASON);
		// xؖv_E
		vo.aryPltLateCertificate = getMosPCodeArray(CommonConst.TID_LATE_CERTIFICATE);
		// ދΎx敪v_E
		vo.aryPltQuitHalfHoliday = getMosPCodeArray(CommonConst.TID_HALF_HOLIDAY_TYPE);
		// ޗRv_E
		vo.aryPltLeaveEarlyReason = getMosPCodeArray(CommonConst.TID_LEAVE_EARLY_REASON);
		// ޏؖv_E
		vo.aryPltLeaveEarlyCertificate = getMosPCodeArray(CommonConst.TID_LEAVE_EARLY_CERTIFICATE);
		// FRv_E
		vo.aryPltApprovalReason = getMosPCodeArray(CommonConst.TID_APPROVAL_REASON);
	}

	/**
	 * ΑӏFΏۓ擾
	 * @param vo
	 * @return	MSyukkinboDto	ΏDTO
	 * @throws Exception
	 */
	private MSyukkinboDto searchApproval(ApprovalCardVo vo) throws Exception {
		// l{擾
		HumanBasisDtoInterface mKihonDto = getBasisInfo(key1);
		vo.setLblKCode(mKihonDto.getKCode());
		vo.setLblKName(mKihonDto.getSimei());
		vo.setLblSectionName(getSectionName(mKihonDto.getSCode()));
		vo.setHidKCode(mKihonDto.getKCode());
		vo.setHidDate(key2);
		vo.setLblYear(String.valueOf(MospUtility.getYear(util.convStringDateToDate(vo.getHidDate()))));
		vo.setLblMonth(String.valueOf(MospUtility.getMonth(util.convStringDateToDate(vo.getHidDate()))));
		vo.setLblDay(String.valueOf(MospUtility.getDay(util.convStringDateToDate(vo.getHidDate()))));
		// Αӌ
		MSyukkinboDto dto = getSyukkinboInfo(mKihonDto.getKCode(), vo.getHidDate());
		if (chkExistDto(dto)) {
			// VOɏZbg
			vo.setFields(dto);
			// Ώ۔N擾
			Date targetDate = util.convStringDateToDate(vo.getHidDate());
			// F[gݒ
			String[] aryRouteInfo = getTargetRouteInfo(mKihonDto.getKCode(), targetDate);
			// ꎟF
			if (KintaiApprovalPart.isRequest(dto) 
					&& isApprover(aryRouteInfo[0], targetDate)
			) {
				vo.setLblApprovalLayer(CommonConst.NAM_1ST_APPROVED);
				vo.setHidApprovalLayer(CommonConst.NUM_ATTENDANCE_1ST_APPROVED);
				vo.setApproval(ApprovalCardVo.MODE_APPROVAL);
			} 
			// 񎟏F
			else if (KintaiApprovalPart.is1stApproved(dto) 
					&& isApprover(aryRouteInfo[1], targetDate)
			) {
				vo.setLblApprovalLayer(CommonConst.NAM_2ND_APPROVED);
				vo.setHidApprovalLayer(CommonConst.NUM_ATTENDANCE_2ND_APPROVED);
				vo.setApproval(ApprovalCardVo.MODE_APPROVAL);
			} else {
				vo.setDefaultValues();
				vo.setApproval(ApprovalCardVo.MODE_VIEW);
			}
		} else {
			vo.setDefaultValues();
			vo.setApproval(ApprovalCardVo.MODE_VIEW);
		}
		return dto;
	}

	/**
	 * ΑӏF
	 * @param vo
	 * @param dto
	 * @throws Exception
	 */
	private void aprroved(ApprovalCardVo vo, MSyukkinboDto dto) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// rmF
		chkExclusive(dto, getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate(), true), vo);
		// F
		runApprovalProcess(
				vo.getHidKCode(),
				vo.getHidDate(),
				vo.getHidApprovalLayer(),
				vo.getTxtApprovalComment(),
				mKihon.getKCode()
		);
		// DTO̍Ď擾
		MSyukkinboDto retDto = getSyukkinboInfo(dto.getKCode(), dto.getHizuke());
		chkUpdate(retDto);
		// R~bg
		commit();
		// bZ[Wݒ
		if (KintaiApprovalPart.is1stApproved(retDto)) {
			vo.setMessage(MospUtility.getMessage(msg, CommonConst.MSG_DONE, CommonConst.NAM_1ST_APPROVED));
		}
		if (KintaiApprovalPart.is2ndApproved(retDto)) {
			vo.setMessage(MospUtility.getMessage(msg, CommonConst.MSG_DONE, CommonConst.NAM_2ND_APPROVED));
		}
		// [hݒ
		vo.setApproval(ApprovalCardVo.MODE_VIEW);
	}

	/**
	 * ΑӍߏ
	 * @param vo
	 * @param dto
	 * @throws Exception
	 */
	private void returned(ApprovalCardVo vo, MSyukkinboDto dto) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// rmF
		chkExclusive(dto, getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate(), true), vo);
		// ߗR̐ݒ
		String reason = "";
		if (KintaiApprovalPart.is1stApproved(vo.getHidApprovalLayer())) {
			reason = CommonConst.NUM_ATTENDANCE_1ST_RETURNED;
		}
		if (KintaiApprovalPart.is2ndApproved(vo.getHidApprovalLayer())) {
			reason = CommonConst.NUM_ATTENDANCE_2ND_RETURNED;
		}
		// ߏ
		runApprovalProcess(
				vo.getHidKCode(),
				vo.getHidDate(),
				reason,
				vo.getTxtApprovalComment(),
				mKihon.getKCode()
		);
		// DTO̍Ď擾
		chkUpdate(getSyukkinboInfo(dto.getKCode(), dto.getHizuke()));
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, CommonConst.MSG_APPROVAL_RETURNED, ""));
		// [hݒ
		vo.setApproval(ApprovalCardVo.MODE_VIEW);
	}

}
