/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.vo;

import jp.mosp.common.MosPVo;

public class MosPMenuVo extends MosPVo {

	private static final long serialVersionUID = 4851143534947875513L;

	// URL
	private static final String RETURN_URL = "/jsp/common/mosPMenu.jsp";
	private static final String EXTRA_CSS  = "/pub/common/css/mosPMenu.css";
	private static final String EXTRA_JS   = "/pub/common/js/mosPMenu.js";

	// 萔
	public static final int MODE_ADMIN = 1;

	// j[tO
	/*	
	private int menuFlag;
	 */

	// tB[h
	public String[] aryCmd ;
	public String[] aryName ;

	// Cj[p
	/*	
	private boolean availableInput;
	private boolean availableManage;
	private boolean availablePayroll;
	private boolean availableHuman;
	private boolean availableSystem;
	private boolean availableSystem2;
	 */

	// [h
	private int mode;

	/**
	 * RXgN^
	 */
	public MosPMenuVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		/*		
		menuFlag = 0;
		availableInput   = false;
		availableManage  = false;
		availablePayroll = false;
		availableHuman   = false;
		availableSystem  = false;
		availableSystem2 = false;
		 */
		aryCmd 		= new String[0];
		aryName 	= new String[0];
		mode = 0;
	}

	/**
	 * tB[hݒ
	 * <p>	2009/01/07	k.taniai	j[AWΉ	</p>
	 * @param compnent R}hݒ
	 * @param combineAllCmdArray
	 */
	public void setFields(String compnent, String[][] combineAllCmdArray) {
		if (compnent.length() > 0) {
			aryCmd = util.divideByComma(compnent);
			aryName	= new String[aryCmd.length];
			for (int i = 0 ; i < aryCmd.length ; i++) {
				aryName[i] = "";
				String cmdNo = aryCmd[i];
				String cmdName = util.getCodeName(aryCmd[i], combineAllCmdArray);
				if (!cmdNo.equals(cmdName)) {
					aryName[i] = escapeHTML(cmdName);
				}
			}
		}
	}

	// ANZT\bh
	/*	
	public void setMenuFlag(int menuFlag) 	{ this.menuFlag = menuFlag	; }
	public boolean getAvailableInput  () 	{ return availableInput  	; }
	public boolean getAvailableManage () 	{ return availableManage 	; }
	public boolean getAvailablePayroll() 	{ return availablePayroll	; }
	public boolean getAvailableHuman  () 	{ return availableHuman  	; }
	public boolean getAvailableSystem () 	{ return availableSystem 	; }
	public boolean getAvailableSystem2() 	{ return availableSystem2	; }
	public void setAvailableInput  (boolean availableInput  ) { this.availableInput   = availableInput  ; }
	public void setAvailableManage (boolean availableManage ) { this.availableManage  = availableManage ; }
	public void setAvailablePayroll(boolean availablePayroll) { this.availablePayroll = availablePayroll; }
	public void setAvailableHuman  (boolean availableHuman  ) { this.availableHuman   = availableHuman  ; }
	public void setAvailableSystem (boolean availableSystem ) { this.availableSystem  = availableSystem ; }
	public void setAvailableSystem2(boolean availableSystem2) { this.availableSystem2 = availableSystem2; }
	 */

	public String[]	getEscAryCmd	() { return aryCmd.clone()	; }
	public String[]	getEscAryName	() { return aryName.clone()	; }

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		/*		
		sb.append("numMenuFlag = ");
		sb.append(menuFlag);
		sb.append(";");
		sb.append("aryAvailableMenu = new Array(");
		sb.append(availableInput   + ", ");
		sb.append(availableManage  + ", ");
		sb.append(availablePayroll + ", ");
		sb.append(availableHuman   + ", ");
		sb.append(availableSystem  + ", ");
		sb.append(availableSystem2 + ");");
		 */
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public void setMode(int mode) { this.mode = mode; }

}
