/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.text.NumberFormat;

import jp.mosp.common.common.ValidateUtility;

/**
 * ɊւPartNX
 * @author yoshida
 * 	@version	0.0.1
 */
public class NumberPart {

	/**
	 * tH[}bg
	 * @param number 
	 * @param max ő包
	 * @param min _ȉő包
	 * @return ()
	 */
	public static String getNumberString(double number, int integer, int fraction) {
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setMaximumIntegerDigits(integer);
		nf.setMaximumFractionDigits(fraction);
		return nf.format(number);
	}

	/**
	 * ϊ
	 * @param input		ϊO
	 * @return	ϊ㐮
	 */
	public static int getIntParam(String input) {
		int num = 0;
		if (StringPart.isNotNull(input)) {
			if (ValidateUtility.chkRegex("^-?\\d+", input)) {
				try {
					num = Integer.parseInt(input);
				} catch (NumberFormatException e) {
					num = 0;
				}
			}
		}
		return num;
	}

	/**
	 * _ϊ
	 * @param input		ϊO
	 * @return	ϊ㕂_
	 */
	public static double getDoubleParam(String input) {
		double dnum = 0;
		if (StringPart.isNotNull(input)) {
			try {
				dnum = Double.parseDouble(input);
			} catch (NumberFormatException e) {
				dnum = 0;
			}
		}
		return dnum;
	}

}
