/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import jp.mosp.common.CommonConst;
import jp.mosp.common.ExportInfoUtility;

import jp.mosp.system.dao.MExportColumnDao;
import jp.mosp.system.dto.MExportColumnDto;

/**
 * GNX|[gɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class ExportPart extends BasePart {

	/**
	 * RXgN^
	 */
	public ExportPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public ExportPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * GNX|[g񍀖ڐݒ
	 * @param strFLID	Ώۃe[uR[h
	 * @return	String[][]	GNX|[g񍀖ڔz
	 * @throws Exception
	 */
	public String[][] getKintaiDataItem(String strFLID) throws Exception {
		return ExportInfoUtility.getColumnDataItem(
				strFLID,
				getTableColumnInfo(jp.mosp.human.dao.MKihonDao.TABLE),
				getTableColumnInfo(jp.mosp.payroll.dao.MKintaiDao.TABLE),
				getTableColumnInfo(jp.mosp.kintai.dao.MSyukkinboDao.TABLE),
				getTableColumnInfo(jp.mosp.kintai.dao.MYukyuDao.TABLE)
		);
	}

	/**
	 * 񍀖ڗpz擾
	 * @param tableName		Ώۃe[u
	 * @return	 񍀖ڗpz
	 * @throws Exception 
	 */
	private String[] getTableColumnInfo(
			String tableName
	) throws Exception {
		MExportColumnDao dao = (MExportColumnDao) getPreparedDao(
				MExportColumnDao.class.getCanonicalName()
		);
		List<MExportColumnDto> list = dao.findForCondition(tableName);
		String[] aryColumnInfo = new String[list.size()];
		int i = 0;
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			MExportColumnDto dto = (MExportColumnDto) iter.next();
			StringBuffer sb = new StringBuffer();
			sb.append(tableName.toUpperCase(Locale.JAPANESE));
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
			sb.append(i + 1);
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
			sb.append(dto.getColumnField().toUpperCase(Locale.JAPANESE));
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
			sb.append(dto.getColumnComment());
			aryColumnInfo[i] = sb.toString();
			i++;
		}
		return aryColumnInfo;
	}

}
