/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.dto.CmAuthorityDto;
import jp.mosp.common.vo.MosPMenuGuideVo;

public class MosPMenuGuideAction extends MosPMenuArrangeAction {

	/**
	 * RXgN^
	 */
	public MosPMenuGuideAction() {
		super();
	}

	public void action() throws Exception {
		// ZbVێ̏
		initStoredData();
		// RlNV擾
		getConnection();
		// VȌ
		MosPMenuGuideVo vo = new MosPMenuGuideVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		CmAuthorityDto dto = getUserAuthDto();
		// ftHgR[h̐ݒ
		if (!chkExistDto(dto)) {
			dto = getDefaultAuthDto();
		}
		List<String[]> listMenu = new ArrayList<String[]>();
		if (chkExistDto(dto)) {
			if (dto.getEmployee().length() != 0) {
				listMenu.add(getMenuUnit(CommonConst.TTL_MENU_INPUT, vo.CMD_MENU_INPUT));
			}
			if (dto.getManager().length() != 0) {
				listMenu.add(getMenuUnit(CommonConst.TTL_MENU_MANAGE, vo.CMD_MENU_MAMAGE));
			}
			if (dto.getPayroll().length() != 0) {
				listMenu.add(getMenuUnit(CommonConst.TTL_MENU_PAYROLL, vo.CMD_MENU_PAYROLL));
			}
			if (dto.getHuman().length() != 0) {
				listMenu.add(getMenuUnit(CommonConst.TTL_MENU_HUMAN, vo.CMD_MENU_HUMAN));
			}		
		}
		String[][] array = new String[listMenu.size()][2];
		for (int i = 0; i < array.length; i++) {
			array[i] = listMenu.get(i);
		}
		vo.setFields(array);
		if (array.length == 1 && dto.getEmployee().length() != 0) {
			//Ζ\ɑJ		
			setNextCmd(getEmployeeCmdArray()[0][0]);
			// T[ubg
			setUrl(MospConst.URL_SRV);
		}
	}

}
