/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.util.Date;
import java.util.Iterator;

import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;

import jp.mosp.common.MosPAction;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.VoInterface;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.dto.KintaiCommonDtoInterface;

import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.KintaiApprovalPart;
import jp.mosp.common.part.KintaiCalcPart;
import jp.mosp.common.part.KintaiCommonPart;
import jp.mosp.common.part.TimePart;
import jp.mosp.common.part.VariousPart;

import jp.mosp.common.part.PartManager;

import jp.mosp.kintai.action.AttendanceCheckCardAction;
import jp.mosp.kintai.action.AttendanceHolidayCardAction;
import jp.mosp.kintai.action.AttendanceListAction;
import jp.mosp.kintai.action.AttendanceQuitCardAction;
import jp.mosp.kintai.action.AttendanceStartCardAction;

import jp.mosp.kintai.dao.MScheduleDao;
import jp.mosp.kintai.dao.MSyukkinboDao;

import jp.mosp.kintai.dto.MScheduleDto;
import jp.mosp.kintai.dto.MSyukkinboDto;

import jp.mosp.kintai.vo.AttendanceMenuVo;
import jp.mosp.kintai.vo.ScheduleMenuVo;

import jp.mosp.payroll.dto.KintaiCompileDto;

import jp.mosp.system.dto.MWorkTypeDto;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;

public abstract class AttendanceTotalAction extends MosPAction {

	// tB[h
	protected String	startDate;
	protected String	endDate;

	protected int		lateNightStart 	= 0;
	protected int		lateNightEnd 	= 0;

	protected int		allHoliday	 	= 0;
	protected int		halfHoliday	 	= 0;

	protected int		inputUnit 		= 1;

	protected boolean isAutoCalc;

	protected List<MSyukkinboDto>	attendanceList;
	protected List<MScheduleDto> 	scheduleList;

	// Ζ`ԃ}bv
	private Map<String, MWorkTypeDto> workTypeMap;

	protected String[][] aryHolidayReason;

	// Wvf[^
	protected String[][] aryAttendance;
	// Wvf[^
	protected String[][] aryAttendanceCompile;

	/*						
	 *  	2009/04/21	m.yoshida	ǉ
	 */
	private MScheduleDao 	scheduleDao;
	private MSyukkinboDao 	syukkinboDao;

	/**
	 * \pDAO
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @throws Exception
	 */
	private void prepareMScheduleDao() throws Exception {
		// DAO
		if (scheduleDao !=null) {
			return;
		}
		scheduleDao = PartManager.kintai(partInfo()).getMScheduleDao();
	}

	/**
	 * oΕpDAO
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @throws Exception
	 */
	private void prepareMSyukkinboDao() throws Exception {
		// DAO
		if (syukkinboDao !=null) {
			return;
		}
		syukkinboDao = PartManager.kintai(partInfo()).getMSyukkinboDao();
	}

	/**
	 * \pDAO擾
	 * @return	ςMScheduleDaoCX^X
	 * @throws Exception
	 */
	protected MScheduleDao scheduleDao() throws Exception {
		// \pDAO
		prepareMScheduleDao();
		return scheduleDao;
	}

	/**
	 * oΕpDAO擾
	 * @return	ςMSyukkinboDaoCX^X
	 * @throws Exception
	 */
	protected MSyukkinboDao syukkinboDao() throws Exception {
		// \pDAO
		prepareMSyukkinboDao();
		return syukkinboDao;
	}

	/**
	 * \Ώۓ擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kcode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	protected MScheduleDto getScheduleInfo(String kcode, String targetDate) throws Exception {
		return scheduleDao().findForKey(kcode, targetDate);
	}

	/**
	 * \Ώۓ擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kcode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	protected MScheduleDto getScheduleInfo(String kcode, Date targetDate) throws Exception {
		return getScheduleInfo(kcode, util.convDateFormatted(targetDate));
	}

	/**
	 * \ΏۓsbN
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @return				ΏDTO
	 * @throws Exception
	 */
	protected MScheduleDto lockScheduleInfo(String kCode, String targetDate) throws Exception {
		return scheduleDao().findForUpdate(kCode, targetDate);
	}

	/**
	 * oΕΏۓ擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kcode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	protected MSyukkinboDto getSyukkinboInfo(String kcode, String targetDate) throws Exception {
		return syukkinboDao().findForKey(kcode, targetDate);
	}

	/**
	 * oΕΏۓ擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kcode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	protected MSyukkinboDto getSyukkinboInfo(String kcode, Date targetDate) throws Exception {
		return getSyukkinboInfo(kcode, util.convDateFormatted(targetDate));
	}

	/**
	 * oΕΏۓsbN
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @return 				ΏDTO(sbNς)
	 * @throws Exception
	 */
	protected MSyukkinboDto lockSyukkinboInfo(String kCode, String targetDate) throws Exception {
		return syukkinboDao().findForUpdate(kCode, targetDate);
	}

	/**
	 * oΕΏۓsbN
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return 				ΏDTO(sbNς)
	 * @throws Exception
	 */
	protected MSyukkinboDto lockSyukkinboInfo(String kCode, Date targetDate) throws Exception {
		return lockSyukkinboInfo(kCode, util.convDateFormatted(targetDate));
	}

	/**
	 * oΕΏۓisbNj擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @return dto ΏDTO(sbNς)
	 * @throws Exception
	 */
	protected MSyukkinboDto getSyukkinboInfo(String kCode, String targetDate, boolean isUpdate) throws Exception {
		if (isUpdate) {
			return lockSyukkinboInfo(kCode, targetDate);
		}
		return getSyukkinboInfo(kCode, targetDate);
	}

	/**
	 * oΕΏۓisbNj擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return dto ΏDTO(sbNς)
	 * @throws Exception
	 */
	protected MSyukkinboDto getSyukkinboInfo(String kCode, Date targetDate, boolean isUpdate) throws Exception {
		if (isUpdate) {
			return lockSyukkinboInfo(kCode, targetDate);
		}
		return getSyukkinboInfo(kCode, targetDate);
	}

	/**
	 * Αӈꗗf[^
	 * @param kCode		ΏێЈR[h
	 * @throws Exception
	 */
	protected List<MSyukkinboDto> getAttendanceList(String kCode) throws Exception {
		// ꗗ̎擾
		attendanceList	= syukkinboDao().findForAttendanceList(kCode, startDate, endDate);
		return attendanceList;
	}

	/**
	 * Αӌꗗf[^擾
	 * @param kCode       ΏێЈR[h
	 * @param targetMonth Ώی
	 * @throws Exception
	 */
	protected List<MSyukkinboDto> getAttendanceList(String kCode, Date targetMonth) throws Exception {
		// ͈͎擾
		startDate = DatePart.convDateFormatted(getStartDate(targetMonth));
		endDate   = DatePart.convDateFormatted(getEndDate(targetMonth));
		// 
		getAttendanceList(kCode);
		return attendanceList;
	}

	/**
	 * Αӌꗗf[^擾i\pj
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param kCode
	 * @param targetDate
	 * @throws Exception
	 */
	protected List<MSyukkinboDto> getAttendanceListForView(String kCode, Date targetDate) throws Exception {
		// ͈͎擾
		startDate = DatePart.convDateFormatted(getStartDateForList(targetDate));
		endDate   = DatePart.convDateFormatted(getEndDateForList(targetDate));
		// 
		getAttendanceList(kCode);
		return attendanceList;
	}

	/**
	 * Wv
	 * @param kCode				ΏێЈR[h
	 * @param attendanceList	ΏۏoΕ냊Xg
	 * @throws Exception
	 */
	protected void totalAttendanceDaily(
			String kCode,
			List<MSyukkinboDto> attendanceList
	) throws Exception {
		KintaiCompileDto dto = PartManager.kintaicompile(partInfo()).getCompiledInfo(
				kCode,
				attendanceList
		);
		// z̏
		aryAttendanceCompile = new String[18][2];
		// z
		// Ζԍv
		aryAttendanceCompile[0][0] = CommonConst.NAM_WORKING;
		aryAttendanceCompile[0][1] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTotalWork()));
		// xeԍv
		aryAttendanceCompile[1][0] = CommonConst.NAM_INTERVAL_TIME;
		aryAttendanceCompile[1][1] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTotalInterbal()));
		// xԍv
		aryAttendanceCompile[2][0] = CommonConst.NAM_ARRIVE_LATE;
		aryAttendanceCompile[2][1] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTotalLate()));
		// ގԍv
		aryAttendanceCompile[3][0] = CommonConst.NAM_LEAVE_EARLY;
		aryAttendanceCompile[3][1] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTotalLeave()));
		// cƎԍv
		aryAttendanceCompile[4][0] = CommonConst.NAM_OVERTIME;
		aryAttendanceCompile[4][1] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTotalOver()));
		// xoԍv
		aryAttendanceCompile[5][0] = CommonConst.NAM_WORK_ON_HOLIDAY;
		aryAttendanceCompile[5][1] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTotalHolidayWork()));
		// [鎞ԍv
		aryAttendanceCompile[6][0] = CommonConst.NAM_LATE_NIGHT;
		aryAttendanceCompile[6][1] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTotalLateNight()));
		// oΓ
		aryAttendanceCompile[7][0] = CommonConst.NAM_PRESENCE;
		aryAttendanceCompile[7][1] = String.valueOf(dto.getTotalWorkDays());
		// Lxɓ
		aryAttendanceCompile[8][0] = aryHolidayReason[0][1];
		aryAttendanceCompile[8][1] = String.valueOf(dto.getTotalPaidHoliday());
		// ʋxɓ
		aryAttendanceCompile[9][0] = aryHolidayReason[1][1];
		aryAttendanceCompile[9][1] = String.valueOf(dto.getTotalParticularHoliday());
		// ΋xɓ
		aryAttendanceCompile[10][0] = aryHolidayReason[2][1];
		aryAttendanceCompile[10][1] = String.valueOf(dto.getTotalAbsence());
		// axɓ
		aryAttendanceCompile[11][0] = aryHolidayReason[3][1];
		aryAttendanceCompile[11][1] = String.valueOf(dto.getTotalMedicalLeave());
		// x
		aryAttendanceCompile[12][0] = aryHolidayReason[4][1];
		aryAttendanceCompile[12][1] = String.valueOf(dto.getTotalCompensationDay());
		// U֋xɓ
		aryAttendanceCompile[13][0] = aryHolidayReason[5][1];
		aryAttendanceCompile[13][1] = String.valueOf(dto.getTotalTransfer());
		// xɓ
		aryAttendanceCompile[14][0] = CommonConst.NAM_OTHER_SHORT;
		aryAttendanceCompile[14][1] = String.valueOf(dto.getTotalOther());
		// xސ
		aryAttendanceCompile[15][0] = CommonConst.NAM_LATE_AND_LEAVE_EARLY;
		aryAttendanceCompile[15][1] = String.valueOf(dto.getLeaveAndLate());
		// 蓖
		StringBuffer allowance = new StringBuffer();
		allowance.append(dto.getSyokuji());
		allowance.append(CommonConst.STR_SLASH_SEPARATOR);
		allowance.append(dto.getCyoku1());
		allowance.append(dto.getCyoku2());
		allowance.append(dto.getCyoku3());
		allowance.append(CommonConst.STR_SLASH_SEPARATOR);
		allowance.append(dto.getHoka1());
		allowance.append(dto.getHoka2());
		allowance.append(dto.getHoka3());
		allowance.append(dto.getHoka4());
		allowance.append(dto.getHoka5());
		aryAttendanceCompile[16][0] = CommonConst.NAM_ALLOWANCE;
		aryAttendanceCompile[16][1] = allowance.toString();
		// F΁i΁AʋxɁAaAxސ̍vj
		aryAttendanceCompile[17][0] = CommonConst.NAM_PERFECT_ATTENDANCE;
		if (dto.isApplyAttendanceAllowance()) {
			aryAttendanceCompile[17][1] = CommonConst.NAM_PERFECT_ATTENDANCE;
		} else {
			aryAttendanceCompile[17][1] = "";			
		}
	}

	/**
	 * Ζ`ԃ}X^ݒ
	 * @throws Exception 
	 */
	protected void setWorkTypeMap() throws Exception {
		// 擾ϊmF
		if (workTypeMap != null) {
			return;
		}
		// Map̍쐬
		workTypeMap = getWorkTypeMap();
	}

	/**
	 * Ζ`ԕʏ擾
	 * @param shiftcode		ΏۋΖ`ԃR[h
	 * @return
	 * @throws Exception
	 */
	protected MWorkTypeDto getWorkTypeInfo(String shiftcode) throws Exception {
		// Ζ`ԃ}X^ݒ
		setWorkTypeMap();
		return workTypeMap.get(shiftcode);
	}

	/**
	 * [鎞Ԏ擾
	 * @throws Exception 
	 */
	private void setLateNightTime() throws Exception {
		// l̐ݒ
		lateNightStart = PartManager.kintai(partInfo()).getLateNightStart();
		lateNightEnd   = lateNightStart + PartManager.kintai(partInfo()).getLateNightEnd();
	}

	/**
	 * vZtO擾
	 * @throws Exception
	 */
	private void setAutoCalc() throws Exception {
		// vZtO擾
		isAutoCalc = PartManager.kintai(partInfo()).isAutoCalc();
	}

	/**
	 * xɎԎ擾
	 * @throws Exception
	 */
	private void setHolidayTimes() throws Exception {
		allHoliday = PartManager.kintai(partInfo()).getAllHolidayTimes();
		halfHoliday = PartManager.kintai(partInfo()).getHalfHolidayTimes();
	}

	/**
	 * Wv{ݒ
	 * @throws Exception
	 */
	protected void setCalcParam() throws Exception {
		// vZݒ
		setAutoCalc();
		// ͒Pʎ
		setInputUnit();
		// [鎞Ԑݒ
		setLateNightTime();
		// xɎԐݒ
		setHolidayTimes();
		// xɗR
		aryHolidayReason = PartManager.mospcode(partInfo()).getHolidayReasonArray();
	}

	/**
	 * ͒PʎԐݒ
	 * @throws Exception
	 */
	protected void setInputUnit() throws Exception {
		// ͒Pʎ
		inputUnit = PartManager.kintai(partInfo()).getInputUnitTimes();
	}

	/**
	 * FR\
	 * @param riyuu FR
	 * @return	result
	 * @throws Exception
	 */
	protected String[] getApproval(String riyuu) throws Exception {
		return PartManager.kintaiapproval(partInfo()).getApproval(riyuu);
	}

	/**
	 * Αӌ
	 * @throws Exception
	 */
	protected void searchAttendance() throws Exception {
		// Αӌ
		MSyukkinboDto dto = getSyukkinboInfo(key1, key2);
		if (VariousPart.chkExistDto(dto)) {
			if (!KintaiCommonPart.isHoliday(dto)) {
				// oΗLAދΖ
				if (dto.getTaJikoku().equals("") 
						&& !KintaiCommonPart.isWeekHoliday(dto)
				) {
					// ދΕ\
					setNextCmd(AttendanceQuitCardAction.CMD_QUIT_CARD_SHOW);
				} else {
					// oΗLAދΗLiTx̏ꍇj
					// mF\
					setNextCmd(AttendanceCheckCardAction.CMD_CHECK_CARD_SELECT);
				}				
			} else {
				// x
				// xɕ\
				setNextCmd(AttendanceHolidayCardAction.CMD_HOLIDAY_CARD_SELECT);		
			}
		} else {
			// oΕ\
			setNextCmd(AttendanceStartCardAction.CMD_START_CARD_SHOW);
		}
		// T[ubg֓]
		setUrl(MospConst.URL_SRV);
	}

	/**
	 * Αӓo^p[^ݒ
	 * @param vo
	 * @throws Exception
	 */
	protected void setAttendanceInfo(AttendanceMenuVo vo) throws Exception {
		// l{擾
		HumanBasisDtoInterface mKihonDto = getBasisInfo(key1);
		// AttendanceMenuVoɒlZbg
		vo.setHidKCode(mKihonDto.getKCode());
		vo.setHidKName(mKihonDto.getSimei());
		vo.setHidYear(String.valueOf(MospUtility.getYear(MospUtility.getDate(key2))));
		vo.setHidMonth(String.valueOf(MospUtility.getMonth(MospUtility.getDate(key2))));
		vo.setHidDay(String.valueOf(MospUtility.getDay(MospUtility.getDate(key2))));
		vo.setHidDate(util.convStringDateFormatted(vo.getHidYear(), vo.getHidMonth(), vo.getHidDay()));
		vo.setHidSelectCmd(cmd);
		vo.setLblKCode(vo.getHidKCode());
		vo.setLblKName(vo.getHidKName());
		vo.setLblYear(vo.getHidYear());
		vo.setLblMonth(vo.getHidMonth());
		vo.setLblDay(vo.getHidDay());
		// cƐ\ݒ
		setOverTimeRequestInfo(vo);
	}

	/**
	 * \[hZbg
	 * <p>[VK]A[XV]A[Fς]</p>
	 * @param vo
	 * @param dto
	 */
	protected void setMode(AttendanceMenuVo vo, MSyukkinboDto dto) throws Exception {
		if (!chkExistDto(dto)) {
			vo.setMode(AttendanceMenuVo.MODE_INSERT);
		} else if (KintaiApprovalPart.isApproved(dto)) {
			vo.setMode(AttendanceMenuVo.MODE_APPROVED);
		} else {
			vo.setMode(AttendanceMenuVo.MODE_EDIT);
		}
	}

	/**
	 * ČpMenuVo̕ۑ
	 * @param vo
	 */
	protected void setStoreAttendanceMenuVo(AttendanceMenuVo vo) {
		// ۑVO̔j
		removeStoredVo(CommonConst.VO_ATTENDANCE_MENU);
		// VO̕ۑ
		storeVo(CommonConst.VO_ATTENDANCE_MENU, vo);
	}

	/**
	 * j̎擾
	 * <p>	2009/02/25	m.yoshida	j\bhC </p>
	 * @param targetDate		Ώ۔N
	 * @return	Ώ۔Nj
	 * @throws Exception
	 */
	protected String getPublicHolidayName(Date targetDate) throws Exception {
		return PartManager.holiday(partInfo()).getPublicHolidayName(targetDate);
	}

	/**
	 * ΑӈꗗpTu^CgR}h̐ݒ
	 * @param vo	ΏVO
	 */
	protected void setSubTitleMenu(AttendanceMenuVo vo) {
		// ΑӊǗR}h
		if (getStoredVo(CommonConst.VO_EMPLOYEE_ATTENDANCE_LIST) != null) {
			// ԑJڊmF
			vo.setCmdMenuButton(vo.CMD_MENU_MAMAGE);
			vo.setCmdListButton(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			vo.setNamListButton(CommonConst.TTL_ATTENDANCE_LIST);
		} else {
			vo.setCmdMenuButton(vo.CMD_MENU_INPUT);
			vo.setCmdListButton(vo.CMD_MENU_INPUT);
			vo.setNamListButton(CommonConst.NAM_MENU);			
		}
	}

	/*XPW[֘A*/

	/**
	 * \茎ꗗf[^
	 * @param kCode		ΏێЈR[h
	 * @throws Exception
	 */
	protected List<MScheduleDto> getScheduleList(String kCode) throws Exception {
		// ꗗ̎擾
		scheduleList = scheduleDao().findForScheduleList(kCode, startDate, endDate);
		return scheduleList;
	}

	/**
	 * \茎ꗗf[^擾
	 * @param kCode       ΏێЈR[h
	 * @param targetMonth Ώی
	 * @throws Exception
	 */
	protected List<MScheduleDto> getScheduleList(String kCode, Date targetMonth) throws Exception {
		// ͈͎擾
		startDate = DatePart.convDateFormatted(getStartDate(targetMonth));
		endDate   = DatePart.convDateFormatted(getEndDate(targetMonth));
		// 
		getScheduleList(kCode);
		return scheduleList;
	}

	/**
	 * \茎ꗗf[^擾i\pj
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param kCode 		ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @throws Exception
	 */
	protected List<MScheduleDto> getScheduleListForView(String kCode, Date targetDate) throws Exception {
		// ͈͎擾
		startDate = DatePart.convDateFormatted(getStartDateForList(targetDate));
		endDate   = DatePart.convDateFormatted(getEndDateForList(targetDate));
		// 
		getScheduleList(kCode);
		return scheduleList;
	}

	/**
	 * Wvf[^Ԑݒ
	 * @param scheduleList		Ώۗ\냊Xg
	 * @throws Exception
	 */
	protected void setScheduleHours(List<MScheduleDto> scheduleList) throws Exception {
		// Αӏݒ
		setCalcParam();
		// Wvf[^擾
		Iterator<MScheduleDto> it = scheduleList.iterator();
		while (it.hasNext()) {
			MScheduleDto dto = it.next();
			if (KintaiCommonPart.isHoliday(dto)) {
				// xɂ̏ꍇ
				dto.setKKJikan(allHoliday);
			} else if (KintaiCommonPart.isWeekHoliday(dto)) {
				// Tx̏ꍇ
			} else {
				// o΂̏ꍇ
				// ΑӍڂ̌vZ
				dto = (MScheduleDto)getCalculatedInfo(dto);
			}
		}
	}

	/*\֘A*/

	/**
	 * IЈl{擾
	 * @param vo
	 * @throws Exception
	 */
	protected void setSelectBasicInfo(ScheduleMenuVo vo) throws Exception {
		// l{̎擾
		HumanBasisDtoInterface mKihonDto = getBasisInfo(vo.getSelectKCode());
		// I̐ݒ
		vo.setSelectKName(mKihonDto.getSimei());
		vo.setSelectSectionName(getSectionName(mKihonDto.getSCode()));
	}

	/**
	 * \̃Zbg
	 * @param mKihonDto 	ΏێЈ{
	 * @param arySchedule 	Ώۓ͗\
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	protected MScheduleDto setScheduleInfo(
			HumanBasisDtoInterface mKihonDto,
			String[] arySchedule
	) throws Exception {
		MScheduleDto dto = new MScheduleDto();
		dto.setKCode(mKihonDto.getKCode());
		dto.setHizuke(arySchedule[0]);
		dto.setNen(MospUtility.getYear(util.convStringDateToDate(dto.getHizuke())));
		dto.setTuki(MospUtility.getMonth(util.convStringDateToDate(dto.getHizuke())));
		dto.setHi(MospUtility.getDay(util.convStringDateToDate(dto.getHizuke())));
		dto.setSyozoku(mKihonDto.getSCode());
		dto.setUpdtTimes(util.getDateTime(DatePart.getNowDate()));
		dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
		if (KintaiCommonPart.isWeekHoliday(arySchedule[1])) {
			// Tx̏ꍇ
			dto.setKinmu(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
		} else {
			MWorkTypeDto workTypeDto = getWorkTypeInfo(arySchedule[1]);
			dto.setKinmu(workTypeDto.getShiftCode());
			dto.setSyJikoku(util.convIntegerTimeToStringTime(workTypeDto.getStartTime()));
			dto.setSyTimes(util.getDateTime(DatePart.getNowDate()));
			dto.setTaJikoku(util.convIntegerTimeToStringTime(workTypeDto.getQuitTime()));
			dto.setKinmuJi(workTypeDto.getWorkTime());
			dto.setKyukeiJi(workTypeDto.getBreakTime());
			dto.setTaTimes(util.getDateTime(DatePart.getNowDate()));
		}
		return dto;
	}

	/**
	 * oἘo^
	 * @param dto			ΏDTO
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void insert(MSyukkinboDto dto, VoInterface vo) throws Exception {
		// ݃`FbN
		chkDuplicate(getSyukkinboInfo(dto.getKCode(), dto.getHizuke()), vo);
		// f[^̑}
		syukkinboDao().insert(dto);
		// DTO̍Ď擾
		chkInsert(getSyukkinboInfo(dto.getKCode(), dto.getHizuke()));
	}

	/**
	 * \̓o^
	 * @param dto
	 * @throws Exception
	 */
	protected void registSchedule(MScheduleDto dto, VoInterface vo) throws Exception {
		MScheduleDto currentDto = getScheduleInfo(dto.getKCode(), dto.getHizuke());
		if (chkExistDto(currentDto)) {
			// rmF
			chkExclusive(currentDto, lockScheduleInfo(dto.getKCode(), dto.getHizuke()), vo);
			// XV
			scheduleDao().update(dto);
		} else {
			// o^
			scheduleDao().insert(dto);
		}
		// DTO̍Ď擾	
		chkUpdate(getScheduleInfo(dto.getKCode(), dto.getHizuke()));
	}

	/**
	 * oΕpݒ
	 * @param dto MScheduleDto
	 * @return mSyukkinboDto MSyukkinboDto
	 * @throws Exception
	 */
	protected MSyukkinboDto copyScheduleInfo(MScheduleDto dto) throws Exception {
		return KintaiCommonPart.copyScheduleToSyukkinbo(dto);
	}

	/**
	 * J}؂̓t擾
	 * @param year		
	 * @param month
	 * @param day
	 * @return
	 */
	protected String getMessageDate(String year, String month, String day) {
		return util.convStringDateFormatted(year, month, day);
	}

	/**
	 * ΑӌvZ@Ăяo
	 * @param shiftCode		ΏۋΖ`kR[h
	 * @return	ΑӌvZ@CX^X
	 * @throws Exception 
	 */
	protected KintaiCalcPart getCalculator(String shiftCode) throws Exception {
		MWorkTypeDto dto = getWorkTypeInfo(shiftCode);
		if (dto == null) {
			throw new NullPointerException();
		}
		return new KintaiCalcPart(
				dto.getStartTime(),
				dto.getQuitTime(),
				dto.getWorkTime(),
				dto.getBreakTime(),
				dto.getOverStart(),
				dto.getOverBreak(),
				lateNightStart,
				lateNightEnd,
				halfHoliday,
				inputUnit
		);
	}

	/**
	 * o΍ڌvZ
	 * @param dto			ΏۏoΕDTO
	 * @return	o΍ڌvZςݏoΕDTO
	 * @throws Exception
	 */
	protected MSyukkinboDto getStartCalculated(MSyukkinboDto dto) throws Exception {
		// Ζ`ԕʏݒ
		KintaiCalcPart calc = getCalculator(dto.getKinmu());
		// o΍ڂ̌vZ
		calc.runCalcStartTime(
				// oΎԃZbg
				util.convStringTimeToIntegerTime(dto.getSyJikoku()),
				KintaiCommonPart.isStartHalfHoliday(dto),
				KintaiCommonPart.isWorkOnHoliday(dto)
		);
		// xԃZbg
		dto.setTiJikan(calc.getLateTime());
		return dto;
	}

	/**
	 * ΑӍڌvZ
	 * @param dto		ΏDTO
	 * @return	ΑӍڌvZςDTO
	 * @throws Exception
	 */
	protected KintaiCommonDtoInterface getCalculatedInfo(KintaiCommonDtoInterface dto) throws Exception {
		// ΑӌvZ@擾
		KintaiCalcPart calc = getCalculator(dto.getKinmu());
		// eڂ̌vZ
		calc.runCalculate(
				// oΎZo
				util.convStringTimeToIntegerTime(dto.getSyJikoku()),
				// ދΎZo
				util.convStringTimeToIntegerTime(dto.getTaJikoku()),
				KintaiCommonPart.isStartHalfHoliday(dto),
				KintaiCommonPart.isQuitHalfHoliday(dto),
				KintaiCommonPart.isWorkOnHoliday(dto)
		);
		// xԃZbg
		dto.setTiJikan(calc.getLateTime());
		// ΖԃZbg
		dto.setKinmuJi(calc.getWorkTime());
		// ގԃZbg
		dto.setSoJikan(calc.getLeaveTime());
		// cƎԃZbg
		dto.setZaJikan(calc.getOverTime());
		// xeԃZbg
		dto.setKyukeiJi(calc.getIntervalTime());
		// [鎞ԃZbg
		dto.setSnJikan(calc.getLateNightTime());
		// xoԃZbg
		dto.setKsJikan(calc.getHolidayWorkTime());
		return dto;
	}

	/**
	 * cƐ\ݒ
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void setOverTimeRequestInfo(AttendanceMenuVo vo) throws Exception {
		// cƐ\擾
		CtOvertimeRequestDto dto = PartManager.overtime(partInfo()).getTargetOverTimeRequest(
				vo.getHidKCode(),
				DatePart.convStringDateToDate(vo.getHidDate())
		);
		// 
		vo.setApplicationTime("");
		vo.setRequestStatus("");
		if (VariousPart.chkExistDto(dto)) {
			// \
			vo.setApplicationTime(TimePart.convIntegerTimeToJPHours(dto.getOverTime()));
			// F
			vo.setRequestStatus(PartManager.kintaiapproval(partInfo())
					.getApprovalName(
							PartManager.workflow(partInfo())
							.toKintaiApprovalStatus(dto.getWorkflow())
					)
			);
		}
	}

}
