/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import jp.mosp.common.common.BaseDto;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDao {
    protected String INSERT_DATE = "adddt";
    protected String INSERT_USER = "addcd";
    protected String UPDATE_DATE = "upddt";
    protected String UPDATE_USER = "updcd";
    protected Properties cfg;
    protected String aspUserId;
    protected String userId;
    protected String cmd;
    protected Connection conn;
    protected PreparedStatement ps;
    protected ResultSet rs;
    protected int cnt;
    protected int index;
    String sql;
    StringBuffer params;

    protected BaseDao() {
    }

    protected BaseDao(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
        this.initDao(cfg, cmd, aspUser, user, conn);
    }

    public void initDao(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
        this.cfg = cfg;
        this.cmd = cmd;
        if (aspUser != null) {
            this.aspUserId = aspUser.getAspUserId();
        }
        if (user != null) {
            this.userId = user.getUserId();
        }
        this.conn = conn;
        this.params = new StringBuffer();
    }

    protected void releaseResultSet() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
    }

    protected void prepareStatement(String sql) throws SQLException {
        this.ps = this.conn.prepareStatement(sql);
        this.sql = sql;
    }

    protected void releasePreparedStatement() throws SQLException {
        if (this.ps != null) {
            this.ps.close();
        }
        this.sql = "";
    }

    protected void setParam(int idx, String param) throws SQLException {
        if (this.ps != null) {
            this.ps.setString(idx, param);
            this.params.append(param);
            this.params.append(",");
        }
    }

    protected void setParam(int idx, int param) throws SQLException {
        if (this.ps != null) {
            this.ps.setInt(idx, param);
            this.params.append(param);
            this.params.append(",");
        }
    }

    protected void setParam(int idx, long param) throws SQLException {
        if (this.ps != null) {
            this.ps.setLong(idx, param);
            this.params.append(param);
            this.params.append(",");
        }
    }

    protected void setParam(int idx, float param) throws SQLException {
        if (this.ps != null) {
            this.ps.setFloat(idx, param);
            this.params.append(param);
            this.params.append(",");
        }
    }

    protected void setParam(int idx, double param) throws SQLException {
        if (this.ps != null) {
            this.ps.setDouble(idx, param);
            this.params.append(param);
            this.params.append(",");
        }
    }

    protected void setParam(int idx, Date param) throws SQLException {
        if (this.ps != null) {
            if (param == null) {
                this.ps.setTimestamp(idx, null);
            } else {
                this.ps.setTimestamp(idx, new Timestamp(param.getTime()));
            }
            this.params.append(param);
            this.params.append(",");
        }
    }

    protected void setDateParam(int idx, Date param) throws SQLException {
        if (this.ps != null) {
            if (param == null) {
                this.ps.setDate(idx, null);
            } else {
                this.ps.setDate(idx, new java.sql.Date(param.getTime()));
            }
            this.params.append(param);
            this.params.append(",");
        }
    }

    protected void clearParams() throws SQLException {
        if (this.ps != null) {
            this.ps.clearParameters();
        }
        this.params = new StringBuffer();
    }

    protected void executeQuery() throws SQLException {
        if (this.ps != null) {
            this.rs = this.ps.executeQuery();
        }
    }

    protected void executeUpdate() throws SQLException {
        if (this.ps != null) {
            this.cnt = this.ps.executeUpdate();
            LogUtility.log(this.cfg, this.aspUserId, this.userId, this.cmd, 2, "\u66f4\u65b0\u30af\u30a8\u30ea\u30fc\u5b9f\u884c", this.params.toString() + this.sql);
        }
    }

    protected void executeUpdate(boolean needLog) throws SQLException {
        if (this.ps != null) {
            this.cnt = this.ps.executeUpdate();
            if (needLog) {
                LogUtility.log(this.cfg, this.aspUserId, this.userId, this.cmd, 2, "\u66f4\u65b0\u30af\u30a8\u30ea\u30fc\u5b9f\u884c", this.params.toString() + this.sql);
            }
        }
    }

    protected String getSelectQuery(Class<?> cls) throws NoSuchFieldException, IllegalAccessException {
        StringBuffer query = new StringBuffer();
        query.append(this.getSelectStatement(cls));
        query.append("FROM ");
        query.append(this.getTable(cls));
        query.append(" ");
        return query.toString();
    }

    protected String getSelectStatement(Class<?> cls) throws IllegalAccessException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            if (name.indexOf("COL_") != 0) continue;
            query.append(field.get(null));
            query.append(", ");
        }
        query.append(this.getCommonColumn());
        query.delete(query.length() - 2, query.length() - 1);
        return query.toString();
    }

    protected String getSelectStatement(Class<?> cls, boolean needTableName) throws IllegalAccessException, NoSuchFieldException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            if (name.indexOf("COL_") != 0) continue;
            if (needTableName) {
                query.append(this.getTable(cls) + ".");
            }
            query.append(field.get(null));
            query.append(", ");
        }
        query.append(this.getCommonColumn(cls, needTableName));
        query.delete(query.length() - 2, query.length() - 1);
        return query.toString();
    }

    protected String getSelectCountQuery(Class<?> cls) throws IllegalAccessException, NoSuchFieldException {
        StringBuffer query = new StringBuffer();
        query.append(this.getSelectCountStatement());
        query.append(" FROM ");
        query.append(this.getTable(cls));
        query.append(" ");
        return query.toString();
    }

    protected String getSelectCountStatement() {
        StringBuffer query = new StringBuffer();
        query.append("SELECT COUNT(*) ");
        return query.toString();
    }

    protected String getInsertQuery(Class<?> cls) throws NoSuchFieldException, IllegalAccessException {
        StringBuffer query = new StringBuffer();
        query.append(this.getInsertQueryBase(cls));
        query.append("(");
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            if (name.indexOf("COL_") != 0) continue;
            query.append("?, ");
        }
        query.append(this.getCommonParams());
        query.delete(query.length() - 2, query.length());
        query.append(")");
        return query.toString();
    }

    private String getInsertQueryBase(Class<?> cls) throws IllegalAccessException, NoSuchFieldException {
        StringBuffer query = new StringBuffer();
        query.append("INSERT INTO ");
        query.append(this.getTable(cls));
        query.append("(");
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            if (name.indexOf("COL_") != 0) continue;
            query.append(field.get(null));
            query.append(", ");
        }
        query.append(this.getCommonColumn());
        query.delete(query.length() - 2, query.length() - 1);
        query.append(") VALUES");
        return query.toString();
    }

    private String getCommonColumn() {
        StringBuffer query = new StringBuffer();
        if (!this.INSERT_DATE.equals("")) {
            query.append(this.INSERT_DATE + ", ");
        }
        if (!this.INSERT_USER.equals("")) {
            query.append(this.INSERT_USER + ", ");
        }
        if (!this.UPDATE_DATE.equals("")) {
            query.append(this.UPDATE_DATE + ", ");
        }
        if (!this.UPDATE_USER.equals("")) {
            query.append(this.UPDATE_USER + ", ");
        }
        return query.toString();
    }

    private String getCommonColumn(Class<?> cls, boolean needTableName) throws NoSuchFieldException, IllegalAccessException {
        StringBuffer query = new StringBuffer();
        if (!this.INSERT_DATE.equals("")) {
            if (needTableName) {
                query.append(this.getTable(cls) + ".");
            }
            query.append(this.INSERT_DATE + ", ");
        }
        if (!this.INSERT_USER.equals("")) {
            if (needTableName) {
                query.append(this.getTable(cls) + ".");
            }
            query.append(this.INSERT_USER + ", ");
        }
        if (!this.UPDATE_DATE.equals("")) {
            if (needTableName) {
                query.append(this.getTable(cls) + ".");
            }
            query.append(this.UPDATE_DATE + ", ");
        }
        if (!this.UPDATE_USER.equals("")) {
            if (needTableName) {
                query.append(this.getTable(cls) + ".");
            }
            query.append(this.UPDATE_USER + ", ");
        }
        return query.toString();
    }

    private String getCommonParams() {
        StringBuffer query = new StringBuffer();
        if (!this.INSERT_DATE.equals("")) {
            query.append("?, ");
        }
        if (!this.INSERT_USER.equals("")) {
            query.append("?, ");
        }
        if (!this.UPDATE_DATE.equals("")) {
            query.append("?, ");
        }
        if (!this.UPDATE_USER.equals("")) {
            query.append("?, ");
        }
        return query.toString();
    }

    protected String getUpdateQuery(Class<?> cls) throws NoSuchFieldException, IllegalAccessException {
        StringBuffer query = new StringBuffer();
        query.append("UPDATE ");
        query.append(this.getTable(cls));
        query.append(" SET ");
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            if (name.indexOf("COL_") != 0) continue;
            query.append(field.get(null));
            query.append(" = ?, ");
        }
        if (!this.UPDATE_DATE.equals("")) {
            query.append(this.UPDATE_DATE + " = ?, ");
        }
        if (!this.UPDATE_USER.equals("")) {
            query.append(this.UPDATE_USER + " = ?, ");
        }
        query.delete(query.length() - 2, query.length() - 1);
        query.append(this.getConditionForKey(cls));
        return query.toString();
    }

    protected String getDeleteQuery(Class<?> cls) throws NoSuchFieldException, IllegalAccessException {
        StringBuffer query = new StringBuffer();
        query.append("DELETE FROM ");
        query.append(this.getTable(cls));
        query.append(" ");
        query.append(this.getConditionForKey(cls));
        return query.toString();
    }

    protected String getConditionForKey(Class<?> cls) throws IllegalAccessException {
        StringBuffer query = new StringBuffer();
        query.append("WHERE ");
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            if (name.indexOf("KEY_") != 0) continue;
            query.append(field.get(null));
            query.append(" = ? AND ");
        }
        query.delete(query.length() - 4, query.length());
        query.append(" ");
        return query.toString();
    }

    protected String getAddConditionForKey(Class<?> cls) throws IllegalAccessException {
        StringBuffer query = new StringBuffer();
        query.append(" AND ");
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            if (name.indexOf("KEY_") != 0) continue;
            query.append(field.get(null));
            query.append(" = ? AND ");
        }
        query.delete(query.length() - 4, query.length());
        query.append(" ");
        return query.toString();
    }

    protected String getOrderForKey(Class<?> cls) throws IllegalAccessException {
        StringBuffer query = new StringBuffer();
        query.append(this.getOrderBy());
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            if (name.indexOf("KEY_") != 0) continue;
            query.append(field.get(null));
            query.append(", ");
        }
        query.delete(query.length() - 2, query.length());
        query.append(" ");
        return query.toString();
    }

    protected String getTable(Class<?> cls) throws NoSuchFieldException, IllegalAccessException {
        Field table = cls.getField("TABLE");
        return (String)table.get(null);
    }

    protected String getPageStatement(String sortKey, boolean isAscending) {
        StringBuffer query = new StringBuffer();
        query.append(this.getOrderBy() + sortKey + " ");
        if (!isAscending) {
            query.append(this.getDesc());
        }
        query.append(this.getLimit() + "? ");
        query.append(this.getOffset() + "? ");
        return query.toString();
    }

    protected String getForUpdate() {
        return "FOR UPDATE";
    }

    protected String getOrderBy() {
        return "ORDER BY ";
    }

    protected String getDesc() {
        return "DESC ";
    }

    protected String getLimit() {
        return "LIMIT ";
    }

    protected String getOffset() {
        return "OFFSET ";
    }

    protected void mappingCommonInfo(BaseDto dto) throws SQLException {
        if (!this.INSERT_DATE.equals("")) {
            Date insertDate = new Date(this.rs.getTimestamp(this.INSERT_DATE).getTime());
            dto.setInsertDate(insertDate);
        }
        if (!this.INSERT_USER.equals("")) {
            dto.setInsertUser(this.rs.getString(this.INSERT_USER));
        }
        if (!this.UPDATE_DATE.equals("")) {
            Date updateDate = new Date(this.rs.getTimestamp(this.UPDATE_DATE).getTime());
            dto.setUpdateDate(updateDate);
        }
        if (!this.UPDATE_USER.equals("")) {
            dto.setUpdateUser(this.rs.getString(this.UPDATE_USER));
        }
    }

    protected void setCommonParams(boolean isInsert) throws SQLException {
        Date date = new Date();
        if (isInsert) {
            if (!this.INSERT_DATE.equals("")) {
                this.setParam(this.index++, date);
            }
            if (!this.INSERT_USER.equals("")) {
                this.setParam(this.index++, this.userId);
            }
        }
        if (!this.UPDATE_DATE.equals("")) {
            this.setParam(this.index++, date);
        }
        if (!this.UPDATE_USER.equals("")) {
            this.setParam(this.index++, this.userId);
        }
    }

    protected void chkInsert(int expectedCount) throws MospException {
        if (this.cnt != expectedCount) {
            throw new MospException(1021);
        }
    }

    protected void chkUpdate(int expectedCount) throws MospException {
        if (this.cnt != expectedCount) {
            throw new MospException(1022);
        }
    }

    protected void chkDelete(int expectedCount) throws MospException {
        if (this.cnt != expectedCount) {
            throw new MospException(1025);
        }
    }

    protected int getRdbmsType() throws MospException {
        try {
            String rdbmsName = this.conn.getMetaData().getDatabaseProductName();
            if (rdbmsName.equals("MySQL")) {
                return 1;
            }
            if (rdbmsName.equals("PostgreSQL")) {
                return 2;
            }
            LogUtility.log(this.cfg, "", "", "", 5, "MosP\u30a8\u30e9\u30fc", "RDBMS\u304c\u4e0d\u660e\u306a\u305f\u3081RDBMS\u4f9d\u5b58\u30af\u30a8\u30ea\u30fc\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002" + rdbmsName);
            throw new MospException(3003);
        }
        catch (SQLException e) {
            throw new MospException(9001, MospUtility.getStackTrace(e));
        }
    }

    protected String getTableDescriptionQuery(String tableName) throws MospException {
        StringBuffer sb = new StringBuffer();
        switch (this.getRdbmsType()) {
            case 1: {
                sb.append("SHOW FULL COLUMNS FROM ");
                sb.append(tableName);
                break;
            }
            case 2: {
                sb.append("SELECT ");
                sb.append("pg_attribute.attname as FIELD, ");
                sb.append("pg_type.typname as TYPE, ");
                sb.append("pg_description.description as COMMENT ");
                sb.append("FROM ");
                sb.append("pg_attribute, ");
                sb.append("pg_type, ");
                sb.append("pg_description, ");
                sb.append("pg_stat_all_tables ");
                sb.append("WHERE ");
                sb.append("pg_stat_all_tables.relname = '");
                sb.append(tableName.toLowerCase());
                sb.append("' ");
                sb.append("AND ");
                sb.append("pg_stat_all_tables.relid = pg_description.objoid ");
                sb.append("AND ");
                sb.append("pg_description.objsubid <> 0 ");
                sb.append("AND ");
                sb.append("pg_description.objoid = pg_attribute.attrelid ");
                sb.append("AND ");
                sb.append("pg_description.objsubid = pg_attribute.attnum ");
                sb.append("AND ");
                sb.append("pg_type.oid = pg_attribute.atttypid ");
                sb.append("ORDER BY ");
                sb.append("pg_description.objsubid");
                break;
            }
        }
        return sb.toString();
    }

    protected String getInsertQuery(Class<?> cls, int size, int max) throws IllegalAccessException, NoSuchFieldException {
        int i;
        StringBuffer query = new StringBuffer();
        query.append(this.getInsertQueryBase(cls));
        Field[] fields = this.getClass().getFields();
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            if (name.indexOf("COL_") != 0) continue;
            sb.append("?, ");
        }
        sb.append(this.getCommonParams());
        sb.delete(sb.length() - 2, sb.length());
        sb.append("), ");
        for (i = 0; i < size && i != max; ++i) {
            query.append(sb);
        }
        query.delete(query.length() - 2, query.length());
        return query.toString();
    }

    protected void executeUpdate(Class<?> cls, int size, int max, int idx) throws SQLException, IllegalAccessException, NoSuchFieldException {
        int executeIndex = idx + 1;
        if (executeIndex % max == 0 || executeIndex == size) {
            this.executeUpdate(false);
            this.clearParams();
            this.index = 1;
            if (size - executeIndex < max && executeIndex != size) {
                this.releasePreparedStatement();
                this.prepareStatement(this.getInsertQuery(cls, size - executeIndex, max));
            }
        } else {
            this.cnt = 0;
        }
    }
}

