/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.PrintedPage;
import org.jopendocument.print.DocumentPrinter;
import org.jopendocument.renderer.ODTRenderer;

public class ODSViewerPanel
extends JPanel {
    ODTRenderer renderer;
    int mode;
    int zoom = 100;
    private static final int MODE_PAGE = 0;
    private static final int MODE_WIDTH = 1;
    private static final int MODE_ZOOM = 2;
    JScrollPane scroll;
    JPanel viewer = new JPanel();
    final JTextField textFieldZoomValue = new JTextField(5);
    int currentPageIndex = 0;

    public ODSViewerPanel(OpenDocument openDocument) {
        this(openDocument, null, true);
    }

    public ODSViewerPanel(OpenDocument openDocument, boolean bl) {
        this(openDocument, null, bl);
    }

    public ODSViewerPanel(OpenDocument openDocument, DocumentPrinter documentPrinter) {
        this(openDocument, documentPrinter, true);
    }

    public ODSViewerPanel(final OpenDocument openDocument, final DocumentPrinter documentPrinter, boolean bl) {
        JComponent jComponent;
        Toolkit.getDefaultToolkit().setDynamicLayout(false);
        this.setOpaque(false);
        this.renderer = new ODTRenderer(openDocument);
        this.renderer.setIgnoreMargins(bl);
        this.updateMode(2, this.zoom);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Fit page");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ODSViewerPanel.this.updateMode(0, 100);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Fit width");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ODSViewerPanel.this.updateMode(1, 100);
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton("-");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ODSViewerPanel.this.zoom > 30) {
                    ODSViewerPanel.this.updateMode(2, ODSViewerPanel.this.zoom - 20);
                }
            }
        });
        jPanel.add(jButton3);
        this.textFieldZoomValue.setEditable(false);
        jPanel.add(this.textFieldZoomValue);
        JButton jButton4 = new JButton("+");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ODSViewerPanel.this.zoom + 20;
                if (n > 400) {
                    n = 400;
                }
                ODSViewerPanel.this.updateMode(2, n);
            }
        });
        jPanel.add(jButton4);
        this.viewer.setOpaque(false);
        this.viewer.setBackground(Color.DARK_GRAY);
        this.viewer.setLayout(null);
        this.renderer.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        this.viewer.add(this.renderer);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.scroll = new JScrollPane(this.viewer);
        this.scroll.setOpaque(false);
        this.scroll.setHorizontalScrollBarPolicy(32);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.scroll.getHorizontalScrollBar().setUnitIncrement(30);
        this.scroll.getVerticalScrollBar().setUnitIncrement(30);
        ((JComponent)this.scroll.getViewport().getView()).setOpaque(false);
        this.add((Component)this.scroll, "Center");
        this.updateMode(2, this.zoom);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                ODSViewerPanel.this.updateMode(ODSViewerPanel.this.mode, ODSViewerPanel.this.zoom);
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        if (openDocument.getPrintedPageCount() > 1) {
            jComponent = new JTextField(5);
            JButton jButton5 = new JButton("<");
            jButton5.addActionListener(new ActionListener((JTextField)jComponent){
                final /* synthetic */ JTextField val$page;
                {
                    this.val$page = jTextField;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ODSViewerPanel.this.currentPageIndex > 0) {
                        --ODSViewerPanel.this.currentPageIndex;
                        ODSViewerPanel.this.updatePage(openDocument.getPrintedPage(ODSViewerPanel.this.currentPageIndex));
                        ODSViewerPanel.this.updatePageCount(openDocument, this.val$page);
                    }
                }
            });
            JButton jButton6 = new JButton(">");
            jButton6.addActionListener(new ActionListener((JTextField)jComponent){
                final /* synthetic */ JTextField val$page;
                {
                    this.val$page = jTextField;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ODSViewerPanel.this.currentPageIndex < openDocument.getPrintedPageCount() - 1) {
                        ++ODSViewerPanel.this.currentPageIndex;
                        ODSViewerPanel.this.updatePage(openDocument.getPrintedPage(ODSViewerPanel.this.currentPageIndex));
                        ODSViewerPanel.this.updatePageCount(openDocument, this.val$page);
                    }
                }
            });
            jPanel.add(jButton5);
            jPanel.add(jComponent);
            jPanel.add(jButton6);
        }
        if (documentPrinter != null) {
            jComponent = new JButton("Print");
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    documentPrinter.print(openDocument);
                }
            });
            jPanel.add(jComponent);
        }
    }

    private void updatePageCount(OpenDocument openDocument, JTextField jTextField) {
        jTextField.setText(this.currentPageIndex + 1 + "/" + openDocument.getPrintedPageCount());
    }

    protected void updatePage(PrintedPage printedPage) {
        this.renderer.setCurrentPage(printedPage);
    }

    private void updateMode(int n, int n2) {
        System.out.println("ODSViewerPanel.updateMode():mode:" + n + " z:" + n2);
        this.mode = n;
        this.zoom = n2;
        int n3 = this.renderer.getPrintWidthInPixel();
        int n4 = this.renderer.getPrintHeightInPixel();
        switch (n) {
            case 0: {
                int n5 = this.getHeight() - this.scroll.getHorizontalScrollBar().getHeight();
                System.out.println("Panel width:" + n5 + " Renderer W:" + this.renderer.getPrintWidth());
                double d = this.renderer.getPrintHeight() / (double)n5;
                System.out.println("resize to:" + d);
                this.renderer.setResizeFactor(d);
                this.zoom = (int)Math.round(36000.0 / d);
                int n6 = 0;
                int n7 = 0;
                if (this.scroll != null) {
                    n6 = (this.scroll.getViewportBorderBounds().width - n3) / 2;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                this.renderer.setLocation(n6, n7);
                break;
            }
            case 1: {
                int n5 = this.getWidth() - this.scroll.getVerticalScrollBar().getWidth();
                System.out.println("Panel width:" + n5 + " Renderer W:" + this.renderer.getPrintWidth());
                double d = this.renderer.getPrintWidth() / (double)n5;
                System.out.println("resize to:" + d);
                this.renderer.setResizeFactor(d);
                this.zoom = (int)Math.round(36000.0 / d);
                this.renderer.setLocation(0, 0);
                break;
            }
            case 2: {
                this.renderer.setResizeFactor(36000 / n2);
                System.out.println("w:" + this.renderer.getPrintWidthInPixel());
                int n5 = 0;
                int n8 = 0;
                if (this.scroll != null) {
                    n5 = (this.scroll.getViewportBorderBounds().width - n3) / 2;
                    n8 = (this.scroll.getViewportBorderBounds().height - n4) / 2;
                }
                if (n8 > 10) {
                    n8 = 10;
                }
                System.out.println("ppppossss:" + n5);
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n8 < 0) {
                    n8 = 0;
                }
                this.renderer.setLocation(n5, n8);
                if (n5 > 0 || n8 > 0) {
                    this.renderer.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
                    break;
                }
                this.renderer.setBorder(null);
                break;
            }
        }
        this.textFieldZoomValue.setText(this.zoom + " %");
        Dimension dimension = new Dimension(this.renderer.getPrintWidthInPixel(), this.renderer.getPrintHeightInPixel());
        this.renderer.setSize(this.renderer.getPrintWidthInPixel(), this.renderer.getPrintHeightInPixel());
        this.viewer.setPreferredSize(dimension);
        this.viewer.revalidate();
        this.repaint();
    }

    public ODTRenderer getRenderer() {
        return this.renderer;
    }
}

