/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;

import jp.mosp.system.dto.MWorkTypeDto;

public class WorkTypeMasterListVo extends MosPVo {

	private static final long serialVersionUID = -3051204572322360172L;

	// URLACSS
	private static final String RETURN_URL	= "/jsp/system/workTypeMasterList.jsp";
	private static final String EXTRA_JS		= "/pub/system/js/workTypeMasterList.js";
	private static final String EXTRA_CSS		= "/pub/system/css/workTypeMasterList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_WORK_TYPE_MASTER;

	//萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	// p[^
	public static final String PRM_TXT_SHIFT_CODE = "txtShiftCode";
	public static final String PRM_TXT_SHIFT_NAME = "txtShiftName";
	public static final String PRM_PLT_DELETE		= "pltDelete"	;	

	// tB[h
	private String[]	aryShiftCode;
	private String[]	aryShiftName;
	private String[]	aryWorkTable;
	private String[]	aryDelete	;
	private String		txtShiftCode;
	private String		txtShiftName;
	private String		pltDelete	;

	// tB[hyѐ
	public static final String NAM_SHIFT_CODE 	= CommonConst.NAM_COMMON_CODE;
	public static final String NAM_SHIFT_NAME 	= CommonConst.NAM_WORKING_TYPE;
	public static final String NAM_WORKING_TABLE	= CommonConst.NAM_WORKING_TABLE_INFO;
	public static final String NAM_DELETE    		= CommonConst.NAM_DELETE_FLAG;

	public static final int	LEN_SHIFT_CODE 	= 10;
	public static final int	LEN_SHIFT_NAME	= 50;

	// \[gL[	
	public final String KEY_SHIFT_CODE	= "keyShiftCode";
	public final String KEY_SHIFT_NAME	= "keyShiftName";
	public final String KEY_DELETE		= "keyDelete"	;

	// [h(0FȂA1F)
	private int searchmode;

	/**
	 * RXgN^
	 */
	public WorkTypeMasterListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		txtShiftCode		= "";
		txtShiftName		= "";
		aryShiftCode		= new String[0];
		aryShiftName		= new String[0];
		aryWorkTable		= new String[0];
		aryDelete			= new String[0];
		setFormerKey(KEY_SHIFT_CODE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtShiftCode = request.getParameter(PRM_TXT_SHIFT_CODE);
		txtShiftName = request.getParameter(PRM_TXT_SHIFT_NAME);
		pltDelete    = request.getParameter(PRM_PLT_DELETE);
	}

	/**
	 * tB[hݒ
	 * @param listWorkingTable		Ζ`ԃXg
	 */
	public void setFields(List listWorkingTable) {
		// Xg̐ݒ
		list = listWorkingTable;
		// f[^̎擾
		count = listWorkingTable.size();
		// z̏
		aryShiftCode	= new String[count];
		aryShiftName	= new String[count];
		aryWorkTable	= new String[count];
		aryDelete		= new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listWorkingTable.iterator();
		while (it.hasNext()) {
			MWorkTypeDto dto = (MWorkTypeDto)it.next();
			aryShiftCode[i]	= escapeHTML(dto.getShiftCode());
			aryShiftName[i]	= escapeHTML(dto.getShiftName());
			aryWorkTable[i]	= escapeHTML(convWorkTypeTimes(dto.getStartTime(), dto.getQuitTime()));
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			}
			i++;
		}
	}

	/**
	 * Ζ`Ԏϊ\bh
	 * @param start
	 * @param quit
	 * @return	string	
	 */
	private String convWorkTypeTimes(int start, int quit) {
		StringBuffer sb = new StringBuffer();
		// oΎ
		if ((start / 60) < 10) {
			sb.append("0");
		}
		sb.append(String.valueOf(start / 60));
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		if ((start % 60) < 10) {
			sb.append("0");
		}
		sb.append(String.valueOf(start % 60));
		sb.append(" ");
		sb.append(CommonConst.STR_SLASH_SEPARATOR);
		sb.append(" ");
		// ގЎ
		int quith = (quit / 60);
		if (quith > 24) {
			sb.append(CommonConst.NAM_NEXT);
			quith = quith - 24;
		}
		if (quith < 10) {
			sb.append("0");
		}
		sb.append(String.valueOf(quith));
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		if ((quit % 60) < 10) {
			sb.append("0");
		}
		sb.append(String.valueOf(quit % 60));
		return sb.toString();
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[] getEscAryShiftCode	() { return aryShiftCode.clone()	; }
	public String[] getEscAryShiftName	() { return aryShiftName.clone()	; }
	public String[] getEscAryWorkTable	() { return aryWorkTable.clone()	; }
	public String[] getEscAryDelete		() { return aryDelete.clone()		; }

	public String getTxtShiftCode	() { return txtShiftCode	; }
	public String getTxtShiftName	() { return txtShiftName	; }
	public String getPltDelete		() { return pltDelete		; }

	public String getEscTxtShiftName	() { return escapeHTML(txtShiftName)	; }
	public String getEscTxtShiftCode	() { return escapeHTML(txtShiftCode)	; }

	public void setPltDelete(int pltDelete) { this.pltDelete = String.valueOf(pltDelete); }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

}
