/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.system.dto.MWorkTypeDto;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;

public class MWorkTypeDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE	= "CM_WORKTYPE"	;
	public static final String KEY_1	= "SHIFTCODE"	;	//Ζ`ԃR[h

	// 
	public static final String COL_SHIFTCODE		= "SHIFTCODE"	;	//Ζ`ԃR[h
	public static final String COL_SHIFTNAME		= "SHIFTNAME"	;	//Ζ`Ԗ
	public static final String COL_STARTTIME		= "STARTTIME"	;	//oΎ
	public static final String COL_QUITTIME		= "QUITTIME"	;	//ގЎ
	public static final String COL_WORKTIME		= "WORKTIME"	;	//Ζ
	public static final String COL_BREAKTIME 		= "BREAKTIME"	;	//xe
	public static final String COL_OVERSTART		= "OVERSTART"	;	//cƊJn
	public static final String COL_OVERBREAK		= "OVERBREAK"	;	//cƋxe
	public static final String COL_OPTION1			= "OPTION1"		;	//IvV1
	public static final String COL_OPTION2			= "OPTION2"		;	//IvV2
	public static final String COL_OPTION3			= "OPTION3"		;	//IvV3
	public static final String COL_OPTION4			= "OPTION4"		;	//IvV4
	public static final String COL_OPTION5			= "OPTION5"		;	//IvV5
	public static final String COL_DELETE_FLAG		= "DELETEFLAG"	;	//폜tO

	/**
	 * RXgN^
	 */
	public MWorkTypeDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<MWorkTypeDto> mappingAll() throws SQLException {
		List<MWorkTypeDto> all = new ArrayList<MWorkTypeDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return cm_worktypeDto cm_worktypeR[h
	 * @throws SQLException
	 */
	private MWorkTypeDto mapping() throws SQLException {
		MWorkTypeDto dto = new MWorkTypeDto();
		dto.setShiftCode	(rs.getString	(COL_SHIFTCODE)	);	//Ζ`ԃR[h
		dto.setShiftName	(rs.getString	(COL_SHIFTNAME)	);	//Ζ`Ԗ
		dto.setStartTime	(rs.getInt		(COL_STARTTIME)	);	//oΎ
		dto.setQuitTime		(rs.getInt		(COL_QUITTIME)	);	//ގЎ
		dto.setWorkTime		(rs.getInt		(COL_WORKTIME)	);	//Ζ
		dto.setBreakTime	(rs.getInt		(COL_BREAKTIME)	);	//xe
		dto.setOverStart	(rs.getInt		(COL_OVERSTART)	);	//cƊJn
		dto.setOverBreak	(rs.getInt		(COL_OVERBREAK)	);	//cƋxe
		dto.setOption1		(rs.getString	(COL_OPTION1)	);	//IvV1
		dto.setOption2		(rs.getString	(COL_OPTION2)	);	//IvV2
		dto.setOption3		(rs.getString	(COL_OPTION3)	);	//IvV3
		dto.setOption4		(rs.getString	(COL_OPTION4)	);	//IvV4
		dto.setOption5		(rs.getString	(COL_OPTION5)	);	//IvV5
		dto.setDeleteFlag	(rs.getInt		(COL_DELETE_FLAG));	//폜tO
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MWorkTypeDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<MWorkTypeDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * Sf[^擾iL̂݁j
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MWorkTypeDto> findAvailable() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF + " ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<MWorkTypeDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param shiftcode Ζ`ԃR[h(L[)
	 * @return cm_worktypeDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MWorkTypeDto findForKey(
			String shiftcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, shiftcode);
			executeQuery();
			MWorkTypeDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param shiftcode Ζ`ԃR[h(L[)
	 * @return cm_worktypeDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MWorkTypeDto findForUpdate(
			String shiftcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, shiftcode);
			executeQuery();
			MWorkTypeDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param shiftcode Ζ`ԃR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String shiftcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_SHIFTCODE);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   shiftcode + "%"  );
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param shiftCode Ζ`ԃR[h
	 * @param shiftName Ζ`Ԗ
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String shiftCode,
			String shiftName
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF + " ");
		if (!shiftCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SHIFTCODE);
			sb.append(" LIKE ? ");
		}
		if (!shiftName.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SHIFTNAME);
			sb.append(" LIKE ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (!shiftCode.equals("")) {
				setParam(index++, shiftCode + "%");
			}
			if (!shiftName.equals("")) {
				setParam(index++, "%" + shiftName + "%");
			}
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param shiftCode 	Ζ`ԃR[h
	 * @param shiftName		Ζ`Ԗ
	 * @param deleteFlag	폜tO
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String shiftCode,
			String shiftName,
			String deleteFlag
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_SHIFTCODE);
		sb.append(" LIKE ? ");
		sb.append(" AND ");
		sb.append(COL_SHIFTNAME);
		sb.append(" LIKE ? ");
		if (!deleteFlag.equals("")) {
			sb.append(" AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, shiftCode + "%");
			setParam(index++, "%" + shiftName + "%");
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MWorkTypeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}


	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MWorkTypeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getShiftCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MWorkTypeDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getShiftCode());	//Ζ`ԃR[h
		setParam(index++, dto.getShiftName());	//Ζ`Ԗ
		setParam(index++, dto.getStartTime());	//oΎ
		setParam(index++, dto.getQuitTime());	//ގЎ
		setParam(index++, dto.getWorkTime());	//Ζ
		setParam(index++, dto.getBreakTime());	//xe
		setParam(index++, dto.getOverStart());	//cƊJn
		setParam(index++, dto.getOverBreak());	//cƋxe
		setParam(index++, dto.getOption1());	//IvV1
		setParam(index++, dto.getOption2());	//IvV2
		setParam(index++, dto.getOption3());	//IvV3
		setParam(index++, dto.getOption4());	//IvV4
		setParam(index++, dto.getOption5());	//IvV5
		setParam(index++, dto.getDeleteFlag());	//폜tO
		setCommonParams(isInsert);
	}

}
