/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.system.dao.MWorkTypeDao;
import jp.mosp.system.dto.MWorkTypeDto;

import jp.mosp.system.vo.WorkTypeMasterCardVo;

public class WorkTypeMasterCardAction extends MosPAction {

	// R}h
	private static final String CMD_WORKTYPE_MASTER_CARD_SHOW   = "S2605";	// \(ǉ)
	private static final String CMD_WORKTYPE_MASTER_CARD_SELECT = "S2606";	// \(I)
	private static final String CMD_WORKTYPE_MASTER_CARD_INSERT = "S2607";	// o^
	private static final String CMD_WORKTYPE_MASTER_CARD_UPDATE = "S2608";	// XV

	// tB[h
	private MWorkTypeDto dto;

	/**
	 * RXgN^
	 */
	public WorkTypeMasterCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾yѐݒ
		WorkTypeMasterCardVo vo = getInitVo();
		// 
		init(vo);
		// R}h̏
		if (cmd.equals(CMD_WORKTYPE_MASTER_CARD_SHOW)) {
			vo.setDefaultValues();
			vo.setMode(WorkTypeMasterCardVo.MODE_INSERT);
		} else if (cmd.equals(CMD_WORKTYPE_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			select(vo);
		} else if (cmd.equals(CMD_WORKTYPE_MASTER_CARD_INSERT)) {
			// VKo^
			insert(vo);
		} else if (cmd.equals(CMD_WORKTYPE_MASTER_CARD_UPDATE)) {
			// XV
			update(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * VOCX^X擾
	 * @return	VO
	 */
	protected WorkTypeMasterCardVo getInitVo() {
		return new WorkTypeMasterCardVo();
	}

	/**
	 * Action
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void init(WorkTypeMasterCardVo vo) throws Exception {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MWorkTypeDto ? (MWorkTypeDto)obj : null;
		// JԂ擾
		vo.setLinitPerDay(Double.parseDouble(getMosPCode(CommonConst.TID_STATUTORY, CommonConst.TCD_STATUTORY_HOUR)[2]));
	}

	/**
	 * I
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void select(WorkTypeMasterCardVo vo) throws Exception {
		// \(L[ŏ)
		// DAO̐錾
		MWorkTypeDao dao = new MWorkTypeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		dto = dao.findForKey(key1);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		vo.setMode(WorkTypeMasterCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, dto);
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	protected void insert(WorkTypeMasterCardVo vo) throws Exception {
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// p[^̑ÓmF
		vo.validate(true);
		// DAȌ
		MWorkTypeDao dao = new MWorkTypeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(dao.findForKey(vo.getTxtShiftCode()), vo);
		// DTȌ
		MWorkTypeDto dto = new MWorkTypeDto();
		vo.setDtoFields(dto);
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(dto.getShiftCode());
		// R~bg
		commit();
		// [hݒ
		vo.setMode(WorkTypeMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, dto);
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	protected void update(WorkTypeMasterCardVo vo) throws Exception {
		// R[h敪擾
		vo.setTxtShiftCode(dto.getShiftCode());
		// p[^̑ÓmF
		vo.validate(false);
		// DAȌ
		MWorkTypeDao dao = new MWorkTypeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getTxtShiftCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MWorkTypeDto retDto = dao.findForKey(dto.getShiftCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(WorkTypeMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, retDto);
	}

}
