/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.system.dao.MCodeDao;
import jp.mosp.system.dto.MCodeDto;
import jp.mosp.system.vo.CodeMasterListVo;

public class CodeMasterListAction extends MosPAction {

	// R}h
	private static final String CMD_CODE_LIST_SHOW      = "S2300";	// \
	private static final String CMD_CODE_LIST_SELECT    = "S2301";	// 
	private static final String CMD_CODE_LIST_RE_SEARCH = "S2302";	// Č
	private static final String CMD_CODE_LIST_SORT      = "S2303";	// \[g

	/**
	 * RXgN^
	 */
	public CodeMasterListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾
		CodeMasterListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof CodeMasterListVo) {
			vo = (CodeMasterListVo)obj;
			vo.clearMessage();
			vo.clearErrField();
		} else {
			vo = new CodeMasterListVo();
		}		
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// R}h̏
		if (cmd.equals(CMD_CODE_LIST_SHOW)) {
			// \
			// R[h敪v_EXg쐬
			vo.aryPltTId = getMosPCodeArray();
			// lɃZbg
			vo.setSearchmode(CodeMasterListVo.SEARCH_OFF);
		} else if (cmd.equals(CMD_CODE_LIST_SELECT)) {
			// 
			vo.setParams(request);
			searchCodeList(vo);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(CodeMasterListVo.SEARCH_ON);
		} else if (cmd.equals(CMD_CODE_LIST_RE_SEARCH)) {
			// Č
			if(vo.getSearchmode() == CodeMasterListVo.SEARCH_ON){
				session.removeAttribute(MospConst.ATT_DTO);
				searchCodeList(vo);
				vo.setPageButton();
				sortList(vo);
			}
		} else if (cmd.equals(CMD_CODE_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * R[hXg
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void searchCodeList(CodeMasterListVo vo) throws Exception {
		// 
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForSearch(vo.getPltTId(),vo.getTxtTCode(),vo.getTxtTName()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryTCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, CodeMasterListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(CodeMasterListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, CodeMasterListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_T_ID)) {
			comp = new CompTId();
		} else if (key.equals(vo.KEY_T_CODE)) {
			comp = new CompTCode();
		} else if (key.equals(vo.KEY_T_NAME)) {
			comp = new CompTName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * R[hɂrNX
	 */
	protected static class CompTId implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 7210303772053153377L;
		public int compare(Object obj1, Object obj2) {
			MCodeDto dto1 = (MCodeDto)obj1;
			MCodeDto dto2 = (MCodeDto)obj2;
			return dto1.getTId().compareTo(dto2.getTId());
		}
	}

	/**
	 * R[hɂrNX
	 */
	protected static class CompTCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 5672044129524635759L;
		public int compare(Object obj1, Object obj2) {
			MCodeDto dto1 = (MCodeDto)obj1;
			MCodeDto dto2 = (MCodeDto)obj2;
			return dto1.getTCode().compareTo(dto2.getTCode());
		}
	}

	/**
	 * R[ĥɂrNX
	 */
	protected static class CompTName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -8615320106870669507L;
		public int compare(Object obj1, Object obj2) {
			MCodeDto dto1 = (MCodeDto)obj1;
			MCodeDto dto2 = (MCodeDto)obj2;
			return dto1.getTName().compareTo(dto2.getTName());
		}
	}

}
