/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.report.dao;

import java.sql.SQLException;
import java.sql.ResultSet;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseDao;

public class ExportDataDao extends BaseDao {

	/**
	 * RXgN^
	 */
	public ExportDataDao() {
		super();
	}

	/**
	 * ɂf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public ResultSet findForConditionKihon(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT M_KIHON.*,KAIMEI,SNAME,YNAME,TNAME FROM ");
		sb.append("((((M_KIHON ");
		sb.append("LEFT JOIN M_KAISYA on M_KIHON.JCODE = M_KAISYA.ID) ");
		sb.append("LEFT JOIN M_SYOZOKU on M_KIHON.SCODE = M_SYOZOKU.SCODE) ");
		sb.append("LEFT JOIN M_YAKUSYOKU on M_KIHON.YCODE = M_YAKUSYOKU.YCODE AND M_KIHON.TOKYU = M_YAKUSYOKU.TOKYU) ");
		sb.append("LEFT JOIN M_CODE on M_KIHON.KNKUBUN = M_CODE.TCODE AND M_CODE.TID = '");
		sb.append(CommonConst.TID_SALARY);
		sb.append("')");
		try {
			prepareStatement(sb.toString());
			executeQuery();
			return rs;
		} catch (SQLException e) {
			throw e;
		} finally {
		}
	}

	/**
	 * ɂf[^擾
	 * @param sikyuym xN
	 * @return rs 
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public ResultSet findForConditionKintai(
			String sikyuym
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT M_KIHON.*,M_KINTAI.*,KAIMEI,SNAME,YNAME,TNAME FROM ");
		sb.append("(((((M_KIHON LEFT JOIN M_KINTAI on M_KIHON.KCODE = M_KINTAI.KCODE AND M_KINTAI.SIKYUYM = ? ) ");
		sb.append("LEFT JOIN M_KAISYA on M_KIHON.JCODE = M_KAISYA.ID) ");
		sb.append("LEFT JOIN M_SYOZOKU on M_KIHON.SCODE = M_SYOZOKU.SCODE) ");
		sb.append("LEFT JOIN M_YAKUSYOKU on M_KIHON.YCODE = M_YAKUSYOKU.YCODE AND M_KIHON.TOKYU  = M_YAKUSYOKU.TOKYU) ");
		sb.append("LEFT JOIN M_CODE on M_KIHON.KNKUBUN = M_CODE.TCODE AND M_CODE.TID = '");
		sb.append(CommonConst.TID_SALARY);
		sb.append("')");
		try {
			prepareStatement(sb.toString());
			setParam(index++, sikyuym);
			executeQuery();
			return rs;
		} catch (SQLException e) {
			throw e;
		} finally {
		}
	}

	/**
	 * ɂf[^擾
	 * @param	kyuyoymdfrom	xwJnN
	 * @param	kyuyoymdto		xwIN
	 * @return rs 
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public ResultSet findForConditionYukyu(
			int kyuyoymdfrom,
			int kyuyoymdto
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT M_KIHON.*,M_YUKYU.*,KAIMEI,SNAME,YNAME,TNAME FROM ");
		sb.append("(((((M_KIHON LEFT JOIN M_YUKYU on M_KIHON.KCODE = M_YUKYU.KCODE AND M_YUKYU.KYUYOYMD > ? AND M_YUKYU.KYUYOYMD < ? ) ");
		sb.append("LEFT JOIN M_KAISYA on M_KIHON.JCODE = M_KAISYA.ID) ");
		sb.append("LEFT JOIN M_SYOZOKU on M_KIHON.SCODE = M_SYOZOKU.SCODE) ");
		sb.append("LEFT JOIN M_YAKUSYOKU on M_KIHON.YCODE = M_YAKUSYOKU.YCODE AND M_KIHON.TOKYU = M_YAKUSYOKU.TOKYU) ");
		sb.append("LEFT JOIN M_CODE on M_KIHON.KNKUBUN = M_CODE.TCODE AND M_CODE.TID = '");
		sb.append(CommonConst.TID_SALARY);
		sb.append("')");
		try {
			prepareStatement(sb.toString());
			setParam(index++, kyuyoymdfrom);
			setParam(index++, kyuyoymdto);
			executeQuery();
			return rs;
		} catch (SQLException e) {
			throw e;
		} finally {
		}
	}

	/**
	 * ɂf[^擾
	 * @param	kyuyoymdfrom	xwJnN
	 * @param	kyuyoymdto		xwIN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public ResultSet findForConditionSyukkinbo(
			String kyuyoymdfrom,
			String kyuyoymdto
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT M_KIHON.*,M_SYUKKINBO.*,KAIMEI,SNAME,YNAME,TNAME FROM ");
		sb.append("(((((M_KIHON LEFT JOIN M_SYUKKINBO on M_KIHON.KCODE = M_SYUKKINBO.KCODE AND M_SYUKKINBO.HIZUKE >= ? AND M_SYUKKINBO.HIZUKE <= ? ) ");
		sb.append("LEFT JOIN M_KAISYA on M_KIHON.JCODE = M_KAISYA.ID) ");
		sb.append("LEFT JOIN M_SYOZOKU on M_KIHON.SCODE = M_SYOZOKU.SCODE) ");
		sb.append("LEFT JOIN M_YAKUSYOKU on M_KIHON.YCODE = M_YAKUSYOKU.YCODE AND M_KIHON.TOKYU = M_YAKUSYOKU.TOKYU) ");
		sb.append("LEFT JOIN M_CODE on M_KIHON.KNKUBUN = M_CODE.TCODE AND M_CODE.TID = '");
		sb.append(CommonConst.TID_SALARY);
		sb.append("')");
		try {
			prepareStatement(sb.toString());
			setParam(index++, kyuyoymdfrom);
			setParam(index++, kyuyoymdto);
			executeQuery();
			return rs;
		} catch (SQLException e) {
			throw e;
		} finally {
		}
	}

	/**
	 * I
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void closers() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			releaseResultSet();
			releasePreparedStatement();
		} catch (SQLException e) {
			throw e;
		} finally {
		}
	}

}
