/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

public class AttendanceCalculateMenuVo extends MosPVo {

	private static final long serialVersionUID = 1473050564230241352L;

	// URL
	private static final String RETURN_URL = "/jsp/payroll/attendanceCalculateMenu.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/js/attendanceCalculateMenu.js";
	private static final String EXTRA_CSS  = "/pub/payroll/css/attendanceCalculateMenu.css";

	// ʃTu^Cg
	public final String ATT_CALCULATE_MENU_TITLE = CommonConst.TTL_ATT_CALCULATE_MENU;

	public final String CMD_ATT_CALCULATE_MENU = "P1010";

	// Wv
	public static final String COMPILE_SECTION 	= "COMPILE_SECTION";
	public static final String COMPILE_K_CODE 		= "COMPILE_K_CODE";

	// 萔

	// [h(0F\sA1F\)

	// tB[h
	private String[] aryCmd ;
	private String[] aryName ;

	/**
	 * RXgN^
	 */
	public AttendanceCalculateMenuVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		aryCmd 		= new String[0];
		aryName 	= new String[0];
	}

	/**
	 * tB[hݒ
	 * @param menuList R}hݒ
	 */
	public void setFields(List<String[]> menuList) {
		aryCmd = menuList.get(0);
		aryName = menuList.get(1);
		for (int i = 0 ; i < aryCmd.length ; i++) {
			aryCmd[i] = escapeHTML(aryCmd[i]);
			aryName[i] = escapeHTML(aryName[i]);
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[]	getEscAryCmd	() { return aryCmd.clone()	; }
	public String[]	getEscAryName	() { return aryName.clone()	; }

}
