/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.Date;

import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.ResideTransferFBDataDto;


public class ResideTransferDao extends PayrollDao {
	
	// 
	public static final String COL_K_CODE               = PdPayDeductionDao.COL_KCODE;		// ЈR[h
	public static final String COL_CALC_DATE            = PdPayDeductionDao.COL_CALC_DATE;	// vZN
	public static final String COL_DETAIL_CODE           = PdPayDeductionDao.COL_DETAIL_CODE;	// ׃R[h
//	public static final String COL_RESIDENCE_TAX        = UdPaymentDao.COL_RESIDENCE_TAX       ;	// Z
//	public static final String COL_SUM_RESIDENCE_TAX        = "SUM(" + "PAY." + UdPaymentDao.COL_RESIDENCE_TAX+")"   ;	// Zōv
//	public static final String COL_COUNT_RESIDENCE_TAX      = "COUNT("+ "PAY." + UdPaymentDao.COL_RESIDENCE_TAX+")" ;	// ZŌ
	public static final String COL_RES_K_CODE               = CmResidenceTaxDao.COL_K_CODE;		// ЈR[h

	public static final String COL_SUM_RESIDENCE_TAX        = "SUM(" + "PAY." + PdPayDeductionDao.COL_AMOUNT+")"   ;	// Zōv
	public static final String COL_COUNT_RESIDENCE_TAX      = "COUNT("+ "PAY." + PdPayDeductionDao.COL_AMOUNT+")" ;	// ZŌ
	
	public static final String COL_DETAIL_CODE_PD007    = "PD007";
	
	
	
	/**
	 * RXgN^
	 */
	public ResideTransferDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
/*	
	*//**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
/*
	private List<ResideTransferFBDataDto> mappingAll() throws SQLException {
		List<ResideTransferFBDataDto> all = new ArrayList<ResideTransferFBDataDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
*/
	
	/**
	 * ʎ擾(DTO)
	 * @return AdjustmentListDto NR[h
	 * @throws SQLException
	 */
/*
 	private ResideTransferFBDataDto mapping() throws SQLException {
		ResideTransferFBDataDto dto = new ResideTransferFBDataDto();
		dto.setPaymentCount(rs.getInt(COL_COUNT_RESIDENCE_TAX));	
		dto.setPaymentTax(rs.getString(COL_SUM_RESIDENCE_TAX));	
		return dto;
	}
*/	

	/**
	 * ʎ擾(DTO)
	 * @return ResideTransferFBDataDto ZFBR[h
	 * @throws SQLException
	 */
	private ResideTransferFBDataDto  mapping() throws SQLException {
		ResideTransferFBDataDto dto = new ResideTransferFBDataDto();
//		dto.setCityCode         (rs.getString( ));	// sR[h
//		dto.setCityKana         (rs.getString( ));	// sJi
//		dto.setDesignatedNumber (rs.getString( ));	// wԍ
//		dto.setPaymentCount     (rs.getInt( ));	// ^
//		dto.setPaymentTax       (rs.getString( ));	// ^Ŋz
//		dto.setRetireTax        (rs.getInt( ));	// ސEŊz
		dto.setTotalCount       (rs.getInt(COL_COUNT_RESIDENCE_TAX ));	// v
		dto.setTotalTax         (rs.getInt(COL_SUM_RESIDENCE_TAX ));	// vŊz
//		dto.setCityChanges      (rs.getString( ));	// ٓL
//		dto.setRetireCount      (rs.getInt( ));	// ސEl
//		dto.setCityPayAmount    (rs.getLong( ));	// xz
//		dto.setCityTax          (rs.getInt( ));	// s
//		dto.setPrefectureTax    (rs.getInt( ));	// {	
		mappingCommonInfo(dto);
		return dto;
	}
	
	
	/**
	 * ɂf[^擾
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public ResideTransferFBDataDto findForFirmBanking(
			String cityCode,
			Date calcDate
	) throws SQLException, IllegalAccessException {
		index = 1;
		CmResidenceTaxDao cmResidenceTaxDao = new CmResidenceTaxDao();
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_SUM_RESIDENCE_TAX);
		sb.append(", ");
		sb.append(COL_COUNT_RESIDENCE_TAX);
		sb.append(" FROM ");
		sb.append(PdPayDeductionDao.TABLE + " PAY");
		sb.append(" , ");
		sb.append(cmResidenceTaxDao.getHistoryTableForFB());
		sb.append(" RES ");
		sb.append(" WHERE ");
		sb.append("PAY." + COL_CALC_DATE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append("PAY." + COL_DETAIL_CODE);
		sb.append(" = ");
		sb.append("'" + COL_DETAIL_CODE_PD007 + "'" );
		sb.append(" AND ");
		sb.append("PAY.");
		sb.append(COL_K_CODE);
		sb.append(" =  ");
		sb.append("RES.");
		sb.append(COL_RES_K_CODE);

		try {
			prepareStatement(sb.toString());
			setParam(index++, calcDate);
			setParam(index++, cityCode);
			setParam(index++, calcDate);
			executeQuery();
			ResideTransferFBDataDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
/*	*//**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 *//*
	private void setParams(ResideTransferFBDataDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode         ());	// ЈR[h
		setParam(index++, dto.getCalcDate      ());	// vZN
		setParam(index++, dto.getPayday        ());	// ^x
		setParam(index++, dto.getCalcStatus    ());	// vZXe[^X
		setParam(index++, dto.getKName         ());	// Ј
		setParam(index++, dto.getStationCode   ());	// R[h
		setParam(index++, dto.getPositionCode  ());	// EʃR[h
		setParam(index++, dto.getBankPayAmount ());	// sUz
		setParam(index++, dto.getAllowanceType ());	// x敪
		setParam(index++, dto.getCoBankCode    ());	// ЋsR[h
		setParam(index++, dto.getPaidBankCode  ());	// UsR[h
		setParam(index++, dto.getPaidBranchCode());	// UsxXR[h
		setParam(index++, dto.getMeansSequence ());	// x@A
		setParam(index++, dto.getAccountType   ());	// a敪
		setParam(index++, dto.getAccountNo     ());	// ԍ
		setParam(index++, dto.getHolderKana    ());	// `ض
		setParam(index++, dto.getPaymentMeans  ());	// x@
		setParam(index++, dto.getAmountType    ());	// z敪
		setCommonParams(isInsert);
	}*/
}
