/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.action.BonusSlipOutputAction;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.common.vo.ReferSlipVo;
import jp.mosp.payroll.dao.PhPaymentDao;
import jp.mosp.payroll.dto.PhPaymentDto;
import jp.mosp.payroll.payment.action.PaySlipOutputAction;

/**
 * ܗ^׎QƉʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li><li>
 * {@link #CMD_SEARCH}
 * </li><li>
 * {@link #CMD_SORT}
 * </li><li>
 * {@link #CMD_PAGE}
 * </li></ul>
 */
public class ReferSlipAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * VXet̔NA^ŁAsB<br>
	 */
	public static final String CMD_SHOW = "P8500";
	
	/**
	 * R}hB<br><br>
	 * w肳ꂽŋܗ^f[^̌sAꗗ\B<br>
	 */
	public static final String CMD_SEARCH = "P8501";
	
	/**
	 * \[gR}hB<br><br>
	 * w肳ꂽŋܗ^f[^̕בւsAꗗ\B<br>
	 */
	public static final String CMD_SORT = "P8503";
	
	/**
	 * y[WR}hB<br><br>
	 * w肳ꂽŋܗ^f[^̃y[WJsAꗗ\B<br>
	 */
	public static final String CMD_PAGE = "P8504";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public ReferSlipAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new ReferSlipVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else if (this.cmd.equals(CMD_SEARCH)) {
			// 
			search();
		} else if (this.cmd.equals(CMD_SORT)) {
			// \[g
			sort();
		} else if (this.cmd.equals(CMD_PAGE)) {
			// y[W
			page();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br><br>
	 * @throws Exception 
	 */
	private void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		ReferSlipVo vo = (ReferSlipVo)getVo();
		// 擾
		getInfo(user.getUserId());
		// ЈR[hݒ
		vo.setHidKCode(mKihon.getKCode());
		// VXet擾
		Date sysDate = new Date();
		// v_EACeݒ
		vo.setPitYear(getYearArray(
				PayrollConst.DEFAULT_CURRENT_YEAR, MospUtility.getYear(sysDate) + 1));
		// VOtB[hݒ
		vo.setPltYear(MospUtility.getYear(sysDate));
		vo.setPltType(PayrollConst.CALC_PAYMENT   );
		// Xg擾
		getList();
	}
	
	/**
	 * sB
	 * @throws Exception 
	 */
	private void search() throws Exception {
		// VO擾
		ReferSlipVo vo = (ReferSlipVo)getVo();
		// p[^擾
		vo.setParams(request);
		// Xg擾
		getList();
	}
	
	/**
	 * \[gsB
	 * @throws Exception 
	 */
	private void sort() throws Exception {
		// VO擾
		ReferSlipVo vo = (ReferSlipVo)getVo();
		// \[gݒ
		vo.setSortKey(key1);
		vo.setSelectIndex(1);
		// Xg擾
		getList();
	}
	
	/**
	 * y[WsB
	 * @throws Exception 
	 */
	private void page() throws Exception {
		// VO擾
		ReferSlipVo vo = (ReferSlipVo)getVo();
		// y[Wݒ
		vo.setSelectIndex(Integer.parseInt(key1));
		// Xg擾
		getList();
	}
	
	/**
	 * Xg擾B
	 * @throws Exception 
	 */
	private void getList() throws Exception {
		// VO擾
		ReferSlipVo vo = (ReferSlipVo)getVo();
		// ܗ^敪mF
		if (vo.getPltType() == PayrollConst.CALC_BONUS) {
			// ׏o̓R}hݒ
			vo.setHidCmd(BonusSlipOutputAction.CMD_REPORT);
			// ܗ^׎擾
			vo.setFields(getBonusList());
		} else {
			// ׏o̓R}hݒ
			vo.setHidCmd(PaySlipOutputAction.CMD_REPORT);
			// ^׎擾
			vo.setFields(getPaymentList());
		}
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getCount() == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * ^׃Xg擾B
	 * @return ^׃Xg
	 * @throws Exception
	 */
	private List<PhPaymentDto> getPaymentList() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		ReferSlipVo vo = (ReferSlipVo)getVo();
		// DAO
		PhPaymentDao dao = new PhPaymentDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.count(
				vo.getHidKCode(),
				getFirstDateOfTheYear(vo.getPltYear()),
				getLastDateOfTheYear (vo.getPltYear())
		));
		// 
		List<PhPaymentDto> list = dao.find(
				vo.getHidKCode(),
				getFirstDateOfTheYear(vo.getPltYear()),
				getLastDateOfTheYear (vo.getPltYear()),
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// vZmF
		Date current = getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT);
		if (current == null) {
			return list;
		}
		// vZ񏜋
		for (int i = 0; i < list.size(); i++) {
			PhPaymentDto dto = list.get(i);
			if (current.compareTo(dto.getCalcMonth()) == 0) {
				list.remove(i);
				vo.setCountAllData(vo.getCountAllData() - 1);
				break;
			}
		}
		return list;
	}
	
	/**
	 * ܗ^׃Xg擾B
	 * @return ܗ^׃Xg
	 * @throws Exception
	 */
	private List<PhBounsDto> getBonusList() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		ReferSlipVo vo = (ReferSlipVo)getVo();
		// DAO
		PhBounsDao dao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.count(
				vo.getHidKCode(),
				getFirstDateOfTheYear(vo.getPltYear()),
				getLastDateOfTheYear (vo.getPltYear())
		));
		// 
		List<PhBounsDto> list = dao.find(
				vo.getHidKCode(),
				getFirstDateOfTheYear(vo.getPltYear()),
				getLastDateOfTheYear (vo.getPltYear()),
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// vZmF
		Date current = getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_BONUS);
		if (current == null) {
			return list;
		}
		// vZ񏜋
		for (int i = 0; i < list.size(); i++) {
			PhBounsDto dto = list.get(i);
			if (current.compareTo(dto.getCalcMonth()) == 0) {
				list.remove(i);
				vo.setCountAllData(vo.getCountAllData() - 1);
				break;
			}
		}
		return list;
	}

	/**
	 * \[gL[擾B<br>
	 * @return \[gL[
	 */
	private String getSortKey() {
		// VO擾
		ReferSlipVo vo = (ReferSlipVo)getVo();
		// IL[擾
		String selectKey = vo.getSelectKey();
		// \[gL[擾
		String sortKey = PhPaymentDao.COL_PAY_DATE;
		if (selectKey == null) {
			// 
		} else if (selectKey.equals("2")) {
			sortKey = PhPaymentDao.COL_ALLOWANCE_TOTAL;
		} else if (selectKey.equals("3")) {
			sortKey = PhPaymentDao.COL_DEDUCTION_TOTAL;
		} else if (selectKey.equals("4")) {
			sortKey = PhPaymentDao.COL_PAYMENT_TOTAL;
		}
		return sortKey;
	}
	
}
